#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>
#include <gmime.h>
#include <glade/glade.h>
#include <mysql/mysql.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/utsname.h>
#include <ctype.h>
#include "../config.h"  
#include "balsa-icons.h"  

#define		DATABASE_VERSION 1

#define cache_vfolders() (gnome_config_get_bool("/gmail/UserInfo/CacheVfolders=FALSE"))
#define TwoPaneView() (gnome_config_get_bool("/gmail/UserInfo/TwoPaneView=FALSE"))

/* Structures - See below for comments. */
typedef struct _Mailbox Mailbox;
typedef struct _Message Message;
typedef struct _GmailApp _GmailApp_;
typedef struct _DTimer DTimer;
typedef struct _MailSetup MailSetup;

/* There is one of these mailbox structures attached as row data in every
 * row of the clist in the leftpane.
 * This should be renamed to be 'vfolder'.
 * 
 */
struct _Mailbox
{
	gchar *name; 	/* Name of the vfolder. */
	gchar *query; 	/* SQL Query. */
	gchar *email; 	/* Default email address specific to this vfolder. */
};

/* This is a common widget that we reuse around the place. */
struct _DTimer
  {
	GtkWidget *dialog;		/* The popup window */
	GtkWidget *label;
	GtkWidget *clist;			/* Contains dynamic download info. */
	GtkWidget *button;
	GtkProgressBar *progress; 	
	gint	value;
	gint	total;
	guint	timeout;
};


/* 
 * This struct used to store the information about a single mail message.
 * Not all of these fields are used in every use.
 */
struct _Message
  {
	gint  id;		/* sql id  */
	GString *headers;	/* The headers bit without the body. */
	GString *message;	/* The message = body. */
	gchar *date;		/* Date sent. */
	gchar *subject;		/* Subject header. */
	gchar *from;		/* Sender. */
	gchar *to;		/* Receiver. */
	gchar *cc;		/* cc field */
	gchar *bcc;		/* bcc field */
	gchar *readstatus; 	/* Gmail status. Read/unread etc etc. */
	gchar *direction;	/* Either 'Incoming' or 'Outgoing'  */
	gchar *uid;		/* Pop 3 UID. */
};

/* 
 * GmailApp is one copy of all general global vars.
 * We only ever keep _one_ copy of this structure in use.
 * 
 * Alot of the variables here are just hacks and could be avoided.
 * 
 * This struct is always evolving.
 *
 * We also use globals in here to record status of certain widgets.
 * eg: progressbar values, radio button highlights etc.
 *
 */
struct _GmailApp
	{

	GnomeClient *client;	

	/* Global window widgets. */
	GtkWidget *app, *appbar, *mailmenu, *hpaned;

	/* The two halves of gmail... left and right panes.. */
	GtkWidget *leftpane, *rightpane;

	/* The right pane contains these. */
	GtkWidget *msglistpane, *msgpane;

	GtkWidget *mblist; /* clist in left pane. */
	GtkWidget *rightlist; /* clist in right pane. */

	GtkWidget *search; /* Search window. */

	/* Keep track of which ctree node is selected. 
	 * FIXME: We shouldn't need to do this.
	 */
	GtkCTreeNode *node;

	/* Database info. */
	MYSQL mysql;
	MYSQL mysql2; /* sometimes we need two connections at once. */

	gchar *sortfield, *sortorder; /* used for mysql sorting. */

	/* Our beloved fonts. */
	GtkStyle 	*boldstyle;
	GtkStyle 	*style;
	
	/* Length that outgoing messages are wrapped at */
	gint wrap_len; 
	gboolean wrap_text;
	
	/* These widgets are used in the new preferences notebook. */
	GtkWidget *prefs; 	/* Window for prefs. */
	GtkWidget *msetup_clist; 	/* Mail setup clist. */
	gboolean vfolders_clean; /* Keep track of changes to vfolders */	

	/* The DRUID! */
	GtkWidget *druid;
	GtkWidget *root_user, *root_pass; /* needed by druid */

	/* Stuff for setup druid. Should be deprecated when we use libglade for druid. */
  GtkWidget *db_host_entry;
  GtkWidget *db_user_entry;
  GtkWidget *db_pass_entry;
  GtkWidget *db_name_entry;
  GtkWidget *db_table_entry;
  GtkWidget *mbox_popup;
  GtkWidget *username_entry;
  GtkWidget *pop_server_entry;
  GtkWidget *pop_password_entry;
  GtkWidget *pop_leave_mail;
  GtkWidget *pop_threshold;
  GtkWidget *real_name, *email, *smtp_server;

	/* Used in the download email popup. */	
	gint 	newmsgs;
	GtkWidget *rightlist_popup;
};

/* Spruce stuff... */

/* define IPv4 dotted-decimal string length */
#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN 16
#endif

/* define IPv6 hex string length */
#ifndef INET6_ADDRSTRLEN
#define INET6_ADDRSTRLEN 46
#endif

typedef unsigned short int port_t;

struct _server_
{
   char *hostname;
   char ip[INET_ADDRSTRLEN + 1];     /* IPv4 dotted decimal -> 16 chars + NULL */
   struct sockaddr_in sin;
   port_t port;
};

/* PLEASE use this typedef when creating a variable of this type */
typedef struct _server_ Server;

/* Gmail supports multiple pop3 mailsetups using this structure. */
struct _MailSetup
{
	gchar *name;		/* Name of the mailsetup in gnome_config. */
	gchar *popuser;
	gchar *poppass;
	gchar *popserver;
	gchar *smtpserver;
	gboolean leave_on_server;
};
