#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/param.h>
#include <time.h>

#include "getstream.h"

void logwrite(int level, const char *format, ...) {
	va_list		pvar;
	char		logbuffer[MAXPATHLEN];
	time_t		t;

	if (level > loglevel)
		return;

	va_start (pvar, format);
	vsnprintf(logbuffer, sizeof(logbuffer), format, pvar);
	va_end (pvar);

	t=time(NULL);

	printf("%-24.24s %s\n",
			ctime (&t),
			logbuffer);
}
