#ifndef GETSTREAM_H
#define GETSTREAM_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <glib/glist.h>

#include <event.h>

#include "csa.h"

#define DEBUG

#ifdef DEBUG
#define dprintf		printf
#else
#define dprintf( a... )
#endif

#define	MAX_CTL_MSG_SIZE	1500

/*
 *
 *
 * getstream.c
 *
 *
 */

extern int loglevel;

/*
 *
 *
 * demux.c
 *
 *
 *
 */
#define MAX_MCAST_PAYLOAD	(1500-40)
#define TS_PACKET_SIZE		188
#define DVR_BUFFER_SIZE		188*10
#define MAX_PID			0x1fff

enum {
	PID_NONE,
	PID_PMT,
	PID_PCR,
	PID_VIDEO,
	PID_AUDIO,
	PID_PRIVATE,
	PID_USER,
	PID_OTHER,
};

struct pidentry_s {
	unsigned char		type,
				cc;
	time_t			last;
	struct channel_s	*channel;
};


#define PSI_MAX_PKT_SIZE	4096		/* ISO 13818-1 says private sections
						   shall not exceed 4093 bytes. Page 91 */

struct psipkt_s {
	uint8_t			pkt[PSI_MAX_PKT_SIZE];
	int			length;
	int			valid;
	int			pid;
};

struct channel_s {
	/* Config elements */
	int			id;
	char			*name;
	GList			*stream;
	struct adapter_s	*adapter;

	/* Demux */
	int			pmtpid;
	unsigned int		pidcount[MAX_PID];
	char			pid0cc;

	/* CSA */
	uint8_t			csakey[8];
	csa_t			*csat;
	int			csalength;

	struct psipkt_s		pmt;
	struct {
		uint8_t		type;
		time_t		last;
	} pidtable[MAX_PID-1];
};

enum {
	AT_DVBS,
	AT_DVBT,
	AT_DVBC
};

struct adapter_s {
	int				no;		/* Adapter Number */
	int				type;		/* Adapter Type - DVB-S/DVB-T/DVB-C */

	int				budgetmode;

	/* fe.c */
	struct event			snrmonev;
	uint32_t			snr, ber, signal;

	struct {					/* Tuning information DVB-S */
		unsigned long	lnb_lof1;
		unsigned long	lnb_lof2;
		unsigned long	lnb_slof;

		unsigned long	t_freq;
		char		*t_pol;
		unsigned long	t_srate;
		int		t_diseqc;
	} dvbs;

	struct {					/* Tuning information DVB-T */
		unsigned long	freq;
		int		bandwidth;		/* 0 (Auto) 6 (6Mhz), 7 (7Mhz), 8 (8Mhz) */
		int		tmode;			/* 0 (Auto) 2 (2Khz), 8 (8Khz) */
		int		modulation;		/* 0, 16, 32, 64, 128, 256 QUAM */
		int		guard;			/* 0, 4, 8, 16, 32 1/x Guard */
		int		hierarchy;		/* 0, -1, 1, 2, 4 - 0 Auto, -1 None */
	} dvbt;

	struct {					/* Tuning information DVB-C */
		unsigned long	freq;
		unsigned long	srate;
		int		modulation;		/* -1 (QPSK), 0, 16, 32, 64, 128, 256 QAM  */
		int		fec;			/* 0 (Auto) - 9 */
	} dvbc;

	GList				*channel;

	/* Demux */
	uint8_t			dvrbuf[DVR_BUFFER_SIZE];
	GList			*pidtable[MAX_PID+1];
	uint8_t			pidcc[MAX_PID+1];
	int			dmxfd[MAX_PID+1];

	/* Only to be touched by fe_tune_thread */
	int				fefd;
};

#include "stream.h"


/*
 *
 *
 * demux.c
 *
 *
 *
 */
int demux_init(struct adapter_s *adapter);

/*
 *
 *
 * fe.c
 *
 *
 */
int fe_tune_init(struct adapter_s *adapter);

/*
 *
 *
 * util.c
 *
 *
 */

int addr_is_mcast(char *addr);
void dump_hex(int level, const char *prefix, uint8_t *buf, int size);
void ts_packet_decode(uint8_t *ts);

/*
 *
 * logging
 *
 *
 */
void logwrite(int level, const char *format, ...);

enum {
	LOG_ERROR,
	LOG_INFO,
	LOG_DEBUG,
	LOG_XTREME,
};

#endif

