
#include <sys/poll.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pthread.h>
#include <signal.h>

#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <event.h>

#include "getstream.h"
#include "sap.h"
#include "stream.h"
#include "config.h"
#include "libhttp.h"

int	loglevel=LOG_ERROR;

#ifdef DEBUG
static int	guardcounter;

void *guard_thread(void *mtp) {
	pthread_t	mt=(pthread_t) mtp;
	struct timeval	tv;

	guardcounter=0;

	while(1) {
		tv.tv_sec=1;
		tv.tv_usec=0;
		select(0, NULL, NULL, NULL, &tv);

		if (guardcounter==0) {
			pthread_kill(mt, SIGABRT);
			pthread_exit(NULL);
		}
		guardcounter=0;
	}
}

static void init_guard_evtimer(void );

static void guard_evtimer(int fd, short event, void *arg) {
	guardcounter++;
	init_guard_evtimer();
}

static void init_guard_evtimer(void ) {
	static struct event	gevent;
	static struct timeval	tv;

	tv.tv_usec=50000;
	tv.tv_sec=00;

	evtimer_set(&gevent, guard_evtimer, &gevent);
	evtimer_add(&gevent, &tv);
}

void init_guard_thread(void ) {
	pthread_t	mt, gt;

	init_guard_evtimer();
	mt=pthread_self();
	pthread_create(&gt, NULL, guard_thread, (void *) mt);
}
#endif



static void usage(void ) {
	fprintf(stderr, "-c <config file> -d \n");
	exit(-1);
}

struct http_server	*hserver;

int main(int argc, char **argv) {
	extern char		*optarg;
	char			ch;
	GList			*al;
	struct config_s		*config=NULL;

	while((ch=getopt(argc, argv, "c:d")) != -1) {
		switch(ch) {
			case 'c':
				config=readconfig(optarg);
				if (!config)
					exit(1);
				break;
			case 'd':
				loglevel++;
				break;
			default:
				usage();
				break;
		}
	}
	if (!config)
		exit(-1);
#if 0
	if (!read_dvbrc()) {
		exit(-1);
	}

	/* Find the adapters transponder from channels */
	for(a=config->adapter;a;a=a->next) {
		struct dvbrc_transponder_s	*t=NULL;
		struct channel_s		*c;

		printf("adapter %d\n", a->no);

		for(c=a->channel;c;c=c->next) {
			struct dvbrc_channel_s	*dc;
			dc=get_channel_by_id(c->id);
			if (!dc) {
				fprintf(stderr, "Unknown channel 0x%x\n", c->id);
				exit(1);
			}

			c->dvbchannel=dc;

			if (!t)
				t=dc->transponder;

			if (t != dc->transponder) {
				fprintf(stderr, "Channels from different transponders\n");
				exit(-1);
			}
		}

		if (!t) {
			fprintf(stderr, "Oops - No transponder - No channel ?\n");
			exit(1);
		}

		/* Store transponder into adapter */
		a->transponder=t;
	}

#endif
	/* Initialize libevent */
	event_init();

	if (config->http_port) {
		hserver=http_init(config->http_port);
		if (!hserver) {
			fprintf(stderr, "Could not create http server on port %d\n", config->http_port);
			exit(-1);
		}
	}

	al=g_list_first(config->adapter);
	while(al) {
		struct adapter_s	*a=al->data;
		GList			*cl;

		cl=g_list_first(a->channel);
		while(cl) {
			struct channel_s	*c=cl->data;

			stream_init(c);
			sap_init(c);

			cl=g_list_next(cl);
		}

		/* Tune to the one and only transponder */
		fe_tune_init(a);
		/* Initialize demux0 dvr0 and co */
		demux_init(a);

		al=g_list_next(al);
	}

#ifdef DEBUG
	init_guard_thread();
#endif

	/* Pigs can fly */
	event_dispatch();

	return 0;
}
