/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: iptAdvancedDialog.cpp,v 1.22.4.1 2005/09/04 20:49:14 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "stdio.h"

#include "config.h"
#include "global.h"
#include "platforms.h"

#include "iptAdvancedDialog.h"
#include "SimpleTextEditor.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/Resources.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>
#include <qtextview.h>


using namespace std;
using namespace libfwbuilder;


iptAdvancedDialog::iptAdvancedDialog(QWidget *parent,FWObject *o)
    : iptAdvancedDialog_q(parent)
{
    obj=o;
    QStringList slm;

    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    if (fwbdebug)
        qDebug("%s",Resources::getTargetOptionStr(
                   obj->getStr("host_OS"),"user_can_change_install_dir").c_str());

    if (!Resources::getTargetOptionBool(
            obj->getStr("host_OS"),"user_can_change_install_dir"))
    {
        ipt_fw_dir->setEnabled(false);
        fwoptions->setStr("firewall_dir","");
    }
    
    data.registerOption(logTCPseq,    fwoptions, "log_tcp_seq"               );
    data.registerOption(logTCPopt,    fwoptions, "log_tcp_opt"               );
    data.registerOption(logIPopt,     fwoptions, "log_ip_opt"                );
    data.registerOption(logNumsyslog, fwoptions, "use_numeric_log_levels"    );

    slm = getLogLevels( obj->getStr("platform").c_str() );
    logLevel->clear();
    logLevel->insertStringList( getScreenNames(slm));
    data.registerOption( logLevel,   fwoptions,  "log_level", slm); 
    
    data.registerOption(useULOG,    fwoptions, "useULOG"         );
    data.registerOption(cprange,    fwoptions, "ulog_cprange"    );
    data.registerOption(qthreshold, fwoptions, "ulog_qthreshold" );
    data.registerOption(nlgroup,    fwoptions, "ulog_nlgroup"    );
    data.registerOption(logprefix,  fwoptions, "log_prefix"      );
    
    slm=getLimitSuffixes( obj->getStr("platform").c_str() );
    logLimitSuffix->clear();
    logLimitSuffix->insertStringList(getScreenNames(slm));
    data.registerOption( logLimitSuffix,   fwoptions,  "limit_suffix", slm); 
    
    data.registerOption(logLimitVal,          fwoptions, "limit_value"                          );
    data.registerOption(logAll,               fwoptions, "log_all"                              );
    data.registerOption(compiler,             fwoptions, "compiler"                             );
    data.registerOption(compilerArgs,         fwoptions, "cmdline"                              );
    data.registerOption(outputFileName,       fwoptions, "output_file"                          );
    data.registerOption(assumeFwIsPartOfAny,  fwoptions, "firewall_is_part_of_any_and_networks" );
    data.registerOption(acceptSessions,       fwoptions, "accept_new_tcp_with_no_syn"           );
    data.registerOption(dropInvalid,          fwoptions, "drop_invalid"                         );
    data.registerOption(logInvalid,           fwoptions, "log_invalid"                          );
    data.registerOption(acceptESTBeforeFirst, fwoptions, "accept_established"                   );
    data.registerOption(bridge,               fwoptions, "bridging_fw"                          );
    data.registerOption(shadowing,            fwoptions, "check_shading"                        );
    data.registerOption(emptyGroups,          fwoptions, "ignore_empty_groups"                  );
    data.registerOption(localNAT,             fwoptions, "local_nat"                            );
    data.registerOption(clampMSStoMTU,        fwoptions, "clamp_mss_to_mtu"                     );

    slm=getActionsOnReject( obj->getStr("platform").c_str() );
    actionOnReject->clear();
    actionOnReject->insertStringList(getScreenNames(slm));
    data.registerOption( actionOnReject,   fwoptions,"action_on_reject", slm); 
    
    data.registerOption(mgmt_ssh    ,fwoptions, "mgmt_ssh"    );
    data.registerOption(mgmt_addr    ,fwoptions, "mgmt_addr"    );
    data.registerOption(addVirtualsforNAT    ,fwoptions, "manage_virtual_addr"    );
    data.registerOption(configureInterfaces    ,fwoptions, "configure_interfaces"    );
    data.registerOption(iptDebug    ,fwoptions, "debug"    );
    data.registerOption(verifyInterfaces    ,fwoptions, "verify_interfaces"    );
    data.registerOption(loadModules    ,fwoptions, "load_modules"    );
    data.registerOption(iptablesRestoreActivation    ,fwoptions, "use_iptables_restore"    );
    data.registerOption(ipt_fw_dir    ,fwoptions, "firewall_dir"    );
    data.registerOption(ipt_user    ,fwoptions, "admUser"    );
    data.registerOption(altAddress    ,fwoptions, "altAddress"    );
    data.registerOption(sshArgs    ,fwoptions, "sshArgs"    );
    data.registerOption(activationCmd    ,fwoptions, "activationCmd"    );


    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );

    
    /* page "Prolog/Epilog" */

    data.registerOption(prolog_script    ,fwoptions, "prolog_script"    );
    
    slm = getPrologPlaces( obj->getStr("platform").c_str() );
    prologPlace->clear();
    prologPlace->insertStringList(getScreenNames(slm));
    data.registerOption( prologPlace,   fwoptions,   "prolog_place", slm); 
    
    data.registerOption(epilog_script    ,fwoptions, "epilog_script"    );
    
    data.loadAll();
    switchLOG_ULOG();

#ifdef HAVE_LIBSSL

//    int port=fwbdm->getPort();
//    if (port==-1) 
//        port= Resources::global_res->getResourceInt("/FWBuilderResources/FWBD/port");
//    mgmt_fwbd_port->set_value( port );
//
//    fillListOfCertificates();
//
//    const Key *key=fwbdm->getPublicKey();
//    if (key) mgmt_fw_key->set_text( key->getFingerprint() );
//
//    if (pis->isEnabled()) mgmt_use_install_script->set_active(true);
//    else                  mgmt_use_fwbd->set_active(true);

#else
//    mgmt_use_fwbd->set_sensitive(false);
//    mgmt_use_install_script->set_active(true);
//
//    disableFWBDoptions();
#endif

}

void iptAdvancedDialog::switchLOG_ULOG()
{
    useLOG->setChecked(!useULOG->isChecked());
    if (useLOG->isChecked())  logTargetStack->raiseWidget(0);
    else                      logTargetStack->raiseWidget(1);
}
/*
 * store all data in the object
 */
void iptAdvancedDialog::accept()
{
    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);
    
    data.saveAll();

/*********************  data for fwbd and install script **************/
    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    mgmt->setAddress( (Firewall::cast(obj))->getAddress() );
    
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );
    
    iptAdvancedDialog_q::accept();
}

void iptAdvancedDialog::reject()
{
    iptAdvancedDialog_q::reject();
}

void iptAdvancedDialog::editProlog()
{
    SimpleTextEditor edt( prolog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        prolog_script->setText( edt.text() );
}

void iptAdvancedDialog::editEpilog()
{
    SimpleTextEditor edt( epilog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        epilog_script->setText( edt.text() );
}


