/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: OSData.cpp,v 1.1 2004/03/10 08:41:33 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "OSData.h"
#include "fwbuilder/Resources.h"

using namespace std;

OSData::OSData(){}

string  OSData::getPathForTool(const string &distro,tools t)
{
    string r="/FWBuilderResources/Target/tools/"+distro+"/";
    switch (t)
    {
    case LSMOD:    r+="path_lsmod";    break;
    case MODPROBE: r+="path_modprobe"; break;
    case IPTABLES: r+="path_iptables"; break;
    case IP:       r+="path_ip";       break;
    case LOGGER:   r+="path_logger";   break;
    }
    return Resources::os_res["linux24"]->getResourceStr(r);
}

