/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: main_window.hh,v 1.34 2001/12/28 04:37:18 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _MAIN_WINDOW_HH
#define _MAIN_WINDOW_HH

#include <gtk--.h>

#include "helpers.hh"
#include "BuiltinDialog.hh"
#include "FWObjectBook.hh"

class PolicyList;

class main_window : public Gtk::Window
{   
    Gtk::Style  *window_style;

    friend void destroy_handler();

    gint on_delete_event(GdkEventAny* ev);

    void on_new1_activate();
    void on_open1_activate();
    void on_save1_activate();
    void on_saveas1_activate();
    void on_exit1_activate();
    void on_print_activate();

    void on_edit1_activate();
    
    void on_options_activate();
    void on_about1_activate();
    void on_release_notes_activate();

    void on_policy_line_add();
    void on_policy_line_remove();

    void on_insert_top();
    void on_append_bottom();
    void on_add_rule();
    void on_remove_rule();
    void on_move_up();
    void on_move_down();

    void on_tools_scan();

    void on_build_autorules();

    void on_compile();
    void on_install();

    void  on_new_fw();
    void  on_new_host();
    void  on_new_net();
    void  on_new_obj_group();
    void  on_new_ip();
    void  on_new_icmp();
    void  on_new_tcp();
    void  on_new_udp();
    void  on_new_custom();
    void  on_new_srv_group();
    void  on_new_time();

    void  on_find();

    gint  on_floated_pane_delete_event(GdkEventAny* ev);

/**
 * this method is used in implementation of "Paste" function. If
 * object with ID equal to that of obj aready exists in the tree, it
 * creates and adds its copy with different ID and name. This method
 * also checks if the target tree branch is a "system" group. System
 * groups are different because they hold real objects, unlike user
 * groups, which hold references to objects. If target is user group,
 * this method calls appropriate method from the dialog class of the
 * dialog, shown in the window. Dialog should add the object to its
 * internal structures and display it to the user, but won't add it to
 * the tree.
 */
    void pasteTo(libfwbuilder::FWObject *target, libfwbuilder::FWObject *obj);

    void on_left_pane_size_allocate_event(GtkAllocation *all);
    void on_right_pane_size_allocate_event(GtkAllocation *all);


    struct windowGeometry {
	Gdk_Rectangle wnd;
	Gdk_Rectangle trwnd;
	Gdk_Rectangle objwnd;
	int           divider;
    };

/**
 * reads geometry from preferences file
 */
    void readGeometry(windowGeometry &c);
/**
 * writes geometry to the preferences file
 */
    void writeGeometry(windowGeometry &c);



/**
 *  get and set window position and size on a screen. "get" works only
 *  if window is visible, "set" works for invisilbe window, too. 
 */
    void getWindowConfiguration(Gdk_Rectangle &r);
    void setWindowConfiguration(Gdk_Rectangle &r);
    void setWindowPosition(gint16 x , gint16 y);

/**
 *  get and set sizes of panes and divider position. getPaneSize works
 *  only when window is visible, while setDividerPosition can set
 *  divider position for invisible window
 */
    void getTreeWndConfiguration(Gdk_Rectangle &r);
    void setTreeWndConfiguration(Gdk_Rectangle &r);
    void setTreeWndPosition(gint16  x, gint16  y);

    void getObjWndConfiguration(Gdk_Rectangle &r);
    void setObjWndConfiguration(Gdk_Rectangle &r);
    void setObjWndPosition(gint16  x, gint16  y);


    int  getDividerPosition();
    void setDividerPosition(int w);


    string              active_tree_item;

    Gtk::MenuBar       *main_menubar1;
    Gtk::Table         *main_tbl;
    Gtk::VBox          *main_vb;
    Gtk::HPaned        *hpaned;
    Gtk::Statusbar     *main_statusbar;
    Gtk::Window        *floating_window;

    BuiltinDialog      *current_right_pane_dialog;
    Gtk::MenuItem      *custom_item;
    FWObjectBook       *obook;
    bool                policy_in_right_pane;

    Gtk::Widget        *left_pane_port;
    Gtk::Bin           *right_pane_port;

    //  data for delayed OpenObject method
    string              oo_obj;

    Gtk::AccelGroup    *agr;

    bool                pane_docked;
    string              current_lib;   // used if pane is floating

    int                 left_pane_width;
    int                 left_pane_height;
    int                 right_pane_width;
    int                 right_pane_height;
    int                 stored_divider_pos;

    // helper functions

    gint open_object_when_idle();

    void build_menu();
    PolicyList* extractPolicyList();

public:

    main_window();

    void  on_duplicate();
    void  on_copyobj();
    void  on_cutobj();
    void  on_pasteobj();
    void  on_delobj();

    void  on_copy();
    void  on_cut();
    void  on_paste();

    void  on_where_used();

    void  on_sort();

    void  on_float_pane();
    gint  on_dock_pane();

    bool  safe_to_close_right_pane();

    bool confirm_remove_object(const string& id);

    void LoadObjDB(const string& data_file);

    void schedule_open_object(string id);

    bool      isDialogDocked()    { return pane_docked; }
    string    getCurrentLibrary() { return current_lib; }
    void      setCurrentLibrary(const string &lib);

    string    nowShowingObjectId();
    libfwbuilder::FWObject* nowShowingObject();
    bool      OpenObject (string id);
    void      ClearRightPane(bool logo);
    void      RefreshRightPane();

    void      showStatusbarMsg(const string& msg);
    void      clearStatusbar();

    BuiltinDialog* getRightPaneDialog() { return current_right_pane_dialog; }
    Gtk::MenuBar*  getMainMenuBar()     { return main_menubar1; }

    bool      checkAndSaveData();

   /**
    *  restoreWindowConfiguration restores window size, creates floating
    *  object dialog window if needed and restores its size. It works on
    *  invisible window. It can not restore window position on the screen
    *  if it is invisible
    */
    void restoreWindowConfiguration();
   /**
    *  restores window's position on the screen. Works if window is already
    *  visible. Restores position of floating object dialog window too if
    *  it exists
    */
    void restoreWindowPosition();
    /**
     *  saves window's size and position, status of floating object dialog
     *  window, its size and position.
     */
    void saveWindowConfiguration();

    virtual void show_impl();
    virtual void show_all_impl();

};


#endif

