/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: StockButton.cc,v 1.3 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Resources.hh"
#include "StockButton.hh"


StockButton::StockButton(stock_button_type t) : PixmapButton()
{
    string icn;
    string text;

    switch (t) {
    case 	OK:  
	icn=Resources::global_res->getIconPath("Ok");
	text="OK";
	break;
    case	CANCEL:
	icn=Resources::global_res->getIconPath("Cancel");
	text="Cancel";
	break;
    case	YES:
	icn=Resources::global_res->getIconPath("Yes");
	text="Yes";
	break;
    case	NO:
	icn=Resources::global_res->getIconPath("No");
	text="No";
	break;
    case	APPLY:
	icn=Resources::global_res->getIconPath("Apply");
	text="Apply";
	break;
    case	REDO:
	icn=Resources::global_res->getIconPath("Redo");
	text="Redo";
	break;
    case	UNDO:
	icn=Resources::global_res->getIconPath("Undo");
	text="Undo";
	break;
    case	CLOSE:
	icn=Resources::global_res->getIconPath("Close");
	text="Close";
	break;
    case	STOP:
	icn=Resources::global_res->getIconPath("Stop");
	text="Stop";
	break;
    case	BACK:
	icn=Resources::global_res->getIconPath("BigLeftArrow");
	text="Back";
	break;
    case	NEXT:
	icn=Resources::global_res->getIconPath("BigRightArrow");
	text="Next";
	break;
    case	FINISH:
	icn=Resources::global_res->getIconPath("Apply");
	text="Finish";
	break;
    }

    addPixmapAndText(icn,text);

}

