
/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleOptionsDialog.cc,v 1.15 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "RuleOptionsDialog.hh"

#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Firewall.hh"
#include "helpers.hh"

#include "PixmapButton.hh"

#include <gtk--.h>

using namespace libfwbuilder;

void RuleOptionsDialog::on_ok_clicked()
{   
    choice=true;
    Gtk::Main::quit();
}

void RuleOptionsDialog::on_cancel_clicked()
{   
    choice=false;
    Gtk::Main::quit();
}

RuleOptionsDialog::RuleOptionsDialog(FWOptions *opt) 
{
    choice=false;
    options=opt;

    ((Gtk::Label*)(ipfilter_log_or_block->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipfilter_log_body->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipfilter_log_first->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipfilter_reject_icmp_as_dest->get_child()))->set_alignment(0.0,0.5);

    iptables_lbl1->set_line_wrap(true);
    iptables_lbl2->set_line_wrap(true);
    iptables_lbl3->set_line_wrap(true);

    ((Gtk::Label*)(iptables_no_state->get_child()))->set_alignment(0.0,0.5);


    limit_suffixes.push_back("");
    limit_suffixes.push_back("/second");
    limit_suffixes.push_back("/minute");
    limit_suffixes.push_back("/hour");
    limit_suffixes.push_back("/day");

    actions_on_reject.push_back("");
    actions_on_reject.push_back("ICMP net unreachable");
    actions_on_reject.push_back("ICMP host unreachable");
    actions_on_reject.push_back("ICMP port unreachable");
    actions_on_reject.push_back("ICMP proto unreachable");
    actions_on_reject.push_back("ICMP net prohibited");
    actions_on_reject.push_back("ICMP host prohibited");
    actions_on_reject.push_back("TCP RST");

    PixmapButton::addPixmapAndText( *button19 , "Ok"     , "OK"     );
    PixmapButton::addPixmapAndText( *button20 , "Cancel" , "Cancel" );

    button19->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button20->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button19->grab_default();
    button19->grab_focus();

}


Gtk::Menu* RuleOptionsDialog::addOptionsMenu( vector<string> &items , 
					      string &active_item)
{
    return createOptionsMenu(items,active_item,NULL);
}

void RuleOptionsDialog::run()
{   
    FWObject *p;

    p=options;
    do {
	p=p->getParent();
    } while ( p!=NULL && Firewall::cast(p)==NULL );
    assert(p!=NULL);

    string platform = p->getStr("platform");


    if (platform=="ipchains") {

    }

    if (platform=="ipfilter") {

	ipfilter_log_or_block->set_active( options->getBool("log_or_block") );
	ipfilter_log_body->set_active( options->getBool("log_body") );
	ipfilter_log_first->set_active( options->getBool("log_first") );

	ipfilter_reject_icmp_as_dest->set_active( options->getBool("icmp_as_dest") );

	string aor=options->getStr("action_on_reject");
	ipfilter_action_on_reject->remove_menu();
	ipfilter_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));

    }

    if (platform=="iptables") {

	iptables_log_prefix->set_text( 
	    options->getStr("log_prefix") );

	string aor=options->getStr("action_on_reject");
	iptables_action_on_reject->remove_menu();
	iptables_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));

	iptables_limit_value->set_value( options->getInt("limit_value") );

	string ls=options->getStr("limit_suffix");
	iptables_limit_suffix->remove_menu();
	iptables_limit_suffix->set_menu( addOptionsMenu(limit_suffixes,ls) );

	iptables_no_state->set_active( options->getBool("stateless") );

    }

    show_all();

    if (platform=="ipchains") {
	notebook300->get_nth_page(1)->hide();
	notebook300->get_nth_page(2)->hide();
    }
    if (platform=="ipfilter") {
	notebook300->get_nth_page(0)->hide();
	notebook300->get_nth_page(2)->hide();
    }
    if (platform=="iptables") {
	notebook300->get_nth_page(0)->hide();
	notebook300->get_nth_page(1)->hide();
    }

    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);

    hide();

    if (choice) {

	if (platform=="ipchains") {


	}

	if (platform=="ipfilter") {

	    options->setBool("log_or_block",ipfilter_log_or_block->get_active());
	    options->setBool("log_or_block",ipfilter_log_or_block->get_active());
	    options->setBool("log_or_block",ipfilter_log_or_block->get_active());
	    options->setBool("log_body",ipfilter_log_body->get_active());
	    options->setBool("log_first",ipfilter_log_first->get_active());
	    options->setBool("icmp_as_dest",ipfilter_reject_icmp_as_dest->get_active());

	    string *aor=(string*)(ipfilter_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );
	}

	if (platform=="iptables") {

	    options->setStr("log_prefix" , 	
			    iptables_log_prefix->get_text() );

	    string *aor=(string*)(iptables_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );

	    options->setInt("limit_value",
			    iptables_limit_value->get_value_as_int() );

	    string *ls=(string*)(iptables_limit_suffix->get_menu()->get_active()->get_user_data());
	    options->setStr("limit_suffix"  , *ls );

	    options->setBool("stateless", iptables_no_state->get_active() );

	}
    }
}









