/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Resources.hh,v 1.13 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _RESOURCES_HH
#define _RESOURCES_HH

#include "config.h"

#include <map>
#include <string>
#include <list>

#include <gtk--.h>

#include <parser.h>
#include <tree.h>

#include <vector>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/XMLTools.hh"
#include "fwbuilder/FWException.hh"


class Resources
{
    xmlDocPtr  doc;
    xmlNodePtr root;

    string resFile;

    static const string RES_FILE_NAME;

    const char* _getResourceFromXML(xmlNodePtr res_node,const char* res_name);

    
public:

    Resources() throw(libfwbuilder::FWException);

    void loadRes() throw(libfwbuilder::FWException);

    xmlNodePtr getXmlNode(const string& path);

    string  getResourceStr(const char*   resource_path);
    string  getResourceStr(const string& resource_path);
    int     getResourceInt(const char*   resource_path);
    int     getResourceInt(const string& resource_path);

    string  getIconPath(const char*   icon);
    string  getIconPath(const string& icon);

    string  getObjResourceStr(const libfwbuilder::FWObject *obj,const char*   resource_name);
    string  getObjResourceStr(const libfwbuilder::FWObject *obj,const string& resource_name);
    bool    getObjResourceBool(const libfwbuilder::FWObject *obj,const char*   resource_name);
    bool    getObjResourceBool(const libfwbuilder::FWObject *obj,const string& resource_name);

    string  getCompiler(const string& platform);
    vector<string>    getPlatforms();

    const char*  getRuleElementResourceStr(const char* rel, 
					   const char* resource);

    static bool isSystem(const libfwbuilder::FWObject *o);
    static string getXPMIconFileName(const libfwbuilder::FWObject *o, const string& icon_sfx);

    static Resources   *global_res;
};


#endif


