/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PrintDialog.hh,v 1.10 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _PRINT_DIALOG_HH
# define _PRINT_DIALOG_HH

#include <gtk--.h>

#include "fwbuilder/FWException.hh"

class PrintDialog : public Gtk::Dialog
{   
    public:

    PrintDialog(const gchar *id);
    virtual ~PrintDialog();
    
    static const string FILTERS_DIR;

    void run() throw(libfwbuilder::FWException);;
    
    protected:
    
    // signal handlers
    void on_dst_changed();
    void on_browse_clicked();
    void on_ok_clicked();
    void on_cancel_clicked();
    
    private:
    
    void savePrefs();
    void loadPrefs();    
    
    bool choice;
    const gchar *current_node;
    
    // Data
    string command  ;
    string filename ;
    bool to_file    ;
    string filter   ;
    
    // Widgets
    Gtk::Button *ok_button;
    Gtk::Button *cancel_button;

    Gtk::HBox   data_box;
    Gtk::VBox   labels_box;
    Gtk::VBox   entry_box;


    Gtk::RadioButton rb_printer, rb_file;
    Gtk::HBox   dst_radio_box     ;
    Gtk::Label  dst_label     ;

    Gtk::Label  pcmd_label    ;
    Gtk::Entry  pcmd_field    ;
    
    Gtk::HBox   pfname_box    ;
    Gtk::Label  pfname_label  ;
    Gtk::Entry  pfname_field  ;
    Gtk::Button pfname_button ;

    Gtk::Label  flt_label     ;
    Gtk::Combo  flt_list      ;

    Gtk::RadioButton rb_all, rb_current;
    Gtk::HBox   src_radio_box     ;
    Gtk::Label  src_label     ;

};

#endif



