/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyListItem.hh,v 1.15 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _POLICYLISTITEM_HH
#define _POLICYLISTITEM_HH

#include <gtk--.h>
#include <gdk_imlib.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Policy.hh"

class PolicyList;
class PolicyListElement;
class ObjectQuickView;

class PolicyListItem : public  Gtk::EventBox {

protected:

    gint        x,y,width,height;
    gint        sw, sh;
    libfwbuilder::FWObject   *object;

    gint        icon_size;
    gint        icon_w, icon_h;
    
// all PolicyListItem objects will reuse the same negation icon data 

    static GdkImlibImage *neg_icon;

    map<int,GdkImlibImage*>    pixmaps;
    map<int,Gtk::Pixmap*>    n_pixmaps;

    vector<string>       icn_files;


    Gtk::Label          *label;

    Gtk::Packer         *packer;
    Gtk::Table          *tbl;

    bool        neg;
    bool        overlap;

// quick view text, if set
    string      quick_view_txt;

    void loadNegIcon();
    Gtk::Pixmap* combineWithNeg(GdkImlibImage*);

    gint on_enter_notify_event(GdkEventCrossing* ev);
    gint on_leave_notify_event(GdkEventCrossing* ev);

    virtual gint key_press_event_impl(GdkEventKey* p0);
    virtual void state_changed_impl(GtkStateType p0);

    gint on_button_press_event(GdkEventButton *ev);
    gint on_button_release_event(GdkEventButton *ev);

    void activateObjectQuickView();
    void deactivateObjectQuickView();


public:

    PolicyListItem(const string &pixmap, 
		   const string &label,
		   bool  neg_flag=false);

    ~PolicyListItem();

    string    getLabel();
    libfwbuilder::FWObject* getObject() { return object; }

    void addLabel(const string &txt);
    void addIcon(const string &icn_file);
    void clear();

    void setNeg(bool flag);
    void setOverlap(bool flag);

    void setQuickView(const string &txt);

    PolicyListElement* getParentPolicyListElement();
};

class PolicyListObjectItem : public PolicyListItem {

    friend class PolicyList;

    void source_drag_begin( GdkDragContext  *context);

    void source_drag_data_get  ( GdkDragContext     *context,
				 GtkSelectionData   *selection_data,
				 guint               info,
				 guint32             time );

public:

    PolicyListObjectItem(libfwbuilder::FWObject *o,
			 bool  neg_flag,
			 bool  change_any_to_orig);


};

class PolicyListRuleNumItem : public PolicyListItem {
    void source_drag_begin( GdkDragContext  *context);
    void source_drag_data_get  ( GdkDragContext     *context,
				 GtkSelectionData   *selection_data,
				 guint               info,
				 guint32             time );
public:
    PolicyListRuleNumItem(const string& label,bool  neg_flag=false);
};


class PolicyListCommentItem : public PolicyListItem {
public:
    PolicyListCommentItem(const string& text);
};


#endif
