/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ObjectTree.hh,v 1.26 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _ObjectTree_HH
#  define _ObjectTree_HH

#include <gtk--.h>

#include "fwbuilder/FWObject.hh"
#include "helpers.hh"

class main_window;
class FWObjectBook;

class ObjectTree : public Gtk::CTree
{   

    friend class main_window;
    friend class FWObjectBook;

/* ignore showInTree flag */
    bool show_all;
    bool rebuild_scheduled;
    bool show_properties;

// all these store ID
    string           selected_object;    
    string           last_clicked_object;
    string           drag_object;
    string           show_object;

//name of the library
    string           lib;

    gint on_button_press_event(GdkEventButton *ev);
    gint on_button_release_event(GdkEventButton *ev);

    void source_drag_begin( GdkDragContext     *context);
    void source_drag_data_get  ( GdkDragContext     *context,
				 GtkSelectionData   *selection_data,
				 guint               info,
				 guint32             time );
    void source_drag_data_delete ( GdkDragContext     *context );

    gint on_key_press_event(GdkEventKey *ev);

    void selection_made(Gtk::CTree::Row r,gint row);

    gint rebuild_when_idle();
    gint rebuild_and_show_when_idle();
    
    string get_properties(libfwbuilder::FWObject *o);

    Gtk::CTree_Helpers::RowList::iterator _insert_row(
	Gtk::CTree_Helpers::RowList           rl,
	Gtk::CTree_Helpers::RowList::iterator i,
	const string &lbl,
	const string &id,
	const string &internals);

    void selectRow(gint row_n);
    void TreePopupMenu();

    void insertSubtree(Gtk::CTree_Helpers::RowList::iterator &j, 
		       libfwbuilder::FWObject *o);

    void rebuildTree();
    void rebuildTreeAndShow(const string &id);
    void selectObject(const string &id);

    void constructor();

    Gtk::CTree_Helpers::Row expand_to_row(const string &id);

public:

    ObjectTree(bool show_properties=false);
    ObjectTree(const string &lib,bool show_properties=false);

    void   scheduleRebuild();
    void   scheduleRebuildAndShow(const string &id);

    string getCurrentSelection();

    void   insertObject( const string &id );
    void   insertObject( libfwbuilder::FWObject *o );

    void   removeObject( const string &id );
    void   removeObject( libfwbuilder::FWObject *o );

    void   changeTreeLabel(const string &id);
/**
 *  This method shows object with given ID in the tree. Do not confuse
 *  with method of class main_window which opens appropriate dialog to
 *  edit the object 
 */
    void   showObject(const string &id);
    void   showObject(libfwbuilder::FWObject *o);

    void   sortSubtree(const string &id);
    void   sortSubtree(libfwbuilder::FWObject *o);


    void   clearSelection();

    string   getNextId();
    string   getPrevId();
    string   getParentId();
};

#endif
