/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ListOfIcons.hh,v 1.12 2001/12/29 10:06:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/




#ifndef _LIST_OF_ICONS_HH
#define _LIST_OF_ICONS_HH

#include <gtk--.h>
#include <IconList.hh>

#include "fwbuilder/FWObject.hh"

class ListOfIcons : public IconList 
{
    gint    count;
    bool    popup;

    virtual gint button_press_event_impl(GdkEventButton* p0);
    virtual gint button_release_event_impl(GdkEventButton* p0);
    virtual gint key_press_event_impl(GdkEventKey* p0);
    
    void set_data_changed_flag(bool flag);
  
public:

    ListOfIcons(gint icon_with,gint icon_height,bool allow_popup_menu);
    ~ListOfIcons();

    void    clear();

    void    addObject(libfwbuilder::FWObject *obj);
    void    removeObject(const string& id);

    string  getObjectId(int no);
    int     findIcon(const string& id);

    bool    checkObjectId(const string& id);

    gint    getCount();
	  
    void    enableMenu()  { popup=true;  }
    void    disableMenu() { popup=false; }

    SigC::Signal1<void,void*>open_item;
    SigC::Signal1<void,void*>popup_menu;

};


#endif
