/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: IPServiceDialog.cc,v 1.11 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "IPServiceDialog.hh"


#include "fwbuilder/FWObject.hh"
#include "ttips.hh"
#include "MessageDialog.hh"
#include "helpers.hh"


using namespace libfwbuilder;

IPServiceDialog::IPServiceDialog(FWObject *obj) 
{ 
    object=obj;


    ((Gtk::Label*)(fragm->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(short_fragm->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(lsrr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ssrr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(rr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ts->get_child()))->set_alignment(0.0,0.5);

    protocol_lbl->set_justify(GTK_JUSTIFY_LEFT);
}

void IPServiceDialog::wrk2dlg()
{
    name->set_text(object->getName());
    protocol_num->set_value( object->getInt("protocol_num") );
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    fragm->set_active( object->getBool("fragm") );
    short_fragm->set_active( object->getBool("short_fragm") );

    lsrr->set_active( object->getBool("lsrr") );
    ssrr->set_active( object->getBool("ssrr") );
    rr->set_active( object->getBool("rr") );
    ts->set_active( object->getBool("ts") );

    name->grab_focus();
}

bool IPServiceDialog::dlg2wrk()
{
/*
 *  check if name is valid
 */
    if ( ! checkObjectName(name->get_text()) ) return(false);


    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    object->setInt( "protocol_num" , protocol_num->get_value_as_int() );

    object->setBool( "fragm" , fragm->get_active() );
    object->setBool( "short_fragm" , short_fragm->get_active() );

    object->setBool( "lsrr" , lsrr->get_active() );
    object->setBool( "ssrr" , ssrr->get_active() );
    object->setBool( "rr"   , rr->get_active() );
    object->setBool( "ts"   , ts->get_active() );

    return(true);
}

void IPServiceDialog::on_changed()
{
  data_changed_flag(true);
}

