/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ExecBgr.hh,v 1.16 2001/12/23 07:15:34 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _EXECBGR_HH_
#define _EXECBGR_HH_

#include <stdio.h>

#include "config.h"

#include "fwbuilder/BackgroundOp.hh"

/**
 * This is simple implementation of the background execution class
 * using framework provided by BackroundOp class. This class runs
 * external program in the background using popen and sends all its output
 * to pipe_write method of BakgroundOp
 *
 * This class uses flags provided by the base class to signal execution 
 * state of the child, return child status and stop execution if user 
 * closed BackgroundOp window prematurely
 * 
 * Functions popen and pclose are reimplemented using examples from Steven's
 * book  Advanced Programming in the Unix Environment because we need to know
 * child's PID but library functions do not provide any way of knowing it.
 *
 * Custom implementations of popen and pclose are in the separate 
 * file ExecBgr-2 to illustrate how little of the cusotm code does it take
 * to implement useful background operation using base class BackgroundOp
 */
class ExecBgr : public libfwbuilder::BackgroundOp 
{
    FILE*    popen(const char *cmd, const char* argv[], const char *type)  throw(libfwbuilder::FWException);
    int      pclose(FILE *fp);
    int      open_max(void);
    int      pgm_pid;
    int      pgm_status;

    
    /**
     *  All output of the child process gets stored in this vector of strings.
     *  Create iterator in your program, then assign it using 
     *  BackgroundOp::begin() and use as usual
     */
    vector<string> BackgroundOp_data;
    
protected:

    virtual void  run_impl(libfwbuilder::Logger *)   throw(libfwbuilder::FWException);
    string   command;
    string   args;

public:

    ExecBgr();

    virtual pthread_t start_operation(ostream *, 
                                      string command, 
                                      string args)  throw(libfwbuilder::FWException);
    
    int     get_status()       { return pgm_status; }

    /*
     * Flag manipulations. These lock flags appropriately for thread-safe
     * operation
     */
    int      get_pgm_status();
    void     set_pgm_status( int status );

    int      get_str_num();

    
    vector<string>::iterator  begin();
    vector<string>::iterator  end();
    string                    front();
};


#endif
