/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP35Dialog.hh,v 1.12 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _DISCOVERYDRUIDP35DIALOG_HH
#  include "DiscoveryDruidP35Dialog_glade.hh"
#  define _DISCOVERYDRUIDP35DIALOG_HH
#include "glademm_support.hh"

#include "BackgroundOpWidget.hh"
#include "fwbuilder/IPAddress.hh"
#include "fwbuilder/dns.hh"

#include "ObjectDescriptor.hh"

#include <sigc++/signal_system.h>

class DiscoveryDruidP35Dialog : public DiscoveryDruidP35Dialog_glade
{   
        
    friend class DiscoveryDruidP35Dialog_glade;

    BackgroundOpWidget               *bow;
    vector<ObjectDescriptor>          hosts;
    libfwbuilder::DNS_findA_query    *q;
    bool                              data_ready;
    SigC::Connection                  completed_conn;

    int on_completed(int arg);

    public:

    DiscoveryDruidP35Dialog();
    ~DiscoveryDruidP35Dialog();

    int  execute(const string& domain_name, const libfwbuilder::IPAddress& ns);
    void stop_operation();
    bool ready();
    vector<ObjectDescriptor>   getHosts() { return hosts; }

};
#endif
