/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: BackgroundOpWidget.hh,v 1.12 2001/12/23 08:00:45 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _BACKGROUND_Op_DISPLAY_HH_
#define _BACKGROUND_Op_DISPLAY_HH_

#include "config.h"

#include "fwbuilder/BackgroundOp.hh"
#include <fstream>

#include <gtk--.h>
#include <gtk--/packer.h>

class BackgroundOpWidget : public Gtk::Packer
{
    int  on_completed(int arg);
    void on_hide();
    void on_button_clicked();
    
    protected:

    libfwbuilder::BackgroundOp *bio;

#ifdef STL_HAS_OFSTREAM_FD
    ofstream     *logger;
#else
    ostream      *logger;
    filebuf      *fbuf;
#endif

    int           pipe_fd[2];
    int           completed_op_arg;

    bool modal;
    Gtk::Button  *button1;
    Gtk::Button  *button2;
    Gtk::Label   *status;
    Gtk::Text    *text;

    void get_line(int fd , GdkInputCondition c);
    void ConnectSignals();
    int signal_completed_when_idle();

    public:

    BackgroundOpWidget(libfwbuilder::BackgroundOp *,bool modal=true);
    virtual ~BackgroundOpWidget();

    void execute()  throw(libfwbuilder::FWException);
    void stop();

    void showBusy(bool flag);
    void showStatusMessage(const string &msg);

    void AppendLine(char *str);
    void AppendLine(int   i);

    void run();

    // convinience methods

    virtual BackgroundOpWidget& operator<< (char  *str);
    virtual BackgroundOpWidget& operator<< (string str);
    virtual BackgroundOpWidget& operator<< (int    i);

    SigC::Signal1<int,int>completed;

    string  getLogText() { 
	if (text)
	    return text->get_chars(0,text->get_length());
	else
	    return string("");
    }
};

#endif


