# modified by Jianjun Xu 

#
#                          FitsFileselectionbox
# ------------------------------------------------------------------
class FitsFileselectionbox {
    inherit itk::Toplevel

    constructor {args} {}
    destructor {}

    private common ffbFilter *
    private common ffbFileName ""
    private common displayFitsOnly 0
    private common userName ""
    private common passwd ""
    private common ftpHost ""

    private variable pwd .
    private variable selected ""
    private variable fileCmd Open
    private variable isFtp 0
    private variable lastLocalDir  "" 
    private variable lastRemoteDir ""
    private variable nameList {}
    private variable sizeList {}
    private variable dateList {}
    private variable dirChar "/"
    
    private method fillContent {cDir}
    private method upDir {}
    private method setDir { n }
    private method openThisFile {}
    private method openSelection {} 
    private method completeFileName {}
    private method selectThat { box }
    private method listFits {}
    private method setFilter {}
    private method helpCmd {} 
    private method initFtp {} 
    private method isDir {}
    private method _pwd { {full 1} }
    private method updateAll {}
    private method switchRemoteLocal {}
    private method closeFTP {}
    private method showNamedFile {}
    private method searchCharsForCompletion {root list} 
    private method pickElemByName {name list} 
    private method _ftpOpen {}
    private method buildMenu {}
    private method postMenu {time x y}
    private method buttonRelease {time}

    private method scrollBoxes  { args }
    private method scrollOthers { box args }
    private method updateBoxes  { data }

    private method cancelCmd   {}
    private method openFileCmd {}
    private method saveFileCmd {}
    private method setCmd {cmd} 

    private variable postTime
    private variable pathElems
    private variable fileCols "files sizes dates"
    private variable fileLbls "Name Size {Mod Date}"

    public method get {} 
    public method chgDir {dir}
    public method init {}
    public method activate { cmd {defaultName ""} }
}

#
# Provide a lowercased access method for the FitsFileselectionbox class.
#
proc ffb {pathName args} {
    uplevel FitsFileselectionbox $pathName $args
}

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
body FitsFileselectionbox::constructor {args} {
    global fitsFileMode
    global isMac
    
    wm withdraw $itk_component(hull)
    wm geometry $itk_component(hull) 350x450
    if { $isMac } { set dirChar ":" }

    component hull configure -borderwidth 0

    #
    # Create an internal frame to contain the components.
    #
    itk_component add frame {
        frame $itk_interior.frame
    } 
    pack $itk_component(frame) -fill both -expand yes
#    pack propagate $itk_component(frame) no

    # Create the dir entry.
    #
    itk_component add dframe {
	frame $itk_component(frame).df 
    }
    pack $itk_component(dframe) -fill x -expand 0 -pady 4 -padx 4

    itk_component add dirBtn {
       menubutton $itk_component(dframe).dir -indicatoron 1 -relief raised \
             -menu $itk_component(dframe).dir.menu
    }
    pack $itk_component(dirBtn) -side left -fill x -expand 1 -padx 2

    itk_component add dirMenu {
       menu $itk_component(dirBtn).menu -tearoff 0
    }

    bind $itk_component(dirBtn) <ButtonPress-1> \
	    "[code $this postMenu %t %X %Y]; break"
    bind $itk_component(dirMenu) <ButtonRelease-1> \
	    [code $this buttonRelease %t]
    
    image create bitmap upDirIcon -data {
	#define updir_width 28
	#define updir_height 16
	static char updir_bits[] = {
           0x00, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x40, 0x20,
           0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x01,
           0x10, 0x00, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01, 0x10, 0x07,
           0x00, 0x01, 0x90, 0x0f, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01,
           0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01, 0x10, 0xfe,
           0x07, 0x01, 0x10, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x01,
           0xf0, 0xff, 0xff, 0x01};
    }
    
    itk_component add updir {
 	button $itk_component(dframe).up \
	    -image upDirIcon \
	    -command  [code $this upDir]
    }
    pack $itk_component(updir) -side left -expand 0 -padx 2

    itk_component add ftpB {
 	button $itk_component(dframe).ftpb -text "FTP..."\
	    -command  [code $this switchRemoteLocal] \
	    -padx 1 -pady 1 -width 8
    } 
    pack $itk_component(ftpB) -side left -expand 0 -padx 2

    ############################
    #
    #   Create the files list.
    #

    itk_component add fframe {
	frame $itk_component(frame).fframe -relief sunken
    }
    pack $itk_component(fframe) -side top -fill both -expand 1 -padx 4 -pady 6
    grid columnconfig $itk_component(fframe) 0 -weight 1
    grid rowconfig    $itk_component(fframe) 1 -weight 1

    # Create file columns

    set i 0
    foreach l $fileLbls lb $fileCols {
       itk_component add lbl$i {
          label $itk_component(fframe).lbl$i -text $l -relief raised
       }
       itk_component add $lb {
          listbox $itk_component(fframe).$lb -height 3 -relief flat \
                -exportselection 0 -bd 0 -highlightthickness 0 \
                -yscrollcommand [code $this scrollOthers $lb] \
                -takefocus 0
       }
       grid $itk_component(lbl$i) -row 0 -column $i -sticky "news"
       grid $itk_component($lb)   -row 1 -column $i -sticky "news"

       bind $itk_component($lb) <ButtonRelease-1> \
             +[code $this selectThat $lb]
       bind $itk_component($lb) <Double-1> \
             "setWatchCursor $itk_component(hull) [code $this openSelection]"

       incr i
    }
    $itk_component(sizes) config -width 7
    $itk_component(dates) config -width 12

    # scrollbar

    itk_component add fscroll {
        scrollbar $itk_component(fframe).fscroll \
              -command [code $this scrollBoxes]
    } 
    grid $itk_component(fscroll) -row 1 -column $i -sticky news

    #  
    #
    ############################

# the bottom portion using grid
    itk_component add bframe {
        frame $itk_component(frame).bframe
    } 
    pack $itk_component(bframe) -side top -fill x -expand 0   
# File name 
    itk_component add fnamel {
	label $itk_component(bframe).fnamel -text "File Name"
    }
    itk_component add fnamee {
	entry $itk_component(bframe).fnamee -textvariable [scope ffbFileName]
    }
    bind $itk_component(fnamee) <Return> \
	  "setWatchCursor $itk_component(hull) [code $this openThisFile]"

# 
#    bind all <Tab> {}
    bind $itk_component(fnamee) <Tab> "[code $this completeFileName]; break"
# Filter 
    itk_component add filterl {
	label $itk_component(bframe).filterl -text "File of type"
    }
    itk_component add filtere {
	entry $itk_component(bframe).filtere -textvariable [scope ffbFilter]
    }
    bind $itk_component(filtere) <Return> [code $this setFilter]
# file mode
    itk_component add filemode {
	checkbutton $itk_component(bframe).filemode \
	    -variable fitsFileMode \
	    -selectcolor $fvPref::checkBBgColor  \
	    -activeforeground black -activebackground $fvPref::globalBgColor \
	    -text "Open as read-only"
    }
# fitsfile
    set displayFitsOnly $fvPref::ifDispFitsOnly

    itk_component add fitsmode {
	checkbutton $itk_component(bframe).fitsmode \
	    -variable [scope displayFitsOnly] \
	    -text "List FITS files only" \
	    -selectcolor $fvPref::checkBBgColor \
	    -activeforeground black -activebackground $fvPref::globalBgColor \
	    -command [code $this listFits] 
    }
# buttons
    itk_component add openB {
	button $itk_component(bframe).openB -text Open \
	    -command "setWatchCursor $itk_component(hull) [code $this openThisFile]"
    }
    itk_component add cancelB {
	button $itk_component(bframe).cancelB -text Cancel \
	    -command [code $this cancelCmd]
    }
    itk_component add helpB {
	button $itk_component(bframe).helpB -text Help \
	    -command [code $this helpCmd]
    }
# geometry
    grid config $itk_component(fnamel) -column 0 -row 0 \
	-columnspan 1 -rowspan 1 -sticky "w" 
    grid config $itk_component(fnamee) -column 1 -row 0 \
	-columnspan 1 -rowspan 1 -sticky "snew" 
    grid config $itk_component(filterl) -column 0 -row 1 \
	-columnspan 1 -rowspan 1 -sticky "w"
    grid config $itk_component(filtere) -column 1 -row 1 \
	-columnspan 1 -rowspan 1 -sticky "snew" 
    grid config $itk_component(filemode) -column 1 -row 2 \
	-columnspan 1 -rowspan 1 -sticky "w"
    grid config $itk_component(fitsmode) -column 1 -row 3 \
	-columnspan 1 -rowspan 1 -sticky "w"
    grid config $itk_component(openB) -column 2 -row 0 \
	-columnspan 1 -rowspan 1 -sticky "snew" -padx 4
    grid config $itk_component(cancelB) -column 2 -row 1 \
	-columnspan 1 -rowspan 1 -sticky "snew" -padx 4
    grid config $itk_component(helpB) -column 2 -row 2 \
	-columnspan 1 -rowspan 1 -sticky "snew" -padx 4

    grid columnconfigure $itk_component(bframe) 1 -weight 5

    wm protocol $itk_interior WM_DELETE_WINDOW [code $this cancelCmd]

    eval itk_initialize $args
}

# ------------------------------------------------------------------
#                           DESTRUCTOR
# ------------------------------------------------------------------
body FitsFileselectionbox::destructor {} {
}

body FitsFileselectionbox::fillContent {cDir} {
    global isMac isWin
    
    if { $cDir != "" } {
        chgDir $cDir
    }
    buildMenu

    set fileNameList ""
    set fileSizeList ""
    set fileDateList ""
    set dirNameList  ""
    set dirSizeList  ""
    set dirDateList  ""
    set selCO ""

    if { $isFtp } {
        updateBoxes [list {\[Loading...\]} {} {}]
        set rlist [setWatchCursor $itk_component(hull) \
              [code ftpClient list ""]]
	set dirNameList  [lindex $rlist 0]
        set dirSizeList  [lindex $rlist 1]
        set dirDateList  [lindex $rlist 2]
	set fileNameList [lindex $rlist 3]	
        set fileSizeList [lindex $rlist 4]
        set fileDateList [lindex $rlist 5]
    } else {
	set lastLocalDir $pwd
	set ffbFilter [string trim $ffbFilter " "]
	if { $ffbFilter  == "" } {
	    set ffbFilter *
	}
	
	set tmpID [$itk_component(files) curselection]
	if { $tmpID != "" } {
	    $itk_component(files) see $tmpID
	} 
	
        if { $cDir == "" } {
            set curContent [file volumes]
        } else {
            #multi filter separated by comma
            set ffbFilter [join [split $ffbFilter ","]]
            set curContent [lsort -increasing [eval glob -nocomplain $ffbFilter]]
        }

        foreach i $curContent {
	   if ![file readable $i ] continue
           if {  ( [string index $i 0]=="~" ) || \
                 ( ($isMac || $isWin) && [file attributes $i -hidden]) || \
                 ( $isMac && $i=="Trash" ) } {
              continue
           }
           if { [catch {set fType [file type [resolveSymLinks $i]]}] } {
              continue
           }
           switch $fType {
              file {
                 if { $displayFitsOnly } {
                    if { [catch {set isfits [isFits $i]}] } continue
                    if { $isfits == 0 } continue
                 }
                 lappend fileNameList $i
                 lappend fileSizeList [calcSizeStr [file size $i]]
                 lappend fileDateList [file mtime $i]
              }
              directory {
                 lappend dirNameList [string trimright $i $dirChar]$dirChar
                 lappend dirSizeList "(dir)"
                 lappend dirDateList [file mtime $i]
              }
              default {
                 ;
              }
           }
        }

    }
    if { $isMac } {
	set nameList [eval list $dirNameList $fileNameList]
        set sizeList [eval list $dirSizeList $fileSizeList]
        set dateList [eval list $dirDateList $fileDateList]
    } else {
	set nameList [eval list "../" $dirNameList $fileNameList]
        set sizeList [eval list "(dir)" $dirSizeList $fileSizeList]
        set dateList [eval list "-" $dirDateList $fileDateList]
    }

    set selID [$itk_component(files) curselection]
    if { $selID != "" } {
	set selCO [$itk_component(files) get $selID]
    }

    if { [llength $nameList] == 0 } {
       updateBoxes [list {\[  \]} {} {}]
    } elseif { $isFtp } {
       updateBoxes [list $nameList $sizeList $dateList]
    } else {
       set dateListFmt {}
       foreach d $dateList {
          lappend dateListFmt [calcDateStr $d]
       }
       updateBoxes [list $nameList $sizeList $dateListFmt]
    }

    set newID [lsearch $nameList $selCO] 
    if { $newID != -1} {
	$itk_component(files) selection set $newID
	$itk_component(files) see $newID
        selectThat files
    }

}

body FitsFileselectionbox::upDir {} {
    global isMac
    
    if { $isFtp } {
	ftpClient cd ..
    } else {
        if { $isMac && [string first : $pwd] == [expr [string length $pwd]-1] } {
            set pwd ""
            fillContent ""
            return
        } elseif { $pwd != "" } {
            cd ..
        }
    }
    set pwd [_pwd]
    fillContent $pwd
}

body FitsFileselectionbox::selectThat { box } {
   set tmpIdx [$itk_component($box) curselection]
   if { $tmpIdx == "" } {
      set selected ""
      return
   }
   foreach b $fileCols {
      if { $box!=$b } {
         $itk_component($b) selection clear 0 end
         $itk_component($b) selection set $tmpIdx
      }
   }
   set selected [$itk_component(files) get $tmpIdx]
   if { ![isDir] } {
      set ffbFileName $selected
      $itk_component(fnamee) selection range 0 end
      focus $itk_component(fnamee)
      $itk_component(fnamee) icursor end
   }
}


body FitsFileselectionbox::isDir {} {
    global isMac
    if { $isFtp } {
	if { [string range $selected end end] == "/" } {
	    return 1
	} elseif { [string trim $selected .] == "" } {
	    return 1
        } elseif { [lsearch -exact $nameList $ffbFileName/] != -1 } {
	    return 1
        } elseif { [string first / $ffbFileName] != -1 } {
            return 1
	} else {
	    return 0
	} 
    } else {
        if { $isMac && $pwd=="" } {
            return 1
        } else {
            return [file isdirectory [string trimright $selected $dirChar]]
        }
    }
}

body FitsFileselectionbox::openThisFile {} {
   if { $ffbFileName != "" } {
      set selected $ffbFileName
      set dirFlag [isDir]
      openSelection
      if { $dirFlag } {
         set ffbFileName ""
      }
   }
}


body FitsFileselectionbox::openSelection {} {
    global isMac
    if { $selected=="" } return
    if { [isDir] } {
       if { !$isMac && [file pathtype $selected]=="absolute" } {
          fillContent $selected
       } else {
          fillContent $pwd$selected
       }
    } else {
	if { $fileCmd == "Save" } {
            saveFileCmd
	} elseif { $fileCmd == "Open"} {
	    openFileCmd
	} else {
	    puts "Un-supported file command"
	}
    }
}


body FitsFileselectionbox::listFits {} {
    fillContent $pwd
}

body FitsFileselectionbox::setFilter {} {
    fillContent $pwd
}

body FitsFileselectionbox::helpCmd {} {
    hhelp fileSelection
}

body FitsFileselectionbox::get {} {
    if { $isFtp } {
       # Need to call _pwd hear to remove the starting directory from filename
       set r_string "[_pwd 0]$ffbFileName"
       set r_string \
             "ftp://${userName}:${passwd}\@[string range $r_string 6 end]"
    } else {
       set r_string "$pwd$ffbFileName"
    }
    return $r_string
}

body FitsFileselectionbox::setCmd {cmd} {
    set fileCmd $cmd
    if { $cmd == "Open" } {
	$itk_component(openB) configure -text Open 
	$itk_component(filemode) configure -state normal
    } elseif {$cmd == "Save" } { 
	$itk_component(openB) configure -text Save 
	$itk_component(filemode) configure -state disabled
    } else {
	error "Not recognized command"
    }
}

body FitsFileselectionbox::init {} {
    $itk_component(files) select clear 0 end
    if { $isFtp } {
        # Reinitialzing, so return to local directory
        switchRemoteLocal
    } else {
        fillContent [_pwd]
    }
}

body FitsFileselectionbox::chgDir {dir} {
    if { $isFtp } {
       set dir [string range $dir 6 end]
       set idx [string first / $dir]
       if { $idx==-1 } {
          set tmpdir "/"
       } else {
          set tmpdir [string range $dir $idx end]
          if { $tmpdir=="/." } {set tmpdir "."}
       }
       ftpClient cd $tmpdir
    } else {
       cd $dir
    }
    
    set pwd [_pwd]
}

body FitsFileselectionbox::initFtp {} {

    closeFTP

    RemoteClass ftpClient
# ask for user name and passwd
    powToplevel .ftp .dummy

    iwidgets::entryfield .ftp.rhost -labeltext "Remote Host:" \
	-labelpos nw -textvariable [scope ftpHost] \
	-command  [code $this _ftpOpen]
    pack .ftp.rhost -padx 4 -pady 4 -fill x

    iwidgets::entryfield .ftp.login -labeltext "Login:" \
	-labelpos nw -textvariable [scope userName] \
	-command  [code $this _ftpOpen]
    pack .ftp.login -padx 4 -pady 4 -fill x

    iwidgets::entryfield .ftp.passwd -labeltext "Password:" \
	-labelpos nw -show "\267" -textvariable [scope passwd] \
	-command  [code $this _ftpOpen]
    pack .ftp.passwd -padx 4 -pady 4 -fill x

    iwidgets::Buttonbox .ftp.butts -padx 4 -pady 4 -orient horizontal

    .ftp.butts add connect -text "Connect" \
	  -command [code $this _ftpOpen]
    .ftp.butts add cancel -text "Cancel" \
	  -command { destroy .ftp           }
    .ftp.butts default connect
    pack .ftp.butts 
    focus [.ftp.rhost component entry]

    tkwait window .ftp
}

body FitsFileselectionbox::_ftpOpen {} {
   if { $userName=="" } {
      set userName anonymous
   }
   if { $passwd=="" && ($userName=="anonymous" || $userName=="ftp") } {
      set passwd "fv@fv.gsfc.nasa.gov"
   }      
   setWatchCursor .ftp [code ftpClient openConn $ftpHost $userName $passwd]
   set isFtp 1
   destroy .ftp
}

body FitsFileselectionbox::_pwd { {full 1} } {
    # Always return the dirChar at end of the pwd string
    if { $isFtp } {
	return [string trimright [ftpClient pwd $full] "/"]/
    } else {
	return [string trimright [pwd] $dirChar]$dirChar
    } 
}

body FitsFileselectionbox::updateAll {} {
    if { $isFtp } return
    setFilter
}

body FitsFileselectionbox::switchRemoteLocal {} {
    if { $isFtp } {
	set ffbCurrentDir $lastLocalDir
	set isFtp 0
	$itk_component(ftpB) configure -text "FTP..."
	closeFTP
    } else {
       initFtp
       if { $isFtp } {
	  set ffbCurrentDir "ftp://$ftpHost/."
	  $itk_component(ftpB) configure -text "Local..."
       } else {
          set ffbCurrentDir $lastLocalDir
       }
    }

    fillContent $ffbCurrentDir
}

body FitsFileselectionbox::closeFTP {} {
# if another ftp is in session, close it first
    if { [find objects -class RemoteClass] != "" } {
	delete object ftpClient
    } 
}

body FitsFileselectionbox::completeFileName {} {
    if { $ffbFileName == "" } return

    set tmpContent [lsort -increasing \
        [pickElemByName ${ffbFileName} $nameList]]

    if { [llength $tmpContent] == 0 } return

    set tmpRootName [lindex $tmpContent 0]
    set tmpRootLength [string length $tmpRootName]

    set tmpList [lrange $tmpContent 1 end]
    if { [llength $tmpList ] == 0 } {
       set i [string length $tmpRootName]
    } else {
       for {set i 0} {$i < $tmpRootLength} {incr i} {
          set tmpRoot [string range $tmpRootName 0 $i]
          
          if { [searchCharsForCompletion $tmpRoot $tmpList] == 1} {
             break
          }
       }
    }

    set ffbFileName [string range $tmpRootName 0 [expr $i-1]]
    showNamedFile
    $itk_component(fnamee) selection range $i end
}

body FitsFileselectionbox::pickElemByName {name list} {
    set tmplist ""

    set last [expr [string length $name]-1]
    foreach i $list {
	if { $name==[string range $i 0 $last]} {
	    lappend tmplist $i
	}
    }
    return $tmplist
}

body FitsFileselectionbox::searchCharsForCompletion {root list} {
    set last [expr [string length $root]-1]
    foreach i $list {
	if { $root!=[string range $i 0 $last] } {
	    return 1
	}
    }
    return 0
}


body FitsFileselectionbox::showNamedFile {} {

    $itk_component(fnamee) icursor end
    
    set tmpIndex [lsearch -glob $nameList ${ffbFileName}*]
    if { $tmpIndex == -1} return
    $itk_component(files) see $tmpIndex
    $itk_component(files) select clear 0 end
    $itk_component(files) select set $tmpIndex
    selectThat files
}

###################################################

body FitsFileselectionbox::activate { cmd {defaultName ""} } {
    init
    setCmd $cmd
    set ffbFileName $defaultName
    wm deiconify $itk_component(hull)
    raise $itk_component(hull)
    focus $itk_component(hull)
    $itk_component(fnamee) selection range 0 end
    $itk_component(fnamee) icursor end
}

###################################################

body FitsFileselectionbox::cancelCmd {} {
   global fileselect

   wm withdraw $itk_component(hull)
   set fileselect ""
   checkForExit
}


body FitsFileselectionbox::openFileCmd {} {
   global isScript fileselect

   set fileselect [get]

   if { $isFtp } {
      delete object ftpClient
      if { [catch {openFitsFileWM $fileselect 1} err] } {
         # reopen ftpClient
         RemoteClass ftpClient
         setWatchCursor "" \
               [code ftpClient openConn $ftpHost $userName $passwd]
         fillContent $pwd
         error $err
      }

   } else {

      if {$fileselect == "" } {
         error "Please select a file"
         return
      } 

      if { [file exist $fileselect] == 0 } {
         error "File $fileselect does not exist"
         return
      }
      if { [file readable $fileselect] == 0 } {
         error "File $fileselect is not readable"
         return
      }
      if { [file extension $fileselect] == ".fv" } {
         set isScript 1
         namespace eval ::fvCmds [list source $fileselect]
         set isScript 0
      } elseif { [openFitsFile $fileselect] == "ERROR" } { 
         return 
      }

   }
   wm withdraw $itk_component(hull)
}


body FitsFileselectionbox::saveFileCmd {} {
   global fileselect

   set fileselect [get]
   set saveToDir  [file dir $fileselect]
   if {$fileselect == "" } {
      error "No file name given"
   } elseif { ![file writable $saveToDir] } {
      error "$saveToDir is not writable"
   } else {
      wm withdraw $itk_component(hull)
   }
}


###################################################

body FitsFileselectionbox::buildMenu {} {
   global isMac

   $itk_component(dirMenu) delete 0 end
   set pathElems [urlSplit $pwd]
   if { $isFtp } {
      set newP "[lindex $pathElems 0][lindex $pathElems 1]"
      eval lappend newP [lrange $pathElems 2 end]
      set pathElems $newP
   } elseif { $isMac } {
      set pathElems [linsert $pathElems 0 Desktop]
   }

   if { !$isMac || $isFtp } {
      set pathSym $dirChar
   } else {
      set pathSym ""
   }

   set c 0
   foreach i $pathElems {
      if { $i==$pathSym } { set i "" }
      $itk_component(dirMenu) add command -label $i$pathSym \
            -command [code $this setDir $c]
      incr c
   }
   $itk_component(dirBtn) configure -text $i$pathSym
}

body FitsFileselectionbox::setDir { n } {
   global isMac
   
   if { $isFtp } {
      set newPath [join [lrange $pathElems 0 $n] /]
   } elseif { $isMac } {
      if { $n==0 } {
          set newPath ""
          set pwd ""
      } else {
          set newPath [eval file join [lrange $pathElems 1 $n]]
      }
   } else {
      set newPath [eval file join [lrange $pathElems 0 $n]]
   }
   fillContent $newPath
}

body FitsFileselectionbox::postMenu {time X Y} {

   set postTime $time

   set x [expr $X - [winfo reqwidth $itk_component(dirMenu)]/2  ]
   set y [expr $Y - [$itk_component(dirMenu) yposition end] - 10]

   tk_popup $itk_component(dirMenu) $x $y
}


body FitsFileselectionbox::buttonRelease {time} {
    if { [expr abs([expr $postTime - $time])] <= 150 } {
        return -code break
    }
}

############################################################

body FitsFileselectionbox::scrollBoxes { args } {
   foreach b $fileCols {
      eval $itk_component($b) yview $args
   }
}

body FitsFileselectionbox::scrollOthers { box args } {
   eval $itk_component(fscroll) set $args
   set view [$itk_component($box) yview]
   foreach b $fileCols {
      if { $box!=$b } {
         $itk_component($b) yview moveto [lindex $view 0]
      }
   }
}

body FitsFileselectionbox::updateBoxes { data } {
   foreach b $fileCols d $data {
           $itk_component($b) delete 0 end
      eval $itk_component($b) insert 0 $d
   }
}
