#ifndef STATS_H
#define STATS_H

/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <stdint.h>
#include <time.h>

struct rate
{
   double input;
   double output;
};

struct sample
{
   time_t timestamp;
   uint64_t input;
   uint64_t output;
   struct sample *head,*tail;
};

struct stats
{
   struct sample *sample;
   size_t avail;
   size_t total;
};

/*
 * Initialize stats structure.
 */
extern void stats_create (struct stats *stats,time_t period);

/*
 * Destroy stats structure.
 */
extern void stats_destroy (struct stats *stats);

/*
 * Update stats counters. Returns 0 if successful, -1 if some
 * occurred. You can check which error occurred by calling
 * abz_get_error().
 */
extern int stats_update (struct stats *stats,const struct sample *sample);

/*
 * Calculate average rate over period (or less if there are
 * not enough samples available) and store the result in sample.
 * Return 0 if successful, -1 if no samples are available.
 */
extern int stats_calc_rate (struct rate *avg,const struct stats *stats,time_t period);

#endif	/* #ifndef STATS_H */
