/***************************************

    This is part of frox: A simple transparent FTP proxy
    Copyright (C) 2000 James Hollingshead

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ccp.c -- ftp-proxy like command control program.
  
  ***************************************/

#include <sys/wait.h>
#include "common.h"
#include "ccp.h"

#define EPR "FROX_"

static int exec_ccp(void);

void ccp_init(void)
{
	sstr *buf;

	if(!config.ccpcmd) return;

	buf=sstr_init(MAX_LINE_LEN);
	
	setenv(EPR "CLIENT", 
	       inet_ntoa(info->client_control.address.sin_addr), 1);
	setenv(EPR "SERVER", 
	       inet_ntoa(info->server_control.address.sin_addr), 1);
	setenv(EPR "SERVERNAME", info->server_name ? 
	       sstr_buf(info->server_name) : "", 1);
	sstr_apprintf(buf, "%lu-%u", time(NULL), getpid());
	setenv(EPR "SESSION", sstr_buf(buf), 1);

	setenv(EPR "COMMAND", "+NEW", 1);
	exec_ccp();

	sstr_free(buf);
}

int ccp_allowcmd(sstr *cmd, sstr *arg)
{
	if(!config.ccpcmd) return TRUE;

	if(!sstr_cmp2(cmd, "USER")) {
		setenv(EPR "SERVER", 
		       inet_ntoa(info->server_control.address.sin_addr), 1);
		setenv(EPR "SERVERNAME", info->server_name ? 
		       sstr_buf(info->server_name) : "", 1);
		setenv(EPR "USER", sstr_buf(arg), 1);
	}
	setenv(EPR "COMMAND", sstr_buf(cmd), 1);
	setenv(EPR "PARAMETER", sstr_buf(arg), 1);

	return(exec_ccp());
}

static int exec_ccp(void)
{
	int log_fds[2], message_fds[2], i;
	static char *argv[2];
	sstr *buf;

	argv[0]=config.ccpcmd;
	argv[1]=NULL;

	pipe(log_fds);
	pipe(message_fds);
	switch(fork()){
	case 0: /*Child*/
		close(log_fds[0]);
		close(message_fds[0]);
		dup2(log_fds[1], 1);
		dup2(message_fds[1], 2);
		execvp(argv[0], argv);
		write_log(ERROR, "Failed to exec ccp prog");
		quit(NO_MESSAGE);
	case -1:
		close(log_fds[1]);
		close(message_fds[1]);
		debug_err("Error");
		break; /*FIXME*/
	default:
	}
	wait(&i);
	if(!WIFEXITED(i)) {
		close(log_fds[0]);
		close(message_fds[0]);
		write_log(ERROR, "CCP program exited abnormally");
		quit(NO_MESSAGE);
	}

	buf=sstr_init(MAX_LINE_LEN);
	sstr_append_read(log_fds[0], buf, MAX_LINE_LEN);
	if(sstr_len(buf)>0) write_log(IMPORT, sstr_buf(buf));
	close(log_fds[0]);

	sstr_empty(buf);
	sstr_append_read(message_fds[0], buf, MAX_LINE_LEN);
	if(sstr_len(buf)>0) sstr_write(info->client_control.fd, buf, 0);
	close(message_fds[0]);
	sstr_free(buf);

	switch( WEXITSTATUS(i) ) {
	case 0:
		return TRUE;
	case 1: 
		return FALSE;
	case 2:
		write_log(ERROR, "CCP requested exit. Closing session");
		quit(NO_MESSAGE);
	}
	write_log(ERROR, "CCP exited with unknown exit code");
	quit(NO_MESSAGE);
	return FALSE;
}
