/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.8 $
 *
 * $Log: flow_exporter.c,v $
 * Revision 1.8  2003/06/19 17:11:20  tim
 * new memory management
 * removed the fragment list
 *
 * Revision 1.7  2003/03/20 20:27:44  tim
 * modified a bit the memory allocation
 *
 * Revision 1.6  2003/03/07 18:56:02  tim
 * *** empty log message ***
 *
 * Revision 1.5  2003/01/20 19:56:33  tim
 * - set src/dst as to 1
 * - add select and delay before sending each udp packet
 *
 * Revision 1.4  2002/12/13 19:44:44  tim
 * - set the correct uptime in exported flows
 *
 * Revision 1.3  2002/12/03 23:28:36  tim
 * added support for snmp interface id
 *
 * Revision 1.2  2002/11/26 09:28:14  tim
 * row level mutex locking
 * cleanup in flow_scan
 *
 * Revision 1.1  2002/11/24 23:13:38  tim
 * Initial revision
 *
 *
 *
 */

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <pthread.h>
#include <errno.h>
#include <string.h>

#include "flow_exporter.h"
#include "flow_storage.h"
#include "flow.h"
#include "fprobe.h"

struct flow_item_t *to_export_list = NULL;

int export_sock;
struct sockaddr_in client_sa;
int req_len;
int to_export_items;
unsigned long last_export, start_time, now;
unsigned int flow_seq;
struct flow_pdu_v5 pdu;

void flow_export_init(char *ip, unsigned short port) {
  int buff_size;

  export_sock = socket(PF_INET, SOCK_DGRAM, 0);
  if (export_sock <= 0) {
#ifdef	DEBUG
    fprintf(stderr,"[Exporter] Error creating export_socket\n");
#endif
    return;
  }
  client_sa.sin_family = AF_INET;
  client_sa.sin_addr.s_addr = inet_addr(ip);
  client_sa.sin_port = htons(port);
  req_len = sizeof(client_sa);
  to_export_items = 0;
  last_export = 0;
  flow_seq = 0;

  buff_size = 1500 * 512;
  if (setsockopt(export_sock, SOL_SOCKET, SO_SNDBUF, (char *)&buff_size, sizeof(int)) < 0) {
    fprintf(stderr,"SO_SNDBUF error: %s\n", strerror(errno));
  }
  start_time = timestamp(NULL);
}

void flow_export_item(struct flow_item_t *flow) {
 /* add a flow to export list */
 unsigned long now;

#ifdef	DEBUG
 fprintf(stderr,"[Exporter] Added flow to export list\n");
#endif
 flow_status[flow->particle_id] = FLOW_STATUS_EXPORT;

 /* pthread_mutex_lock(&mutex_exporter);
 flow->next = to_export_list;
 to_export_list = flow;
 to_export_items++;

 pthread_mutex_unlock(&mutex_exporter);
 */

}

void flow_export_xmit() {
  unsigned int flows;

  now = timestamp(NULL);
  flows = flow_export_send_packet();
}

void write_packet(void *buffer, int count) {
  int try, bytes;
  fd_set WRITE_FD;
  struct timeval tv;

  tv.tv_sec = 0;
  tv.tv_usec = 1; 
  try = 2;
  do { 
    try++;
    FD_ZERO(&WRITE_FD);
    FD_SET(export_sock, &WRITE_FD);
    if (select(export_sock+1, NULL, &WRITE_FD, NULL, &tv) > 0) {

      if (FD_ISSET(export_sock, &WRITE_FD)) {
        bytes = sendto(export_sock, buffer, 24 + 48*count, 0, (struct sockaddr *)&client_sa, req_len); 
        if (bytes != 24+48*count) {
          fprintf(stderr,"Error sending frame: %s\n", strerror(errno));
          break;
        }
      } else {
#ifdef	DEBUG
        fprintf(stderr,"[Exporter] Will try again (%d out of 3)\n", try);
#endif
      }
    } else {
#ifdef	DEBUG
      fprintf(stderr,"[Exporter] Can't select..Will try again (%d out of 3)\n", try);
#endif
    }
  } while(try<3);
  flow_seq+=count;
}

void write_packet2(void *buffer, int count) {
  int bytes;

  bytes = sendto(export_sock, buffer, 24 + 48*count, 0, (struct sockaddr *)&client_sa, req_len);
  if (bytes != 24+48*count) {
    fprintf(stderr,"Error sending framge: %s\n", strerror(errno));
  }
  flow_seq+=count;
}



unsigned int flow_export_send_packet() {
  int i, count, packets;
  struct flow_item_t *tmp,*old;
  struct flow_item_t *flow;
  int new_packet;
  struct timespec timeout;

  

#ifdef	DEBUG
  fprintf(stderr,"[Exporter] Sending pdu packet\n");
#endif
  new_packet = 1; packets = 0; count = 0;
  for(i=0;i<FLOW_ITEMS;i++) {
    flow = flow_particle[i];

    if (flow_status[i] == FLOW_STATUS_EXPORT) {

      if (new_packet) {
        memset(&pdu, 0, sizeof(struct flow_pdu_v5));

        pdu.version = 5;
        SWAPINT16(pdu.version);

        pdu.count = 0;                /* number of flows in this packet */
        pdu.sysUpTime = (now-start_time)*1000; /* router uptime */
        pdu.unix_secs = now;          /* seconds seince 0000 UTC 1970 */
        pdu.unix_nsecs = 0;           /* residual nanoseconds since 0000 UTC 1970 */
        pdu.flow_sequence = flow_seq; /* seq counter of total flows seen */
        SWAPINT32(pdu.flow_sequence);

        pdu.reserved = 0;
        new_packet = 0;
        count = 0;
      }

      pdu.records[count].srcaddr = flow->src_ip;
      pdu.records[count].dstaddr = flow->dst_ip;
      pdu.records[count].nexthop = 0;

      pdu.records[count].input = flow->src_iif;
      pdu.records[count].output = flow->dst_iif;
      SWAPINT16(pdu.records[count].input);
      SWAPINT16(pdu.records[count].output);

      pdu.records[count].dPkts = flow->packets;
      pdu.records[count].dOctets = flow->bytes;
      SWAPINT32(pdu.records[count].dPkts);
      SWAPINT32(pdu.records[count].dOctets);

      pdu.records[count].First = (flow->flow_start-start_time)*1000;
      pdu.records[count].Last = (flow->last_packet-start_time)*1000;
      SWAPINT32(pdu.records[count].First);
      SWAPINT32(pdu.records[count].Last);

      pdu.records[count].srcport = flow->sport;
      pdu.records[count].dstport = flow->dport;

      pdu.records[count].src_as = 1;
      pdu.records[count].dst_as = 1;
      SWAPINT16(pdu.records[count].src_as);
      SWAPINT16(pdu.records[count].dst_as);
      /* 
      SWAPINT16(pdu.records[count].srcport);
      SWAPINT16(pdu.records[count].dstport);
      */

      pdu.records[count].prot = flow->proto;
      count++;

      flow_add_pool(flow);

      if (count >= MAXFLOWS_V5) {
        pdu.count = count;
        SWAPINT16(pdu.count);
        write_packet2(&pdu, count);
        packets++;
        last_export = now;
        count = 0;
        new_packet = 1;
        if (packets % 5 == 0) {
          timeout.tv_sec = 0;
          timeout.tv_nsec = 1;
          while (nanosleep(&timeout, &timeout) == -1 && errno == EINTR);
        }
      }
    }
  }
  if (count) {
    pdu.count = count;
    SWAPINT16(pdu.count);
    write_packet2(&pdu, count);
  }
  return count;
}
