// Copyright 2005 "Gilles Degottex"

// This file is part of "Music"

// "Music" is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// "Music" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "View.h"

#include <cassert>
#include <iostream>
using namespace std;
#include <qtooltip.h>

list<View*> View::s_views;
QSettings* View::s_settings = NULL;

void View::saveAll()
{
	assert(s_settings!=NULL);

	for(list<View*>::iterator it=s_views.begin(); it!=s_views.end(); ++it)
	{
		s_settings->beginGroup((*it)->getName());
		s_settings->writeEntry("show", (*it)->setting_show->isOn());
		(*it)->save();
		s_settings->endGroup();
	}
}
void View::loadAll()
{
	assert(s_settings!=NULL);

	for(list<View*>::iterator it=s_views.begin(); it!=s_views.end(); ++it)
	{
		s_settings->beginGroup((*it)->getName());
		(*it)->setting_show->setOn(s_settings->readBoolEntry("show", (*it)->setting_show->isOn()));
		(*it)->load();
		s_settings->endGroup();
	}
}
void View::clearAllSettings()
{
	assert(s_settings!=NULL);

	for(list<View*>::iterator it=s_views.begin(); it!=s_views.end(); ++it)
	{
		s_settings->beginGroup((*it)->getName());
		s_settings->removeEntry("show");
		(*it)->clearSettings();
		s_settings->endGroup();
	}
}

// ------------------------- instances ---------------------------

View::View(const QString& name, QWidget* parent)
: m_name(name)
, m_parent(parent)
, m_popup_menu(parent)
{
	// settings
	m_popup_menu.insertItem(new Title("<b>"+QWidget::tr(m_name)+"</b>", &m_popup_menu));
	m_popup_menu.insertSeparator();

	setting_show = new QAction(parent);
	setting_show->setMenuText(QWidget::tr("Show ")+getName()+QWidget::tr(" view"));
	setting_show->setToggleAction(true);
	parent->connect(setting_show, SIGNAL(toggled(bool)), parent, SLOT(setShown(bool)));
	setting_show->setToolTip(QWidget::tr(m_name));

	parent->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));

	s_views.push_back(this);
}

void View::mouseReleaseEvent(QMouseEvent* e)
{
	if(e->button()==Qt::RightButton)
		m_popup_menu.exec(e->globalPos());
}

// ----------------------- LabeledSpinBox ------------------------

//LabeledSpinBox::LabeledSpinBox(int min, int max, int step, QWidget* parent)
//: QWidget(parent)
//{
//
//}

