/***** BEGIN LICENSE BLOCK *****

    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2011 Giorgio Maone - g.maone@informaction.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
                             
***** END LICENSE BLOCK *****/

var gFlashGot = {
    
  onload: function(ev) {
    ev.currentTarget.removeEventListener(ev.type, arguments.callee, false);
    try {
      gFlashGot.init();
      
      if (!gFlashGotService._initialized) window.setTimeout(function() { gFlashGotService.init(); }, 500);
      
    } catch(e) {
      dump("FlashGot init error: " + e.message);
      gFlashGot.log("Unrecoverable init error: " + e.message + " --- " + e.stack);
    }
  },
  
  
  hoverElement: null,
  
  _isContentEvent: function(ev) {
    var d = ev.originalTarget.ownerDocument;
    return d && d.defaultView && d.defaultView.top == window.content;
  },
  
  init: function() {
    if(!gFlashGotService) throw new Error("FlashGotService not registered!");
    
    gFlashGotService.dom._winType = document.documentElement.getAttribute("windowtype");
    
    // install listeners
    gFlashGot.mouseDown = null;
    var target = window.gBrowser || window;
    
    if (target.tabContainer) {
        target.tabContainer.addEventListener("TabSelect", this.updateMediaStatus, false);
    }

    target.addEventListener("load", this.updateMediaStatus, true);
    
    target.addEventListener("mousedown", function(ev) {
      if (!(ev.button <= 1 && gFlashGot._isContentEvent(ev))) return;
      if (gFlashGot.mouseDown && gFlashGot.mouseDown.gesture === 1)
        gFlashGotService.cursor(false);
      
      gFlashGot.mouseDown = {
        x: ev.screenX,
        y: ev.screenY,
        gesture: ev.button === 1 ? 0 : -1,
        lastY: ev.screenY
      };
      gFlashGot.hoverElement = ev.originalTarget;
    }, false);
    
    target.addEventListener("mousemove", function(ev) {
      const md = gFlashGot.mouseDown;
      if (!md) return;
      
      switch(md.gesture) {
        case -1: // aborted
          return;
        case 0: // yet to be started
          if (Math.sqrt(Math.pow(ev.screenX - md.x, 2) + Math.pow(ev.screenY - md.y, 2)) < 12)
            break; // too near
          if (gFlashGot.isSelInvalid && !gFlashGot.currentLink) {
            md.gesture = -1;
            break;
          }
        case 1: // ongoing gesture
          var sy = ev.screenY;
          var dy = sy - md.lastY;
          md.lastY = sy;
          if (dy < 0 || Math.abs(ev.screenX - md.x) / (ev.screenY - md.y) > .25 ||
              !gFlashGot._isContentEvent(ev)) {
            // raising back or not south, abort
            if (md.gesture === 1) gFlashGotService.cursor(false);
            md.gesture = -1;
          } else if (md.gesture === 0) {
            md.gesture = 1;
            if (gFlashGotService.getPref("gesture.feedback")) gFlashGotService.cursor(true);
          }
      }
    }, false);
    
    target.addEventListener("mouseover", function(ev) {
      if (!gFlashGot.mouseDown) gFlashGot.hoverElement = ev.originalTarget;
    }, false);
    
    target.addEventListener("submit", function(ev) {
      if (!gFlashGot._isContentEvent(ev)) return;
      var f = ev.originalTarget;
      if(/#FlashGot_form$/.test(f.action) || 
          f.ownerDocument.defaultView.location.hash == "#FlashGot_Form")
        gFlashGotService.interceptor.forceAutoStart = true;
    }, false);

    target.addEventListener("mouseup", function(ev) {
      const md = gFlashGot.mouseDown;
      const button = ev.button;
      gFlashGot.mouseDown = null;
      
      var gesture = md && md.gesture === 1;
      if (gesture) {
        gFlashGotService.cursor(false);
      }
      
      if (!(button <= 1 && gFlashGot._isContentEvent(ev) && gFlashGotService.interceptor)
          || ev.ctrlKey || ev.metaKey)
        return;
      
      gFlashGotService.interceptor.bypassAutoStart = false;
      gFlashGotService.interceptor.forceAutoStart = false;
      
      if (gesture || button === 0 && ev.altKey) {
        function prevent() {
          ev.preventDefault();
          ev.stopPropagation();
          gFlashGot.lastClickCaptureTime = Date.now();
        }
        
        if (button === 0) {
          var invert = gFlashGotService.getPref("invertAltShiftClick", false);
          if((ev.shiftKey && !invert) || (invert && !ev.shiftKey)) {
            gFlashGotService.interceptor.bypassAutoStart =
              gFlashGotService.getPref("bypassCombo", true);
            return;
          }
        }
        
        if(gFlashGotService.getPref(button === 0 ? "altClick" : "gesture")) {
          try {
            if(gFlashGot.download()) {
              prevent();
              return;
            }
            if (button !== 0) return;
          } catch(ex) {}
          gFlashGotService.interceptor.forceAutoStart = true;
        } else {
          return;
        }
        
        ev2 = ev.view.document.createEvent("MouseEvents");
        ev2.initMouseEvent("click", ev.canBubble, ev.cancelable, 
                           ev.view, ev.detail, ev.screenX, ev.screenY, 
                           ev.clientX, ev.clientY, 
                           //ev.ctrlKey, ev.altKey, ev.shiftKey, ev.metaKey,
                           false,false,false,false,
                           ev.button, ev.relatedTarget);
        prevent();
        gFlashGot.hoverElement.dispatchEvent(ev2);
      }
    }, true);
    
    target.addEventListener("click", function(ev) {
      if(ev.altKey && ev.originalTarget.ownerDocument != document &&
        typeof(gFlashGot.lastClickCaptureTime) == "number" && 
        Date.now() - gFlashGot.lastClickCaptureTime < 100
      ) {
        ev.preventDefault();
        ev.stopPropagation();
      }
    }, true);
    
    
    this.contextMenu.addEventListener("popupshowing", function(ev) {
        if(this == ev.explicitOriginalTarget) {
          gFlashGot.prepareContextMenu(ev);
        }
      },false);
    this.contextMenu.addEventListener("popuphidden", function(ev) {
        if(this == ev.explicitOriginalTarget) {
          gFlashGot.disposeContextMenu(ev);
        }
    }, false);
    
    
    window.setTimeout(function() {
      gFlashGotService.checkVersion();
      if (gFlashGotService.firstRun) gFlashGot._mediaUI; // forces relocation
      
      gFlashGot.toggleMainMenuIcon();
    }, 500);
  }

, 
  log: function(msg) {
    gFlashGotService.log(msg);
  }
,
  get contextMenu() {
    var cm =
        document.getElementById("contentAreaContextMenu") ||
        document.getElementById("mailContext") || // TB3
        document.getElementById("messagePaneContext"); // TB2 
    if (cm) {
      delete this.contextMenu;
      this.contextMenu = cm;
    }
    return cm;
  }
,
  switchOption: function(opt) {
    gFlashGotService.setPref(opt, !gFlashGotService.getPref(opt));
  }
,
  openOptionsDialog: function(tab) {
     window.openDialog(
        "chrome://flashgot/content/flashgotOptions.xul",
        "flashgotOptions",
        "chrome, dialog, centerscreen, alwaysRaised",
        arguments.length ? {tabselIndexes:  [tab || 0]} : null);  
  }
,
  openAboutDialog: function() {
    window.open("chrome://flashgot/content/about.xul", "flashgotAbout",
      "chrome,dialog,centerscreen");
  }
,
  browse: function(url) {
    var browser =  window.getBrowser();
    browser.selectedTab = browser.addTab(url);
  }
,
  browseHomePage: function() {
    this.browse("http://flashgot.net");
  }
,
  get hideIcons() {
    return gFlashGotService.getPref("hide-icons", false);
  }
,
  toggleIcon: function(m, hide) {
    if(!m) return;
    const iconicClass = m.tagName + "-iconic";
    const rx=new RegExp("\\b"+iconicClass+"\\b");
    if(hide) {
      m.className=m.className.replace(rx, "").replace(/\bflashgot-icon-(\w+)\b/,'flashgot-noicon-$1');
    } else {
      const cl=m.className;
      if(!rx.test(cl)) {
        m.className=cl.replace(/\bflashgot-noicon-(\w+)\b/,'flashgot-icon-$1')+" "+iconicClass;
      }
    }
  }
,
  toggleMainMenuIcon: function() {
    this.toggleIcon(document.getElementById("flashgot-menu"), this.hideIcons);
  }
,
  prepareToolsMenu: function(ev) {
    
    function toggleMenu(id,disabled) {
      id = "flashgot-main-menuitem-" + id;
      var m = document.getElementById(id);
      if(!m) return;
      m.setAttribute("disabled", disabled);
      gFlashGot.toggleIcon(m, hideIcons);
    }
    
    
    
    if(gFlashGotService && !(document.getElementById("flashgot-menu").hidden = gFlashGotService.getPref("hide-menu"))) {
      const dis = false; // !gFlashGotService.DMS.found; // can never be since we implemented built-in
      const hideIcons = this.hideIcons;
      this.updateMediaUI();
      
      toggleMenu("tabs", dis || !this.isTabbed); 
      toggleMenu("all", dis);
      toggleMenu("sel", dis || this.isSelInvalid);
      toggleMenu("buildGallery", false);
      toggleMenu("media", dis || !this.media);
      toggleMenu("opts", false);      
    }
  }
,
 
  prepareContextMenu: function(ev) {
    this.toggleMainMenuIcon();
    
    const fg = gFlashGotService;
    var menuCount = 0;
   
    function menuSwitch(name, disabled) {
      
      var menuItem = document.getElementById("flashgot-menuitem-" + name);
      
      if(menuItem && 
        ! ( menuItem.hidden = 
            ( hidden || gFlashGotService.getPref("hide-" + name) ) )
      ) {
       menuItem.setAttribute("disabled", disabled ? "true" : "false");
       if(! (menuItem.hidden=disabled && hideDisabled) ) {
         menuCount++;
       }
       gFlashGot.toggleIcon(menuItem, hideIcons);
      }
    }
    
    var menuItem = null;
    const defaultDM = fg.defaultDM;  
    const dms = fg.hasDMS ? fg.DMS : null;
    var dm = dms && (dms.found ? dms[defaultDM] : null) || {hideNativeUI: function() {}};
    
    const invalidLink = !this.popupLink;   
    const invalidSel = this.isSelInvalid;
    
    const noLink = this.linksCount == 0;
    const hideDisabled = fg.getPref("hideDisabledCmds");
   
    var hidden = !dm;
    const hideIcons = this.hideIcons;
    
    var hideLink = invalidLink || hidden || dm.disabledLink;
    var hideSel = invalidSel || hidden  || dm.disabledSel;
    
    
    this.updateMediaUI();
    
    menuSwitch("it",  hideLink);
    menuSwitch("sel", hideSel);
    menuSwitch("all", noLink || hidden || dm.disabledAll);
    menuSwitch("tabs", (! (typeof(gBrowser)=="object" 
      && gBrowser.browsers && gBrowser.browsers.length > 1) ) 
                           || hidden || dm.disabledAll);
    menuSwitch("media", hidden || !this.media);

    hidden = false;
    menuSwitch("buildGallery", false);
    
    const optsMenu = document.getElementById("flashgot-menu-options");
    this.toggleIcon(optsMenu,hideIcons);
    if(!(optsMenu.hidden = gFlashGotService.getPref("hide-options"))) {
      menuCount++;
    }
    
    const submenu = document.getElementById("flashgot-submenu");
    this.toggleIcon(submenu, hideIcons);
    const subanchor = document.getElementById("flashgot-submenu-anchor");
    const subpop = subanchor.parentNode;
    const sep1 = document.getElementById("flashgot-context-separator");
    const sep2 = document.getElementById("flashgot-context-separator2");
    const menu = sep1.parentNode;
    var next = null;
    
    const nested = fg.getPref("nested-menu") && (menuCount > 1);
    submenu.hidden = !nested;
    if(nested) {
      menuCount=0;
      if(!subanchor.nextSibling) {
        menuItem = document.getElementById("flashgot-menuitem-tabs");
        if (menuItem)
            menuItem.setAttribute("accesskey",
                document.getElementById("flashgot-main-menuitem-tabs").getAttribute("accesskey"));
        for(menuItem = sep1.nextSibling;
            menuItem && (menuItem != sep2); 
            menuItem = next) {
          next = menuItem.nextSibling;
          subpop.appendChild(menuItem);
        }
      }
    } else {
      menuItem = document.getElementById("flashgot-menuitem-tabs");
      if (menuItem) menuItem.removeAttribute("accesskey");
      for(menuItem = subanchor.nextSibling; menuItem; menuItem = next) {
        next = menuItem.nextSibling;
        menu.insertBefore(menuItem, sep2);
      }
    }
    sep1.hidden = menuCount == 0;
    
    if (!fg.hasDMS) {
      ev.target.addEventListener("popupshown", function shown(ev) {
        ev.currentTarget.removeEventListener(ev.type, shown, false);
        if (fg.DMS) gFlashGot.prepareContextMenu(ev);
      }, false);
    } else {
      fg.restoreNativeUIs(document);
      dm.hideNativeUI(document);
      this.prepareCommandsMenu(document.getElementById("flashgot-menuitem-it"), hideLink && hideSel);
    }
    
  }
,
  disposeContextMenu: function(ev) {
    gFlashGotService.restoreNativeUIs(document);
  },
  prepareCommandsMenu: function(anchorNode, hideOnly) {
    var node, parentNode = anchorNode.parentNode;
    
    var cmi = (parentNode.getElementsByClassName && parentNode.getElementsByClassName("flashgot-command-menuitem")
               || parentNode.getElementsByTagName("menuitem"));
    
    var j, len;
    
    for(j = cmi.length; j-- > 0;) 
      if (/^flashgot-command-mi-/.test(cmi[j].id))
        parentNode.removeChild(cmi[j]);
    
    if(hideOnly) return;
    
    var mi, dm, id;
    const dms = gFlashGotService.DMS;
    for(j = 0, len = dms.length; j < len; j++) {
      dm = dms[j];
      if(dm.supported && dm.shownInContextMenu) {
        id =  "flashgot-command-mi-" + dm.codeName;
        if (!document.getElementById(id)) {
          mi = document.createElement("menuitem");
          mi.setAttribute("class", "menuitem-iconic flashgot-command-menuitem");
          mi.setAttribute("label", dm.name);
          mi.setAttribute("id", id);
          mi.setAttribute("oncommand", "gFlashGot.downloadSel(this.label) || gFlashGot.downloadPopupLink(this.label)");
          parentNode.insertBefore(mi, anchorNode);
        }
        dm.hideNativeUI(document);
      }
    }
  },
  
  
  prepareOptsMenu: function(parentNode) {
   
    const opts = parentNode.getElementsByTagName("menuitem");
    
    this.toggleIcon(document.getElementById("flashgot-tbb-menuitem-opts"), this.hideIcons);
    
    var menuItem, id, match, lastMenu=null, isTBB=false;
    var j = opts.length;
    while(j-- > 0) {
      menuItem = opts[j];
      if((id=menuItem.id)) {
        if((match = id.match(/opt-(.*)/))) {
          menuItem.setAttribute("checked",
            gFlashGotService.getPref(match[1]) ? "true" : "false");
        } else if((match = id.match(/^flashgot-(\w+)-menuitem-nodms$/))) {
          lastMenu = menuItem;
          isTBB = match[1]=="tbb";
        }
      }
    }
    
    if(!lastMenu) return;
    
    const defaultDM = gFlashGotService.defaultDM;  
    const dms = gFlashGotService.DMS;
    var menuItemId;
    if(dms.found) {
      var idPrefix="flashgot-menuopt-dm-";
      var eventPostfix;
      if(isTBB) {
        idPrefix += "tbb-";
        eventPostfix = "gFlashGot.downloadSel() || gFlashGot.downloadAll()";
      } else {
        eventPostfix = "gFlashGot.downloadSel() || gFlashGot.downloadPopupLink()";
      }
      lastMenu.setAttribute("hidden", "true");
      parentNode = lastMenu.parentNode;
      var dm;
      const miclass = "flashgot-dms-entry";
      // add menu items
      for(j = dms.length; j-- >0;) {
        dm = dms[j];
        if(dm.supported) {
          menuItemId = idPrefix + dm.codeName;
          menuItem = document.getElementById(menuItemId);
          if(!menuItem) {
            menuItem = document.createElement("menuitem");
            menuItem.setAttribute("class", miclass);
            menuItem.setAttribute("id", menuItemId);
            menuItem.setAttribute("type", "radio");
            menuItem.setAttribute("autocheck", "true");
            menuItem.setAttribute("oncommand", 
                "gFlashGotService.defaultDM = this.label; window.setTimeout(function() { " + 
                  eventPostfix + " }, 0)");
            menuItem.setAttribute("label", dm.name);
            parentNode.insertBefore(menuItem, lastMenu);
          }
          menuItem.setAttribute("checked", (defaultDM == dm.name) ? "true" : "false");
          lastMenu = menuItem;
        }
      }
      // remove menu items
      var nodes=parentNode.getElementsByAttribute("class", miclass);
      for(j=nodes.length; j-->0;) {
        dm=dms[nodes[j].getAttribute("label")];
        if(!(dm && dm.supported)) {
          parentNode.removeChild(nodes[j],true);
        }
      }
    } else {
      lastMenu.removeAttribute("hidden");
    }
  }
,

  get _mediaUI() {
    var addonBar = document.getElementById("addon-bar");
    var widgetId = "flashgot-media-status";
    if (addonBar) {
      var el = document.getElementById(widgetId);
      if (el) el.parentNode.removeChild(el);
      widgetId = "flashgot-media-tbb";
      el = document.getElementById(widgetId);
      if (el && (el.nextSibling && el.nextSibling.id == "search-container" ||
                 addonBar.collapsed && el.parentNode == addonBar)) {
        el = null;
      }
      if (!el) {
        var bar, refId;
        var navBar = document.getElementById("nav-bar");
        if(addonBar.collapsed && navBar && !navBar.collapsed) {
          bar = navBar;
          refId = "urlbar-container";
        } else {
          bar = addonBar;
          refId = "status";
        }
        
        var set = bar.currentSet.split(/\s*,\s*/);
        
        for (var p; (p = set.indexOf(widgetId)) > -1;)
          set.splice(p, 1);
          
        set.splice(set.indexOf(refId), 0, widgetId); 
        bar.setAttribute("currentset", bar.currentSet = set.join(","));
        document.persist(bar.id, "currentset");
        try {
          window.BrowserToolboxCustomizeDone(true);
        } catch (e) {}
      }
    }
    delete this._mediaUI;
    return this._mediaUI =
      [widgetId, "flashgot-menuitem-media", "flashgot-main-menuitem-media"]
        .map(function(id) { return document.getElementById(id) })
        .filter(function(el) { return !!el });
  },
  
  _mediaTip: function(media) {
    return media && media.length &&
      typeof(/ /) === "object" // Fx >= 3, multiline tooltips supported 
      ? media.map(function(l) { return l.tip }).join("\n")
      : '';
  },
  
  updateMediaUI: function() {
    var media = this.media;
    var count = (media && media.length) ? " (" + media.length + ")" : "";
    var tip = this._mediaTip(media);
    
    var l;
    for each(var ui in this._mediaUI) {
      if (ui) {
        l = ui.getAttribute("label");
        if (l) ui.label = l.replace(/\s*\(\d+\)$/, '') + count;
        
        if (tip) ui.setAttribute("tooltiptext", tip);
        else ui.removeAttribute("tooltiptext");
        
        if (count) ui.hidden = ui.disabled = false;
      }
    }
    this.updateMediaStatus(true);
  },
  
  updateMediaStatus: function(anim) {
    if (this !== gFlashGot) {
      gFlashGot.updateMediaStatus();
      return;
    }
    
    var ms = this.mediaStatusAnim.widget;
    if (ms) {
      if (gFlashGotService.getPref("media.statusIcon", true)) {
          
          var media = this.media;
          ms.hidden = ms.disabled = !(media && media.length);
          
          if (!(anim || ms.hidden)) {
            var tip = this._mediaTip(media);
            if (tip) ms.setAttribute("tooltiptext", tip);
            else ms.removeAttribute("tooltiptext");
          }
          
      } else {
        ms.hidden = true;
      }
      this.mediaStatusAnim.run(!anim);
    }
  },
  
  mediaStatusAnim: {
    interval: 0,
    lastShowing: false,
    cycles: 0,
    get widget() {
      delete this.widget;
      return this.widget = gFlashGot._mediaUI[0];  
    },
    run: function(once) {
      var w = this.widget;
      if (!w) return;
      var showing = !w.hidden;
      if (showing) {
        var opacity = 0;
        if (!this.lastShowing) {
          this.cycles = 3;
          this.lastShowing = true;
          opacity = 1;
        }
        if (this.cycles <= 0) return;
        var opacity = opacity || parseFloat(w.style.opacity) || 1;
        if (opacity <= .1) {
           opacity = 1;
           this.cycles --;
        } else {
           opacity -= .05;
        }
        w.style.opacity = opacity;
        if (!once)
          window.setTimeout(function() { gFlashGot.mediaStatusAnim.run(); }, 50);
      } else this.lastShowing = false;
    }
  },
  
  prepareMediaMenu: function(menu) {
    var pivot = Array.slice(menu.getElementsByTagName("menuseparator")).pop();
    while (pivot.nextSibling) menu.removeChild(pivot.nextSibling);
    var m = this.media;
    if (!(m && m.length)) return false;
  
    var mi;
    for (var j = 0; j < m.length; j++) {
      menu.appendChild(this._createMediaMenuItem(m[j]));
    }
    return true;
  },
  _createMediaMenuItem: function(l) {
    mi = document.createElement("menuitem");
    mi.setAttribute("label", l.label);
    mi.setAttribute("tooltiptext", l.tip);
    mi.addEventListener("command", function() { gFlashGot.downloadMedia([l]); }, false);
    return mi;
  },
  

  get srcWindow() {
    return document.commandDispatcher.focusedWindow;
  }
,
  get srcDocument() {
    return this.srcWindow.document;
  }
,

  get isTabbed() {
    var b = window.gBrowser;
    return b && b.browsers && b.browsers.length > 1;
  }
,
  get isSelInvalid() {
    return this.srcWindow.getSelection().isCollapsed && !this.grabSelectedTextFields(null, true);
  }
,
  get popupLink() { 
    return this.findLinkAsc(document.popupNode);
  }
,
  get currentLink() { 
    const sel = this.srcWindow.getSelection();
    return !sel.isCollapsed && this._wrapAnchor(sel.anchorNode)
      || this.findLinkAsc(this.hoverElement) || this.findLinkAsc(document.commandDispatcher.focusedElement);
  }
,
  get linksCount() {
    const doc = this.srcDocument;
    if(!doc) return 0;
    
    var count = doc.links && doc.links.length || 0;
    
    if(gFlashGotService.getPref("includeImages")) 
       count += (doc.images && doc.images.length) || 0;
    count += (doc.embeds && doc.embeds.length) || 0;
    
    return count;
  }
,
  getLinks: function(filter, includeImages, doc) {
    if(typeof(doc) != "object") {
      doc = this.srcDocument;
    }
    if(doc == null) return [];
    const allLinks = [];
    
    function wrapAndFilter(newL, l) {
      const href = l.src;
      if (!href) return null;
      
      if(href.lastIndexOf("://", 9) < 0) {
        try {
          newL.href = 
                (uriResolver || 
                 (uriResolver = 
                  Components.classes['@mozilla.org/network/io-service;1']
                            .getService(Components.interfaces.nsIIOService)
                            .newURI(doc.URL, null, null))).resolve(href);
        } catch(ex) {
          return false;
        }
      } else {
        newL.href =  href 
      }
      

      var des = l.alt || l.title || href.substring(href.lastIndexOf("/") + 1);
      var w, h;
      if ((w = l.width) && (h = l.height))
        des += " (" + w + "," + h + ")";
        
      newL.description = des;

      return filter(newL, l);
    }
    
    function filterLinks(elems, filter, tagName) {
      const wrap = tagName === "A";
      try {
        if(elems) {
          var l, newL;
          for(var j = 0, len = elems.length; j < len; j++) {
            l = elems[j];
            newL = wrap ? gFlashGot._wrapAnchor(l) : { tagName: tagName };
            if(newL && filter(newL, l)) {
              allLinks[allLinks.length] = newL;
            }
          }
        }
      } catch(ex) {}
    }
    
    
    
    filterLinks(doc.links, filter, "A"); 
    
    var uriResolver = null;
    
    if(includeImages) {
      filterLinks(doc.images, wrapAndFilter,"IMG");
    }
    
    filterLinks(doc.embeds,wrapAndFilter,"EMBED");

    return allLinks;
  }
,
  get referrer() {
    if(this._referrer) return this._referrer;
    var docURL = this.srcDocument.URL;
    var gb = docURL && docURL.substring(0,5) == "file:" && this.getBuildGalleryData();
    return gb ? gb.referrer : docURL;
  }
,  
  set referrer(r) {
    return this._referrer = r; 
  },
  
  getBuildGalleryData: function(doc) {
    doc = doc || window.content.document;
    const props = ['preview', 'content', 'referrer'];
    var gb = {};
    try {
      for each(var p in props) {
        gb[p] = doc.getElementById(p).firstChild.nodeValue;
      }
    } catch(e) {
      gb = null;
    }
    return gb;
  },
  
  grabSelectedTextFields: function(selection, justCheck) {
    const doc = this.srcDocument;
    var ff, f, j;
    const vv = [];
    var selStart, selEnd;
    for each(var t in ["textarea", "input"]) {
      var ff = doc.getElementsByTagName(t);
      for(j = 0; (f = ff[j]); j++) {
        try {
          if(selection && selection.containsNode(f, true)) {
            if(justCheck) return true;
            vv.push(f.value);
          }
          else {
            selStart = f.selectionStart, selEnd = f.selectionEnd;
            if(selStart < selEnd) {
              if(justCheck) return true;
              vv.push(f.value.substring(selStart, selEnd));
            }
          }
        } catch(e) {}
      }
    }
    return justCheck ? false : vv;
  }
,
  getSelectionLinks: function(includeImages) {
    const selection = this.srcWindow.getSelection();
    
    // link nodes detection
    var links = this.getLinks(function(link, trueNode) {
      return link && gFlashGot.checkLink(link) && 
        selection.containsNode(trueNode ? trueNode : link, true); 
    }, includeImages); 
    
    var selString = selection.toString();
    
    // add textboxes
    
    selString += this.grabSelectedTextFields(selection).join("\n");
    
    var m;
    
    // password detection
    var pwd = gFlashGotService.getPref("selection.guessPassword", true) &&
        (m = selString.match(/\b(?:password|passw|pass|pwd|pw)\W+(.*)/i)) && m[1];

    // text links detection
    m = selString.match(
      /\b(?:(?:h.{2}p|ftp|mms|ed2k|rtsp|rtmpe?):\/\/|[a-z]+[a-z\d]+\.[a-z\d\-\.]+\/|magnet:\?)[^\s]*/gi);
    selString = "";
    var j, k;
    if(m) {
      var descMap = null;
      var href, desc;
      var d, diff;
      
      linksLoop:
      for(j = 0, len = m.length; j < len; j++) {
        desc = m[j];
        href = desc.replace(/^h.{2}p/i, "http").replace(/^([a-z]+[a-z\d]+\.[a-z\d\.]+\/)/i, "http://$1");
        // TODO: riddles like http://rap*dshare.com
        if(href) {
          if(!descMap) { // we use it to avoid textual "quasi-duplicates", as http://somepart...oftheurl
            descMap = {};
            for(k = links.length; k-- > 0;) {
              descMap[links[k].description] = true;
            }
          }
          if (descMap[href] || descMap[desc]) continue;
          if (!/^https?:/.test(desc)) {
            for (d in descMap) {
              diff = d.length - desc.length;
              if (diff >= 0 && d.indexOf(desc) == diff) continue linksLoop; 
            }
          }
          links[links.length] = { href: href, description: m[j] };
        }
      }
    }
    
    if(pwd) {
      var des;
      var pwdDes = " pw: " + pwd;
      for(j = links.length; j-- > 0;) {
        des = links[j].description || "";
        links[j].pwd = pwd;
        links[j].description = des.substring(0, 4) == "http" ? pwdDes : des.concat(pwdDes);
      }
    }
    return links;
  }
,
  checkLink: function(link) {
    return link.href && /^(?:\w+:\/\/.*|javascript:.*http|magnet:)/i.test(link.href) && !/^(mailto|news|file|data):/i.test(link.href);
  }
,
  _wrapAnchor: function(node) {
    var isAnchor = (node instanceof HTMLAnchorElement);
    if(isAnchor || node instanceof HTMLAreaElement) {
      var href = node.href;
      if(href) return { 
        href: href,
        tagName: "A",
        getElementsByTagName: function(n) { return node.getElementsByTagName(n) },
        description: isAnchor 
          ? node.title || node.textContent
          : node.alt || node.title 
        };
    }
    return null;
  }
,
  findLinkAsc: function(node) {
     var anchor;
     while(node) {
      anchor = this._wrapAnchor(node);
      if(anchor) return this.checkLink(anchor) ? anchor : null;
      node = node.parentNode;
    }
    return null;
  }
,
  delayCmd: function(cmd) {
    const pg = this.createProgress();
    pg.update(5);
    window.setTimeout(function() {
      try {
        pg.value = 100;
        gFlashGot["download"+cmd]();
        gFlashGot.showProgress();
      } catch(ex) {
        dump(ex);
      }
    },0);
  }
,
  
  downloadPopupLink: function(dmName) {
    const link = this.popupLink;
    return link && this.download([link], gFlashGotService.OP_ONE, dmName);
  }
,
  downloadPopupNodeText: function(dmName) {
    if (!(document.popupNode && document.popupNode.textContent)) return false;
    return this.download([{
      href: document.popupNode.textContent,
      description: "Thunderbird Link"
    }], gFlashGotService.OP_ONE, dmName);
  }
,
  downloadLink: function(dmName) {
    const link = this.currentLink;
    return link && this.download([link], gFlashGotService.OP_ONE, dmName);
  }
,
  downloadSel: function(dmName) {
    if(this.isSelInvalid) return false;
    const startTime = Date.now();
    const links = this.getSelectionLinks(gFlashGotService.getPref("includeImages"));
    if(!links.length) return false;
    links.startTime = startTime;
    return this.download(links, gFlashGotService.OP_SEL, dmName);
  }
,
  collectAllLinks: function(doc, tagName) {
    var links = [];
    try {
      const includeImages = gFlashGotService.getPref("includeImages");
      if(tagName) {
        var frames = doc.getElementsByTagName(tagName);
        var contentDocument;
        for(var j = frames.length; j-->0;) {
          try {
            if((contentDocument = frames[j].contentDocument)) {
              links = links.concat(
                this.collectAllLinks(contentDocument));
            }
          } catch(e) { dump(e + "\n"); }
        }
      } else {
        links = links.concat(this.getLinks(this.checkLink, includeImages, doc)
          ).concat(this.collectAllLinks(doc, "frame")
          ).concat(this.collectAllLinks(doc, "iframe"));
        this.addMediaLinks(links);
      }
    } catch (e) { dump(e + "\n"); }
    return links;
  }
,
  get media() {
    return gFlashGotService.getMedia(content);
  },
  
  addMediaLinks: function(links, mm) {
    mm = mm || this.media;
    if (!(mm && mm[0])) return false;
    if (!(links.length || links.referrer)) links.referrer = mm[0].referrer;
    Array.prototype.push.apply(links, mm);
    return true;
  },
  
  clearMedia: function() {
    if (this.media) {
       // keep _map in place, so we still prevent duplicates
      this.media.length = 0;
    }
    this.updateMediaUI();
  }
,
  downloadAll: function(dmName) {
    const startTime = Date.now();
    const links = this.collectAllLinks(content.document);
    links.startTime = startTime;
    return this.download(links, gFlashGotService.OP_ALL, dmName);
  }
,
  downloadTabs: function(dmName) {
    if(!this.isTabbed) return this.downloadAll(dmName);
    const bb = getBrowser().browsers;
    var doc;
    var links=[];
    for (var j = 0, len = bb.length; j<len; j++) 
      if ((doc = bb[j].contentDocument))
        links = links.concat(this.collectAllLinks(doc));

    return links.length &&
       this.download(links, gFlashGotService.OP_ALL, dmName);
  }
,
  downloadMedia: function(mediaLinks, dmName) {
    var links = [];
    return this.addMediaLinks(links, mediaLinks) &&
      this.download(links, gFlashGotService.OP_SEL, dmName || gFlashGotService.getPref("media.dm", ""));
  }
,
  download: function(links, opType, dmName) {
    if (!links) {
      // best guess selection/link
      return this.downloadSel() || this.downloadLink();
    }

    try {
      links.referrer = links.referrer || this.referrer;
      links.browserWindow = window;
      links.document = this.srcDocument;
    } catch(ex) {}
    
    links.progress = this.createProgress();
    const ret = gFlashGotService.download(links, opType, dmName);
    if(!ret) links.progress.update(100);
    return ret;
  }
,
  progressList: [],
  createProgress: function(v) {
    return new this.Progress(v);
  },
  Progress: function(v) {
    this.value = v || 0;
    this.showing = false;
    this.update = function(v) {
      if(!this.showing) {
        this.showing = true;
        gFlashGot.progressList.push(this);
      }
      if(typeof(v) == "number") this.value = v;
      gFlashGot.showProgress();
    }
  },
  
  showProgressValue: function(v) {
    var done = v >= 100; 
    document.getElementById("flashgot-progresspanel").collapsed = done;
    document.getElementById("flashgot-progressmeter").value = v;
    gFlashGotService.yield();
  },
  
  showProgress: function() {
    const pgl = this.progressList; 
    var len = pgl.length;
    var value;
    if(len > 0) {
      value = 0;
      for(var j = len; j-- > 0;) {
        var v = pgl[j].value;
        if(v < 100) {
          value += v;
        } else {
          pgl.splice(j, 1);
          len--;
        }
      }
      value = len > 0 ? Math.round(value / len) : 100;
    } else {
      value = 100;
    }
    this.showProgressValue(value);
  }
,
  buildGallery: function() {
    var previewURL = null, contentURL = null;
    var gb = this.getBuildGalleryData();
    if(gb) {
      dump("FGBG: reusing gallery data\n");
      previewURL = gb.preview;
      contentURL = gb.content;
    } else {
      var links=this.getSelectionLinks(true);
      if(!(links && links.length)) {
        dump("FGBG: no selection links, using "); 
        if(this.popupLink) {
         dump("popup link\n");
         links = [this.popupLink];
        } else {
         dump("all links\n");
         links=this.getLinks(this.checkLink, true);
        }
      }
      var len;
      if(links && (len=links.length)) {
        const previewRX = /\d+.*\.(jpg|jpeg|png|gif|bmp)(\?|$)/i;
        const contentRX = /\d+.*\.[a-z0-9]{2,4}(\?|$)/i;
        var l, tag, url, imgs, i, iLen, imgSrc;
        for(var  j = 0; j < len && !(contentURL && previewURL); j++) {
          l = links[j];
          tag = l.tagName && l.tagName.toUpperCase();
          url = l.href;
          if(tag !== "IMG" && contentRX.test(url)) {
            contentURL = url;
            if (tag === "A" && ("getElementsByTagName" in l)) {
              imgs = l.getElementsByTagName("img");
              for(i = 0, iLen = imgs.length; i < iLen; i++) {
                imgSrc = imgs[i].src;
                if(previewRX.test(imgSrc)) {
                  previewURL = imgSrc;
                  break;
                }
              }
            }
          }
        }
        if( (!previewURL) && (tag === "IMG" || previewRX.test(url)) ) {
          previewURL=url;
        } 
      }
      if(!previewURL) previewURL = "";
      if(previewURL && !contentURL) contentURL = previewURL;
    }
    window.openDialog("chrome://flashgot/content/flashgotGalleryBuilder.xul","_blank",
      "chrome,dialog,centerscreen,resizable",
      { 
        previewURL: previewURL, 
        contentURL: contentURL, 
        referrerURL: this.referrer,
        originalWindow: window,
        tmpDir: gFlashGotService.tmpDir,
        prefs:  gFlashGotService.prefs
      }
    );
  }

}

window.addEventListener("load", gFlashGot.onload, false);