//  Copyright (c) 2014 Thomas Goyne <tgoyne@gmail.com>
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.

#ifndef ZIPFILE_H
#define ZIPFILE_H

#include "filehandle.h"

#include <vector>
#include <zlib.h>

class ZipFile {
	FileHandle file;
	std::vector<char> buffer;
	std::vector<uint8_t> index_buffer;
	bool is_file;
	z_stream z;
	enum {
		Initial,
		Inflate,
		Deflate
	} state;

public:
	ZipFile(const char *filename, const char *mode);
	ZipFile(const uint8_t *in_buffer, const size_t size);
	ZipFile();
	~ZipFile();

	void Read(void *buffer, size_t size);
	int Write(const void *buffer, size_t size);
	void Finish();
	uint8_t *GetBuffer(size_t *size);

	template<typename T>
	T Read() {
		T ret = T();
		Read(&ret, sizeof(T));
		return ret;
	}

	template<typename T>
	void Write(T const& value) {
		Write(&value, sizeof value);
	}
};

#endif
