/* $Id: traps.h,v 1.30 2009-01-28 14:38:06 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TRAPS_H_INCLUDED
#define __TRAPS_H_INCLUDED

#include "build_config.h"
#include "compiler.h"

#include "ptrace.h"

extern inline void
disable_ints(void)
{
	asm (
		"cli\n"
	);
}

extern inline void
enable_ints(void)
{
	asm (
		"sti\n"
	);
}

#define bios_exception	MODE_PREFIX(bios_exception)
#define bios_dummy	MODE_PREFIX(bios_dummy)

C_ENTRY void
bios_exception(struct regs *regs) __attribute__((__noreturn__));

C_ENTRY void
bios_dummy(struct regs *regs);

/* =================== REAL-MODE INIT ========================= */
#ifdef INIT_RM

extern void
trap_init(void);

#endif /* INIT_RM */
#endif /* __TRAPS_H_INCLUDED */
