/*
 * $Id: arch_gen_mem_Xx8.c,v 1.22 2009-08-03 06:49:41 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* Source might be used by memory chip sources, too... */
#ifndef MEM_SIZE
#define MEM_SIZE	(256*1024)
#endif

#include "config.h"

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fixme.h"
#include "glue-log.h"
#include "glue-shm.h"

#include "sig_cs.h"
#include "sig_isa_bus.h"

/*
 * Types
 */
struct chip {
	uint32_t *haddr;

	struct sig_cs *port_cs;
	struct sig_isa_bus_main *port_bus;
};

static unsigned char *
NAME_(access)(struct chip *chip, unsigned long addr)
{
	addr &= ~0xfffUL;

	return (unsigned char *) chip->haddr + addr;
}

static int
NAME_(readb)(
	void *_chip,
	uint8_t *valp,
	unsigned long addr
)
{
	struct chip *chip = (struct chip *) _chip;
	unsigned char *va;

	addr &= MEM_SIZE - 1;

	va = NAME_(access)(chip, addr);

	*valp = *(uint8_t *) (va + addr - (addr & ~0xfffUL));

	return 0;
}

static int
NAME_(writeb)(
	void *_chip,
	uint8_t val,
	unsigned long addr
)
{
	struct chip *chip = (struct chip *) _chip;
	unsigned char *va;

	addr &= MEM_SIZE - 1;

	va = NAME_(access)(chip, addr);

	*(uint8_t *) (va + addr - (addr & ~0xfffUL)) = val;

	return 0;
}

static int
NAME_(map)(
	void *_chip,
	unsigned long addr,
	char **haddr_mr_p,
	char **haddr_mw_p
)
{
	fixme();
#if 0
	struct chip *chip = (struct chip *) _chip;
	unsigned long haddr;
	unsigned long laddr;

	laddr = addr & ~0xfffUL & (MEM_SIZE - 1);
	haddr = addr & ~0xfffUL & ~(MEM_SIZE - 1);

	assert(/* 0 <= laddr && */ laddr < MEM_SIZE);

	*fdp = chip->fd;
	*offsetp = chip->offset + laddr;
	*startp = haddr;
	*lenp = MEM_SIZE;
	*wflagp = 1;
#endif

	return 0;
}

static void
NAME_(power_set)(void *_chip, unsigned int val)
{
	struct chip *chip = (struct chip *) _chip;

	if (val) {
		memset(chip->haddr, 0, MEM_SIZE);
	}
}

void *
NAME_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = NAME_(power_set),
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb	= NAME_(readb),
		.writeb	= NAME_(writeb),
		.map	= NAME_(map),
	};
	struct chip *chip;

	chip = malloc(sizeof(*chip));
	assert(chip);
	chip->haddr = shm_alloc(MEM_SIZE, SHM_PAGE_ALIGNED);
	assert(chip->haddr);

	sig_boolean_connect_in(port_power, chip, &power_funcs);

	chip->port_cs = port_cs;
	chip->port_bus = port_bus;
	sig_cs_connect(chip->port_cs, chip, &cs_funcs);

	return chip;
}

void
NAME_(destroy)(void *_cpssp)
{
	struct chip *cpssp = _cpssp;

	shm_free(cpssp->haddr, MEM_SIZE);
	free(cpssp);
}
