/*
 * $Id: sig_usb_bus.h,v 1.17 2009-05-21 16:38:09 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_USB_BUS_H_INCLUDED
#define __SIG_USB_BUS_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"
#include "sig_boolean.h"

struct sig_usb_bus_main_funcs {
	void (*reset_set)(void *s, int val);
	void (*speed_set)(void *s, int val);
	void (*recv_token)(void *s, int pid, int addr, int endp);
	void (*recv_sof)(void *s, int frame_num);
	void (*recv_data)(void *s, int pid, unsigned int length, uint8_t *data,
			uint16_t crc16);
	void (*recv_handshake)(void *s, int pid);
};
struct sig_usb_bus_main {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_usb_bus_main_funcs *f;
	} member[16];
	unsigned int member_count;
};

struct sig_usb_bus_main_merge {
	struct sig_usb_bus_main *s0;
	struct sig_usb_bus_main *s1;
};

extern int
sig_usb_bus_reset_set(struct sig_usb_bus_main *sig, void *s, int val);

extern int
sig_usb_bus_speed_set(struct sig_usb_bus_main *sig, void *s, int val);

extern int
sig_usb_bus_send_token(struct sig_usb_bus_main *sig, void *s,
		int pid, int addr, int endp);

extern int
sig_usb_bus_send_sof(struct sig_usb_bus_main *sig, void *s, int frame_num);

extern int
sig_usb_bus_send_data(struct sig_usb_bus_main *sig, void *s,
		int pid, unsigned int length, uint8_t *data, uint16_t crc16);

extern int
sig_usb_bus_send_handshake(struct sig_usb_bus_main *sig, void *s, int pid);

extern void
sig_usb_bus_main_connect(struct sig_usb_bus_main *sig,
	void *s,
	const struct sig_usb_bus_main_funcs *f);

extern struct sig_usb_bus_main *
sig_usb_bus_main_create(const char *name);
extern void
sig_usb_bus_main_destroy(struct sig_usb_bus_main *sig);

extern struct sig_usb_bus_main_merge *
sig_usb_bus_main_merge(
	struct sig_usb_bus_main *s0,
	struct sig_usb_bus_main *s1);
extern void
sig_usb_bus_main_split(struct sig_usb_bus_main_merge *m);

struct sig_usb_bus {
	enum sig_gen_type type;
	struct sig_boolean *power;
	struct sig_usb_bus_main *bus;
};

extern struct sig_usb_bus *
sig_usb_bus_create(const char *name);
extern void
sig_usb_bus_destroy(struct sig_usb_bus *sig);

#endif /* __SIG_USB_BUS_H_INCLUDED */
