/*
 * $Id: sig_magneto_optical.h,v 1.14 2009-09-10 11:27:13 vrsieh Exp $
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_MAGNETO_OPTICAL_H_INCLUDED
#define __SIG_MAGNETO_OPTICAL_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct cd_atip {
	uint8_t writing_power;
	uint8_t reference_speed;
	uint8_t unrestricted_use;
	uint8_t media_type;
	uint8_t start_of_leadin_m;
	uint8_t start_of_leadin_s;
	uint8_t start_of_leadin_f;
	uint8_t last_possible_start_of_leadout_m;
	uint8_t last_possible_start_of_leadout_s;
	uint8_t last_possible_start_of_leadout_f;
};

struct sig_magneto_optical_funcs {
	int (*atip)(void *cpssp, struct cd_atip *atip);
	int (*read)(void *cpssp, int32_t blk,
			uint8_t *data, uint8_t *psub, uint8_t *qsub);
	int (*write)(void *cpssp, int32_t blk,
			const uint8_t *data, const uint8_t *psub, const uint8_t *qsub);
};

struct sig_magneto_optical {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_magneto_optical_funcs *f;
	} member[10];
	int member_count;
};

struct sig_magneto_optical_merge {
	struct sig_magneto_optical *s0;
	struct sig_magneto_optical *s1;
};

extern int
sig_magneto_optical_atip(struct sig_magneto_optical *b, void *s,
		struct cd_atip *atip);
extern int
sig_magneto_optical_read(struct sig_magneto_optical *b, void *s,
		int32_t blk,
		uint8_t *data, uint8_t *psub, uint8_t *qsub);
extern int
sig_magneto_optical_write(struct sig_magneto_optical *b, void *s,
		int32_t blk,
		const uint8_t *data, const uint8_t *psub, const uint8_t *qsub);

extern void
sig_magneto_optical_connect(struct sig_magneto_optical *sig,
		void *s, const struct sig_magneto_optical_funcs *f);
extern void
sig_magneto_optical_disconnect(struct sig_magneto_optical *sig,
	        void *s);

extern struct sig_magneto_optical_merge *
sig_magneto_optical_merge(struct sig_magneto_optical *s0,
		struct sig_magneto_optical *s1);
extern void
sig_magneto_optical_split(struct sig_magneto_optical_merge *m);

extern struct sig_magneto_optical *
sig_magneto_optical_create(const char *name);
extern void
sig_magneto_optical_destroy(struct sig_magneto_optical *sig);

#endif /* __SIG_MAGNETO_OPTICAL_H_INCLUDED */
