/*
 * $Id: glue-shm.c,v 1.26 2009-08-03 06:49:39 vrsieh Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <sys/types.h>
#include <sys/mman.h>
#include <assert.h>
#include <stdio.h>

#include "glue-main.h"
#include "glue-shm.h"

#ifndef MAP_ANONYMOUS
#define MAP_ANONYMOUS MAP_ANON
#endif

void *
shm_alloc(unsigned int len, int flags)
{
	int prot;
	int map;
	void *retval;

	time_stop();

	/* Round to page boundary. */
	len = (len + 0xfff) & 0xfffff000;
	if (len == 0) {
		len = 4096;
	}

	if (flags & SHM_CODE) {
		prot = PROT_READ | PROT_WRITE | PROT_EXEC;
	} else {
		prot = PROT_READ | PROT_WRITE;
	}
#ifdef MAP_32BIT
	if (flags & SHM_CODE) {
		map = MAP_SHARED | MAP_ANONYMOUS | MAP_32BIT;
	} else {
		map = MAP_SHARED | MAP_ANONYMOUS;
	}
#else
	map = MAP_SHARED | MAP_ANONYMOUS;
#endif

	if (len) {
		retval = mmap((char *) 0, len, prot, map, -1, 0);
		assert(retval != (void *) -1);
	} else {
		retval = NULL;
	}

	time_cont();

	return retval;
}

void
shm_free(void *ptr, unsigned int len)
{
	int ret;

	/* Round to page boundary. */
	len = (len + 0xfff) & 0xfffff000;
	if (len == 0) {
		len = 4096;
	}

	ret = munmap(ptr, len);
	assert(0 <= ret);
}
