/*
 * $Id: glue-gui-gtk-change.h,v 1.5 2009-10-16 09:01:39 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_GUI_GTK_CHANGE_H_INCLUDED
#define __GLUE_GUI_GTK_CHANGE_H_INCLUDED

typedef struct {
	GtkHBox parent;

	const char *type;

	GtkWidget *insert;
	GtkWidget *remove;

	GtkWidget *window;
	GtkWidget *box;
	GtkWidget *label;
	GtkWidget *list_box;
	struct {
		const char *name;
		const char *port;
	} media[1000];
	unsigned int nmedias;
	GtkWidget *button_box;
	GtkWidget *button_ok;
	GtkWidget *button_cancel;

	GtkListStore *media_store;
	GtkTreeSelection *media_select;
} GuiGtkChange;

#define GUI_GTK_TYPE_CHANGE	(gui_gtk_change_get_type())
#define GUI_GTK_CHANGE(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_CHANGE, GuiGtkChange))

extern GType
gui_gtk_change_get_type(void);

extern GtkWidget *
gui_gtk_change_new(const char *type);

extern void
gui_gtk_change_set(GuiGtkChange *change, const char *string);

#endif /* __GLUE_GUI_GTK_CHANGE_H_INCLUDED */
