/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright © CNRS, INRIA, Université Bordeaux 1
 * See COPYING in top-level directory.
 */

#include "mpi.h"
#include "mpi_eztrace.h"
#include "mpi_ev_codes.h"
#include "eztrace.h"
#include "mpi_eztrace.h"


/* For MPI_Init and MPI_Init_thread, we *have* to call the Fortran version
 * of the function. Once it is done, we can call the __mpi_init_generic function
 */
void __mpi_init_generic();

void mpif_init_(void *error)
{
  libmpi_init_((int*) error);
  __mpi_init_generic();
}

void mpif_init_thread_(int *r, int *p, int *error)
{
  libmpi_init_thread_(r, p, error);
  __mpi_init_generic();
}

/* For all the remaining Fortran functions, we can just call the C version */
void mpif_finalize_(int *error)
{
  *error = MPI_Finalize();
}

void mpif_comm_size_(MPI_Fint *c, int *s, int * error)
{
  MPI_Comm c_comm = MPI_Comm_f2c(*c);
  *error = MPI_Comm_size(c_comm, s);
}

void mpif_comm_rank_(MPI_Fint *c, int *r, int *error)
{
  MPI_Comm c_comm = MPI_Comm_f2c(*c);
  *error = MPI_Comm_rank(c_comm, r);
}



void mpif_comm_spawn_(char *command, char **argv, int *maxprocs,
		      MPI_Fint *info, int *root, MPI_Fint *comm,
		      MPI_Fint *intercomm, int *array_of_errcodes, int*error)
{
  MPI_Comm c_comm = MPI_Comm_f2c(*comm);
  MPI_Info c_info = MPI_Info_f2c(*info);
  ALLOCATE_ITEMS(MPI_Comm, *maxprocs, c_intercomm, p_intercomm);

  int i;
  for(i=0; i<*maxprocs;i++)
    p_intercomm[i] = MPI_Comm_f2c(intercomm[i]);

  *error = MPI_Comm_spawn(command, argv, *maxprocs,
			  c_info, *root, c_comm,
			  p_intercomm, array_of_errcodes);
  for(i=0; i<*maxprocs;i++)
    intercomm[i] = MPI_Comm_c2f(p_intercomm[i]);

  FREE_ITEMS(*maxprocs, p_intercomm);
}

