/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: container_cb.c
 */

#include <frontend.h>
#include <gtk/gtk.h>

#include "support.h"
#include "thing.h"
#include "readable.h"
#include "logging.h"
#include "plugin_cb.h"
#include "container_cb.h"
#include "resize.h"

/*
 *
 *   void on_expand_container_clist_realize (GtkWidget *, gpointer)
 *
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of containers that can be expanded.
 *
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable containers
 *
 */
void on_expand_container_clist_realize(GtkWidget * widget, gpointer user_data)
{
	gint rc = 0;
	GtkCList *clist = GTK_CLIST(widget);
	handle_array_t *containers;

	rc = evms_get_container_list(0, 0, 0, &containers);

	if (rc != SUCCESS) {
		log_error("%s: evms_get_container_list() returned error code %d.\n", __FUNCTION__,
			  rc);
	} else {
		guint i;
		gboolean is_selected = (containers->count == 1);

		set_selection_window_clist_column_titles(clist, _("Size"),
							 make_object_type_readable_string
							 (CONTAINER), NULL);

		for (i = 0; i < containers->count; i++) {
			if (evms_can_expand(containers->handle[i]) == SUCCESS)
				add_thing_to_selection_list(clist, containers->handle[i],
							    is_selected);
		}

		if (clist->rows == 1)
			gtk_clist_select_row(clist, 0, 0);

		evms_free(containers);
	}
}

/*
 *
 *   void on_shrink_container_clist_realize (GtkWidget *, gpointer)
 *
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of containers that can be shrunk.
 *
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable containers
 *
 */
void on_shrink_container_clist_realize(GtkWidget * widget, gpointer user_data)
{
	gint rc = 0;
	GtkCList *clist = GTK_CLIST(widget);
	handle_array_t *containers;

	rc = evms_get_container_list(0, 0, 0, &containers);

	if (rc != SUCCESS) {
		log_error("%s: evms_get_container_list() returned error code %d.\n", __FUNCTION__,
			  rc);
	} else {
		guint i;
		gboolean is_selected = (containers->count == 1);

		set_selection_window_clist_column_titles(clist, _("Size"),
							 make_object_type_readable_string
							 (CONTAINER), NULL);

		for (i = 0; i < containers->count; i++) {
			if (evms_can_shrink(containers->handle[i]) == SUCCESS)
				add_thing_to_selection_list(clist, containers->handle[i],
							    is_selected);
		}

		if (clist->rows == 1)
			gtk_clist_select_row(clist, 0, 0);

		evms_free(containers);
	}
}

/*
 *
 *   void on_container_plugin_clist_realize (GtkWidget *, gpointer)
 *
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of plugins that support containers.
 *
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - contains task action code for action to use list
 *
 *   Exit:
 *      Selection list populated with available plugins that support containers
 *
 */
void on_container_plugin_clist_realize(GtkWidget * widget, gpointer user_data)
{
	set_selection_window_clist_column_titles(GTK_CLIST(widget), NULL, _("Container Plugin"),
						 NULL);

	on_plugin_selection_clist_realize(GTK_CLIST(widget), 0, SUPPORTS_CONTAINERS,
					  GPOINTER_TO_UINT(user_data));
}

/*
 *
 *   void on_resize_container_button_clicked (GtkButton *, gpointer)
 *
 *   Description:
 *      This routine simply calls the function that handles
 *      displaying expand/shrink points for the selected
 *      storage container.
 *
 *   Entry:
 *      button    - address of the GtkButton widget
 *      user_data - contains id of resize action EVMS_Task_Expand or
 *                  EVMS_Task_Shrink
 *
 *   Exit:
 *      See description.
 *
 */
void on_resize_container_button_clicked(GtkButton * button, gpointer user_data)
{
	on_resize_selection_button_clicked(button, GPOINTER_TO_UINT(user_data));
}

