/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_info.h
 */

#ifndef _MD_INFO_H_
#define _MD_INFO_H_ 1

#define NUM_VOLUME_INFO_ENTRIES 5
#define NUM_DISK_INFO_ENTRIES 5
#define NUM_SUPER_INFO_ENTRIES 24

#define MD_SUPER_INFO_CLEAN (1<<0)
#define MD_SUPER_INFO_ERRORS (1<<1)

typedef struct md_super_info {
	u_int32_t md_magic;
	u_int32_t major_version;
	u_int32_t minor_version;
	u_int32_t patch_version;
	u_int32_t set_uuid0;
	u_int32_t set_uuid1;
	u_int32_t set_uuid2;
	u_int32_t set_uuid3;
	time_t ctime;
	time_t utime;
	int32_t   level;
	u_int64_t size;                /* in sectors */
	u_int32_t nr_disks;
	u_int32_t raid_disks;
	u_int32_t active_disks;
	u_int32_t working_disks;
	u_int32_t failed_disks;
	u_int32_t spare_disks;
	int32_t md_minor;              /* minor or -1 if not used */
	boolean not_persistent;
	u_int32_t state_flags;         /* see above */
	u_int32_t sb_csum;
	int32_t layout;
	u_int64_t events;
	u_int32_t chunksize;           /* in sectors */
	u_int32_t this_disk_index;
} md_super_info_t;

typedef struct md_disk_info {
	u_int32_t number;
	u_int32_t major;
	u_int32_t minor;
	u_int32_t raid_disk;
	char * state;
} md_disk_info_t;

// Functions exported by md_info.c
extern int md_get_info(md_volume_t            * volume,
		       char                   * name,
		       extended_info_array_t ** info_array);

#endif
