
/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 	Module:rsct_appcb_queue.c
 */

#include "rsct_internal.h"
#include "eceinternal.h"
#include "rsct_appcb_queue.h"
#include <pthread.h>

extern pthread_t  gl_appcb_thread;

/*************static global variable****************/
static pthread_mutex_t gl_appcb_lock;
static GSList*         gl_appcb_list;


typedef struct appcb_entry_s{
	registercb_t* rcb;
	int type;
	int size;
	void* data;  
} appcb_entry_t;


void 
RSCT_appcb_init()
{
	
	pthread_mutex_init(&gl_appcb_lock,NULL);
	pthread_mutex_lock(&gl_appcb_lock);
	
	while(g_slist_length(gl_appcb_list) > 0){
		appcb_entry_t* entry=g_slist_nth_data(gl_appcb_list,0);
		free(entry->data);
		g_slist_remove(gl_appcb_list,entry);
	}
	pthread_mutex_unlock(&gl_appcb_lock);
}

void 
RSCT_appcb_add(int type,
	       void* rcb,
	       int size,
	       void* data )
{
	
	appcb_entry_t* entry;
	
	pthread_mutex_lock(&gl_appcb_lock);
	
	entry=(appcb_entry_t*)malloc(sizeof(appcb_entry_t));
	entry->rcb=rcb;
	entry->type=type;
	entry->size=size;
	entry->data=data;
	gl_appcb_list=g_slist_append(gl_appcb_list,entry);
	
	pthread_mutex_unlock(&gl_appcb_lock);
}

//don't use log here because this function is called too much times
int
RSCT_appcb_length()
{
	int length;
	
	//LOG_ENTRY();
	
	pthread_mutex_lock(&gl_appcb_lock);
	length=g_slist_length(gl_appcb_list); 
	pthread_mutex_unlock(&gl_appcb_lock);
	
	return length;
	
	//RETURN(length);
	
}

void 
RSCT_appcb_run_remove_first()
{
	
	appcb_entry_t* entry;
	int length;
	LOG_ENTRY();	
	
	pthread_mutex_lock(&gl_appcb_lock);
	length=g_slist_length(gl_appcb_list);
	pthread_mutex_unlock(&gl_appcb_lock);
	
	if(length == 0){
		LOG_EXIT_VOID();
		return;
	}
	
	pthread_mutex_lock(&gl_appcb_lock);
	entry=g_slist_nth_data(gl_appcb_list,0);
	pthread_mutex_unlock(&gl_appcb_lock);
	
	if(entry){		
		switch(entry->type){
		case CALLBACK_MESSAGE :{    
			ece_msg_t* ecemsg;
			ecemsg=(ece_msg_t*)entry->data;
			if(entry && entry->rcb && entry->rcb->reg_callback)
				entry->rcb->reg_callback(CALLBACK_MESSAGE,
							 sizeof(ece_msg_t)+ecemsg->size, 
							 ecemsg);
			
			break;
		}
			
		case CALLBACK_MEMBERSHIP:{
			
			int num_entries;
			ece_event_t* event=(ece_event_t*)entry->data;
			num_entries=event->num_entries;
			
			if(entry && entry->rcb && entry->rcb->reg_callback)
				entry->rcb->reg_callback(CALLBACK_MEMBERSHIP,
							 sizeof(ece_event_t)+
							 sizeof(ece_nodeid_t)*(num_entries-1),
							 entry->data);
			
			break;
		}
		default:
			LOG_ERROR("wrong entry in gl_appcb_list. Exit!\n");
			exit(1);
		}
	} else{
		
		LOG_WARNING("NULL entry in gl_appcb_lock");
		LOG_EXIT_VOID();
		return;
	}
	
	
	pthread_mutex_lock(&gl_appcb_lock);
	if(entry && entry->data)
		free(entry->data);
	gl_appcb_list=g_slist_remove(gl_appcb_list,entry);
	pthread_mutex_unlock(&gl_appcb_lock);
	
	LOG_EXIT_VOID();
	return;
}
