/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * File: replace.h
 *
 */

/*
 * Ok, it's not really a device manager.  We use the device manager plug-in type
 * so that the plug-in gets called only once during discovery.  On discovery,
 * the replace plug-in finds any old device-mapper mirror maps that were used
 * for replace and removes the maps.  Segment managers and region managers can
 * get called multiple times.  It would be a waste to call the replace plug-in
 * several times during discovery.  EVMS features only get called for discovery
 * if an object has a feature header and the feature header has the plug-in's
 * ID.  The replace plug-in should always be called on discovery, so being a
 * feature won't do.
 */
#define REPLACE_PLUGIN_ID	(SetPluginID(EVMS_OEM_IBM, EVMS_DEVICE_MANAGER, 12))


