/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdos.so
 *
 *   File: move.h
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <plugin.h>

#include "ptables.h"


#ifndef _DOS_MOVE_HEADER
#define _DOS_MOVE_HEADER 1

int dos_validate_move_target( DISKSEG *src, DISKSEG *trg );
int dos_can_move_segment( DISKSEG *seg );
int dos_move_segment( DISKSEG *seg, DISKSEG *freespace );
int dos_move_segment_finish( DISKSEG *src, DISKSEG *tgt, int copy_rc );
int dos_move_segment_commit( DISKSEG *src, DISKSEG *tgt, copy_job_t *job );

#endif
