/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: print_ext_info_item.c
 */

#ifndef _LVM_HELP_PRINT_EXT_INFO_ITEM_
#define _LVM_HELP_PRINT_EXT_INFO_ITEM_ 1

#include "print_size.c"

/* Function: print_ext_info_item
 *
 *	Format and display one item from an extended info array
 */
int print_ext_info_item( extended_info_t * ext_item )
{
	char	* str1;
	int	i;

	printf("%-25s", ext_item->title);

	switch ( ext_item->collection_type ) {

	case EVMS_Collection_None:
		switch ( ext_item->type ) {

		// The LVM plugin currently only uses a few of these types.
		// Add more as the plugin uses more
		case EVMS_Type_String:
			printf("%s\n", ext_item->value.s);
			break;
		case EVMS_Type_Int:
			if ( ext_item->unit == EVMS_Unit_Sectors ) {
				printf("%s\n", str1=print_size(ext_item->value.i, FALSE));
				if (str1) free(str1);
			}
			else {
				printf("%d\n", ext_item->value.i);
			}
			break;
		case EVMS_Type_Unsigned_Int32:
			if ( ext_item->unit == EVMS_Unit_Sectors ) {
				printf("%s\n", str1=print_size(ext_item->value.ui32, FALSE));
				if (str1) free(str1);
			}
			else {
				printf("%d\n", ext_item->value.ui32);
			}
			break;
		case EVMS_Type_Real32:
			if ( ext_item->unit == EVMS_Unit_Percent ) {
				printf("%0.2f %%\n", ext_item->value.r32);
			}
			else {
				printf("%0.2f\n", ext_item->value.r32);
			}
			break;
		default:
			printf("\n");
		}
		break;

	case EVMS_Collection_List:
		switch ( ext_item->type ) {
		case EVMS_Type_String:
			for ( i = 0; i < ext_item->collection.list->count; i++ ) {
				if (!i) {
					printf("%s\n", ext_item->collection.list->value[i].s);
				}
				else {
					printf("%25s%s\n", "", ext_item->collection.list->value[i].s);
				}
			}
			break;
		default:
			printf("\n");
		}
		break;

	default:
		printf("\n");
	}

	return 0;
}

#endif

