/* ethos-plugin-info.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_PLUGIN_INFO_H__
#define __ETHOS_PLUGIN_INFO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define ETHOS_TYPE_PLUGIN_INFO			(ethos_plugin_info_get_type ())
#define ETHOS_PLUGIN_INFO(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_TYPE_PLUGIN_INFO, EthosPluginInfo))
#define ETHOS_PLUGIN_INFO_CONST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_TYPE_PLUGIN_INFO, EthosPluginInfo const))
#define ETHOS_PLUGIN_INFO_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass),  ETHOS_TYPE_PLUGIN_INFO, EthosPluginInfoClass))
#define ETHOS_IS_PLUGIN_INFO(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), ETHOS_TYPE_PLUGIN_INFO))
#define ETHOS_IS_PLUGIN_INFO_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  ETHOS_TYPE_PLUGIN_INFO))
#define ETHOS_PLUGIN_INFO_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  ETHOS_TYPE_PLUGIN_INFO, EthosPluginInfoClass))

typedef struct _EthosPluginInfo		EthosPluginInfo;
typedef struct _EthosPluginInfoClass	EthosPluginInfoClass;
typedef struct _EthosPluginInfoPrivate	EthosPluginInfoPrivate;

struct _EthosPluginInfo
{
	GObject parent;
	
	EthosPluginInfoPrivate *priv;
};

struct _EthosPluginInfoClass
{
	GObjectClass parent_class;

	void (*reserved1) (void);
	void (*reserved2) (void);
	void (*reserved3) (void);
	void (*reserved4) (void);
};

GType                 ethos_plugin_info_get_type           (void) G_GNUC_CONST;
EthosPluginInfo*      ethos_plugin_info_new                (void);

gboolean              ethos_plugin_info_load_from_file     (EthosPluginInfo  *plugin_info,
                                                            const gchar      *group,
                                                            const gchar      *filename,
                                                            GError          **error);
gboolean              ethos_plugin_info_load_from_key_file (EthosPluginInfo  *plugin_info,
                                                            const gchar      *group,
                                                            GKeyFile         *key_file,
                                                            GError          **error);
gboolean              ethos_plugin_info_load_from_data     (EthosPluginInfo  *plugin_info,
                                                            const gchar      *group,
                                                            const gchar      *data,
                                                            gsize             length,
                                                            GError          **error);

G_CONST_RETURN gchar* ethos_plugin_info_get_id             (EthosPluginInfo  *plugin_info);
void                  ethos_plugin_info_set_id             (EthosPluginInfo  *plugin_info,
                                                            const gchar      *id);
G_CONST_RETURN gchar* ethos_plugin_info_get_filename       (EthosPluginInfo  *plugin_info);
void                  ethos_plugin_info_set_filename       (EthosPluginInfo  *plugin_info,
                                                            const gchar      *filename);

G_CONST_RETURN gchar* ethos_plugin_info_get_name           (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_module         (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_loader         (EthosPluginInfo  *plugin_info);
gchar**               ethos_plugin_info_get_authors        (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_description    (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_copyright      (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_website        (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_version        (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_dependencies   (EthosPluginInfo  *plugin_info);
G_CONST_RETURN gchar* ethos_plugin_info_get_icon_name      (EthosPluginInfo  *plugin_info);
gboolean              ethos_plugin_info_get_active         (EthosPluginInfo  *plugin_info);
void                  ethos_plugin_info_set_active         (EthosPluginInfo  *plugin_info,
                                                            gboolean          active);
guint                 ethos_plugin_info_get_iage           (EthosPluginInfo  *plugin_info);
gboolean              ethos_plugin_info_has_errors         (EthosPluginInfo  *plugin_info);
GList*                ethos_plugin_info_get_errors         (EthosPluginInfo  *plugin_info);

G_END_DECLS

#endif /* __ETHOS_PLUGIN_INFO_H__ */
