# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE File Dialog instead of the Qt File Dialog.
"""

import os

import Preferences

try:
    raise ImportError
    # TODO: KDE 4
##    from kfile import KFileDialog, KFile, KRecentDocument
##    from qt import QString, QStringList, QRegExp
##    
##    def __convertFilter(filter, selectedFilter = None):
##        """
##        Private function to convert a Qt file filter to a KDE file filter.
##        
##        @param filter Qt file filter (QString or string)
##        @param selectedFilter this is set to the selected filter
##        @return the corresponding KDE file filter (QString)
##        """
##        rx = QRegExp("^[^(]*\(([^)]*)\).*$")
##        fileFilters = QStringList.split(';;', filter)
##        
##        newfilter = QStringList()
##        for fileFilter in fileFilters:
##            sf = selectedFilter and selectedFilter.compare(fileFilter) == 0
##            namefilter = QString(fileFilter).replace(rx, "\\1")
##            fileFilter = QString(fileFilter).replace('/', '\\/')
##            if sf:
##                newfilter.prepend("%s|%s" % (namefilter, fileFilter))
##            else:
##                newfilter.append("%s|%s" % (namefilter, fileFilter))
##        return newfilter.join('\n')
##    
##    def getOpenFileName(startWith = QString.null, filter = QString.null, parent = None,
##                        name = None, caption = QString.null, selectedFilter = None,
##                        resolveSymlinks = 1):
##        """
##        Function to open a modal dialog to get the name of an existing file.
##        
##        @param startWith the file dialogs working directory. If this includes
##            a file name, the file will be selected.
##        @param filter only files matching the selected filter will be shown
##        @param parent parent widget of the dialog 
##        @param name name of the dialog
##        @param caption the caption of the dialog
##        @param selectedFilter this is set to the selected filter
##        @param resolveSymlinks flag to indicate, whether symbolic links should be followed
##        """
##        if not QString(filter).isEmpty():
##            filter = __convertFilter(filter, selectedFilter)
##        dlg = KFileDialog(startWith, filter, parent, "filedialog", 1)
##        dlg.setOperationMode(KFileDialog.Opening)
##        
##        dlg.setMode(KFile.File | KFile.LocalOnly)
##        dlg.setCaption(\
##            caption is QString.null and QApplication.translate('KFileDialog', 'Open') or caption)
##        
##        dlg.exec_loop()
##        
##        if selectedFilter is not None:
##            flt = dlg.currentFilter()
##            flt.prepend("(").append(")")
##            selectedFilter.replace(0, selectedFilter.length(), flt)
##            
##        return dlg.selectedFile()
##    
##    def getSaveFileName(startWith = QString.null, filter = QString.null, parent = None,
##                        name = None, caption = QString.null, selectedFilter = None,
##                        resolveSymlinks = 1):
##        """
##        Function to open a modal dialog to get the name of an existing file.
##        
##        @param startWith the file dialogs working directory. If this includes
##            a file name, the file will be selected.
##        @param filter only files matching the selected filter will be shown
##        @param parent parent widget of the dialog 
##        @param name name of the dialog
##        @param caption the caption of the dialog
##        @param selectedFilter this is set to the selected filter
##        @param resolveSymlinks flag to indicate, whether symbolic links should be followed
##        """
##        if not QString(filter).isEmpty():
##            filter = __convertFilter(filter, selectedFilter)
##        specialdir = not QString(startWith).isEmpty() and str(QString(startWith).at(0)) == ':'
##        dlg = KFileDialog(specialdir and startWith or QString.null,
##                          filter, parent, "filedialog", 1)
##        if not specialdir:
##            dlg.setSelection(startWith)
##        dlg.setOperationMode(KFileDialog.Saving)
##        
##        dlg.setMode(KFile.File | KFile.LocalOnly)
##        dlg.setCaption(\
##            caption is QString.null and QApplication.translate('KFileDialog', 'Save As') or caption)
##        
##        dlg.exec_loop()
##        
##        filename = dlg.selectedFile()
##        if not filename.isEmpty():
##            KRecentDocument.add(filename)
##            
##            if selectedFilter is not None:
##                flt = dlg.currentFilter()
##                flt.prepend("(").append(")")
##                selectedFilter.replace(0, selectedFilter.length(), flt)
##        
##        return filename
##        
##    def getOpenFileNames(filter = QString.null, startWith = QString.null, parent = None,
##                        name = None, caption = QString.null, selectedFilter = None,
##                        resolveSymlinks = 1):
##        """
##        Function to open a modal dialog to get the name of an existing file.
##        
##        @param filter only files matching the selected filter will be shown
##        @param startWith the file dialogs working directory. If this includes
##            a file name, the file will be selected.
##        @param parent parent widget of the dialog 
##        @param name name of the dialog
##        @param caption the caption of the dialog
##        @param selectedFilter this is set to the selected filter
##        @param resolveSymlinks flag to indicate, whether symbolic links should be followed
##        """
##        if not QString(filter).isEmpty():
##            filter = __convertFilter(filter, selectedFilter)
##        dlg = KFileDialog(startWith, filter, parent, "filedialog", 1)
##        dlg.setOperationMode(KFileDialog.Opening)
##        
##        dlg.setMode(KFile.Files | KFile.LocalOnly)
##        dlg.setCaption(\
##            caption is QString.null and QApplication.translate('KFileDialog', 'Open') or caption)
##        
##        dlg.exec_loop()
##        
##        if selectedFilter is not None:
##            flt = dlg.currentFilter()
##            flt.prepend("(").append(")")
##            selectedFilter.replace(0, selectedFilter.length(), flt)
##            
##        return dlg.selectedFiles()
##        
##    def getExistingDirectory(startWith = QString.null, parent = None,
##                        name = None, caption = QString.null, dirOnly = 1,
##                        resolveSymlinks = 1):
##        """
##        Function to open a modal dialog to get the name of an existing file.
##        
##        @param startWith the file dialogs working directory. If this includes
##            a file name, the file will be selected.
##        @param parent parent widget of the dialog 
##        @param name name of the dialog
##        @param caption the caption of the dialog
##        @param dirOnly flag indicating, whether only directories should be shown
##        @param resolveSymlinks flag to indicate, whether symbolic links should be followed
##        """
##        dlg = KFileDialog(startWith, QString.null, parent, "filedialog", 1)
##        dlg.setOperationMode(KFileDialog.Opening)
##        
##        dlg.setMode(KFile.Directory | KFile.LocalOnly | KFile.ExistingOnly)
##        dlg.setFilter(QString.null)
##        dlg.setCaption(caption is QString.null and \
##                       QApplication.translate('KFileDialog', 'Select Directory') or caption)
##        
##        dlg.exec_loop()
##        
##        return dlg.selectedFile()
    
except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"
    
import PyQt4.QtGui

__iconProvider = None

def __qtSetIconProvider(provider):
    """
    Function to set the icon provider.
    
    @param provider QFileIconProvider
    """
    global __iconProvider
    __iconProvider = provider
    
def __qtIconProvider():
    """
    Function to return the previously stored icon provider.
    
    @return QFileIconProvider
    """
    global __iconProvider
    return __iconProvider

__qtGetOpenFileName = PyQt4.QtGui.QFileDialog.getOpenFileName
__qtGetOpenFileNames = PyQt4.QtGui.QFileDialog.getOpenFileNames
__qtGetSaveFileName = PyQt4.QtGui.QFileDialog.getSaveFileName
__qtGetExistingDirectory = PyQt4.QtGui.QFileDialog.getExistingDirectory

################################################################################

from PyQt4.QtCore import QString, QStringList, QDir
from PyQt4.QtGui import QFileDialog

def getOpenFileName(parent = None, caption = QString(), dir_ = QString(),
                    filter = QString(), selectedFilter = None, 
                    options = QFileDialog.Options()):
    """
    Module function to get the name of a file for opening it.
    
    @param parent parent widget of the dialog (QWidget)
    @param caption window title of the dialog (QString)
    @param dir_ working directory of the dialog (QString)
    @param filter filter string for the dialog (QString)
    @param selectedFilter selected filter for the dialog (QString)
    @param options various options for the dialog (QFileDialog.Options)
    @return name of file to be opened (QString)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        f = __kdeGetOpenFileName(parent, caption, dir_, 
                                    filter, selectedFilter, options)
    else:
        f = __qtGetOpenFileName(parent, caption, dir_, 
                                   filter, selectedFilter, options)
    return QDir.toNativeSeparators(f)
    
def getOpenFileNames(parent = None, caption = QString(), dir_ = QString(),
                    filter = QString(), selectedFilter = None, 
                    options = QFileDialog.Options()):
    """
    Module function to get a list of names of files for opening.
    
    @param parent parent widget of the dialog (QWidget)
    @param caption window title of the dialog (QString)
    @param dir_ working directory of the dialog (QString)
    @param filter filter string for the dialog (QString)
    @param selectedFilter selected filter for the dialog (QString)
    @param options various options for the dialog (QFileDialog.Options)
    @return list of filenames to be opened (QStringList)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        l = __kdeGetOpenFileNames(parent, caption, dir_, 
                                     filter, selectedFilter, options)
    else:
        l =  __qtGetOpenFileNames(parent, caption, dir_, 
                                    filter, selectedFilter, options)
    fl = QStringList()
    for f in l:
        fl.append(QDir.toNativeSeparators(f))
    return fl
    
def getSaveFileName(parent = None, caption = QString(), dir_ = QString(),
                    filter = QString(), selectedFilter = None, 
                    options = QFileDialog.Options()):
    """
    Module function to get the name of a file for saving it.
    
    @param parent parent widget of the dialog (QWidget)
    @param caption window title of the dialog (QString)
    @param dir_ working directory of the dialog (QString)
    @param filter filter string for the dialog (QString)
    @param selectedFilter selected filter for the dialog (QString)
    @param options various options for the dialog (QFileDialog.Options)
    @return name of file to be saved (QString)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        f = __kdeGetSaveFileName(parent, caption, dir_, 
                                    filter, selectedFilter, options)
    else:
        f = __qtGetSaveFileName(parent, caption, dir_, 
                                   filter, selectedFilter, options)
    return QDir.toNativeSeparators(f)
    
def getExistingDirectory(parent = None, caption = QString(), dir_ = QString(),
                         options = QFileDialog.Options(QFileDialog.ShowDirsOnly)):
    """
    Module function to get the name of a directory.
    
    @param parent parent widget of the dialog (QWidget)
    @param caption window title of the dialog (QString)
    @param dir_ working directory of the dialog (QString)
    @param options various options for the dialog (QFileDialog.Options)
    @return name of selected directory (QString)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        d = __kdeGetExistingDirectory(parent, caption, dir_, options)
    else:
        d = __qtGetExistingDirectory(parent, caption, dir_, options)
    return QDir.toNativeSeparators(d)
    
def setIconProvider(provider):
    """
    Function to set the icon provider.
    
    @param provider QFileIconProvider
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        __kdeSetIconProvider(provider)
    else:
        __qtSetIconProvider(provider)
    
def iconProvider():
    """
    Function to return the previously stored icon provider.
    
    @return QFileIconProvider
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeIconProvider()
    else:
        return __qtIconProvider()
