/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 *  Copyright © 2012 Igalia S.L.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#if !defined (__EPHY_EPIPHANY_H_INSIDE__) && !defined (EPIPHANY_COMPILATION)
#error "Only <epiphany/epiphany.h> can be included directly."
#endif

#ifndef EPHY_PRIVATE_H
#define EPHY_PRIVATE_H

#include "ephy-embed.h"
#include "ephy-embed-event.h"
#include "ephy-embed-private.h"
#include "ephy-location-controller.h"
#include "ephy-window.h"

#include <gtk/gtk.h>

/* EphyWindow */

GtkActionGroup         *ephy_window_get_toolbar_action_group (EphyWindow *window);

EphyLocationController *ephy_window_get_location_controller  (EphyWindow *window);

EphyEmbedEvent         *ephy_window_get_context_event        (EphyWindow *window);

GtkWidget              *ephy_window_get_find_toolbar         (EphyWindow *window);

void                    ephy_window_set_location             (EphyWindow *window,
                                                              const char *address);

#endif

