<object name="profile_builder">
  <window name="main" width="800" height="600" 
          ondelete="entity:exit" title="Profile Builder">
    <valign expand="true">
      <button label="Clear columns" onclick="clear_cols"/>
      <button label="Load columns" onclick="load_cols"/>
      <button label="Populate Cells" onclick="load_cells"/>
      <halign expand="true">
        <scrollwindow expand="true" name="anom_sw">
          <ctree name="mytree" expand="true" selection-type="multiple"
                 expander-style="none">
	    <ctree-column width="80" title="This"/>
	    <ctree-column width="80" title="is"/>
	    <ctree-column width="80" title="a"/>
	    <ctree-column title="test."/>
            <ctree-row onbuttonpress="on_button_press">
              <ctree-cell text="Hello"/>
	      <ctree-cell text="New"/>
	      <ctree-cell text="World"/>
	      <ctree-cell text="2001"/>
	    </ctree-row>
            <ctree-row onbuttonpress="javascript:on_button_press">
              <ctree-cell text="Hello"/>
	      <ctree-cell text="New"/>
	      <ctree-cell text="World"/>
	      <ctree-cell text="2001"/>
	    </ctree-row>
          </ctree>
        </scrollwindow>
      </halign>
    </valign>
  </window>

  <javascript>
  <![CDATA[

  function on_button_press (ctree, row, cell, bnum, column, offset)
  {
      print ("got", ctree.path, row.path, cell.path, bnum, column, offset);
  }

  ]]>
  </javascript>
      
  <perl>
  <![CDATA[


  sub on_button_press
  {
    my ($ctree, $row, $cell, $bnum, $column, $offset) = @_;
    print "$ctree, $row, $cell, $bnum, $column, $offset\n";
  }

  sub clear_cols
  {
    my $node;

    $node = enode ("ctree.mytree");
    $node->destroy_children ();
  }


  sub load_cols
  {
    my $node;

    $node = enode ("ctree.mytree");
    $node->append_xml (qq!<ctree-column title="This"/>
	    <ctree-column title="is"/>
	    <ctree-column title="a"/>
	    <ctree-column title="test."/>!);
  }


  sub load_cells
  {
    my $node;
   
    $node = enode ("ctree.mytree");
    $node->append_xml (qq!<ctree-row><ctree-cell text="Hello"/>
			  <ctree-cell text="New"/>
			  <ctree-cell text="World"/>
			  <ctree-cell text="2001"/></ctree-row>!);
  }

  ]]>
  </perl>
</object>




