"**************************************************************************
"enCore 3.3.4 to 4.0 Patch.
"Copyright (C) 2004 enCore Open Source Project. All Rights Reserved.
"
"This program is free software; you can redistribute it and/or modify it 
"under the terms of the GNU General Public License as published by the 
"Free Software Foundation; either version 2 of the License, or any later
"version.
"
"It is distributed in the hope that it will be useful, but WITHOUT ANY
"WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
"FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
"details. (http://lingua.utdallas.edu/hw/gpl.html)
"
"You install this code by pasting it into your MOO window. Read the
"instructions and verb code in this file CAREFULLY before you apply the
"patch. You MUST incorporate any changes you have made to verbs that will 
"be affected by this patch BEFORE you apply it, or else your changes WILL 
"BE LOST! 
"
"Commands and verbs MUST be applied in the order they appear in this file.
"Failure to observe these warnings may result in problems and possible 
"damage to your database. Also, to use this patch you must have applied any 
"previous patches BEFORE you apply this one. We recommend that you paste in
"only small portions of the patch at a time so you can check that everything
"is ok as you go along.
"
"BACK UP YOUR DATABASE BEFORE YOU APPLY THIS PATCH!
"
"Jan Rune Holmevik                                           Cynthia Haynes
"Dept. of Humanistic Informatics              School of Arts and Humanities
"University of Bergen                         University of Texas at Dallas
"Sydnesplass 7 HF-bygget                                 PO.Box 830688-JO31
"N-5007 Bergen, Norway                            Richardson, TX 75083-0688
"Email: jan.holmevik@uib.no                    Email: cynthiah@utdallas.edu
"**************************************************************************

;;#0.("license") = {"License: enCore and enCore Xpress is Copyright (C) 1997-2004 of the enCore Open Source MOO Project. All rights reserved. The core of this program is Copyright (C) 1991-1997 of LambdaMOO. The enCore layer is Copyright (C) 1997-2004 of its respective authors. The Xpress client and GUI is Copyright (C) 1998-2004 of Jan Rune Holmevik and Cynthia Haynes. The MOOtcan telnet applet is Copyright 1998-2004 of Sindre Soerensen and Jan Rune Holmevik. The Virtual Assignment Server Environment is Copyright (C) 2000-2004 of Jason Nolan and the University of Toronto. This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License See http://lingua.utdallas.edu/encore/gpl.html for details. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY."}

;;#0.("copyright") = "Copyright (C) 1997-2004 enCore Open Source Project, All Rights Reserved"

;;#0.("contributors") = {"Credits: Jan Rune Holmevik, Cynthia Haynes, Sindre Soerensen, Ken Schweller, Mark Blanchard, Jorge Barrios, Amy Bruckman, Matthew Campbell, John Towell, Gustavo Glusman, Craig Leikis, Juli Burk, Michael Thompson, Rui Miguel Barbosa Pinto, Andrew Wilson, Ken Fox, Matthew Beermann, Jason Nolan, Noel Davis, Stephen Ashley, Herve Collin, Emma Jane Hogbin, Claudijo Borovic, Alexandre Borgia, Scott Carmichael, Michel Lavondes, and Daniel Jung."}

@rmprop $httpd.expires

@property $httpd.charset "ISO-8859-1"

;;$xpress_client.("screen_sizes") = {{"self.screen.availWidth,self.screen.availHeight", "Full Screen"}, {"1152,768", "1152 by 768 pixels (wide screen)"}, {"1024,768", "1024 by 768 pixels"}, {"900,600", "900 by 600 pixels (wide screen)"}, {"800,600", "800 by 600 pixels"}, {"720,480", "720 by 480 pixels (wide screen)"}, {"640,480", "640 by 480 pixels"}}

@set $player.xpress_screen_size to "900,600"

@set $xpress_client.browser_resizable to "yes"

@set $room.web_contents_msg to "You see: "
@set $room.web_exits_msg to "Links: "

@set $encore_web_class.web_alink_color to "Yellow"

@set $encore_web_class.Media_Content_Alignment to "center"
@set $encore_web_class.Text_Alignment to "left"

@set $news.table_vertical_alignment to "bottom"

@set $encore_web_class.icon_alignment to "bottom"

@rmprop $encore_web_class.table_vertical_alignment 
@prop $encore_web_class.table_vertical_alignment "bottom"

@set $mootcan.java_client_alignment to "top"

@set $encore_web_object.web_align to "top"

@set $xpress_client.web_alignment_options to {{"Left", "left"}, {"Center", "center"}, {"Right", "right"}, {"Justify", "justify"}}

@set $note.note_text_alignment to "left"

@set $encore_web_class.icon_border to "0"

@property $encore_web_class.xml_namespace ""
@property $encore_web_class.xml_declaration {}

@set $encore_web_class.xml_namespace to "xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en-US\" xml:lang=\"en-US\""
@set $encore_web_class.xml_declaration to {"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>"} 

@set $encore_web_class.default_doctype to {"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"}
@set $encore_web_class.doctype_frameset to {"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">"} 

@property $xpress_client.menu_frame "menu_frame"
@property $xpress_client.web_frame "web_frame"
@property $xpress_client.java_frame "java_frame"


@set-note-text $xpress_client.javascript_functions
function _get_java_client_params(list_type) {
  var _params = "";
  if ("flat" == list_type) {
     for (var _pair in _java_client_param_pairs) {
       _params = _params + _java_client_param_pairs[_pair][0] + '="' + _java_client_param_pairs[_pair][1] + '" ';
     }
  }
  else {
     for (var _pair in _java_client_param_pairs) {
        _params = _params + '<param name=' + _java_client_param_pairs[_pair][0] + ' value="' + _java_client_param_pairs[_pair][1] + '">\n';
     }
  }
  return _params;
}

function _isNetscape() {
   return (navigator.appName == "Netscape");
}

function _javaPluginAvailable() {
   var _mimetype = navigator.mimeTypes["application/x-java-vm"];
   if (_mimetype) {
      _plugin = _mimetype.enabledPlugin;
      return(null != _plugin);
   }
   else {
      return false;
   }
}

function _getMaxSize() {
   if (_isNetscape()) {
      if (_javaPluginAvailable()) {
         var _marginWidth = 2;
         return [innerWidth-_marginWidth*2, innerHeight-_marginWidth*2];
      }
      else {
         return ["100%", "100%"];
      }
   }
   else { // we assume MSIE-style DOM-things
      return [myBody.clientWidth, myBody.clientHeight];
   }
}

function _getWidth() {
   return _getMaxSize()[0];
}

function _getHeight() {
   return _getMaxSize()[1];
}

function _javaTag() {

   var _tag = 
   '<applet\n' +
   ' archive=' + _java_client_archive + '\n' +
   ' code=' + _java_client_classname + '\n' +
   ' codebase=' + _java_client_codebase + '\n' +
   ' width=' + _getWidth() + '\n' +
   ' height=' + _getHeight() + '\n' +
   ' align=top\n' +
   ' alt="">\n' + _get_java_client_params('tagged') + 
   '  Sorry, you need a browser that supports Java to use this system.\n' +
   '</applet>\n';
   
   return _tag;
}

function _makePage() {
   var data = _javaTag();
   
   for (var counter = 0; counter < 5000; counter++) {}
   
   document.write(data);

}

_makePage();
.


@rename #1:title to "title name"

@rename $encore_web_utils:make_alert to "alert make_alert"

@rmverb $xpress_client:character_application_html
@rmprop $xpress_client.validate_script
@rmverb $exit:xpress_edit
@rmverb $xpress_object_editor:Edit_Exit_Options

"--- New utility package for misc verbs and properties
@create $enCore_CGI_Application named Xpress_misc
@corify xpress_misc as xpress_misc

@rmprop $xpress_login.validate_script

@property $xpress_misc.validate_script {}

@set-note-text $xpress_misc.validate_script
function validateForm(){
 if(document.getElementById('real_name').value == "") {
    alert('You forgot to tell us your real name. Please try again.')
   document.getElementById('real_name').focus()
    return false }
  
 if(document.getElementById('name').value == "") {
    alert('In order to create a new character for you, we need to know what character name you wish to use.')
    document.getElementById('name').focus()
    return false }

  if(document.getElementById('email_address').value == "") {
    alert('Unless we know your email address we cannot send you the password for your new character.')
    document.getElementById('email_address').focus()
    return false }

  return true
} 
.

@copy-move $xpress_client:guide_html to $xpress_misc

@copy-move $xpress_login:character_application_html to $xpress_misc
@program $xpress_misc:character_application_html
"===========================================================";
"Copyright (C) 1999-2004 Jan Rune Holmevik";
"MOO character creation/application form";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
body = form = script = reason = {};
javascript = mail_alert = real_name = name = email_address = "";
finished = 0;
validateScript = this.validate_script;
title = $encore_web_utils:get_title(user, this, tostr($network.MOO_name, $login.create_enabled ? " New Character Creation" | " Character Application"));
if ({{}, {}} != args[2])
  "User is sending a POST request";
  application = args[2];
  real_name = application[2][1];
  name = application[2][2];
  email_address = application[2][3];
  try
    reason = application[2][4];
  except error (ANY);
  endtry;
  if (typeof(reason) == STR)
    reason = {reason};
  endif
  if (!$player_db:available(name) && name != this.name)
    "Cannot create new user. Return application form with submitted data intact.";
    javascript = tostr("alert('Sorry, the name ", name, " is already being used, or else it is not acceptable. Please choose another name.')");
  elseif ($registration_db:find_exact(email_address))
    javascript = tostr("alert('It appears that you already have a character in ", $network.moo_name, ". Please talk to an administrator if you need another one.')");
  else
    if ($login.create_enabled)
      "----------------------------------------------";
      "Auto create is on, process application and create new character";
      "----------------------------------------------";
      {new_player, password} = $wiz_utils:make_player(name, email_address, real_name);
      $mail_agent:send_message(this.owner, $new_player_log, tostr(name, " (", new_player, ")"), {email_address, tostr("Account ", new_player.name, " automatically created")});
      if ($network.active)
        $wiz_utils:send_new_player_mail(tostr("Someone requested a character on ", $network.moo_name, " for email address ", email_address, "."), name, email_address, new_player.name, password);
        mail_alert = tostr("Your password has been mailed to your email address: ", email_address, ".");
      endif
      body = $list_utils:append($encore_web_utils:h("New account created", 2), $encore_web_utils:p(tostr("User name: ", $encore_web_utils:b(new_player.name))), $encore_web_utils:p(tostr("Password: ", $encore_web_utils:b(password))), $encore_web_utils:p("The password is case sensitive. Please keep it confidential."), $encore_web_utils:close());
      finished = 1;
    else
    "----------------------------------------------";
    "Send application to  character application list";
    "----------------------------------------------";
      $mail_agent:send_message(this.owner, $character_request_list, tostr("Character application from ", real_name), {tostr("Real name: ", real_name), tostr("Requested character name: ", name), tostr("Email address: ", email_address), "", @reason});
      body = $list_utils:append(body, $encore_web_utils:p("You character application has been submitted. One of the wizards will attend to it as soon as possible. If your application is accepted, your new user name and password will be mailed to the email address you provided."), $encore_web_utils:close());
      finished = 1;
    endif
  endif
else
  "User is sending a GET request. return blank form";
  javascript = "document.getElementById('real_name').focus()";
endif
if (!finished)
  script = $encore_web_utils:insert_JavaScript(validateScript);
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("real_name", real_name, "30", "text"), {"Your full name"}); 
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("name", name, "30", "text"), {"Name of your new character"}); 
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("email_address", email_address, "30", "text"), {"Your email address"}); 
  if (!$login.create_enabled)
    form = $list_utils:append(form, $encore_web_utils:p(tostr("Please say a few words about why you wish to become a member of ", $network.moo_name)), $encore_web_utils:textarea(reason, "reason", "10", "50"));
  endif
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("submit", $login.create_enabled ? "Create new character" | "Submit application", "", "submit"), $encore_web_utils:close());
  form = $encore_web_utils:form(form, "application", "/xpress_misc/character_application.html", "return validateForm()");
endif
body = $list_utils:append(script, title, body, form);
result = this:build(user, body, "Character Creation", tostr("self.focus();", javascript));
return result;
.


@program $httpd:init_for_core
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Webserver defaults";
"===========================================================";
if (caller_perms().wizard)
  pass();
  this.protocol = "HTTP/1.0 ";
  this.allow = "GET, POST, HEAD";
  this.content_type = "text/html";
  this.pragma = "No-Cache";
  this.total_homepage_hits = 0;
  this.total_logins = 0;
  this.total_pages_served = 0;
endif
.


@program $encore_web_utils:move_via_web
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Verb for moving players via web links";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
try
  {user, destination} = args;
  origin = user.location;
  "------------------------------------------------------";
  "--             Default movement messages            --";
  "------------------------------------------------------";
  leave_msg = tostr("You move to ", destination.name);
  oleave_msg = tostr(user.name, " leaves for ", destination.name);
  oarrive_msg = tostr(user.name, " arrives from ", origin.name);
  "------------------------------------------------------";
  "-- Find correct exit and use messages if any        --";
  "------------------------------------------------------";
  for exit in (origin.exits)
    if (exit.dest == destination)
      "Exit found, check for messages";
      if (exit.leave_msg != "")
        leave_msg = exit.leave_msg;
      endif
      if (exit.oleave_msg != "")
        oleave_msg = tostr(user.name, " ", $string_utils:pronoun_sub(exit.oleave_msg));
      endif
      if (exit.oarrive_msg != "")
        oarrive_msg = tostr(user.name, " ", $string_utils:pronoun_sub(exit.oarrive_msg));
      endif
      break;
    endif
  endfor
  "------------------------------------------------------";
  "--        Move player and make announcements        --";
  "------------------------------------------------------";
  "Modified by Traveller 7/15/01 so that exitfunc and enterfunc get the 'real' value of player";
  player = user;
  user:tell(leave_msg);
  destination:announce(oarrive_msg);
  user.update_web_display = 0;
  user:moveto(destination);
  origin:announce_all(oleave_msg);
except error (ANY);
"We'll find a clever way to handle errors later";
endtry
return;
.

@program $httpd:generate_server_response_header
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik and sindre.sorensen@uib.no";
"Adds server responses to HTTP transactions";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{status, cookie, html, content_type, ?user_agent_request = ""} = args;
error_mess = header_fields = {};
status_response = this.(status)[1];
"Added to make sure content type is always included. Jan 9/21/01";
if (!content_type)
  content_type = this.content_type;
endif
"==============================================================";
"== Assemble server status response and entity header fields ==";
"==============================================================";
header_fields = {@header_fields, tostr("Content-Type: ", content_type, "; charset=", this.charset)};
header_fields = {@header_fields, tostr("Pragma: ", this.pragma)};
header_fields = {@header_fields, tostr("Server: ", this.server_name, $core_version)};
response_header = $list_utils:append(status_response, header_fields);
if (cookie != "")
  "==============================================================";
  "== Add instructions for setting a client-side access cookie ==";
  "==============================================================";
  set_cookie = tostr("Set-Cookie: Access_Code=", cookie);
  response_header = {@response_header, set_cookie};
endif
response_header = {@response_header, ""};
if (status != "200_OK")
  "=====================================================================";
  "== Return a page with an explanation of the error that has occured ==";
  "=====================================================================";
  error_mess = {@error_mess, @$httpd.(status)[2]};
  error_mess = {@error_mess, user_agent_request ? "<br />Failed request was: " + 
user_agent_request | ""};
  error_mess = {@error_mess, "<br />", html ? "Details: " | "No details available.", 
@html};
  error_mess = {@error_mess, tostr("<hr size=\"1\" /><address>", $httpd.server_name, 
$core_version, " web server at ", $network.site, " port ", $network.webport, 
"</address>", "</body>", "</html>")};
  html = error_mess;
endif
result = $list_utils:append(response_header, html);
return result;
.


@program $httpd:get
"===========================================================";
"Copyright (C) 1998-2004, Jan Rune Holmevik, Sindre Soerensen and Scott Carmichael";
"This verb handles and directs all http requests";
"===========================================================";
if (caller != this)
  return E_PERM;
endif
try
  "==========================";
  "== Initialize variables ==";
  "==========================";
  {method, uri, httpver} = args;
  body = result = html = head = page_props = footer = {};
  data = message = cookie = content_type = content_type_incoming = boundary = "";
  authentication_ok = 0;
  status = "200_OK";
  conn = player;
  if (method in {"GET", "POST"})
    "=================================================================";
    "== Find and return the object and verb that the user requested ==";
    "=================================================================";
    if (valid_uri = $encore_web_utils:parse_url(uri))
      object = valid_uri[1];
      program = valid_uri[2];
      client_headers = this:collect_user_agent_headers(conn);
      if ("GET" == method)
        "Make sure form data is preserved in POST requests";
        data = valid_uri[3];
        form_fields = $encore_web_utils:parse_form(data);
      elseif ("POST" == method)
        {data, content_type_incoming, boundary} = this:collect_user_agent_POST(conn, client_headers);
        form_fields = $encore_web_utils:parse_form(data, content_type_incoming, boundary);
      endif
      "========================================";
      "== Perform HTTP-cookie authentication ==";
      "========================================";
      {authentication_ok, user, login, cookie, message} = this:authenticate(uri, client_headers, form_fields, object, program, method);
      if (authentication_ok)
        "==============================================================";
        "Generate HTML code for the requested object or web application";
        if (login)
          "================================================";
          "           Open Xpress client window            ";
          "================================================"; 
          body = this:blank_html(user, message);
        else
          "==============================================================";
          "Verify that form data originated from this server. SDC";
          "==============================================================";
          referer = "Referer" in client_headers;
          referer = referer != 0 ? client_headers[referer + 1] | "";
          if (!match(referer, tostr("^http://", $network.site)) && form_fields[2] != {});
            body = "403_Forbidden";
          else
            body = object:(program)(user, form_fields);
          endif
        endif
        "==============================================================";
        "Perform misc error checks";
        "==============================================================";
        "Check to see if the verb returns anything but a list of strings:";
        if (!$list_utils:flat_list_of_STR(body) && typeof(body) != STR)
          status = "500_Internal_Server_Error";
          body = {"The verb did not return a flat list of strings:<div><pre>", toliteral(body), "</pre></div>"};
        endif
        "Check to see if a type 400 error code has been returned";
        if (body in {"400_Bad_Request", "403_Forbidden"})
          status = body;
        else
          !body ? body = {"HTTP-EQUIV=\"content-type\""} | 0;
          if (match(body[1], "HTTP-EQUIV=\"content-type\""))
            "A plain text is to be returned.";
            content_type_source = body[1];
            html = listdelete(body, 1);
          else
            if ($encore_web_utils:page_assembled(body))
              "=========================================================";
              "The page has already been assembled either by";
              "a web application or by the owner";
              "=========================================================";
              html = body;
            else
              "=========================================================";
              "Assemble the elements of the web page";
              "=========================================================";
              head = $encore_web_utils:make_head(user, object);
              body = $encore_web_utils:make_body(user, object, body);
              html = $encore_web_utils:make_page(user, object, $list_utils:append(head, body));
            endif
            content_type_source = html[3];
          endif
          "Determine correct content type for outgoing page";
          content_type = this:determine_content_type(content_type_source);
        endif
        this.total_pages_served = this.total_pages_served + 1;
      else
        if (login)
          "================================================================";
          "User is logging in, but authentication failed. Return the error ";
          "message explaining what went wrong. Close client screen";
          "================================================================";
          html = this:blank_html(user, message);
        else
          "=============================================================";
          "First point of access. New user wants to log in. Return main";
          "login frameset.";
          "=============================================================";
          html = $Xpress_login:login_page(user, message);
        endif
      endif
    else
      "Object not found";
      status = "404_Not_Found";
    endif
  else
    "HTTP Method not Implemented";
    status = "501_Not_Implemented";
  endif
  "===========================================================";
  "== Add server response header and send data back to user ==";
  "===========================================================";
  result = $httpd:generate_server_response_header(status, cookie, html, content_type, argstr);
  if (this.watchers)
    this:log(tostr(status, " Sent ", length(result), " lines."), 9);
    if ({{}, {}} != form_fields)
      this:log("User agent posted data: " + toliteral(form_fields), 7);
    endif
  endif
except error (ANY)
  body = {"<div><pre>", @this:generate_traceback(error), "</pre></div>"};
  status = "500_Internal_Server_Error";
  result = $httpd:generate_server_response_header(status, "", body, "", argstr);
endtry
for line in (result)
  while (!notify(conn, line, 1) && conn in connected_players(1))
    suspend(0);
  endwhile
endfor
if (buffered_output_length(conn))
  "========================================";
  "== Make sure the user gets everything ==";
  "========================================";
  while (buffered_output_length(conn))
    suspend(0);
  endwhile
endif
return;
.

@program $httpd:authenticate
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Performs authentication of HTTP requests.";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{URI, client_headers, form_fields, requested_object, requested_verb, method} = args;
access_granted = login = 0;
message = cookie = "";
user = $no_one;
if (URI == "")
  if (form_fields != {{}, {}})
    "=========================================";
    "===== New user login. Process login =====";
    "=========================================";
    login = 1;
    user_info = form_fields;
    user_name = $string_utils:trim(user_info[2][1]) || "";
    password = $string_utils:trim(user_info[2][2]) || "";
    if (user_name == "guest")
      if (!children($guest))
        "No guest characters has been made yet";
        message = "alert('Sorry, no guest accounts are available in this MOO. Please enter a valid user name and password to log in.');window.close();";
      else
        "===================";
        "Process guest login";
        "===================";
        user = $string_utils:match_player("guest");
        if (!valid(user = `user:defer_login(user_name) ! E_VERBNF => user:defer(user_name)'))
          "Guest login failed";
          user = $no_one;
          message = "alert('Sorry, all guest accounts are currently in use. Please try connecting again later.');window.close()";
        else
          "Guest login approved";
           access_granted = 1;
          {user, cookie, message} = $Xpress_client:initialize_session(user);
          this.total_logins = this.total_logins + 1;
        endif
      endif
    else
      "=========================================";
      "===== Process registered user login =====";
      "=========================================";
      if (valid(user = $string_utils:match_player(user_name)))
        "Valid user name, now check password";
        if (user.password == 0)
          "User has no password yet, create a temporary web password and return the user's home URI";
          {user, cookie, message} = $Xpress_client:initialize_session(user);
          this.total_logins = this.total_logins + 1;
          access_granted = 1;
        else
          if (strcmp(crypt(password, user.password), user.password))
            "Password not valid. Alert, and return user to login page";
            user = $no_one;
            message = tostr("alert('The password you entered is invalid. Remember that passwords are case sensitive. If you have forgot your password, please send an email to ", $network.postmaster, " to receive a new one.');window.close();");
          else
            "Valid user and password, create a temporary web password and return the user's home URI";
            {user, cookie, message} = $Xpress_client:initialize_session(user);
            this.total_logins = this.total_logins + 1;
            access_granted = 1;
          endif
        endif
      else
        "User not found. Alert, and return user to login page";
        user = $no_one;
        message = "alert('The user name you entered is invalid. Please try again.');window.close();";
      endif
    endif
  endif
else
  "=====================================================================";
  "== Logged in user is requesting a page.                            ==";
  "== Process client header for cookie information and access code    ==";
  "=====================================================================";
  access_code_found = 0;
  client_headers = $list_utils:reverse(client_headers);
  for line_nr in [1..length(client_headers)]
    line = client_headers[line_nr];
    if (position = index(line, "Access_Code="))
      cookie_data = line[position + 12..$];
      cookie_data = $string_utils:explode(cookie_data, ":");
      user = toobj(cookie_data[1]);
      access_code = cookie_data[2];
      access_code_found = 1;
      break;
    endif
  endfor
  if (!$object_utils:isa(user, $player))
    "======================================================";
    "==    Make sure user is actually a player object    ==";
    "======================================================";
    user = $no_one;
  endif
  if (access_code_found)
    "Check to see if access code is valid";
    if (strcmp(crypt(user.web_access_code, access_code), access_code))
      "============================================================";
      "== Web access code not valid. Check if special conditions ==";
      "== apply so the user can have the page anyway             ==";
      "============================================================";
      if ($encore_web_utils:anonymous_access(requested_object, requested_verb, method))
        access_granted = 1;
      else
        "=====================================================";
        "== Authentication error, access code expired       ==";
        "=====================================================";
        message = "alert('Permission denied. Your access code for this session has expired. Please reconnect.');window.close();";
      endif
    "------------------ Added security code begins --------------------";
    elseif (is_clear_property(user, "web_access_code") || user.web_access_code == "")
      "======================================================================";
      "== S0m3d00d th1nk5 h3 0wnz u5. Log it and pretend we didn't notice. ==";
      "======================================================================";
      msg = tostr("ATTEMPTED SPLOIT (HTTP-based): ", name, " (", candidate, ") on ", connection_name(player), ($string_utils:connection_hostname(connection_name(player)) in candidate.all_connect_places) ? "" | "******");
      fork (0)
        server_log(msg, 1);
        for p in (connected_players())
          if (p.wizard)
            notify(p, msg);
          endif
        endfor
      endfork
      display_login_page = 1;
      message = "alert('Permission denied. Your Xpress access code has expired. Please return to the login page and reconnect.');window.close();";
    "------------------- Added security code ends ---------------------";
    else
      "===========================================";
      "== Valid user and password, grant access ==";
      "===========================================";
      access_granted = 1;
    endif
  else
    if ($encore_web_utils:anonymous_access(requested_object, requested_verb, method))
      "==========================================================";
      "== No web access code was found, but anonymous requests ==";
      "== are enabled so we'll let it pass anyway              ==";
      "==========================================================";
      access_granted = 1;
    else
      "return message that cookie has expired and return user to login";
      mess = "alert('Permission denied. Your access code for this session has expired.');window.close();";
      boot_player(user);
    endif
  endif
endif
return {access_granted, user, login, cookie, message};
.


@program $Xpress_client:initialize_session
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Initialize enCore Xpress session for user";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user} = args;
message = "";
base_url = tostr($encore_web_utils:baseurl(), "Xpress_Client/");
user.xpress_on = 1;
user.web_access_code = tostr(random());
cookie = tostr(user) + ":" + crypt(user.web_access_code);
if (user.xpress_layout == "vertical_layout" || user.xpress_layout == "vertical_layout_2" 
|| user.xpress_layout == "horizontal_layout")
  user.ts_client = 1;
endif
if ($object_utils:has_property($player, "ansi"))
  user.ansi = 0;
endif
"Resize window to users preferences and load the Xpress client.";
message = tostr("self.focus();window.moveTo(0,0);window.resizeTo(", user.xpress_screen_size, ");location.href=\'", base_url, user.xpress_layout, "\';");
return {user, cookie, message};
.

@property $encore_web_utils.arg_separator ";"

@program $encore_web_utils:parse_url_encoded_form_data
"===========================================================";
"Adapted from BioGate parse_form Copyright (C) BioGate partners 1997, Modifications by Jan Rune Holmevik, 1998-2004";
"In XML & is a reserved character. To use it for url-encoded data one must use &amp; instead.";
"W3C recommends using ; instead so I have changed to that here. Jan 02/03";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
form = args[1];
form_fields = {{}, {}};
field_name = field_data = "";
"Alternative arg_separator is &amp;. Not used here";
"form = $string_utils:subst(form, {{\"&amp;\", \"&\"}})";
data_sets = $string_utils:explode(form, this.arg_separator);
for data_set in (data_sets)
  data_pair = $string_utils:explode(data_set, "=");
  if (length(data_pair) == 2)
    field_name = data_pair[1];
    field_data = data_pair[2];
  elseif (index(data_set, "=") == 1)
    field_name = "";
    field_data = data_set[2..$];
  elseif (index(data_set, "=") == length(data_set))
    field_name = data_set[1..$ - 1];
    field_data = "";
  else
    field_name = "";
    field_data = data_pair[1];
  endif
  field_name = $encore_web_utils:decode_url(field_name);
  field_data = $encore_web_utils:decode_url(field_data);
  form_fields[1] = {@form_fields[1], field_name};
  form_fields[2] = {@form_fields[2], field_data};
endfor
"Insert line breaks in data fields if found";
for n in [1..length(form_fields[2])]
  field = form_fields[2][n];
  new_field = {};
  found = 0;
  while (eol = index(field, "<EOL>"))
    "Line break found at position eol";
    $command_utils:suspend_if_needed(0);
    line = field[1..eol - 1];
    field = field[eol + 5..$];
    new_field = {@new_field, line};
    found = 1;
  endwhile
  if (found)
    "Check if there are more characters left in line";
    last_line = field[1..$];
    if (length(last_line) > 0)
      new_field = {@new_field, last_line};
    endif
    form_fields[2][n] = new_field;
  endif
endfor
return form_fields;
.

@copy-move $encore_web_application:blank_html to $encore_web_class
@program $encore_web_class:blank_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Returns a blank web page";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, ?action = ""} = args;
if (action == {{},{}})
  action = "";
endif
return this:build(user, {}, "", action);
.

@program $Xpress_login:login_page
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Generates the main enCore Xpress Login Screen";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user, ?message = ""} = args;
html = {};
base_url = tostr($encore_web_utils:baseurl(), "/Xpress_Login/");
login = tostr(base_url, "login");
welcome = tostr(base_url, "welcome_screen");
if (message)
  message = tostr("onload=\"", message, "\"");
endif
html = {@html, tostr("<frameset cols=\"100%\"", message, ">")};
html = {@html,       "     <noframes>"};
html = {@html,       "         <body><h3>Sorry you need a browser that supports frames to use this system</h3></body>"};
html = {@html,       "     </noframes>"};
html = {@html,       "     <frameset cols=\"50%\">"};
html = {@html,       "          <frameset cols=\"200,100%\">"};
html = {@html, tostr("               <frame src=\"", login, "\" name=\"login\" noresize=\"noresize\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" title=\"Login frame\" />")};
html = {@html, tostr("               <frame src=\"", welcome, "\" name=\"welcome\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" title=\"Welcome screen\" />")};
html = {@html,       "          </frameset>"};
html = {@html,       "     </frameset>"};
html = {@html,       "</frameset>"};
html = this:build(user, html, "Login", message, "", "", "", this.doctype_frameset);
return html;
.

@program $xpress_login:login
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates a login page for connecting to the MOO from the web";
"IMPORTANT NOTE: You must not modify this verb in such a way that the copyright notice is removed from the web display. If you want to add your own copyright notice, you should insert this below current copyright notices. Removing copyright notices consititutes a violation of the license under which this software is provided to you.";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user, action} = args;
body = login = loginForm = {};
base_url = $encore_web_utils:baseurl();
if (typeof(action) == LIST)
  action = "";
endif
if (match(action, "Permission Denied"))
  "Return a blank page";
  body = loginForm = {};
else
  action = $encore_web_utils:select_field("useridField") + action;
  if (!children($guest))
    default_login_name = "";
  else
    default_login_name = "Guest";
  endif
  "---------------------------------------------------------";
  "Set up the main Xpress Client Screen based on users' preferences";
  "---------------------------------------------------------";
  screen_size = $string_utils:explode(user.Xpress_screen_size, ",");
  width = screen_size[1];
  height = screen_size[2];
  openXpress = {"function openXpress() {", "     XpressClient();", "     window.location.reload('/');", "}"};
  client_window = $encore_web_utils:javascript_window_open($xpress_client, "XpressClient", "", width, height);
  mootcan_standalone_url = tostr(base_url, "mootcan/standalone.html");
  mootcan_script = $encore_web_utils:javascript_window_open($mootcan, "openMOOtcan", mootcan_standalone_url);
  browse = $encore_web_utils:javascript_window_open($Xpress_login, "openBrowseMode", tostr(base_url, toint($player_start)));
  request = $encore_web_utils:javascript_window_open($Xpress_login, "openRequestForm", tostr(base_url, "Xpress_misc/character_application_html"));
  script = $list_utils:append(openXpress, client_window, mootcan_script, browse, request);
  script = $encore_web_utils:insert_JavaScript(script);
  login = $list_utils:append($encore_web_utils:h(tostr("enCore Xpress ", $core_version), "3"), $encore_web_utils:p($copyright), $encore_web_utils:p("This program is Free Software and comes WITHOUT ANY WARRANTY!"));
  loginForm = {@loginForm, "<table cellpadding=\"2\" cellspacing=\"2\" border=\"0\" style=\"width: 100%;\">"};
  loginForm = {@loginForm, tostr("<tr><td style=\"text-align: right;\">User ID</td><td style=\"text-align: left;\"><input class=\"login\" type=\"text\" id=\"useridField\" name=\"useridField\" value=\"", default_login_name, "\" size=\"10\" tabindex=\"1\" /></td></tr>")};
  loginForm = {@loginForm, tostr("<tr><td style=\"text-align: right;\">Password</td><td style=\"text-align: left;\"><input class=\"login\" type=\"password\" id=\"passwordField\" name=\"passwordField\" value=\"\" size=\"10\" tabindex=\"2\" /></td></tr>")};
  loginForm = {@loginForm, "</table>"};
  loginForm = $encore_web_utils:form($list_utils:append(loginform, $encore_web_utils:p(), $encore_web_utils:input("xpress", "Log in", "", "submit")), "logindata", "", "openXpress()", tostr($network.MOO_name, "_XpressClient"));
  login = $list_utils:append(login, loginForm);
  login = $list_utils:append(login, $encore_web_utils:p($encore_web_utils:a(tostr($core_homepage, "xpress_system_requirements.html"), "System Requirements", "_blank")));
  login = $list_utils:append(login, $encore_web_utils:input("mootcan", "Telnet", "", "button", "onclick=\"return openMOOtcan()\""));
  if ($xpress_client.http_09_enabled)
    login = $list_utils:append(login, $encore_web_utils:input("browse", "Browse", "", "button", "onclick=\"return openBrowseMode()\""));
  endif
  if ($login.create_enabled)
    login = $list_utils:append(login, $encore_web_utils:input("request", "Create Account", "", "button", "onclick=\"return openRequestForm()\""));
  endif
  validator = $encore_web_utils:get_icon(user, this, tostr($xpress_client.external_baseurl, "images/system/valid-xhtml10.gif"), "Valid XHTML 1.0!");
  body = $list_utils:append(script, login, $encore_web_utils:p(validator));
  body = $encore_web_utils:align(body, "center");
endif
result = this:build(user, body, "Login", action);
return result;
.

@verb $encore_web_utils:h*eading this none this
@program $encore_web_utils:h
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a heading tag.";
"===========================================================";
{text, ?level = 1} = args;
if (typeof(text) == LIST)
   heading = {tostr("<h", level, ">", @text, "</h", level, ">")};
else
   heading = {tostr("<h", level, ">", text, "</h", level, ">")};
endif
return heading;
.


@program $mootcan:standalone_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Run MOOtcan as a standalone application";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
base_url = tostr("http://", $network.site, "/");
external_baseurl = $xpress_client.external_baseurl + $xpress_client.java_client_folder;
style = 0;
body = {tostr("<applet archive=\"", $xpress_client.java_client_archive, "\" code=\"", $xpress_client.java_client_filename, "\" codebase=\"", external_baseurl, "\" alt=\"\" width=\"", this.java_client_width, "\" height=\"", this.java_client_height, "\" align=\"", this.java_client_alignment, "\">")};
body = {@body, tostr("<param name=\"MOOname\" value=\"", $network.MOO_name, "\" />")};
body = {@body, tostr("<param name=\"HostName\" value=\"", $network.site, "\" />")};
body = {@body, tostr("<param name=\"Port\" value=\"", $network.port, "\" />")};
body = {@body, tostr("<param name=\"font\" value=\"", user.java_font, "\" />")};
body = {@body, tostr("<param name=\"fontsize\" value=\"", user.java_font_size, "\" />")};
body = {@body, tostr("<param name=\"localecho\" value=\"", user.java_client_localecho, "\" />")};
body = {@body, "Sorry, you need a browser that supports Java to use this system."};
body = {@body, "</applet>"};
result = this:build(user, body, "MOOtcan", "", "", "", "", "", style);
return result;
.

@program $xpress_client:vertical_layout
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main enCore Xpress client user screen using three frames";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
html = {};
base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_client/");
menu = tostr(base_url, "menu.html");
java = tostr(base_url, "java.html");
web = tostr(base_url, "web.html");
division = $string_utils:explode(user.Xpress_screen_division, ",");
talk_area = division[1];
web_area = division[2];
html = {@html,         "<frameset cols=\"50%\">"};
html = {@html,         "     <noframes>"};
html = {@html,         "          <body><h3>Sorry you need a browser that supports frames to use this system</h3></body>"};
html = {@html,         "     </noframes>"};
html = {@html,         "     <frameset cols=\"50%\">"};
html = {@html,         "          <frameset rows=\"65,100%\">"};
html = {@html, tostr(  "               <frame src=\"", menu, "\" name=\"", this.menu_frame, "\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"", this.frameborder, "\" />")};
if (verb == "vertical_layout")
  html = {@html, tostr("               <frameset cols=\"", talk_area, ",", web_area, "\">")};
  html = {@html, tostr("                    <frame src=\"", java, "\" name=\"", this.java_frame, "\" scrolling=\"no\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"", this.frameborder, "\" />")};
  html = {@html, tostr("                    <frame src=\"", web, "\" name=\"", this.web_frame, "\" scrolling=\"yes\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
else
  html = {@html, tostr("               <frameset rows=\"", web_area, ",", talk_area, "\">")};
  html = {@html, tostr("                    <frame src=\"", web, "\" name=\"", this.web_frame, "\" scrolling=\"yes\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"", this.frameborder, "\" />")};
  html = {@html, tostr("                    <frame src=\"", java, "\" name=\"", this.java_frame, "\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
endif
html = {@html,         "               </frameset>"};
html = {@html,         "          </frameset>"};
html = {@html,         "     </frameset>"};
html = {@html,         "</frameset>"};
result = this:build(user, html, tostr($httpd.server_name, $core_version), "", "", "", "", this.doctype_frameset);
return result;
.

@program $xpress_client:simple_layout
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main enCore Xpress client user screen using two frames";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user, ?message = ""} = args;
html = {};
base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_client/");
menu = tostr(base_url, "menu.html");
java = tostr(base_url, "java.html");
html = {@html,       "<frameset cols=\"50%\">"};
html = {@html,       "     <noframes>"};
html = {@html,       "          <body><h3>Sorry you need a browser that supports frames to use this system</h3></body>"};
html = {@html,       "     </noframes>"};
html = {@html,       "     <frameset cols=\"50%\">"};
html = {@html,       "          <frameset rows=\"65,100%\">"};
html = {@html, tostr("               <frame src=\"", menu, "\" name=\"", this.menu_frame, "\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"", this.frameborder, "\" />")};
html = {@html, tostr("               <frame src=\"", java, "\" name=\"", this.java_frame, "\" scrolling=\"no\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "          </frameset>"};
html = {@html,       "     </frameset>"};
html = {@html,       "</frameset>"};
result = this:build(user, html, tostr($httpd.server_name, $core_version), "", "", "", "", this.doctype_frameset);
return result;
.

@program $encore_web_class:build
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Assembles the web page based on arguments from the calling verb.";
"Accepts the following arguments: user, body html, alternative page title, javascript onload call, target, frame identity, content type, and doctype";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, body, ?title = this.name, ?onload = "", ?target = "", ?frame_identity = "", ?content_type = $httpd.content_type, ?doctype = this.default_doctype, ?style = 1} = args;
if (caller == $xpress_login)
  onload = tostr("onload=\"", onload, "\"");
else
  if (onload)
    onload = tostr("onload=\"", onload, "\"");
  else
    onload = "";
  endif
endif
head = $encore_web_utils:make_head(user, this, title, target, content_type, style);
if (doctype != this.doctype_frameset)
  "Do not insert body tags for framesets";
  body = $encore_web_utils:make_body(user, this, body, onload, frame_identity);
endif
html = $encore_web_utils:make_page(user, this, $list_utils:append(head, body), doctype);
return html;
.

@program $encore_web_utils:make_head
"===========================================================";
"Copyright (C) 1997-2004, Jan Rune Holmevik";
"Creates an HTML Header for a page. In addition to the object number of the object or application, this verb also accepts three optional arguments which specifies an alternative page title a base target, and content type.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, ?title = object:title(), ?target = "", ?content_type = $httpd.content_type, ?style = 1} = args;
style_sheet = {};
if (target != "")
  target = {tostr("   <base target=\"", target, "\" />")};
else
  target = {};
endif
head = {"<head>"};
meta = {tostr("   <meta http-equiv=\"content-type\" content=\"", content_type, "\" />")};
meta = {@meta, tostr("   <meta name=\"Generator\" content=\"", $httpd.server_name, $core_version, "\" />")};
meta = {@meta, tostr("   <meta name=\"Description\" content=\"This page was generated by the ", $network.MOO_name, " ", $httpd.server_name, $core_version, " web server on ", $time_utils:time_sub("$N $3. $Y at $H:$M:$S, $Z", time()), "\" />")};
meta = {@meta, tostr("   <meta name=\"Keywords\" content=\"", $core_name, ", enCore Xpress, ", $network.MOO_name, ", MOO, MUD\" />")};
meta = {@meta, tostr("   <meta name=\"Copyright\" content=\"", $copyright, "\" />")};
meta = {@meta, tostr("   <link rel=\"shortcut icon\" href=\"", $xpress_client.external_baseurl, "images/system/favicon.ico\" />")};
title = {tostr("   <title>", title, " (", $network.MOO_name, ")</title>")};
if (style)
  style_sheet = $list_utils:append({"   <style type=\"text/css\" media=\"screen\">", "      <!--"}, object:css(user, object), {"      -->", "   </style>"});
endif
head = $list_utils:append(head, meta, title, target, style_sheet, {"</head>"});
return head;
.

@program $encore_web_utils:make_page
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Enclose a page in html tags and insert doctype";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, page, ?doctype = object.default_doctype} = args;
if (doctype == "")
  doctype = object.default_doctype;
endif
xml_declaration = object.xml_declaration;
html = $list_utils:append(xml_declaration, doctype, {tostr("<html ", object.xml_namespace, ">")}, page, {"</html>"});
return html;
.


@program $encore_web_utils:make_body
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Returns a page enclosed in body tags.";
"===========================================================";
{user, object, ?page = {}, ?onload = "", ?frame_identity = ""} = args;
if (frame_identity)
  frame_identity = tostr(" id=\"", frame_identity, "\" name=\"", frame_identity, "\"");
endif
body = $list_utils:append({tostr("<body", frame_identity, " ", onload, ">")}, page, 
{"</body>"});
return body;
.

@rename $encore_web_utils:make_style_sheet to css
@copy-move $encore_web_utils:css to $encore_web_class

@program $encore_web_class:css
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
style_sheet = {};
if ($object_utils:isa(object, $encore_web_object) && $encore_web_object.use_external_stylesheet || ($object_utils:isa(object, $encore_web_application) && $encore_web_application.use_external_stylesheet))
  "--------------------------------------------------";
  "Use specified external style sheet";
  "--------------------------------------------------";
  ref = $object_utils:isa(object, $encore_web_object) == 1 ? $encore_web_object.external_stylesheet | $encore_web_application.external_stylesheet;
  if (!match(ref, "http://"))
    ref = tostr($xpress_client.external_baseurl, $xpress_client.stylesheets_folder, ref);
  endif
  style_sheet = {tostr("   <link rel=\"StyleSheet\" href=\"", ref, "\" type=\"text/css\" media=\"screen\" />")};
else
  "--------------------------------------------------";
  "Make embedded style sheet based on object apperance values";
  "--------------------------------------------------";
  if (user.override_object_styles && object.allow_override_styles)
    object = user;
  endif
  background = "";
  if (match(object.web_background, "http://"))
    background = object.web_background;
  elseif (object.web_background != "")
    background = tostr($xpress_client.external_baseurl, $xpress_client.icons_folder, object.web_background);
  endif
  style_sheet = {@style_sheet, "      /* General element definitions */"};
  style_sheet = {@style_sheet, tostr("        body, p, td { color: ", object.web_text_color, "; font-family: ", object.web_font, "; font-size: ", object.web_font_size, "; background: none }")};
  style_sheet = {@style_sheet, tostr("        body { ", bkground = background == "" ? "" | tostr("background: url(", background, "); "), bgcolor = object.web_bgcolor == "" ? "" | tostr("background-color: ", object.web_bgcolor, "; "), " }")};
  style_sheet = {@style_sheet, tostr("        img { border: ", object.icon_border, " }")};
  style_sheet = {@style_sheet, tostr("        div.title { color: ", object.title_font_color, "; font-size: ", object.title_font_size, "; ", background = $object_utils:isa(object, $encore_web_application) == 1 ? tostr(" background-image: url(\"", $xpress_client.external_baseurl, $xpress_client.themes_folder, user.xpress_theme, "/theme-background.jpg\")") | " background: none", " }")};
  style_sheet = {@style_sheet, tostr("        div.subtitle { color: ", object.title_font_color, "; font-size: ", object.subtitle_font_size, "; ", background = $object_utils:isa(object, $encore_web_application) == 1 ? tostr(" background-image: url(\"", $xpress_client.external_baseurl, $xpress_client.themes_folder, user.xpress_theme, "/theme-background.jpg\")") | " background: none", " }")};
  style_sheet = {@style_sheet, tostr("        pre { font-family: ", object.fixed_width_font, "; font-size: ", object.fixed_width_font_size, " }")};
  style_sheet = {@style_sheet, "      /* Link definitions */"};
  style_sheet = {@style_sheet, tostr("        a { font-family: ", object.web_font, "; font-size: ", object.web_font_size, ";", object.underline_links == 0 ? " text-decoration: none" | "", " background: none }")};
  style_sheet = {@style_sheet, tostr("        a:link { color: ", object.web_link_color, " }")};
  style_sheet = {@style_sheet, tostr("        a:visited { color: ", object.web_vlink_color, " }")};
  style_sheet = {@style_sheet, tostr("        a:hover { background: ", object.web_alink_color, " }")};
  style_sheet = {@style_sheet, "      /* Table layout */"};
  style_sheet = {@style_sheet, tostr("        table { width: ", object.table_width, ";  border : 1px solid black; }")};
  style_sheet = {@style_sheet, tostr("        th { vertical-align: ", object.table_vertical_alignment, " }")};
  style_sheet = {@style_sheet, tostr("        td { vertical-align: ", object.table_vertical_alignment, ";  }")};
  style_sheet = {@style_sheet, tostr("        div.header { background-color: silver; }")};
endif
return style_sheet;
.

@program $encore_web_utils:page_assembled
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Returns 1 if the first line on the page matches ?xml or !DOCTYPE. Returns 0 if not";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
return match(args[1][1], "<html>") || match(args[1][3], "xml") || match(args[1][1], "<!DOCTYPE") ? 1 | 0;
.

@verb $encore_web_application:css this none this
@program $encore_web_application:css 
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
{user, object} = args;
style_sheet = pass(@args);
style_sheet = {@style_sheet, "      /* Xpress web application styles */"};
style_sheet = {@style_sheet, tostr("        textarea { font-family: ", object.fixed_width_font, "; font-size: ", object.fixed_width_font_size, " }")};
style_sheet = {@style_sheet, tostr("        input.text { font-family: ", object.fixed_width_font, "; font-size: ", object.fixed_width_font_size, " }")};
style_sheet = {@style_sheet, tostr("        input.button { font-family: system; font-size: 12px }")};
style_sheet = {@style_sheet, tostr("        input.submit { font-family: system; font-size: 12px }")};
style_sheet = {@style_sheet, tostr("        div.menu { text-align: center; padding-top: 1em }")};
return style_sheet;
.

@verb $room:css this none this
@program $room:css 
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
{user, object} = args;
style_sheet = pass(@args);
style_sheet = {@style_sheet, "      /* Room content layout objects and exits */"};
style_sheet = {@style_sheet, tostr("        span#objects { position : relative; width : 50%; float : left; }")};
style_sheet = {@style_sheet, tostr("        span#exits { position : relative; width : 50%; float : left; }")};
return style_sheet;
.

@verb $inventory_manager:css this none this
@program $inventory_manager:css 
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
{user, object} = args;
style_sheet = pass(@args);
style_sheet = {@style_sheet, "      /* Layout for Xpress Inventory Manager */"};
style_sheet = {@style_sheet, tostr("        span#left { width : 33%; float : left; }")};
style_sheet = {@style_sheet, tostr("        span#middle { width : 33%; float : left; }")};
style_sheet = {@style_sheet, tostr("        span#right { width : 33%; clear : left;}")};
return style_sheet;
.

@verb $xpress_program_editor:css this none this
@program $xpress_program_editor:css 
"===========================================================";
"Copyright (C) 2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
{user, object} = args;
style_sheet = pass(@args);
style_sheet = {@style_sheet, "      /* Layout for Xpress Program Editor */"};
style_sheet = {@style_sheet, tostr("        span#left { position : absolute; width : 250px; line-height : 200%; }")};
style_sheet = {@style_sheet, tostr("        span#right { position : relative; left : 250px; line-height : 200%; }")};
return style_sheet;
.

@verb $administration_module:css this none this
@program $administration_module:css 
"===========================================================";
"Copyright (C) 2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
{user, object} = args;
style_sheet = pass(@args);
style_sheet = {@style_sheet, "      /* Layout for Xpress Program Editor */"};
style_sheet = {@style_sheet, tostr("        span#classes { position : absolute; width : 150px; line-height : 200%; float : left; padding-top : 1.5em;  }")};
style_sheet = {@style_sheet, tostr("        span#data { position : absolute; left : 150px; line-height : 200%; padding-top : 1.5em; padding-right : 1.5em; }")};
return style_sheet;
.

@verb $xpress_moo_mailer:css this none this
@program $xpress_moo_mailer:css 
"===========================================================";
"Copyright (C) 2004, Jan Rune Holmevik";
"Creates a stylesheet for a page.";
"===========================================================";
{user, object} = args;
style_sheet = pass(@args);
style_sheet = {@style_sheet, "      /* MOO mailer styles */"};
style_sheet = {@style_sheet, tostr("        div.mailhead { background-color: silver }")};
style_sheet = {@style_sheet, tostr("        div.highlight { display: inline; background-color: yellow }")};
return style_sheet;
.


@program $encore_web_utils:generate_table
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"This verb generates a table based on arguments passed from the calling verb. The first argument should be the user, the second, a list containing the data (a list or set of lists), and the third argument should contain the number of the calling object. In addition, the following optional arguments may be passed to this verb:";
"The 4rd argument should be an alpha numerical value 0/1. If 1 is passed, a table with number of rows equal to the longest collumn (list) in data will be created. Else, a simple 1 row table will be generated";
"===========================================================";
{user, data, object, ?layout = "0"} = args;
table = {"<table>"}; 
if (layout == "0" || layout == 0)
  rows = 1;
else
  "Find length of longest list";
  rows = 0;
  for lst in (data)
    suspend(0);
    if (length(lst) > rows)
      rows = length(lst);
    endif
  endfor
endif
"Generate table rows";
for row in [1..rows]
  table = {@table, tostr("<tr>")};
  "Generate table cells";
  for item in [1..length(data)]
    suspend(0);
    if (rows == 1)
      cell = data[item];
    elseif (row > length(data[item]))
      cell = {" "};
    else
      cell = {data[item][row]};
    endif
    if (row == 1)
      "Added table header tags. Jan 01/03";
      cell = {tostr("<th>"), @cell, "</th>"};
    else
      cell = {tostr("<td>"), @cell, "</td>"};
    endif
    table = $list_utils:append(table, cell);
  endfor
  table = {@table, "</tr>"};
endfor
table = {@table, "</table>"};
return table;
.

@program $encore_web_utils:get_title
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Get object title and insert contextual menu if appropriate";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, ?title = object.name} = args;
if (verb == "get_title")
  {functions, buttons} = object:make_contextual_menu(user);
  title = $list_utils:append(functions, {tostr("<div class=\"title\">", title)}, {"</div>"}, 
buttons);
else
  title = {tostr("<div class=\"subtitle\">", title, "</div>")};
endif
return title;
.


@program $encore_web_utils:preformat
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
return {"<pre>", @args[1], "</pre>"};
.

@program $encore_web_utils:get_text_linebreak
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik, Mark Blanchard, and Hervi Collin";
"Returns a list with a <br> tag appended to the end of each line.";
"===========================================================";
result = {};
text = args[1];
if (typeof(text) == LIST)
  for line in [1..length(text)]
    $command_utils:suspend_if_needed(1);
    if ($string_utils:explode(text[line], "<") || $string_utils:explode(text[line], ">"))
      string = $string_utils:subst($string_utils:subst(text[line], {{"<", "&lt;"}}), {{">", "&gt;"}}) + $encore_web_utils:br();
      result = {@result, string};
    elseif (text[line] == "")
      result = {@result, $encore_web_utils:br()};
    endif
  endfor
endif
return result;
.

@program $encore_web_utils:resolve_url
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
{user, object} = args;
url = object.url_address;
width = caller.web_width == "" ? "" | tostr(" width=\"", caller.web_width, "\"");
height = caller.web_height == "" ? "" | tostr(" height=\"", caller.web_height, "\"");
filetype = $encore_web_utils:get_file_type(url);
if (filetype == "a href=")
  img = tostr($xpress_client.external_baseurl, $xpress_client.icons_folder, "weblink.gif");
  html = tostr("<", filetype, caller.url_address, " target=\"_blank\">[Click to view the web page connected to this object]</a>");
elseif (filetype == "applet")
  codebase = "";
  url = $string_utils:explode(url, "/");
  sourcefile = url[length(url)];
  for n in [1..length(url) - 1]
    if (n == 1)
      codebase = codebase + url[n] + "//";
    else
      codebase = codebase + url[n] + "/";
    endif
  endfor
  html = tostr("<", filetype, " code=\"", sourcefile, "\" codebase=\"", codebase, "\" ", width, " ", height, " </applet>");
else
  html = tostr("<", filetype, " src=\"", caller.url_address, "\" ", width, " ", height, " alt=\"", caller:name(), "\" />");
endif
return {html};
.


@program $encore_web_utils:get_file_type
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
url = $string_utils:explode(args[1], ".");
ext = url[length(url)];
if (ext in $httpd.inline_image_suffixes)
  type = "img";
elseif (ext == "class" || ext == "jar")
  type = "applet";
elseif (ext in $httpd.embed_file_suffixes)
  type = "embed";
else
  type = "a href=";
endif
return type;
.

@verb $encore_web_utils:baseurl this none this
@program $encore_web_utils:baseurl
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Return the MOO's base url.";
"===========================================================";
{?path = ""} = args;
return tostr("http://", $network.site, ":", $network.webport, "/", path);
.


@program $encore_web_utils:align
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Align content, defaults to left";
"===========================================================";
{content, ?alignment = "left"} = args;
return {tostr("<div style=\"text-align: ", alignment, "\">"), @content, "</div>"};
.

@program $xpress_misc:guide_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
guide = {};
title = $encore_web_utils:get_title(user, this, $guide.name);
for line in ($guide.text)
  guide = {@guide, line};
endfor
guide = $encore_web_utils:detect_urls(user, guide);
guide = $encore_web_utils:div($encore_web_utils:insert_line_breaks(guide));
body = $list_utils:append(title, guide);
result = this:build(user, body, $guide.name);
return result;
.



@program $encore_web_object:_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Verb that generates HTML source code on-the-fly for a MOO object that is sub class of $enCore_web_object.";
"===========================================================";
user = args[1];
if ($encore_web_utils:is_locked(user, this) && user.location != this)
  "Locked, direct user to $player_start if anonymous";
  html = this:build(user, (loc = user == $no_one ? $player_start | user.location):_html(user), loc.name, $encore_web_utils:tell_locked(this));
else
  this:update_hits();
  audio = visual = drawing = title = {};
  base_url = $encore_web_utils:baseurl();
  title = $encore_web_utils:get_title(user, this);
  "---------------------------------------------------------";
  "Add audio content";
  "---------------------------------------------------------";
  if (this.audio_url)
    audio = $encore_web_utils:make_sound(user, this.audio_url);
  endif
  "---------------------------------------------------------";
  "Add visual multi-media content";
  "---------------------------------------------------------";
  if (this.url_address)
    visual = $encore_web_utils:resolve_url(user, this);
    visual = $encore_web_utils:align(visual, this.media_content_alignment);
  endif
  if (this.drawing != {} && this.drawing != {""} && this.drawing != "" && this.display_ascii)
    drawing = $encore_web_utils:preformat(this.drawing);
  endif
  "---------------------------------------------------------";
  "Add object textual content and assemble parts";
  "---------------------------------------------------------";
  description = $encore_web_utils:detect_urls(user, this.description);
  description = $encore_web_utils:insert_line_breaks(description);
  description = $encore_web_utils:align($encore_web_utils:p(description), this.text_alignment);
  html = $list_utils:append(title, audio, visual, drawing, description);
endif
return html;
.

@program $room:_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Verb that generates links based on contents and exits in a room";
"===========================================================";
user = args[1];
if (!$encore_web_utils:page_assembled(html = pass(user)))
  contents = exits = links = {};
  if (this.contents != {})
    contents = $encore_web_utils:generate_links(user, this.contents);
    contents = $encore_web_utils:insert_line_breaks({$encore_web_utils:bold(this.web_contents_msg), @contents});
    contents = $encore_web_utils:span(contents, "objects");
  endif
  if (this.exits != {})
    "Modified by Traveller 7/15/01 to use the dynamic :obvious_exits() instead of the static exit.obvious";
    exits = this:obvious_exits();
    exits = $encore_web_utils:generate_links(user, exits);
    exits = $encore_web_utils:insert_line_breaks({$encore_web_utils:bold(this.web_exits_msg), @exits});
    exits = $encore_web_utils:span(exits, "exits");
  endif
  html = $list_utils:append(html, $encore_web_utils:p($list_utils:append(contents, exits)));
  "Move user to new location if java client on";
  if (user.ts_client && user.location != this)
    $encore_web_utils:move_via_web(user, this);
  endif
endif
return html;
.

@program $news:_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
user = args[1];
html = pass(@args);
contents = {};
if (this.contents)
  titles = {};
  dates = {};
  articles = $news:articles();
  titles = $encore_web_utils:generate_links(user, this.contents);
  for article in (articles)
    dates = {@dates, $news:date(article.date)};
  endfor
  titles = {$encore_web_utils:div("Title", "header"), @titles};
  dates = {$encore_web_utils:div("Last updated", "header"), @dates};
  contents = $encore_web_utils:generate_table(user, {titles, dates}, this, "1");
else
  contents = $list_utils:append(contents, $encore_web_utils:p("Sorry, there are no news articles to read."));
endif
html = $list_utils:append(html, contents);
return html;
.

@program $note_board:_html
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik";
"===========================================================";
user = args[1];
html = pass(@args);
contents = {};
if (this.contents)
  titles = this.contents;
  lengths = authors = dates = {};
  for note in (titles)
    suspend(0);
    lengths = {@lengths, tostr(length(note.text), " lines")};
    if (!note.author_name)
      authors = {@authors, note.owner.name};
    else
      authors = {@authors, note.author_name};
    endif
    dates = {@dates, $time_utils:time_sub("$2/$3/$y $H:$M $Z", note.date)};
  endfor
  titles = $encore_web_utils:generate_links(user, titles);
  titles = {$encore_web_utils:div("Title", "header"), @titles};
  lengths = {$encore_web_utils:div("Length", "header"), @lengths};
  authors = {$encore_web_utils:div("Author", "header"), @authors};
  dates = {$encore_web_utils:div("Posted", "header"), @dates};
  contents = $encore_web_utils:generate_table(user, {titles, lengths, authors, dates}, this, 1);
else
  contents = $list_utils:append(contents, $encore_web_utils:div({"It is empty."}));
endif
html = $list_utils:append(html, contents);
return html;
.

@program $note:_html
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
user = args[1];
if (!$encore_web_utils:page_assembled(html = pass(user)))
  text = $encore_web_utils:detect_urls(user, this.text);
  text = $encore_web_utils:insert_line_breaks(text);
  text = $encore_web_utils:align($encore_web_utils:p(text), this.note_text_alignment);
  html = $list_utils:append(html, text);
endif
return html;
.

@program $recorder:_html
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
html = pass(@args);
user = args[1];
contents = {};
if (this.contents)
  titles = this.contents;
  lengths = {};
  owners = {};
  for n in (titles)
    lengths = {@lengths, tostr(length(n.text), " lines")};
    owners = {@owners, n.owner.name};
  endfor
  titles = $encore_web_utils:generate_links(user, titles);
  titles = {$encore_web_utils:div("Title", "header"), @titles};
  lengths = {$encore_web_utils:div("Length", "header"), @lengths};
  owners = {$encore_web_utils:div("Owner", "header"), @owners};
  titles = $encore_web_utils:insert_line_breaks(titles);
  lengths = $encore_web_utils:insert_line_breaks(lengths);
  owners = $encore_web_utils:insert_line_breaks(owners);
  contents = $encore_web_utils:generate_table(user, {titles, lengths, owners}, this, 
"1");
endif
html = $list_utils:append(html, contents);
return html;
.

@program $container:_html
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik";
"===========================================================";
user = args[1];
contents = {};
if (!$encore_web_utils:page_assembled(html = pass(user)))
  if (!this.opened)
    html = {@html, tostr(this.name, " is closed. Type 'open ", this.name, "' to open it.")};
  elseif (this.contents == {})
    html = {@html, tostr(this.name, " is empty.")};
  elseif (this.dark)
    html = {@html, tostr("The inside of ", this.name, " is too dark to make out its contents.")};
  elseif (!$object_utils:has_verb(caller, "_html"))
    contents = $encore_web_utils:generate_links(user, this.contents);
    contents = $encore_web_utils:insert_line_breaks(contents);
    html = $list_utils:append(html, $encore_web_utils:div(contents));
  endif
endif
return html;
.


@program $player:_html
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
out = pass(user);
if (!$anonymous_users)
  if ($object_utils:isa(this, $guest))
    "Do not display extra info on guests";
  else
    extra = {};
    if (this.real_name)
      extra = $list_utils:append(extra, $encore_web_utils:p(tostr("Real Name: ", this.real_name)));
    endif
    if (this.homepage)
      extra = $list_utils:append(extra, $encore_web_utils:p(tostr("Home page: ", $encore_web_utils:a(this.homepage, this.homepage, "_blank"))));
    endif
    if (this.wizard)
      extra = $list_utils:append(extra, $encore_web_utils:p(tostr(this.psc, " is a wizard in ", $network.MOO_name)));
    elseif (this.programmer)
      extra = $list_utils:append(extra, $encore_web_utils:p(tostr(this.psc, " is a programmer in ", $network.MOO_name)));
    endif
    extra = $list_utils:append(extra, $encore_web_utils:p());
    if (this.interests_msg != "")
      if (typeof(this.interests_msg) == LIST)
        for n in (this.interests_msg)
          extra = {@extra, n};
        endfor
      else
        extra = {@extra, tostr(this.interests_msg)};
      endif
    endif
    out = $list_utils:append(out, extra);
  endif
endif
return out;
.

@program $xpress_client:java_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik and Sindre Soerensen";
"The original code and Javascript functions written by Sindre Soerensen.";
"Simplified and modified to allow more browsers to run Xpress.";
"Jan, January, 2003-2004";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
frame_identity = "myBody";
base_url = tostr("http://", $network.site, "/");
external_baseurl = $xpress_client.external_baseurl + $xpress_client.java_client_folder;
style = 0;
applet_params = {{"MOOname", $network.MOO_name}, {"HostName", $network.site}, {"port", 
$network.port}, {"font", user.java_font}, {"fontsize", user.java_font_size}, 
{"localecho", user.java_client_localecho}, {"login", tostr("autoconnect ", user, " ", 
crypt(user.web_access_code))}};
"Converting the applet_params from MOO-list to javascript-array";
javascript_applet_params = {};
for param in (applet_params)
  javascript_applet_params = {@javascript_applet_params, tostr("['", param[1], "', '", 
param[2], "'],")};
endfor
javascript_applet_params[$] = javascript_applet_params[$][1..$ - 1];
javascript_applet_params = {"var _java_client_param_pairs = [", 
@javascript_applet_params, "];"};
javascript_vars = {"var _pluginspage = 'http://www.mozilla.org/oji/MRJPlugin.html';"};
javascript_vars = {@javascript_vars, tostr("var _java_client_codebase ='", 
external_baseurl, "';")};
javascript_vars = {@javascript_vars, tostr("var _java_client_archive ='", 
this.java_client_archive, "';")};
javascript_vars = {@javascript_vars, tostr("var _java_client_classname='", 
this.java_client_filename, "';")};
javascript = $list_utils:append(javascript_vars, javascript_applet_params, 
this.javascript_functions);
javascript = $encore_web_utils:insert_javascript(javascript);
body = javascript;
result = this:build_page(user, body, "MOOtcan", "", "", frame_identity, "", 
this.default_doctype, style);
return result;
.


@program $encore_web_utils:get_icon
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Make image tag for icon.";
"===========================================================";
{user, object, ?icon = "", ?alt = "", ?action = ""} = args;
result = locked = "";
if (!icon && $object_utils:has_property(object, "icon"))
  icon = object.icon;
endif
try
  size = user.icon_size;
  base_url = $xpress_client.external_baseurl + $xpress_client.icons_folder;
  "---------------------------------------";
  "Check if object is locked";
  "---------------------------------------";
  if ($encore_web_utils:is_locked(user, object))
    icon = base_url + object.locked_icon;
  elseif (!match(icon, "http://"))
    if (icon == "")
      "----------------------------------------------------";
      "User has deleted the icon, or no icon is present";
      "Return parent's icon if it exists.";
      "----------------------------------------------------";
      icon = $object_utils:has_property(parent(object), "icon") == 1 ? $string_utils:trim(parent(object).icon) | "";
    endif
    icon = base_url + icon;
  endif
  if (icon != "")
    result = tostr("<img src=\"", icon, "\" height=\"", size, "\" border=\"", object.icon_border, "\" align=\"", object.icon_alignment, "\"", alt == "" ? " alt=\"\"" | tostr(" alt=\"", alt, "\" title=\"", alt, "\""), action == "" ? "" | tostr(" onclick=\"", action, "\""), " />");
  endif
except error (ANY)
endtry
return result;
.

@rename $encore_web_utils:insert_line_breaks to "insert_line_break*s br"
@program $encore_web_utils:insert_line_breaks
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
if (args)
  text = args[1];
  result = {};
  newline = "";
  if (typeof(text) == LIST)
    for line in (text)
      $command_utils:suspend_if_needed(0);
      result = {@result, line + "<br />"};
    endfor
  else
    result = {text + "<br />"};
  endif
else
  result = "<br />";
endif
return result;
.

@program $encore_web_utils:generate_links
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"If the variable exit name is specified as 0 then this verb will use the exit's destination as link name";
"===========================================================";
{user, domain, ?target = "", ?use_exit_name = 0} = args;
result = {};
base_url = tostr("http://", $network.site, ":", $network.webport, "/");
for object in (domain)
  suspend(0);
  if ($object_utils:isa(object, $encore_web_object))
    if ($object_utils:isa(object, $exit) && !use_exit_name)
      linkname = object.dest.name;
      link = tonum(object.dest);
    elseif (is_player(object))
      linkname = object:titlec();
      link = tonum(object);
    else
      linkname = object.name;
      link = tonum(object);
    endif
    link = tostr("<a href=\"", base_url, link, "/\"", target == "" ? "" | tostr(" target=\"", target, "\""), ">", $encore_web_utils:get_icon(user, object), linkname, "</a>");
  else
    link = object.name;
  endif
  result = {@result, link};
endfor
return result;
.

@verb $encore_web_utils:p*aragraph this none this
@program $encore_web_utils:paragraph
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a paragraph element";
"===========================================================";
{?content = {"<p></p>"}, ?class = ""} = args;
if (args)
  if (typeof(content) == LIST)
    content = {tostr("<p", class == "" ? ">" | tostr(" class=\"", class, "\">")), @content, "</p>"};
  else
    content = {tostr("<p", class == "" ? ">" | tostr(" class=\"", class, "\">"), content, "</p>")};
  endif
endif
return content;
.

@verb $encore_web_utils:b*old this none this
@program $encore_web_utils:bold
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a bold element";
"===========================================================";
{content, ?class = ""} = args;
if (typeof(content) == LIST)
  content = {tostr("<b", class == "" ? ">" | tostr(" class=\"", class, "\">")), @content, "</b>"};
else
  content = tostr("<b", class == "" ? ">" | tostr(" class=\"", class, "\">"), content, "</b>");
endif
return content;
.


@verb $encore_web_utils:close*_button this none this
@program $encore_web_utils:close
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a close window button. If no argument is given, target defaults to self";
"===========================================================";
{?window = "self"} = args;
return {tostr("<input class=\"button\" type=\"button\" id=\"CloseWindow\" name=\"CloseWindow\" value=\"Close\" onclick=\"", window, ".close()\" />")};
.
 
@program $MOO_Info:about_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Show vital MOO statistics plus lisence and credits";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
info = wiz_list = {};
for wiz in ($wiz_utils:all_wizards_advertised())
  wiz_list = {@wiz_list, wiz:name()};
endfor
title = $encore_web_utils:get_title(user, this, tostr("About ", $network.MOO_name));
info = {@info, tostr("Founded : ", $time_utils:time_sub("$N $T, $Y.", #2.first_connect_time))};
info = {@info, tostr("Total number of users : ", length(players()))};
info = {@info, tostr("Wizards : ", $string_utils:english_list(wiz_list))};
info = {@info, tostr("MOO Server: LambdaMOO version ", server_version())};
info = {@info, tostr("Core: ", $core_name, ", version ", $core_version)};
info = {@info, tostr("Web server: ", $httpd.server_name, $core_version, " (", $httpd.protocol, ")")};
info = {@info, tostr("Authentication: ", $httpd.authentication_method)};
info = {@info, tostr("Database: ", tonum(max_object()), " objects, ", db_disk_size(), " bytes on disk")};
info = {@info, tostr("Uptime: ", $time_utils:english_time(time() - $last_restart_time))};
info = {@info, tostr("Last Backup: ", $time_utils:english_time(time() - $last_dump_time), " ago")};
info = {@info, tostr("Total Xpress Logins: ", $httpd.total_logins)};
info = {@info, tostr("Total MOO web pages served: ", $httpd.total_pages_served)};
info = {@info, tostr("enCore Open Source Project: ", $core_homepage)};
info = $encore_web_utils:detect_urls(user, info);
info = $encore_web_utils:p($encore_web_utils:insert_line_breaks(info));
license = $string_utils:substitute($sysobj.license[1], $encore_web_utils.html_entity_subs);
license = $encore_web_utils:detect_urls(user, license);
license = $encore_web_utils:insert_line_breaks(license);
license = $encore_web_utils:p($encore_web_utils:italics(license));
credits = $encore_web_utils:p($contributors);
body = $encore_web_utils:div($list_utils:append(title, info, license, credits, $encore_web_utils:close()));
result = this:build(user, body);
return result;
.

@program $encore_web_utils:detect_urls
"Copyright (C) 1999-2000, Jan Rune Holmevik and Matthew Beermann";
"Searches for URLs in text and marks them up.";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, text, ?treat_as_HTML = 0} = args;
if (typeof(text) == STR)
  text = {text};
endif
result = {};
for line in (text)
  $command_utils:suspend_if_needed(0);
  new_line = line;
  more_urls = 1;
  rest_line = line;
  while (more_urls)
    if ((position = index(rest_line, "http://")) && !(treat_as_HTML && index(rest_line, "<") && index(rest_line, "<") < position && index(rest_line, ">") > position))
      "A url was detected in this line";
      "Find the end of the URL by searching for the first empty space";
      rest_line = rest_line[position..$];
      url = "";
      for next in [1..length(rest_line)]
        if (rest_line[next] == " ")
          break;
        else
          url = url + rest_line[next];
        endif
      endfor
      "URL assembled, now check if the last character is punctuation";
      while (url[$] in {")", "]", "}", ">", ":", ";", ".", ",", "!", "'", "\""})
        url = url[1..length(url) - 1];
      endwhile
      link = tostr("<a href=\"", url, "\" target=\"_blank\">", url, "</a>");
      rest_line = rest_line[next..$];
      new_line = $string_utils:substitute(line, {{url, link}});
    else
      more_urls = 0;
    endif
    line = new_line;
  endwhile
  result = {@result, line};
endfor
return result;
.

@program $network:init_for_core
if (caller_perms().wizard)
  pass(@args);
  this.active = 1;
  this.reply_address = "moomailreplyto@yourhost";
  this.errors_to_address = "moomailerrors@yourhost";
  this.site = "127.0.0.1";
  this.postmaster = "postmastername@yourhost";
  this.usual_postmaster = "postmastername@yourhost";
  this.password_postmaster = "postmastername@yourhost";
  this.envelope_from = "postmastername@yourhost";
  this.blank_envelope = 0;
  this.MOO_name = $core_name;
  this.maildrop = "127.0.0.1";
  this.port = 7777;
  this.webport = 7000;
  this.large_domains = {};
  this.trusts = {$hacker};
  this.connect_connections_to = {};
endif
.

@program $xpress_client:init_for_core
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Reset object to default values.";
"===========================================================";
if (caller_perms().wizard)
  pass();
  this.java_client_folder = "mootcan/";
  this.java_client_archive = "mootcan-012.jar";
  this.java_client_filename = "MOOtcan.class";
  this.texts_folder = "texts/";
  this.stylesheets_folder = "stylesheets/";
  this.external_baseurl = "http://127.0.0.1/encore/";
  this.on = 1;
  this.allow_internet_mail = 0;
  this.HTTP_09_enabled = 1;
  this.web_text_color = "black";
  this.web_link_color = "blue";
  this.web_vlink_color = "purple";
  this.web_alink_color = "red";
  this.java_font_sizes = {9, 10, 11, 12, 13, 14};
  this.java_client_width = "100%";
  this.java_client_height = "100%";
  this.java_client_alignment = "top";
  this.java_client_font = "Courier";
  this.java_client_font_size = "10";
  this.window_close_timeout = "3000";
  this.guest_names_and_manners = {"In this MOO you can use your own name instead of an anonymous guest name. The name you choose must be unique, however. If it's being used by someone else, you must choose another name. Also, please note that names must not contain any open spaces."};
  this.MOTD_Msg = "";
  this.MOTD_viewer_list = {};
  this.Screen_Sizes = {{"self.screen.availWidth,self.screen.availHeight", "Full Screen"}, {"1152,768", "1152 by 768 pixels (wide screen)"}, {"1024,768", "1024 by 768 pixels"}, {"900,600", "900 by 600 pixels (wide screen)"}, {"800,600", "800 by 600 pixels"}, {"720,480", "720 by 480 pixels (wide screen)"}, {"640,480", "640 by 480 pixels"}};
  this.screen_layouts = {{"vertical_layout", "Vertical Orientation"}, {"horizontal_layout", "Horizontal Orientation"}, {"simple_layout", "Chat Area Only"}};
  this.Screen_Divisions = {{"30%,70%", "Talk Area 30%, Web Area 70%"}, {"40%,60%", "Talk Area 40%, Web Area 60%"}, {"50%,50%", "Talk Area 50%, Web Area 50%"}, {"60%,40%", "Talk Area 60%, Web Area 40%"}, {"70%,30%", "Talk Area 70%, Web Area 30%"}};
  this.themes = {{"Amber", "amber"}, {"Azure", "azure"}, {"Ice", "ice"}, {"Lemon", "lemon"}, {"Lime", "lime"}, {"Magenta", "magenta"}, {"Poppy", "poppy"}, {"Sky", "sky"}, {"Steel", "steel"}, {"Tangerine", "tangerine"}};
  this.icon_sizes = {{"Tiny", 16}, {"Small", 24}, {"Normal", 32}, {"Large", 48}, {"Extra Large", 64}};
  this.web_background = "background-gray.jpg";
  "--------------------------------------------------------";
  "Set default icons for other objects in the Xpress system";
  "--------------------------------------------------------";
  $room.icon = "room.gif";
  $bot.icon = "bot.gif";
  $builder.icon = "builder.gif";
  $classroom.icon = "classroom.gif";
  $container.icon = "container.gif";
  $exit.icon = "exit.gif";
  $guest.icon = "guest.gif";
  $lecture.icon = "lecture.gif";
  $xpress_moo_mailer.icon = "mail.gif";
  $help_browser.icon = "help.gif";
  $moderated_room.icon = "moderated_room.gif";
  $news.icon = "news.gif";
  $note.icon = "note.gif";
  $note_board.icon = "noteboard.gif";
  $player.icon = "player.gif";
  $prog.icon = "programmer.gif";
  $slide_projector.icon = "projector.gif";
  $recorder.icon = "recorder.gif";
  $thing.icon = "thing.gif";
  $webpage.icon = "webpage.gif";
  $webprojector.icon = "webprojector.gif";
  $wiz.icon = "wizard.gif";
endif
.

@program $player:init_for_core
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Reset object to default values.";
"===========================================================";
if (caller_perms().wizard)
  pass();
  if ($code_utils:verb_location() != this)
    if (this in {$no_one, $hacker})
      this.home = $nothing;
    else
      clear_property(this, "home");
    endif
    if (a = $list_utils:assoc(this, {{$builder, $builder_help}, {$prog, {$prog_help, $builtin_function_help, $verb_help, $core_help}}, {$wiz, $wiz_help}}))
      this.help = a[2];
    else
      this.help = 0;
    endif
    for p in ({"last_connect_place", "all_connect_places", "features", "last_disconnect_time"})
      clear_property(this, p);
    endfor
    this.first_connect_time = this.last_connect_time = $maxint;
  else
    "Xpress player defaults";
    this.home = $player_start;
    this.help = {$help, $encore_help};
    this.features = {$stage_talk, $pasting_feature, $login_watcher, $soc_verbs};
    this.doing = "";
    this.web_access_code = "";
    this.java_font = "Courier";
    this.java_font_size = 12;
    this.xpress_on = 0;
    this.sound_volume = 10;
    this.mail_notify_sound = "moomail.wav";
    this.java_client_localecho = "False";
    this.web_mail_signature = {};
    this.update_web_display = 1;
    this.recording = 0;
    this.Xpress_Confunc_Msg = {};
    this.Xpress_Log = {};
    this.Xpress_Notebook = {};
    this.invis = 0;
    this.xpress_bookmarks = {};
    this.xpress_screen_size = "screen.availWidth,screen.availHeight";
    this.Xpress_layout = "vertical_layout";
    this.xpress_screen_division = "50%,50%";
    this.override_object_styles = 0;
    this.xpress_bookmarks = {};
    this.show_contextual_menu = 1;
    this.designer = 0;
    this.xpress_theme = "magenta";
  endif
endif
.

@program $xpress_login:init_for_core
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Reset object to default values.";
"===========================================================";
if (caller_perms().wizard)
  pass();
  this.web_bgcolor = "Magenta";
  this.web_text_color = "Black";
  this.web_link_color = "Black";
  this.web_vlink_color = "Black";
  this.web_alink_color = "Silver";
  this.welcome_screen = {"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\">", "<html>", "<head>", "  <title>Welcome to enCore</title>", "  <style type=\"text/css\" media=\"screen\">", "    <!--", "    body, p { color: Black; font-family: Sans-Serif; font-size: 14px; background-color: White;  }", "    h1 { font-size: 200%; }", "    a { font-family: Sans-Serif; font-size: 14px; }", "    a:link { color: Blue }", "    a:visited { color: Purple }", "    a:hover { color: Red }", "    -->", "  </style>", "</head>", "<body>", tostr("<h1>Welcome to enCore version ", $core_version, "</h1>"), "<p>For more information please see the following sources: </p><a href=\"http://www.press.umich.edu/titles/09665.html\" target=\"_blank\">High Wired: On the Design, Use, and Theory of Educational MOOs</a><p><a href=\"http://vig.abacon.com/catalog/abbooks/0,2371,0205271146,00.html\" target=\"_blank\">MOOniversity: A Guide to Online Learning Environments</a></p><p><a href=\"ftp://ftp.utdallas.edu/pub/ah/moo/TraceBack.pdf\">TraceBack: MOO, Open Source, and the Humanities</a></p><p>Don't forget to subscribe to the enCore administrator's email list. Please go to <a href=\"http://listar.utdallas.edu/\" target=\"_blank\">http://listar.utdallas.edu</a> to subscribe.</p><p>Good luck with your new enCore MOO,<br />Jan Rune Holmevik and Cynthia Haynes</p>", "</body>", "</html>"};
endif
.

@verb $encore_web_utils:target this none this
@program $encore_web_utils:target
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"XHTML strict does not support the target attribute. This verb will use javascript to accomplish the same result as target=frame_name";
"Required variable uri, target defaults to self if no target is given";
"===========================================================";
{uri, ?target = ""} = args;
if (target)
  target = target + ".";
endif
return tostr(target, "location.href='", uri, "';");
.


@program $encore_web_utils:insert_JavaScript
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
":insert_javascript({javascript}, ?{noscript}) -- insert javascript inside a script tag, with an optional NOSCRIPT element for browsers not supporting javascript.";
"===========================================================";
{functions, ?noscript = {}} = args;
start_script = {tostr("<script type=\"text/javascript\">")};
end_script = {"</script>"};
start_noscript = {"<noscript>"};
end_noscript = {"</noscript>"};
script = $list_utils:append(start_script, functions, end_script);
if (noscript)
  script = $list_utils:append(script, start_noscript, noscript, end_noscript);
endif
return script;
.

@program $encore_web_class:make_contextual_menu
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Verb that generates a contextual menu for an object.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, ?object = this, ?call_spec = "", ?return_functions = 1} = args;
contextual_menu = buttons = functions = {};
if (user != $no_one && $object_utils:isa(object, $encore_web_object) && user.show_contextual_menu || caller == $inventory_manager)
  base_url = $encore_web_utils:baseurl();
  image_url = $xpress_client.external_baseurl + $xpress_client.icons_folder;
  "----------------------------------------------------------------";
  "Insert browser back button. Rooms and inventory manager excluded.";
  "----------------------------------------------------------------";
  if (!$object_utils:isa(this, $room) && caller != $inventory_manager)
    buttons = {@buttons, tostr("<a href=\"back\" onclick=\"javascript:history.go(-1); return false;\">", $encore_web_utils:get_icon(user, $xpress_client, "back.gif", "Go Back/View Previous"), "</a>")};
  endif
  "----------------------------------------------------------------";
  "Insert contextual help and info button. Exits and basic rooms excluded";
  "----------------------------------------------------------------";
  if ($object_utils:isa(object, $thing) || $object_utils:isoneof(object, {$classroom, $moderated_room}))
    buttons = {@buttons, tostr("<a href=\"", base_url, toint(object), "/examine_html\" onclick=\"ContextSensitiveHelp()\" target=\"", $help_browser:get_frame_name("ContextSensitiveHelp"), "\">", $encore_web_utils:get_icon(user, $help_browser, "help.gif", "About this object"), "</a>")};
    if (return_functions)
      functions = $list_utils:append(functions, $encore_web_utils:javascript_window_open($help_browser, "ContextSensitiveHelp", "", $help_browser.context_help_width, $help_browser.context_help_height));
    endif
  endif
  "----------------------------------------------------------------";
  "Insert contextual take/drop button is applicable";
  "Does not currently work in Netscape 4.X";
  "----------------------------------------------------------------";
  if ($encore_web_utils:can_handle(user, object))
    buttons = {@buttons, tostr("<a href=\"", base_url, toint(this), object in user.contents ? "/drop_html" | "/take_html", call_spec == "" ? "" | tostr("?", call_spec), "\">", object in user.contents ? $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "drop.gif"), "Drop this object") | $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "take.gif"), "Take this object"), "</a>")};
  endif
  "----------------------------------------------------------------";
  "Insert download via email option for note objects";
  "----------------------------------------------------------------";
  if ($network.active && $network.maildrop != "" && $object_utils:isa(object, $note) && !$object_utils:isa(user, $guest))
    buttons = {@buttons, tostr("<a href=\"", base_url, toint(object), "/email_html", call_spec == "" ? "" | tostr("?", call_spec), "\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "email.gif"), "Email contents to me"), "</a>")};
  endif
  "----------------------------------------------------------------";
  "Insert contextual Xpress Edit button if user has permission to edit it";
  "----------------------------------------------------------------";
  if ($encore_web_utils:permission_to_edit(user, object))
    buttons = {@buttons, tostr("<a href=\"", base_url, "Xpress_Object_Editor/view.html?", toint(object), "/\" target=\"", $Xpress_Object_Editor:get_frame_name("openXpressEdit"), "\" onclick=\"openXpressEdit();\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "xpress_edit.gif"), "Edit this object"), "</a>")};
    "Add a window function for opening Xpress Edit";
    if (return_functions)
      functions = $list_utils:append(functions, $encore_web_utils:javascript_window_open($xpress_object_editor, "openXpressEdit", ""));
    endif
  endif
  if (user == object.owner)
    "----------------------------------------------------------------";
    "Insert lock/unlock icon, Exits excluded.";
    "----------------------------------------------------------------";
    if (!$object_utils:isa(object, $exit))
      buttons = {@buttons, tostr("<a href=\"", base_url, toint(this), "/", object.key == 0 ? "lock_html" | "unlock_html", call_spec == "" ? "" | tostr("?", call_spec), "\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, object.key == 0 ? "unlocked.gif" | "locked.gif"), tostr(object.key == 0 ? "Lock" | "Unlock", " this object")), "</a>")};
    endif
  endif
  if (user == object.owner && caller == $inventory_manager && !$object_utils:isa(object, $player) && !$object_utils:isa(object, $exit))
    "----------------------------------------------------------------";
    "Insert Recycle icon for inventory manager. Exits and player objects excluded.";
    "----------------------------------------------------------------";
    buttons = {@buttons, tostr("<a href=\"", base_url, "Xpress_Object_Editor/recycle_object?", toint(object), call_spec == "" ? "" | tostr(";", call_spec), "\" onclick=\"return confirmDelete();\">", $encore_web_utils:get_icon(user, $xpress_client, tostr(image_url, "recycle.gif"), "Recycle this object"), "</a>")};
  endif
  if (buttons != {})
    functions = $encore_web_utils:insert_javascript(functions);
  endif
endif
if (return_functions)
  return {functions, buttons};
else
  return buttons;
endif
.

@program $xpress_client:quit_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
boot_player(user);
result = this:build(user, {}, "Disconnect", "top.close()");
return result;
.


@program $xpress_client:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"IMPORTANT NOTE: You must not modify this verb in such a way that the copyright notice and the link to the enCore home page and the GNU GPL license is moved or removed from the web display. Removing copyright notices consititutes a violation of the license under which this software is provided to you.";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
functions = preload = guest_function = quit_function = sound = {};
action = "self.focus();preLoadImages();";
base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_client/");
external_baseurl = this.external_baseurl + this.themes_folder + user.xpress_theme + "/";
"-----------------------------------------------------------";
"Add guest preference window that opens automatically when guests log in";
"Version 4 note: Removed this capability because it won't work with clients that use pop-up blocking.";
"-----------------------------------------------------------";
"if ($object_utils:isa(user, $guest) && $real_guest_names)";
  "action = action + \"guestPreferences();";
"endif";
"-----------------------------------------------------------";
"Add possible login alerts";
"-----------------------------------------------------------";
{alerts, alert_func} = this:Xpress_Confunc(user);
action = action + alert_func + ";";
quit_function = {"function close_session(){ ", tostr("     if (confirm('Thank you for visiting ", $network.MOO_name, ". Welcome back soon. Please click OK to disconnect from the MOO, or cancel to continue.')) {"), tostr("          ", $encore_web_utils:target(tostr(base_url, "quit.html"), tostr("parent.", $xpress_client.java_frame)), ";"), "          return true;", "     }", "     return false;", "}"};
swapImage = {"function swapImage(name,image) {", "     document.images[name].src = image;", "}"};
preload = {"function preLoadImages() {"};
{menu, functions, preload, base_url} = user:_web_menu(user, preload);
quit = {tostr("<img src=\"", external_baseurl, "quit1.jpg\"id=\"quit\" alt=\"Log Out\" title=\"Log Out\" onclick=\"swapImage('quit','", external_baseurl, "quit1.jpg'); return close_session()\" onmouseover=\"swapImage('quit','", external_baseurl, "quit2.jpg')\" onmouseout=\"swapImage('quit','", external_baseurl, "quit1.jpg')\" />")};
preload = {@preload, tostr("   quit2 = new Image(); quit2.src = \"", external_baseurl, "quit2.jpg\";")};
preload = {@preload, "}"};
"-----------------------------------------------------------";
"Add mail notification sound";
"-----------------------------------------------------------";
if (user.sound_volume && user.mail_notify_sound)
  sound = this:check_moo_mail(user);
endif
menu = $encore_web_utils:align($list_utils:append(menu, quit, sound), "center");
script = $list_utils:append(preload, guest_function, functions, quit_function, swapImage, alerts);
script = $encore_web_utils:insert_JavaScript(script);
body = $list_utils:append(script, menu);
result = this:build(user, body, "Xpress Toolbar", action);
return result;
.


@program $guest:_web_menu
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates a dynamic web menu line based on which player class the user belongs to";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, preload} = args;
options = options_window = {};
base_url = tostr("http://", $network.site, ":", $network.webport, "/");
external_baseurl = $xpress_client.external_baseurl + $xpress_client.themes_folder + this.xpress_theme + "/";
"Assemble menu line";
about = {tostr("<img src=\"", external_baseurl, "about1.jpg\" id=\"about\" alt=\"Information About the MOO\" title=\"Information About the MOO\" onclick=\"openAboutWindow(); swapImage('about','", external_baseurl, "about1.jpg')\" onmouseover=\"swapImage('about','", external_baseurl, "about2.jpg')\" onmouseout=\"swapImage('about','", external_baseurl, "about1.jpg')\" />")};
preload = {@preload, tostr("   about2 = new Image(); about2.src = \"", external_baseurl, "about2.jpg\";")};
help = {tostr("<img src=\"", external_baseurl, "help1.jpg\" id=\"help\" alt=\"Browse the MOO's Help System\" title=\"Browse the MOO's Help System\" onclick=\"openHelpBrowser(); swapImage('help','", external_baseurl, "help1.jpg')\" onmouseover=\"swapImage('help','", external_baseurl, "help2.jpg')\" onmouseout=\"swapImage('help','", external_baseurl, "help1.jpg')\" />")};
preload = {@preload, tostr("   help2 = new Image(); help2.src = \"", external_baseurl, "help2.jpg\";")};
look = {tostr("<img src=\"", external_baseurl, "look1.jpg\" id=\"look\" alt=\"Focus On My Location\" title=\"Focus On My Location\" onclick=\"swapImage('look','", external_baseurl, "look1.jpg'); ", $encore_web_utils:target(tostr(base_url, "Xpress_client/display_user_location"), tostr("parent.", $xpress_client.web_frame)),"\" onmouseover=\"swapImage('look','", external_baseurl, "look2.jpg')\" onmouseout=\"swapImage('look','", external_baseurl, "look1.jpg')\" />")};
preload = {@preload, tostr("   look2 = new Image(); look2.src = \"", external_baseurl, "look2.jpg\";")};
who = {tostr("<img src=\"", external_baseurl, "who1.jpg\" id=\"who\" alt=\"See Who Is Online\" title=\"See Who Is Online\" onclick=\"openWhoBrowser(); swapImage('who','", external_baseurl, "who1.jpg')\" onmouseover=\"swapImage('who','", external_baseurl, "who2.jpg')\" onmouseout=\"swapImage('who','", external_baseurl, "who1.jpg')\" />")};
preload = {@preload, tostr("   who2 = new Image(); who2.src = \"", external_baseurl, "who2.jpg\";")};
if ($real_guest_names)
  options = {tostr("<img src=\"", external_baseurl, "options1.jpg\" id=\"options\" alt=\"Change My Preferences\" title=\"Change My Preferences\" onclick=\"guestPreferences(); swapImage('options','", external_baseurl, "options1.jpg')\" onmouseover=\"swapImage('options','", external_baseurl, "options2.jpg')\" onmouseout=\"swapImage('options','", external_baseurl, "options1.jpg')\" />")};
  preload = {@preload, tostr("   options2 = new Image(); options2.src = \"", external_baseurl, "options2.jpg\";")};
  options_window = $encore_web_utils:javascript_window_open($MOO_info, "guestPreferences", tostr(base_url, "xpress_client/guest_preferences.html"));
endif
guide = {tostr("<img src=\"", external_baseurl, "guide1.jpg\" id=\"guide\" alt=\"Read an Introduction to MOOing\" title=\"Read an Introduction to MOOing\" onclick=\"openGuide(); swapImage('guide','", external_baseurl, "guide1.jpg')\" onmouseover=\"swapImage('guide','", external_baseurl, "guide2.jpg')\" onmouseout=\"swapImage('guide','", external_baseurl, "guide1.jpg')\" />")};
preload = {@preload, tostr("   guide2 = new Image(); guide2.src = \"", external_baseurl, "guide2.jpg\";")};
request = {tostr("<img src=\"", external_baseurl, "request1.jpg\" id=\"request\" alt=\"Apply for a Character\" title=\"Apply for a Character\" onclick=\"openCharacterApplication(); swapImage('request','", external_baseurl, "request1.jpg')\" onmouseover=\"swapImage('request','", external_baseurl, "request2.jpg')\" onmouseout=\"swapImage('request','", external_baseurl, "request1.jpg')\" />")};
preload = {@preload, tostr("   request2 = new Image(); request2.src = \"", external_baseurl, "request2.jpg\";")};
menu = $list_utils:append(about, help, look, who, options, guide, request);
"Assemble JavaScript functions";
about_window = $encore_web_utils:javascript_window_open($MOO_info, "openAboutWindow", tostr(base_url, "MOO_info/about.html"));
help_browser = $encore_web_utils:javascript_window_open($help_browser, "openHelpBrowser", tostr(base_url, "help_browser/main.html"));
who_browser = $encore_web_utils:javascript_window_open($who_browser, "openWhoBrowser", tostr(base_url, "who_browser/main.html"));
guide_window = $encore_web_utils:javascript_window_open($MOO_info, "openGuide", tostr(base_url, "xpress_misc/guide.html"));
character_application = $encore_web_utils:javascript_window_open($MOO_info, "openCharacterApplication", tostr(base_url, "xpress_misc/character_application.html"));
functions = $list_utils:append(about_window, help_browser, who_browser, options_window, guide_window, character_application);
return {menu, functions, preload, base_url};
.

@program $player:_web_menu
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates a dynamic web menu line based on which player class the user belongs to";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, preload} = args;
base_url = $encore_web_utils:baseurl();
external_baseurl = $xpress_client.external_baseurl + $xpress_client.themes_folder + user.xpress_theme + "/";
"Assemble menu line";
about = {tostr("<img src=\"", external_baseurl, "about1.jpg\" id=\"about\" alt=\"Information about the MOO\" title=\"Information about the MOO\" onclick=\"openAboutWindow(); swapImage('about','", external_baseurl, "about1.jpg')\" onmouseover=\"swapImage('about','", external_baseurl, "about2.jpg')\" onmouseout=\"swapImage('about','", external_baseurl, "about1.jpg')\" />")};
preload = {@preload, tostr("   about2 = new Image(); about2.src = \"", external_baseurl, "about2.jpg\";")};
help = {tostr("<img src=\"", external_baseurl, "help1.jpg\" id=\"help\" alt=\"Browse the MOO's Help System\" title=\"Browse the MOO's Help System\" onclick=\"openHelpBrowser(); ; swapImage('help','", external_baseurl, "help1.jpg')\" onmouseover=\"swapImage('help','", external_baseurl, "help2.jpg')\" onmouseout=\"swapImage('help','", external_baseurl, "help1.jpg')\" />")};
preload = {@preload, tostr("   help2 = new Image(); help2.src = \"", external_baseurl, "help2.jpg\";")};
look = {tostr("<img src=\"", external_baseurl, "look1.jpg\" id=\"look\" alt=\"Focus On My Location\" title=\"Focus On My Location\" onclick=\"swapImage('look','", external_baseurl, "look1.jpg'); ",$encore_web_utils:target(tostr(base_url, "Xpress_client/display_user_location"), tostr("parent.", $xpress_client.web_frame)), "\" onmouseover=\"swapImage('look','", external_baseurl, "look2.jpg')\" onmouseout=\"swapImage('look','", external_baseurl, "look1.jpg')\" />")};
preload = {@preload, tostr("   look2 = new Image(); look2.src = \"", external_baseurl, "look2.jpg\";")};
who = {tostr("<img src=\"", external_baseurl, "who1.jpg\" id=\"who\" alt=\"See Who Is Online\" title=\"See Who Is Online\" onclick=\"openWhoBrowser(); swapImage('who','", external_baseurl, "who1.jpg')\" onmouseover=\"swapImage('who','", external_baseurl, "who2.jpg')\" onmouseout=\"swapImage('who','", external_baseurl, "who1.jpg')\" />")};
preload = {@preload, tostr("   who2 = new Image(); who2.src = \"", external_baseurl, "who2.jpg\";")};
navigator = {tostr("<img src=\"", external_baseurl, "xpress1.jpg\" id=\"navigator\" alt=\"Xpress Links to MOO Resources\" title=\"Xpress Links to MOO Resources\" onclick=\"openNavigator(); swapImage('navigator','", external_baseurl, "xpress1.jpg')\" onmouseover=\"swapImage('navigator','", external_baseurl, "xpress2.jpg')\" onmouseout=\"swapImage('navigator','", external_baseurl, "xpress1.jpg')\" />")};
preload = {@preload, tostr("   xpress2 = new Image(); xpress2.src = \"", external_baseurl, "xpress2.jpg\";")};
inventory = {tostr("<img src=\"", external_baseurl, "inventory1.jpg\" id=\"inventory\" alt=\"View My Inventory\" title=\"View My Inventory\" onclick=\"openInventory();swapImage('inventory','", external_baseurl, "inventory1.jpg')\" onmouseover=\"swapImage('inventory','", external_baseurl, "inventory2.jpg')\" onmouseout=\"swapImage('inventory','", external_baseurl, "inventory1.jpg')\" />")};
preload = {@preload, tostr("   inventory2 = new Image(); inventory2.src = \"", external_baseurl, "inventory2.jpg\";")};
options = {tostr("<img src=\"", external_baseurl, "options1.jpg\" id=\"options\" alt=\"Change My Preferences\" title=\"Change My Preferences\" onclick=\"openOptions(); swapImage('options','", external_baseurl, "options1.jpg')\" onmouseover=\"swapImage('options','", external_baseurl, "options2.jpg')\" onmouseout=\"swapImage('options','", external_baseurl, "options1.jpg')\" />")};
preload = {@preload, tostr("   options2 = new Image(); options2.src = \"", external_baseurl, "options2.jpg\";")};
search = {tostr("<img src=\"", external_baseurl, "search1.jpg\" id=\"search\" alt=\"Search the MOO Database\" title=\"Search the MOO Database\" onclick=\"openSearchEngine(); swapImage('search','", external_baseurl, "search1.jpg')\" onmouseover=\"swapImage('search','", external_baseurl, "search2.jpg')\" onmouseout=\"swapImage('search','", external_baseurl, "search1.jpg')\" />")};
preload = {@preload, tostr("   search2 = new Image(); search2.src = \"", external_baseurl, "search2.jpg\";")};
mail = {tostr("<img src=\"", external_baseurl, "mail1.jpg\" id=\"mail\" alt=\"Send and Receive MOO Mail\" title=\"Send and Receive MOO Mail\" onclick=\"openMailBrowser(); swapImage('mail','", external_baseurl, "mail1.jpg')\" onmouseover=\"swapImage('mail','", external_baseurl, "mail2.jpg')\" onmouseout=\"swapImage('mail','", external_baseurl, "mail1.jpg')\" />")};
preload = {@preload, tostr("   mail2 = new Image(); mail2.src = \"", external_baseurl, "mail2.jpg\";")};
menu = $list_utils:append(about, help, navigator, look, who, search, inventory, options, mail);
"Assemble JavaScript functions";
about_window = $encore_web_utils:javascript_window_open($MOO_info, "openAboutWindow", tostr(base_url, "MOO_info/about.html"));
help_browser = $encore_web_utils:javascript_window_open($help_browser, "openHelpBrowser", tostr(base_url, "help_browser/main.html"));
who_browser = $encore_web_utils:javascript_window_open($who_browser, "openWhoBrowser", tostr(base_url, "who_browser/main.html"));
xpress_navigator = $encore_web_utils:javascript_window_open($xpress_navigator, "openNavigator", tostr(base_url, "Xpress_navigator/main_html"));
inventory_window = $encore_web_utils:javascript_window_open($inventory_manager, "openInventory", tostr(base_url, "Inventory_Manager/view_inventory"));
options_window = $encore_web_utils:javascript_window_open($xpress_object_editor, "openOptions", tostr(base_url, tostr("Xpress_Object_editor/view.html")));
search_window = $encore_web_utils:javascript_window_open($search_engine, "openSearchEngine", tostr(base_url, "search_engine/search.html"));
mail_browser = $encore_web_utils:javascript_window_open($Xpress_MOO_mailer, "openMailBrowser", tostr(base_url, "Xpress_MOO_mailer/main.html"));
functions = $list_utils:append(about_window, help_browser, who_browser, xpress_navigator, inventory_window, options_window, search_window, mail_browser);
return {menu, functions, preload, base_url};
.


@program $builder:_web_menu
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates a dynamic web menu line based on which player class the user belongs to";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{menu, functions, preload, base_url} = pass(@args);
external_baseurl = $xpress_client.external_baseurl + $xpress_client.themes_folder + this.xpress_theme + "/";
objects = {tostr("<img src=\"", external_baseurl, "objects1.jpg\" id=\"objects\" alt=\"Create and Edit Objects\" title=\"Create and Edit Objects\" onclick=\"openObjectEditor(); swapImage('objects','", external_baseurl, "objects1.jpg')\" onmouseover=\"swapImage('objects','", external_baseurl, "objects2.jpg')\" onmouseout=\"swapImage('objects','", external_baseurl, "objects1.jpg')\" />")};
preload = {@preload, tostr("   objects2 = new Image(); objects2.src = \"", external_baseurl, "edit2.jpg\";")};
object_editor = $encore_web_utils:javascript_window_open($Xpress_object_editor, "openObjectEditor", tostr(base_url, "Xpress_object_editor/main.html"));
menu = $list_utils:append(menu, objects);
functions = $list_utils:append(functions, object_editor);
return {menu, functions, preload, base_url};
.

@program $prog:_web_menu
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates a dynamic web menu line based on which player class the user belongs to";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{menu, functions, preload, base_url} = pass(@args);
if (this.programmer)
  external_baseurl = $xpress_client.external_baseurl + $xpress_client.themes_folder + 
this.xpress_theme + "/";
  program = {tostr("<img src=\"", external_baseurl, "program1.jpg\" id=\"program\" alt=\"Edit Verbs and Properties\" title=\"Edit Verbs and Properties\" onclick=\"openProgramEditor(); swapImage('program','", external_baseurl, "program1.jpg')\" onmouseover=\"swapImage('program','", external_baseurl, "program2.jpg')\" onmouseout=\"swapImage('program','", external_baseurl, "program1.jpg')\" />")};

  preload = {@preload, tostr("   program2 = new Image(); program2.src = \"", external_baseurl, "program2.jpg\";")};

  Window = $encore_web_utils:javascript_window_open($Xpress_Program_Editor, "openProgramEditor", tostr(base_url, "Xpress_Program_Editor/main.html"));
  menu = $list_utils:append(menu, program);
  functions = $list_utils:append(functions, Window);
endif
return {menu, functions, preload, base_url};
.

@program $wiz:_web_menu
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates a dynamic web menu line based on which player class the user belongs to";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{menu, functions, preload, base_url} = pass(@args);
external_baseurl = $xpress_client.external_baseurl + $xpress_client.themes_folder + 
this.xpress_theme + "/";
administration = {tostr("<img src=\"", external_baseurl, "wizard1.jpg\" id=\"wizard\" alt=\"MOO Administration\" title=\"MOO Administration\" onclick=\"openAdministrationModule(); swapImage('wizard','", external_baseurl, "wizard1.jpg')\" onmouseover=\"swapImage('wizard','", external_baseurl, "wizard2.jpg')\" onmouseout=\"swapImage('wizard','", external_baseurl, "wizard1.jpg')\" />")};
preload = {@preload, tostr("   wizard2 = new Image(); wizard2.src = \"", external_baseurl, "wizard2.jpg\";")};
openAdministrationModule = $encore_web_utils:javascript_window_open($administration_module, "openAdministrationModule", tostr(base_url, "administration_module/main.html"));
menu = $list_utils:append(menu, administration);
functions = $list_utils:append(functions, openAdministrationModule);
return {menu, functions, preload, base_url};
.

@program $encore_web_utils:make_sound
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Create a sound embed tag.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, audio_file, ?name = "sound"} = args;
sound = {};
if (user.sound_volume)
  if (!index(audio_file, "http://"))
    "If complete url has not been specified, use sound file from encore";
    audio_file = $xpress_client.external_baseurl + $xpress_client.sounds_folder + audio_file;
  endif
  sound = {tostr("<embed src=\"", audio_file, "\" width=\"1\" height=\"1\" name=\"", name, "\" hidden=\"true\" autostart=\"true\" volume=\"", user.sound_volume, "\" loop=\"false\" mastersound=\"mastersound\" />")};
endif
return sound;
.


@program $encore_web_utils:form
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates HTML code for a form based on parameters passed by the calling verb. The first argument must be the form data, and should be of type LIST, the other four arguments, form name, action, Javascript onSubmit call and target, are optional, and should be of type STR.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{data, ?name = "Untitled_Form", ?action = "/", ?onsubmit = "", ?target = "", ?method = "post"} = args;
form = tostr("<form id=\"", name, "\" action=\"http://", $network.site, ":", $network.webport, action, "\" ");
if (onSubmit)
  form = tostr(form, " onsubmit=\"", onsubmit, "\"");
endif
if (target)
  form = tostr(form, " target=\"", target, "\"");
endif
if ("post" == method)
  "Internet Explorer 4.x will not send CRLF after FORM-posts with the default enctype (application/x-www-form-urlencoded)";
  enctype = "multipart/form-data";
  form = form + " method=\"" + method + "\" enctype=\"" + enctype + "\"";
endif
form = form + ">";
result = $list_utils:append({form}, data, {"</form>"});
return result;
.

@program $encore_web_object:examine_html
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Display obvious verbs via Xpress.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
body = vrbs = help = {};
title = $encore_web_utils:get_subtitle(user, this, tostr("Information about ", this.name));
"List obvious verbs on object";
if (vrbs = this:examine_verbs(user))
  vrbs = $list_utils:append($encore_web_utils:p("Here are some of the things you can do with this object. Type the obvious verbs shown here into the Xpress talk area. The word \"anything\" should be substituted for a valid object name."), $encore_web_utils:preformat(vrbs));
endif
if ($object_utils:has_property(this, "help_msg"))
  "Add help on object";
  help = $list_utils:append(body, $encore_web_utils:get_text_linebreak(this.help_msg));
endif
body = $list_utils:append(title, vrbs, help);
result = this:build(user, body);
return result;
.



@program $encore_web_utils:insert_context_sensitive_help
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Inserts a context sensitive help button or icon, and creates a javascript window open function for the context sensitive help text";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, help_property, ?width = $help_browser.context_help_width, ?height = $help_browser.context_help_height} = args;
external_baseurl = $xpress_client.external_baseurl + $xpress_client.icons_folder;
help = {tostr("<a href=\"http://", $network.site, ":", $network.webport, "/help_browser/view_html?", toint(object), ";", help_property, "\" onclick=\"ContextSensitiveHelp()\" target=\"", $help_browser:get_frame_name("ContextSensitiveHelp"), "\">", $encore_web_utils:get_icon(user, $help_browser, "help.gif", "Help and information"), "</a>")};
context_help_function = $encore_web_utils:javascript_window_open($help_browser, "ContextSensitiveHelp", "", width, height);
return {help, context_help_function};
.

@program $help_browser:main_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main help browser using four frames";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
base_url = tostr($encore_web_utils:baseurl(), "/help_browser/");
default_help_db = toint($encore_help);
default_help_topic = "Introduction";
help_menu_frame = tostr(base_url, "menu_html");
help_db_frame = tostr(base_url, "help_databases_html");
help_contents_frame = tostr(base_url, "help_contents_html?", default_help_db);
help_view_frame = tostr(base_url, "view_html?", default_help_db, ";", default_help_topic);
html = {             "<frameset cols=\"50%\">"};
html = {@html,       "   <noframes>"};
html = {@html,       "      <body><h3>Sorry you need a browser that supports frames to use this system</h3></body>"};
html = {@html,       "   </noframes>"};
html = {@html,       "   <frameset cols=\"50%\">"};
html = {@html,       "      <frameset rows=\"75,100%\">"};
html = {@html, tostr("         <frame src=\"", help_menu_frame, "\" id=\"help_menu\" name=\"help_menu\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "         <frameset cols=\"30%,70%\">"};
html = {@html, tostr("            <frame src=\"", help_db_frame, "\" id=\"help_db\" name=\"help_db\" noresize=\"noresize\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "            <frameset rows=\"40%,60%\">"};
html = {@html, tostr("               <frame src=\"", help_contents_frame, "\" id=\"help_contents\" name=\"help_contents\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html, tostr("               <frame src=\"", help_view_frame, "\" id=\"help_view\" name=\"help_view\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "            </frameset>"};
html = {@html,       "         </frameset>"};
html = {@html,       "      </frameset>"};
html = {@html,       "   </frameset>"};
html = {@html,       "</frameset>"};
result = this:build(user, html, "MOO Help System", "", "", "", "", this.doctype_frameset);
return result;
.

@program $help_browser:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
base_url = "/help_browser/menu.html";
title = $encore_web_utils:get_title(user, this, "Help Browser");
{help_button, help_window_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Help_Browser");
help_window_function = $encore_web_utils:insert_javascript(help_window_function);
search_form = $list_utils:append(help_button, $encore_web_utils:input("search_string", "", "20"), $encore_web_utils:input("Submit", "Search", "", "submit"));
search_form = $encore_web_utils:form($list_utils:append(title, search_form, $encore_web_utils:close("parent")), "search", base_url);
if ({{}, {}} != args[2])
  "User has submitted a search request";
  request = args[2][2][1];
  relevant_help_dbs = $code_utils:help_db_list(user);
  found = 0;
  for db in (relevant_help_dbs)
    if ($object_utils:has_property(db, request))
      help_text = this:view_html(user, {{"", ""}, {toint(db), request}});
      return help_text;
      break;
    endif
  endfor
  if (!found)
    body = $encore_web_utils:h(tostr("Sorry, ", request, " was not found"), "2");
    result = this:build(user, body, "Help System Window");
    return result;
  endif
endif
body = $list_utils:append(help_window_function, search_form);
result = this:build(user, body, "Help System", $encore_web_utils:focus_field("search_string"), "help_view");
return result;
.

@program $help_browser:help_databases_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Compile list of available help databases";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
links = {};
base_url = tostr($encore_web_utils:baseurl(), "/help_browser/help_contents.html");
relevant_help_dbs = $code_utils:help_db_list(user);
relevant_help_dbs = setremove(relevant_help_dbs, $help);
title = $encore_web_utils:get_subtitle(user, this, "Help Topics");
for help_db in (relevant_help_dbs)
  links = {@links, tostr($encore_web_utils:a(tostr(base_url, "?", toint(help_db)), help_db.name, "", "", $encore_web_utils:get_icon(user, this)))};
endfor
body = $list_utils:append(title, $encore_web_utils:br(links));
result = this:build(user, body, "Help Topics", "", "help_contents");
return result;
.

@program $help_browser:help_contents_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Compile a list of help topics on a given help database";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user, arguments} = args;
body = links = {};
if ({{}, {}} == arguments)
  "No arguments were passed";
else
  help_db = toobj(arguments[2][1]);
  relevant_help_dbs = $code_utils:help_db_list(user);
  if (help_db in relevant_help_dbs)
    "List help topics in selected database";
    base_url = tostr("http://", $network.site, ":", $network.webport, "/help_browser/view.html");
    help_items = properties(help_db);
    help_items = $list_utils:sort(help_items);
    title = $encore_web_utils:get_subtitle(user, this, tostr(help_db.name));
    for item in (help_items)
      try
        if (help_db.(item)[1] != "*forward*")
          links = {@links, $encore_web_utils:a(tostr(base_url, "?", toint(help_db), ";", $string_utils:trim(item)), item)};
        endif
      except error (ANY)
      endtry
    endfor
    body = $list_utils:append(title, $encore_web_utils:br(links));
  else
    "User does not have permission to read requested help database";
    return "403_Forbidden";
  endif
endif
result = this:build(user, body, "Help Items", "", "help_view");
return result;
.

@program $help_browser:view_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
body = {};
arguments = args[2];
if ({{}, {}} == arguments)
  "No arguments were passed";
  body = {};
else
  help_db = toobj(arguments[2][1]);
  help_item = arguments[2][2];
  help_item = $string_utils:trim($string_utils:substitute(help_item, {{"#", ""}}));
  relevant_help_dbs = $code_utils:help_db_list(user);
  if (help_db in relevant_help_dbs || $object_utils:has_property(help_db, "help_msg"))
    "User has requested a spesific help item";
    if ($object_utils:isa(help_db, $generic_help))
      title_str = $string_utils:substitute(help_item, {{"_", " "}});
    else
      title_str = help_db.name;
    endif
    title = $encore_web_utils:get_subtitle(user, this, title_str);
    try
      help_text = $encore_web_utils:get_text_linebreaks(help_db.(help_item));
    except error (ANY)
      help_text = {tostr("Sorry, Xpress help not available. Type 'help ", help_item, "' in the talk area for help on this item.")};
    endtry
    body = $list_utils:append(title, help_text);
  else
    "User does not have permission to read requested help database";
    return "403_Forbidden";
  endif
endif
result = this:build(user, body, "enCore Help");
return result;
.

@program $xpress_navigator:main_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main Xpress navigator screen";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
base_url = tostr($encore_web_utils:baseurl(), "/Xpress_Navigator/");
menu_frame = tostr(base_url, "menu.html");
work_frame = tostr(base_url, "bookmarks.html");
html = {             "<frameset cols=\"50%\">"};
html = {@html,       "   <noframes>"};
html = {@html,       "      <body><h3>sorry you need a browser that supports frames to use this system</h3></body>"};
html = {@html,       "   </noframes>"};
html = {@html,       "   <frameset rows=\"75,100%\">"};
html = {@html, tostr("      <frame src=\"", menu_frame, "\" id=\"menu\" name=\"menu\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html, tostr("      <frame src=\"", work_frame, "\" id=\"work\" name=\"work\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "   </frameset>"};
html = {@html,       "</frameset>"};
result = this:build(user, html, "Xpress Navigator", "", "", "", "", this.doctype_frameset);
return result;
.

@program $xpress_navigator:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
base_url = $encore_web_utils:baseurl();
"Assemble menu line";
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "xpress_navigator");
buttons = menu = body = {};
functions = $encore_web_utils:insert_javascript(help_function);
buttons = $list_utils:append(buttons, $encore_web_utils:input("Bookmarks", "Bookmarks", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "Xpress_Navigator/bookmarks.html'\"")));
if (!$object_utils:isa(user, $guest))
  buttons = $list_utils:append(buttons, $encore_web_utils:input("Notebook", "Notebook", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "Xpress_Navigator/Notebook'\"")));
  buttons = $list_utils:append(buttons, $encore_web_utils:input("Log", "Log", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "Xpress_Navigator/MOO-Log'\"")));
  buttons = $list_utils:append(buttons, $encore_web_utils:input("VASE", "VASE", "", "button", tostr("onclick=\"window.open('", base_url, toint($assignment_server), "', '", $string_utils:substitute($network.MOO_name, {{" ", "_"}}), "_OpenVASE', 'width=800,height=600,scrollbars=yes,menubar=yes,toolbar=yes,copyhistory=yes,resizable=yes,location=yes');parent.close()\"")));
endif
title = $encore_web_utils:get_title(user, this, "Xpress Navigator");
menu = $list_utils:append(title, help_button, buttons);
menu = $list_utils:append(menu, $encore_web_utils:close("parent"));
body = $list_utils:append(functions, menu);
result = this:build(user, body, "Xpress Navigator Menu", "self.focus();");
return result;
.

@program $xpress_navigator:bookmarks_html
"===========================================================";
"Copyright (C) 1998-2004, Jan Rune Holmevik";
"Display a list of resource categories and bookmarked links";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
result = body = confirmDelete = bookmark_list = {};
alert = "";
base_url = $encore_web_utils:baseurl();
external_baseurl = $xpress_client.external_baseurl + $xpress_client.icons_folder;
title = $encore_web_utils:get_subtitle(user, this, "Bookmarks");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Bookmarks");
confirmDelete = {"function confirmDelete() {", "   if (confirm('Are you sure you want to delete this bookmark?')) {", "      return true;", "   }", "   return false;", "}"};
functions = $list_utils:append(help_function, confirmDelete);
functions = $encore_web_utils:insert_javascript(functions);
button = bookmarks = body = {};
if ({{}, {}} == data)
  requested = 0;
else
  requested = data[2][1];
  alert = data[1][1];
endif
"-------------------------------------------------------------";
" Manage personal bookmarks";
"-------------------------------------------------------------";
button = $encore_web_utils:p($encore_web_utils:input("add_bookmark", "Add Bookmark", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "Xpress_Navigator/add_bookmark'\"")));
"Assemble categories and bookmarks";
try;
  "-------------------------------------------------------------";
  " Compile personal bookmarks";
  "-------------------------------------------------------------";
  bookmarks = {{tostr(user.name, "'s Personal Bookmarks"), {}}};
  bookmarks[1][2] = user.xpress_bookmarks;
  bookmarks = $list_utils:append(bookmarks, this.bookmarks);
  "-------------------------------------------------------------";
  " Compile system bookmarks";
  "-------------------------------------------------------------";
  for n in [1..length(bookmarks)]
    if (n == toint(requested))
      body = {@body, tostr($encore_web_utils:a(tostr(base_url, "Xpress_navigator/bookmarks.html?", tostr(n)), bookmarks[n][1], "", "", $encore_web_utils:img(tostr(external_baseurl, "list_view2.gif"))), $encore_web_utils:br())};
      for bookmark in (bookmarks[n][2])
        line = tostr($encore_web_utils:a(tostr(base_url, toint(bookmark)), bookmark.name, "web_frame", "", $encore_web_utils:img(tostr(external_baseurl, "bookmark.gif"))));
        if (requested == "1")
          "------------------------------------------------";
          " Remove bookmark option";
          "------------------------------------------------";
          line = line + tostr($encore_web_utils:a(tostr(base_url, "Xpress_navigator/remove_bookmark?", toint(bookmark)), " [Remove]", "", "onclick=\"return confirmDelete()\""));
        endif
        bookmark_list = {@bookmark_list, line};
      endfor
      body = $list_utils:append(body, $encore_web_utils:ul(bookmark_list));
    else
      body = {@body, tostr($encore_web_utils:a(tostr(base_url, "Xpress_navigator/bookmarks.html?", tostr(n)), bookmarks[n][1], "", "", $encore_web_utils:img(tostr(external_baseurl, "list_view1.gif"))), $encore_web_utils:br())};
    endif
  endfor
except error (ANY)
  alert = "There is a problem with your Xpress Bookmarks. Please notify a MOO administrator";
endtry
body = $list_utils:append(functions, title, help_button, button, body);
result = this:build(user, body, "Xpress Navigator", $encore_web_utils:make_alert(alert));
return result;
.

@program $xpress_navigator:Notebook
"===========================================================";
"Copyright (C) 1998-2004, Jan Rune Holmevik";
"Display the user's personal notebook";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
msg = status = "";
notebook = {};
if (data != {{}, {}})
  "=== User has specified an action ===";
  action = data[2][1];
  notebook_contents = data[2][2];
  if (action == "saveMOO")
    "=== Save Notebook in MOO ===";
    if (typeof(notebook_contents) == STR)
      notebook_contents = {notebook_contents};
    endif
    user.Xpress_Notebook = notebook_contents;
    status = "Your Notebook has been saved";
  elseif (action == "email")
    "=== Email data to user ===";
    user.Xpress_Notebook = notebook_contents;
    status = this:save_via_email(user, "Your MOO Notebook", notebook_contents);
  elseif (action == "erase")
    user.Xpress_Notebook = {};
    status = "Your Notebook has been erased";
  else
    status = "Please choose action";
  endif
  msg = $encore_web_utils:alert(status);
endif
"=== Build Notebook application web page ===";
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Notebook");
check = {"function check(){", "     if (document.getElementById('action').selectedIndex == 3) { ", "         if (confirm('Do you really want to erase your notebook?')) {", "               document.getElementById('notebook_form').submit();", "               return true", "         }", "     return false;", "     }", "     document.getElementById('notebook_form').submit()", "     return true; ", "}"};
functions = $list_utils:append(help_function, check);
functions = $encore_web_utils:insert_javascript(functions);
title = $encore_web_utils:get_subtitle(user, this, tostr(user.name, "'s Notebook"));
"Compile menu";
menu = $encore_web_utils:option("Choose action", "", 1);
menu = $list_utils:append(menu, $encore_web_utils:option("Save notebook in MOO", "saveMOO"));
menu = $list_utils:append(menu, $encore_web_utils:option("Save notebook to email", "email"));
if (user.Xpress_Notebook != {})
  menu = $list_utils:append(menu, $encore_web_utils:option("Erase notebook", "erase"));
endif
menu = $encore_web_utils:select(menu, "action", "return check()");
menu = $list_utils:append(help_button, menu);
notebook = $encore_web_utils:textarea(user.Xpress_notebook, "Notebook", 20, 65);
form = $list_utils:append($encore_web_utils:p(menu), $encore_web_utils:p(notebook));
form = $encore_web_utils:form(form, "notebook_form", "/Xpress_Navigator/Notebook/");
body = $list_utils:append(functions, title, form);
result = this:build(user, body, "Xpress Notebook", msg);
return result;
.

@program $xpress_navigator:MOO-Log
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Display the user's personal MOO Log";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
msg = status = "";
log = {};
if (data != {{}, {}})
  "=== User has specified an action ===";
  action = data[2][1];
  log_contents = data[2][2];
  if (action == "stop")
    "=== Stop logging ===";
    status = user:stop_log(user);
  elseif (action == "start")
    "=== Start logging ===";
    status = user:start_log(user);
  elseif (action == "email")
    "=== Email data to user ===";
    status = this:save_via_email(user, "Your MOO Log", log_contents);
  elseif (action == "erase")
    user.recording = 0;
    user.Xpress_Log = {};
    status = "Your log has been erased";
  else
    status = "Please choose action";
  endif
  msg = $encore_web_utils:alert(status);
endif
"=== Build Log application web page ===";
title = $encore_web_utils:get_subtitle(user, this, tostr(user.name, "'s Log ", user.recording == 1 ? "(on)" | "(off)"));
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Logging");
check = {"function check(){", "     if (document.getElementById('action').selectedIndex == 3) { ", "         if (confirm('Do you really want to erase your log?')) {", "               document.getElementById('log').submit();", "               return true", "         }", "     return false;", "     }", "     document.getElementById('log').submit()", "     return true; ", "}"};
functions = $list_utils:append(help_function, check);
functions = $encore_web_utils:insert_javascript(functions);
menu = $encore_web_utils:option("Choose action", "text/html", 1);
if (user.recording)
  menu = $list_utils:append(menu, $encore_web_utils:option("Stop recording", "stop"));
else
  menu = $list_utils:append(menu, $encore_web_utils:option("Start recording", "start"));
  if (user.Xpress_Log != {})
    menu = $list_utils:append(menu, $encore_web_utils:option("Save to email", "email"));
    menu = $list_utils:append(menu, $encore_web_utils:option("Erase log", "erase"));
  endif
endif
menu = $encore_web_utils:select(menu, "action", "return check()");
menu = $list_utils:append(help_button, menu);
log = $encore_web_utils:textarea(user.xpress_log, "logcontents", 20, 65);
form = $list_utils:append($encore_web_utils:p(menu), $encore_web_utils:p(log));
form = $encore_web_utils:form(form, "log", "/Xpress_Navigator/MOO-Log/");
body = $list_utils:append(functions, title, form);
result = this:build(user, body, "Xpress Log", msg);
return result;
.

@verb $encore_web_utils:option this none this
@program $encore_web_utils:option
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create an option  element.";
"===========================================================";
{option, ?value = "", ?selected = 0} = args;
if (selected)
  option = {tostr("   <option value=\"", value, "\" selected=\"selected\">", option, "</option>")};
else
  option = {tostr("   <option value=\"", value, "\">", option, "</option>")};
endif
return option;
.


@rename $encore_web_utils:italics to i*talics
@program $encore_web_utils:italics
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik";
"===========================================================";
{content, ?class = ""} = args;
if (typeof(content) == LIST)
  content = {tostr("<i", class == "" ? ">" | tostr(" class=\"", class, "\">")), @content, "</i>"};
else
  content = tostr("<i", class == "" ? ">" | tostr(" class=\"", class, "\">"), content, "</i>");
endif
return content;
.


@verb $encore_web_utils:img*age this none this
@program $encore_web_utils:img
"===========================================================";
"Copyright (C) 2004, Jan Rune Holmevik";
"Create tag for inline image.";
"===========================================================";
{img, ?border = "0", ?align = "middle", ?alt = ""} = args;
if (img != "")
  img = tostr("<img src=\"", img, "\" border=\"", border, "\" align=\"", align, "\" alt =\"", alt, "\" title=\"", alt, "\" />");
endif
return img;
.

@verb $encore_web_utils:ul this none this
@program $encore_web_utils:ul
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a ul element";
"===========================================================";
{content, ?class = ""} = args;
if (typeof(content) == LIST)
  result = {tostr("<ul", class == "" ? ">" | tostr(" class=\"", class, "\">"))};
  for line in (content)
     result = {@result, tostr("     <li>", line, "</li>")};
  endfor
  result = {@result, "</ul>"};
else
  result = {tostr("<ul", class == "" ? "><li>" | tostr(" class=\"", class, "\">"), content, "<li></ul>")};
endif
return result;
.

@program $encore_web_utils:br
"===========================================================";
"Copyright (C) 1995-2004, Jan Rune Holmevik and Mark Blanchard";
"===========================================================";
if (args)
  text = args[1];
  result = {};
  newline = "";
  if (typeof(text) == LIST)
    for line in (text)
      $command_utils:suspend_if_needed(0);
      result = {@result, line + "<br />"};
    endfor
  else
    result = {text + "<br />"};
  endif
else
  result = "<br />";
endif
return result;
.

@program $who_browser:main_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Displays a list of connected users.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
who_listing = players = notice = close = {};
functions = "";
if (connected_players())
  who_list = {};
  base_url = $encore_web_utils:baseurl();
  {help_button, help_window} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Who_Browser");
  functions = $list_utils:append(help_window, this.move_alert);
  functions = $encore_web_utils:insert_javascript(functions);
  title = $encore_web_utils:get_title(user, this);
  "Compile list of connected users, and sort by idle time";
  for person in (connected_players())
    $command_utils:suspend_if_needed(0);
    if (!($object_utils:has_property(person, "invis") && person.invis))
      "Do not show invisible users in the who list.";
      players = setadd(players, {person, connected_seconds(person), idle_seconds(person), person.location});
    endif
  endfor
  if (players)
    sorted_list = $list_utils:sort_alist(players, 3);
    "Put values from sorted list into four collumns";
    users = {$encore_web_utils:div("Name", "header")};
    connected = {$encore_web_utils:div("Connected for", "header")};
    idle = {$encore_web_utils:div("Idle time", "header")};
    location = {$encore_web_utils:div("Location", "header")};
    activity = {$encore_web_utils:div("Doing", "header")};
    for n in (sorted_list)
      $command_utils:suspend_if_needed(0);
      OBJ = toobj(n[1]);
      link = tostr($encore_web_utils:a(tostr(base_url, toint(OBJ)), obj.name, "", "", $encore_web_utils:get_icon(user, OBJ)));
      if (OBJ.xpress_on)
        link = link + tostr($encore_web_utils:img(tostr($xpress_client.external_baseurl, $xpress_client.icons_folder, "xpress_indicator.gif")));
      endif
      users = {@users, tostr(link)};
      connected = {@connected, tostr($string_utils:from_seconds(connected_seconds(n[1])))};
      idle = {@idle, tostr($string_utils:from_seconds(idle_seconds(n[1])))};
      if ($object_utils:isa(OBJ.location, $generic_editor) || OBJ.location.key != 0)
        location_link = OBJ.location.name;
      else
        location_link = $encore_web_utils:a(tostr(base_url, toint(OBJ.location)), OBJ.location.name, "", "onclick=\"return confirmMove()\"");
      endif
      location = {@location, tostr(location_link)};
      activity = {@activity, tostr(OBJ.doing)};
    endfor
    who_listing = $encore_web_utils:generate_table(user, {users, connected, idle, location, activity}, this, "1");
    if (length(sorted_list) == 1)
      verb = " is ";
      noun = " person ";
    else
      verb = " are ";
      noun = " people ";
    endif
    notice = $encore_web_utils:p(tostr("There ", verb, length(sorted_list), noun, " in ", $network.MOO_name, " on ", $time_utils:time_sub("$D $N $T, $Y, at $O:$M $P, $Z", time())));
  else
    notice = $encore_web_utils:p(tostr("Nobody is connected to ", $network.MOO_name, " at this time."));
  endif
  info = $list_utils:append(help_button, $encore_web_utils:input("refresh", "Refresh Who Browser", "", "button", tostr("onclick=\"location.href='", base_url, "Who_Browser/main.html'\"")), $encore_web_utils:close());
endif
body = $list_utils:append(functions, title, info, notice, who_listing);
result = this:build(user, body, "Who Browser", "self.focus();", "web_frame");
return result;
.

@program $search_engine:search_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Perform search on object names, user real names or email addresses in the MOO.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, form_data} = args;
form = options = search_results = subtitle = {};
alert = message = "";
base_url = $encore_web_utils:baseurl();
title = $encore_web_utils:get_title(user, this, "Xpress Search");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Searching");
help_function = $encore_web_utils:insert_javascript(help_function);
search = $encore_web_utils:input("search", "", "20");
if (!$anonymous_users)
  options = $encore_web_utils:option("Object name", 1, 1);
  options = $list_utils:append(options, $encore_web_utils:option("Real name", 2));
  options = $list_utils:append(options, $encore_web_utils:option("Email address", 3));
  options = $encore_web_utils:select(options, "search_options", $encore_web_utils:focus_field("search"));
endif
form = $list_utils:append(help_button, $encore_web_utils:p(), {"Search "}, options, search, $encore_web_utils:input("go", "Find", "", "submit"), $encore_web_utils:close());
form = $encore_web_utils:form(form, "form", "/search_engine/search_html");
if ({{}, {}} != form_data)
  hits = {};
  "Process from data and compile search results.";
  if ($anonymous_users)
    string = form_data[2][1];
    category = "1";
  else
    string = form_data[2][2];
    category = form_data[2][1];
  endif
  if (category == "1")
    search_domain = $root_class;
    criteria = "name";
  elseif (category == "2")
    search_domain = $player;
    criteria = "real_name";
  else
    search_domain = $player;
    criteria = "email_address";
  endif
  for object in ($object_utils:descendants_suspended(search_domain))
    $command_utils:suspend_if_needed(1);
    if (match(object.(criteria), string))
      hits = {@hits, object};
    endif
  endfor
  if (hits)
    name = {$encore_web_utils:div("Object", "header")};
    loc = {$encore_web_utils:div("Location", "header")};
    owner = {$encore_web_utils:div("Owner", "header")};
    for item in (hits)
        $command_utils:suspend_if_needed(1);
        name = {@name, $encore_web_utils:a(tostr(base_url, toint(item)), item.name, "web_frame", "", $encore_web_utils:get_icon(user, item))};
        if (item.location != $nothing)
          loc = {@loc, tostr(item.location.name, " (", item.location, ")")};
        else
          loc = {@loc, "Nowhere"};
        endif
        owner = {@owner, tostr(item.owner.name, " (", item.owner, ")")};
    endfor
    search_results = $encore_web_utils:generate_table(user, {name, loc, owner}, this, 1);
  else
    message = tostr("Sorry, ", string, " was not found in ", $network.MOO_name, ".");
  endif
  search_results = $list_utils:append(subtitle, search_results);
endif
alert = $encore_web_utils:alert(message) + $encore_web_utils:focus_field("search");
body = $list_utils:append(help_function, title, $encore_web_utils:div(form), $encore_web_utils:div(search_results));
result = this:build(user, body, "MOO Search Engine", alert);
return result;
.

@program $inventory_manager:view_inventory
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"View a player's inventory via Xpress.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
try
  index = toint(data[2][2]);
except error (ANY)
  index = 1;
endtry
body = this:make_inventory(user, index);
html = this:build(user, body, this.name, "self.focus();");
return html;
.



@program $inventory_manager:make_inventory
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"View a player's inventory via Xpress.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, ?index = 1} = args;
body = object_menu = {};
try;
  base_url = $encore_web_utils:baseurl();
  target = "web_frame";
  use_exit_name = 1;
  call_spec = tostr(toint(this), ";make_inventory");
  title = $encore_web_utils:get_title(user, this, tostr(user.name, "'s Stuff!"));
  {help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Inventory_Manager");
  help_button = $list_utils:append(help_button, $encore_web_utils:input("refresh", "Refresh My Stuff", "", "button", tostr("onclick=\"location.href='", base_url, "Inventory_Manager/view_inventory?", toint(user), "'\"")), $encore_web_utils:close());
  edit_window = $encore_web_utils:javascript_window_open($xpress_object_editor, "openXpressEdit", "");
  confirmDelete = {"function confirmDelete() {", tostr("   if (confirm('Are you sure you want to permanently recycle this object? This action cannot be undone!')) {"), "       return true;", "   }", "   return false;", "}"};
  functions = $list_utils:append(confirmDelete, help_function, edit_window);
  functions = $encore_web_utils:insert_javascript(functions);
  stuff = {};
  if (user.owned_objects != {})
    "-----------------------------------------";
    "Compile list of owned objects";
    "-----------------------------------------";
    if (length(user.owned_objects) > this.max_view)
      object_menu = this:make_object_menu(user, index);
    endif
    links = locations = actions = {};
    if (index + this.max_view > length(user.owned_objects))
      last = length(user.owned_objects);
    else
      last = index + this.max_view;
    endif
    for item in ($list_utils:reverse(user.owned_objects)[index..last])
      $command_utils:suspend_if_needed(0);
      action = "";
      links = {@links, tostr($encore_web_utils:generate_links(user, {item}, target, use_exit_name)[1], " (", item, ")")};
      locations = {@locations, item.location == $nowhere ? "Nowhere" | tostr(item.location.name, " (", item.location, ")")};
      "-----------------------------------------";
      "Add contextual menu for object if relevant";
      "-----------------------------------------";
      if ($object_utils:has_callable_verb(item, "make_contextual_menu"))
        contextual_menu = item:make_contextual_menu(user, item, call_spec, return_functions = 0);
        for button in (contextual_menu)
          action = action + button;
        endfor
      endif
      actions = {@actions, action};
    endfor
    links = {$encore_web_utils:div("Object", "header"), @links};
    locations = {$encore_web_utils:div("Location", "header"), @locations};
    actions = {$encore_web_utils:div("Actions", "header"), @actions};
    stuff = $encore_web_utils:generate_table(user, {links, locations, actions}, this, 1);
  endif
  "-----------------------------------------";
  "Add quota information";
  "-----------------------------------------";
  quota_info = this:display_quota(user);
  body = $list_utils:append(functions, title, help_button, quota_info, {$encore_web_utils:br(), $encore_web_utils:br()}, object_menu, stuff);
except error (ANY)
endtry
return body;
.

@program $inventory_manager:display_quota
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Visualize a user's quota usage.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
"-----------------------------------------";
"Measure the user's quota usage";
"-----------------------------------------";
$quota_utils:summarize_one_user(user);
{quota, usage, timestamp, unmeasured} = user.size_quota;
url = $xpress_client.external_baseurl + $xpress_client.system_images_folder;
used = usage * 100 / quota;
free = quota - usage;
if (free < 0)
  free = 0;
endif
"------------------------------------------------";
"Determine what quota chart to show";
"------------------------------------------------";
if (used < 13)
  chart = "quota_0.gif";
elseif (used >= 13 && used < 25)
  chart = "quota_12_5.gif";
elseif (used >= 25 && used < 38)
  chart = "quota_25.gif";
elseif (used >= 38 && used < 50)
  chart = "quota_37_5.gif";
elseif (used >= 50 && used < 63)
  chart = "quota_50.gif";
elseif (used >= 63 && used < 75)
  chart = "quota_62_5.gif";
elseif (used >= 75 && used < 88)
  chart = "quota_75.gif";
elseif (used >= 88 && used < 100)
  chart = "quota_87_5.gif";
else
  chart = "quota_100.gif";
endif
quota_chart = $encore_web_utils:span(tostr("Quota usage ", $encore_web_utils:img(tostr(url, chart))), "left");
quota_data = $encore_web_utils:span(tostr($encore_web_utils:img(tostr(url, "quota_free.gif")), " ", $string_utils:group_number(free), " bytes free", $encore_web_utils:br(), $encore_web_utils:img(tostr(url, "quota_used.gif")), " ", used, " bytes used "), "middle");
owned_objects = $encore_web_utils:span(tostr("Total objects: ", length(user.owned_objects)), "right");
result = $list_utils:append($encore_web_utils:p({quota_chart, quota_data, owned_objects})); 
return result;
.

@program $inventory_manager:make_object_menu
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Break down long object listings into chuncks in order to reduce lag and load times.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, index} = args;
finished = 0;
first = menuindex = 1;
quick_access = {};
total_objects = length(user.owned_objects);
base_url = tostr($encore_web_utils:baseurl(), "/Inventory_Manager/view_inventory?", toint(user), ";");
if (index > 1)
  "Add back button";
  if (index - this.max_view < 1)
    newindex = 1;
  else
    newindex = index - this.max_view;
  endif
  quick_access = {@quick_access, $encore_web_utils:a(tostr(base_url, newindex), "[&lt;&lt; prev]")};
endif
while (!finished)
  if (first in {index, index + 1})
    "We are at current index position. Do not create link";
    quick_access = {@quick_access, $encore_web_utils:b(menuindex)};
  else
    quick_access = {@quick_access, $encore_web_utils:a(tostr(base_url, first), menuindex)};
  endif
  first = first + this.max_view;
  menuindex = menuindex + 1;
  if (first > total_objects)
    finished = 1;
  endif
endwhile
if (index + this.max_view <= total_objects)
  "Add forward button";
  quick_access = {@quick_access, $encore_web_utils:a(tostr(base_url, index + this.max_view), "[next &gt;&gt;]")};
endif
quick_access = $encore_web_utils:align(quick_access, "center");
return quick_access;
.

@set-note-text $encore_help.object_editor
The enCore Xpress Object Editor makes it easy to assert your creative side. To edit an object you own either type in the object's name or object number, or click the button 'My Objects' to view a list of all your objects. Select an object from the list by clicking on it. When you have selected an object  to work with a list of editing options will appear in the form of a drop down menu in the Object Editor's work area to the bottom left. Choose an option from the menu to edit it.

You can also use the Object Editor to create new objects. Simply click the button named 'Create New Object'. In the right area of the Object Editor  you will now see three categories of objects. These are so-called generic  objects, or blueprints, that you can use as basis for your own objects. Select a category and choose the type of object you wish to make from the available options. Once you have created the object you continue to work on it in work area to the left.

See also help on creating rooms.
.

"--------------------------------------------------------------------------
"The following code is a new and improved version of the Xpress MOO mailer. Thanks to Daniel Jung for the contribution of this code

@prop $Xpress_MOO_Mailer.xpress_moo_mailer_strings {}

;$xpress_moo_mailer.("xpress_moo_mailer_strings") = {"XPRESS MOO MAILER STRINGS", " --- menu_html --- ", "Compose Mail", "Mail Lists", "Close", " --- folders_html --- ", "Mail Boxes", "Mail Search", "Search these boxes for:", "regex", "boolean", "search", " --- quick access --- ", "prev", "next", " --- contents_html, search, view_html --- ", "Subject", "From", "To", "Mail Box", "Date", "Delete", " --- delete_mail_html --- ", "Are you sure you want to delete the selected messages?", "Deleted: message %msg_nr on %folder.name", "An error occurred. Message not deleted.", " --- contents_html, search --- ", "This Mail Box is empty.", "Your search didn't return any results.", "Sorry, Xpress does not support Big Mail Recipient folders. Read these folders using the command line verbs read, and @nn.", " --- view_html ---", "Message %msg_nr on %folder_name", "Reply", "Print", "Window", "Quote Original", " --- compose --- ", "a list of names or numbers separated by spaces", "Include Signature", "Send MOO Mail", "Send via Internet", " --- send_mail, spoof strings --- ", "This message has not been sent. Are you sure you want to discard it?", "Mail successfully sent via MOO mail to %to.", "Error sending mail: %reason.why", "Error sending mail: You cannot send Internet mail to MOO mailing lists.", "Mail successfully sent via Internet. Replies to this mail message will go to your Internet email address and not to your MOO mailbox.", "Error, mail not sent. Recipient was not found in %$network.MOO_name. Please try again, and remember to use player names as mail addresses, not actual email addresses even if you are sending mail via the Internet.", "Incomplete form data. Maybe you are being tricked into deleting mail unwillingly. Please notify a wizard.", "Incomplete form data. Maybe you are being tricked into sending mail unwillingly. Please notify a wizard.", "Incomplete form data. Maybe you are being tricked into subscribing/unsubscribing unwillingly. Please notify a wizard.", " --- object editor --- ", "Edit Mail Options", "Setting MOO Mail options", "Display messages in a frame in the main MOO Mailer window", "Display messages in a window by its own", "Quote in replies by default", "Don't quote in replies by default", "Include signature by default", "Don't include signature by default", "Number of messages per page", "System mail notification sound", "Custom mail notification sound (begin with `http://')", "MOO Mail Signature", " --- subscribe --- ", "MOO Mailing Lists", "The following mailing lists are available in %$network.MOO_name. Click the checkboxes to subscribe or unsubscribe from the lists as desired, then click the %Update_Subscriptions button.", "List Subscriptions", "List Description", "Update Subscriptions", "Your mailing list subscriptions have been updated!", " --- miscelleanous --- ", "Sorry, you need a frame browser to use this system.", "Compose New Mail"}

@prop $mail_recipient_class.messages_in_main_window 1

@prop $mail_recipient_class.messages_out {}

@prop $mail_recipient_class.messages_search {}

@prop $mail_recipient_class.links_per_page {3, 5, 7, 10, 12, 15, 20, 30, 100}

@prop $mail_recipient_class.messages_to_display 7

@prop $mail_recipient_class.mail_notify_sound_custom ""

@prop $mail_recipient_class.quote_by_default 1

@prop $mail_recipient_class.signature_by_default 1

@program $Xpress_MOO_Mailer:main_html
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Generates the main MOO mail browser using three frames    ";
" ==========================================================";
" Added an optional forth preview frame, made it resizable. ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
strings = this.xpress_moo_mailer_strings;
base_url = tostr($encore_web_utils:baseurl(), "Xpress_MOO_Mailer/");
menu_frame = tostr(base_url, "menu.html");
folder_frame = tostr(base_url, "folders.html");
contents_frame = tostr(base_url, "contents.html");
html = {tostr(         "<frameset cols=\"50%\">")};
html = {@html,         "   <noframes>"};
html = {@html, tostr(  "      <body>", strings[73], "</body>")};
html = {@html,         "   </noframes>"};
html = {@html, tostr(  "   <frameset cols=\"50%\">")};
html = {@html, tostr(  "      <frameset rows=\"95,82%\">")};
html = {@html, tostr(  "         <frame src=\"", menu_frame, "\" name=\"menu\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html, tostr(  "         <frameset cols=\"30%,70%\">")};
html = {@html, tostr(  "            <frame src=\"", folder_frame, "\" name=\"folder\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
if (user.messages_in_main_window)
    default_msg = (length(user.messages)) ? tostr(base_url, "/view_html?obj=", toint(user), ";index=", user:oldest_nonread(), ";box=InBox;view=pre") | "";
  html = {@html, tostr("      <frameset rows=\"50%,50%\">")};
  html = {@html, tostr("         <frame src=\"", contents_frame, "\" name=\"contents\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
  html = {@html, tostr("         <frame src=\"", default_msg, "\" name=\"message\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
  html = {@html,       "      <frameset>"};
else
  html = {@html, tostr("            <frame src=\"", contents_frame, "\" name=\"contents\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
endif
html = {@html,         "      </frameset>"};
html = {@html,         "   </frameset>"};
html = {@html,         "</frameset>"};
html = {@html,         "</frameset>"};
html = {@html,         "</frameset>"};
html = {@html,         "</frameset>"};
result = this:build(user, html, "Xpress MOO Mailer", "", "", "", "", this.doctype_frameset);
return result;
.

@program $xpress_moo_mailer:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Create the top menu for the MOO mailer";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
functions = {};
base_url = $encore_web_utils:baseurl();
strings = this.xpress_moo_mailer_strings;
title = $encore_web_utils:get_title(user, this, "Xpress MOO Mailer");
"Assemble menu line";
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "MOO_Mailer");
compose = $encore_web_utils:input("compose", strings[74], "", "button", "onclick=\"openMailEditor()\"");
maillists = $encore_web_utils:input("lists", strings[66], "", "button", "onclick=\"openMailLists()\"");
menu = $list_utils:append(help_button, compose, maillists, $encore_web_utils:close("parent"));
menu = $enCore_web_utils:form($list_utils:append(title, menu));
"Assemble JavaScript functions";
mail_editor = $encore_web_utils:javascript_window_open($Xpress_MOO_mailer, "openMailEditor", tostr(base_url, "Xpress_MOO_mailer/compose"), this.browser_window_width, this.browser_window_height);
maillistwindow = $encore_web_utils:javascript_window_open($Xpress_MOO_mailer, "openMailLists", tostr(base_url, "Xpress_MOO_mailer/subscribe"), this.browser_window_width, this.browser_window_height);
functions = $list_utils:append(help_function, mail_editor, maillistwindow);
functions = $encore_web_utils:insert_javascript(functions);
body = $list_utils:append(functions, menu);
result = this:build(user, body, "", "self.focus()");
return result;
.

@verb $mail_recipient_class:"oldest_nonread" this none this rxd
@program $mail_recipient_class:oldest_nonread
" ==========================================================";
" Returns the number of the first message after last logoff ";
" Daniel Jung, Nov. 2003                                     ";
" ==========================================================";
ldt = this.last_disconnect_time;
for msg in (this.messages)
  if (toint(msg[2][1]) > ldt)
    return msg[1];
  endif
endfor
return length(this.messages);
.

@program $Xpress_MOO_Mailer:folders_html
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Lists all mail folders the user is subscribed to          ";
" ==========================================================";
" Added an Outbox and changed the link syntax.              ";
" Added a search function. Took out language strings.       ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, alert} = args;
if (alert == {{}, {}})
  alert = "";
endif
folders = {};
strings = this.xpress_moo_mailer_strings;
base_url = tostr($encore_web_utils:baseurl(), "Xpress_MOO_mailer/contents.html");
title = $encore_web_utils:get_subtitle(user, this, strings[7]);
folders = {@folders, $encore_web_utils:a(tostr(base_url, "?obj=", toint(user), ";box=InBox"), "InBox", "", "", $encore_web_utils:get_icon(user, this)), $encore_web_utils:br()};
folders = {@folders, $encore_web_utils:a(tostr(base_url, "?obj=", toint(user), ";box=OutBox"), "OutBox", "", "", $encore_web_utils:get_icon(user, this)), $encore_web_utils:br()};
cm = user.current_message;
cm[1..2] = (verb == "@rn") ? {{this, @cm[1..2]}} | {};
for item in (cm)
  mail_box = item[1];
  if ($mail_agent:is_recipient(mail_box) && (!$object_utils:isa(mail_box, $big_mail_recipient)))
    folders = {@folders, $encore_web_utils:a(tostr(base_url, "?obj=", toint(mail_box)), mail_box.name, "", "", $encore_web_utils:get_icon(user, this)), $encore_web_utils:br()};
  endif
endfor
search = $encore_web_utils:get_subtitle(user, this, strings[8]);
search = $list_utils:append(search, $encore_web_utils:input("folder", toint(user), "", "hidden")); 
search = $list_utils:append(search, $encore_web_utils:input("newsearch", "1", "", "hidden")); 
search = $list_utils:append(search, $encore_web_utils:p(strings[9]));
search = $list_utils:append(search, $encore_web_utils:input("sstring", "", "10", "text"));
search = $list_utils:append(search, $encore_web_utils:input("submit", strings[12], "", "submit"));
search = $encore_web_utils:form(search, "search_form", "/Xpress_MOO_Mailer/search");
body = $list_utils:append(title, folders, $encore_web_utils:p(), search);
result = this:build(user, body, "MOO Mailer Folders", alert, "contents");
return result;
.

@verb $Xpress_MOO_Mailer:"get_mailfolder_name" this none this rxd
@program $Xpress_MOO_Mailer:get_mailfolder_name
" ==========================================================";
" Copyright (C) 2003, Daniel Jung                           ";
" ==========================================================";
{folder, ?box = "", ?sstring = ""} = args;
if (is_player(folder))
  if (box == "OutBox")
    name = tostr(folder.name, "'s OutBox");
  elseif (box == "Search")
    name = tostr(folder.name, "'s search hits on '", sstring, "'");
  else
    name = tostr(folder.name, "'s InBox");
  endif
else
  name = folder.name;
endif
return name;
.

@verb $Xpress_MOO_Mailer:"get_date" this none this rxd
@program $Xpress_MOO_Mailer:get_date
" ==========================================================";
" Copyright (C) 2003, Daniel Jung                           ";
" :get_date(time())                                         ";
" returns a time string to be used in themail headers in    ";
" view_html and the tables in search and contents_html      ";
" ==========================================================";
{t} = args;
t = ctime(t);
return tostr(t[9..10], ".", t[5..7] in $time_utils.monthabbrs, ".", t[23..24], ", ", t[12..16]);
.

@program $Xpress_MOO_Mailer:contents_html
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Build list of messages in folder.                         ";
" Create quick access navigation menu if required.          ";
" ==========================================================";
" Changed layout, customized number of messages, added      ";
" multiple delete option, changed form data parsing and     ";
" link syntax and simplified the page call (quick access).  ";
" Took out language strings. Daniel Jung, Nov. 2003         ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data, ?alert = ""} = args;
strings = this.xpress_moo_mailer_strings;
result = {};
{folder, box, page} = $list_utils:map_formdata(data, {{"obj", user}, {"box", ""}, {"page", 0}});
folder = toobj(folder);
page = toint(page);
if (!this:permission_to_read(user, folder))
  return "403_Forbidden";
else
  if ($object_utils:isa(folder, $big_mail_recipient))
    return this:build(user, {strings[30]}, "MOO Mailer Contents", alert);
  else
    folder_name = this:get_mailfolder_name(folder, box);
    if (is_player(folder))
      messages = (box == "OutBox") ? folder.messages_out | folder.messages;
    else
      messages = folder.messages;
    endif
    base_url = tostr($encore_web_utils:baseurl(), "Xpress_MOO_mailer/");
    mail_reader = $encore_web_utils:javascript_window_open($Xpress_MOO_mailer, "openMailReader", "");
    open_mail_reader = $encore_web_utils:insert_javascript(mail_reader);
    title = $encore_web_utils:get_subtitle(user, this, folder_name);
    subject = from = date = delete = quick_access = {};
    messages_to_display = user.messages_to_display;
    if (!messages)
      table = {strings[28]};
    else
      chunks = (length(messages) / user.messages_to_display) + (((length(messages) % user.messages_to_display) > 0) ? 1 | 0);
      if (!page)
        if (is_player(folder))
          page = folder:oldest_nonread() / user.messages_to_display;
          (page == 0) ? page = chunks | 0;
        else
          page = chunks;
        endif
      endif
      page = min(chunks, page);
      first = 1 + ((page - 1) * user.messages_to_display);
      last = min((first + user.messages_to_display) - 1, length(messages));
      add_delete = (user.wizard || (user == folder.owner)) ? 1 | 0;
      delete = {};
      subject = $encore_web_utils:br($encore_web_utils:div(strings[17], "header"));
      from = $encore_web_utils:br($encore_web_utils:div((box == "OutBox") ? strings[19] | strings[18], "header"));
      date = $encore_web_utils:br($encore_web_utils:div(strings[21], "header"));
      for n in [first..last]
        suspend(0);
        message = messages[n];
        subj = tostr(message[1], " ", message[2][4]);
        sender = tostr(message[2][2]);
        if (add_delete)
          delete = $list_utils:append(delete, $encore_web_utils:input("morituri", n , "", "checkbox"));
        endif
        loc = tostr(base_url, "view.html?obj=", toint(folder), ";index=", n, ";box=", box);
        if (user.messages_in_main_window)
          subject = {@subject, $encore_web_utils:a(tostr(loc, ";view=pre"), subj, "message")};
        else
          window_name = tostr(strsub($network.MOO_name, " ", "_"), "_openMailReader");
          target = window_name;
          subject = {@subject, $encore_web_utils:a(loc, subj, target, "onclick=\"openMailReader()\"")};
        endif
        if (box == "OutBox")
          "put the first of all recipients in the from field";
          recips = message[2][3];
          i = index(recips, ")");
          recip = recips[1..i];
          from = {@from, recip};
        else
          from = {@from, sender};
        endif
        date = {@date, this:get_date(message[2][1])};
      endfor
      if (add_delete)
        delete = {"", @delete};
        table = $encore_web_utils:generate_table(user, {delete, subject, from, date}, this, 1);
        formstuff = $encore_web_utils:input("obj", folder, "", "hidden");
        formstuff = $list_utils:append(formstuff, ($encore_web_utils:input("box", box, "", "hidden")));
        formstuff = $list_utils:append(formstuff, ($encore_web_utils:input("wac", crypt(user.web_access_code, user.web_access_code), "", "hidden")));
        formstuff = $list_utils:append(formstuff, table, ($encore_web_utils:input("submit", strings[22], "", "submit")));
        table = $encore_web_utils:form(formstuff, "delete_mail", "/Xpress_MOO_mailer/delete_mail.html", tostr("if (!confirm('", $string_utils:escape(strings[24]), "')){return false;}"));
      else
        table = $encore_web_utils:generate_table(user, {subject, from, date}, this, 1);
        table = {@table, $encore_web_utils:br()};
      endif
      if (chunks > 1)
        for chunk in [1..chunks]
          quick_access = (chunk == page) ? {@quick_access, $encore_web_utils:b(page)} | {@quick_access, $encore_web_utils:a(tostr(base_url, "contents.html?obj=", toint(folder), ";box=", box, ";page=", chunk), chunk)};
        endfor
        if (page > 1)
          quick_access = {$encore_web_utils:a(tostr(base_url, "contents.html?obj=", toint(folder), ";box=", box, ";page=", page - 1), tostr("[&lt;&lt; ", strings[14], "]")), @quick_access};
        endif
        if (page < chunks)
          quick_access = {@quick_access, $encore_web_utils:a(tostr(base_url, "contents.html?obj=", toint(folder), ";box=", box, ";page=", page + 1), tostr("[", strings[15], " &gt;&gt;]"))};
        endif
        quick_access = $encore_web_utils:align(quick_access, "center");
      endif
    endif
    body = $list_utils:append(open_mail_reader, title, quick_access, table, quick_access);
    result = this:build(user, body, "MOO Mailer Contents", alert);
  endif
  return result;
endif
.


@program $Xpress_MOO_Mailer:view_html
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Displays the contents of a MOO mail message               ";
" ==========================================================";
" Added preview/fullview mode, changed form data parsing,   ";
" changed layout. Highlighted search words in case this     ";
" verb is called from a query. Daniel Jung, Nov. 2003       ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
valid_folders = mail_head = mail_message = body = {};
{user, ?data = {{}, {}}} = args;
{folder, msg_nr, box, view, sstring} = $list_utils:map_formdata(data, {{"obj", user}, {"index", 0}, {"box", ""}, {"view", "full"}, {"sstring", ""}});
folder = toobj(folder);
msg_nr = toint(msg_nr);
len = length(folder.messages);
msg_nr > len ? msg_nr = len | 0;
msg_nr < 1 ? msg_nr = 1 | 0;
sstring = this:decode(sstring);
strings = this.xpress_moo_mailer_strings;
base_url = tostr($encore_web_utils:baseurl(), "Xpress_MOO_Mailer/");
if (data != {{}, {}})
  cm = user.current_message;
  cm[1..2] = (verb == "@rn") ? {{this, @cm[1..2]}} | {};
  valid_folders = {user};
  for item in (cm)
    valid_folders = {@valid_folders, item[1]};
  endfor
  if (this:permission_to_read(user, folder))
    mail_reader = $encore_web_utils:javascript_window_open($Xpress_MOO_Mailer, "openMailReader", "");
    open_mail_reader = $encore_web_utils:insert_javascript(mail_reader);
    "User has permission to read the requested message";
    "Mark message as read";
    folder_name = this:get_mailfolder_name(folder, box);
    if (box == "OutBox")
      message = folder.messages_out[msg_nr];
    else
      user:set_current_message(folder, msg_nr, time());
      message = folder.messages[msg_nr];
    endif
    " ------------------------ ";
    " --- make the headers --- ";
    " ------------------------ ";
    mail_head = {@mail_head, $encore_web_utils:b(strings[21]), this:get_date(message[2][1]), $encore_web_utils:br()};
    mail_head = {@mail_head, $encore_web_utils:b(strings[18]), sstring ? strsub(tostr(message[2][2]), sstring, $encore_web_utils:div(sstring, "highlight")) | message[2][2], $encore_web_utils:br()};
    mail_head = {@mail_head, $encore_web_utils:b(strings[19]), sstring ? strsub(tostr(message[2][3]), sstring, $encore_web_utils:div(sstring, "highlight")) | message[2][3], $encore_web_utils:br()};
    mail_head = {@mail_head, $encore_web_utils:b(strings[17]), sstring ? strsub(message[2][4], sstring, $encore_web_utils:div(sstring, "highlight")) | message[2][4]};
    mail_head = $encore_web_utils:div(mail_head, "mailhead");
    " --------------------- ";
    " --- make the body --- ";
    " --------------------- ";
    for line in (message[2][5..$])
      if (sstring)
        line = strsub(line, sstring, $encore_web_utils:div(sstring, "highlight"));
      endif
      line = $encore_web_utils:detect_urls(user, line)[1];
      " --- make indents if quoted --- ";
      div = level = 0;
      while (index(line, "> ") == 1)
        line = (length(line) > 2) ? line[3..$] | $encore_web_utils:br();
        div = level = level + 1;
      endwhile
      wrapbegin = wrapend = "";
      while (level > 0)
        wrapbegin = tostr(wrapbegin, "<div style=\"padding-left: .5em; border-left: solid black;\">");
        wrapend = tostr(wrapend, "</div>");
        level = level - 1;
      endwhile
      mail_message = div ? {@mail_message, tostr(wrapbegin, line, wrapend), ""} | {@mail_message, tostr(line, $encore_web_utils:br())};
    endfor
    mail_message = $encore_web_utils:div(mail_message, "mailbody");
    title = $encore_web_utils:get_subtitle(user, this, $string_utils:subst(strings[32], {{"%msg_nr", tostr(msg_nr)}, {"%folder_name", folder_name}}));
    if (box != "OutBox")
      if (view == "full")
        reply_button = $list_utils:append($encore_web_utils:input("reply", strings[33], "", "submit"), $encore_web_utils:input("obj", folder, "", "hidden"), $encore_web_utils:input("index", msg_nr, "", "hidden"), $encore_web_utils:input("cit", "yes", "", "checkbox", "", user.quote_by_default == 1 ?  "checked" | ""), {strings[36]}, $encore_web_utils:close());
        reply_button = $encore_web_utils:form(reply_button, "reply", "/Xpress_MOO_mailer/compose");
      elseif (view == "pre")
        reply_button = $encore_web_utils:a(tostr(base_url, "compose?obj=", toint(folder), ";index=", msg_nr, ";box=", box, ";cit=", toint(user.quote_by_default) ? "yes" | "no"), tostr("[", strings[33], "]"), tostr(strsub($network.moo_name, " ", "_"), "_openMailReader"), "onclick=\"openMailReader()\"");
        print_button = $encore_web_utils:a("", tostr("[", strings[34], "]"), "", tostr("onclick=\"if (self.print){self.print();}return false;\""));
        window_button = $encore_web_utils:a(tostr(base_url, "view_html?obj=", toint(folder), ";index=", msg_nr, ";box=", box, ";sstring=", sstring), tostr("[", strings[35], "]"), tostr(strsub($network.moo_name, " ", "_"), "_openMailReader"), "onclick=\"openMailReader()\"");
        reply_button = $encore_web_utils:align({reply_button, print_button, window_button}, "right");
      else
        reply_button = {};
      endif
    else
      reply_button = {};
    endif
    body = $list_utils:append(title, open_mail_reader, mail_head, (view == "pre") ? reply_button | {}, mail_message, reply_button);
  else
    return "403_Forbidden";
  endif
else
  body = {"This shouldn't appear. Debugging: This must be an error in the query URL."};
endif
result = this:build(user, body, "MOO Mail Message");
return result;
.


@program $Xpress_MOO_Mailer:delete_mail_html
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Deletes a specified MOO mail message, renumbers the folder";
" ==========================================================";
" Added OutBox, multiple messages delete, took out strings. ";
" Security Patch: Made it spoof proof.                      ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
for elem in [1..length(data[1])]
endfor
strings = this.xpress_moo_mailer_strings;
alert = "";
body = {};
if (data != {{}, {}})
  try
    {folder, msg_nr, box, morituri, wac} = $list_utils:map_formdata_all(data, {{"obj", user}, {"index", 0}, {"box", ""}, {"morituri", {}}, {"wac", 0}});
    (typeof(morituri) != LIST) ? morituri = {morituri} | 0;
    folder = toobj(folder);
    msg_nr = toint(msg_nr);
    if (!$encore_web_utils:check_wac(user, wac))
      " --- we're being spoofed! --- ";
      alert = tostr("alert('", $string_utils:escape(strings[50]), "')");
    else
      if ((folder.owner == user) || user.wizard)
        if (length(morituri))
          index = 1;
          new = {};
          old = ((folder == user) && (box == "OutBox")) ? folder.messages_out | folder.messages;
          for msg in [1..length(old)]
            suspend(0);
            if (!(tostr(old[msg][1]) in morituri))
              new = $list_utils:append(new, {{index, old[msg][2]}});
              index = index + 1;
            endif
          endfor
          ((folder == user) && (box == "OutBox")) ? folder.messages_out = new | (folder.messages = new);
          folder_name = tostr("'", this:get_mailfolder_name(folder, box), "'");
          alert = tostr("alert('", $string_utils:escape($string_utils:subst(strings[25], {{"%msg_nr", $string_utils:english_list(morituri)}, {"%folder.name", folder_name}})), "');");
        endif
      else
        return "403_Forbidden";
      endif
    endif
    return this:contents_html(user, {{"obj", "box"}, {folder, box}}, alert);
  except error (ANY)
    alert = tostr("alert('", $string_utils:escape(strings[26]), "');");
  endtry
endif
result = this:build(user, body, "MOO Mail Message", alert);
return result;
.

@program $Xpress_MOO_Mailer:compose
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Process web mail editor data, send message to recipient(s)";
" ==========================================================";
" Changed form data parsing, took out strings.              ";
" Made lost messages reappear.    Daniel Jung, Nov. 2003    ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, ?data = {{}, {}}} = args;
strings = this.xpress_moo_mailer_strings;
to = subject = lost_to = lost_subject = "";
original = lost_message = msg_data = {};
onload = "document.getElementById('to').focus()";
title = $encore_web_utils:get_title(user, this, "MOO Mail Editor");
if (data != {{}, {}})
  {folder, msg_nr, box, quote, lost_to, lost_subject, lost_message} = $list_utils:map_formdata(data, {{"obj", user}, {"index", 0}, {"box", ""}, {"cit", "no"}, {"lost_to", ""}, {"lost_subject", ""}, {"lost_message", {}}});
  if (lost_to || lost_subject || lost_message)
    " --- recovering from a bad send command --- ";
    to = lost_to;
    subject = lost_subject;
    message = typeof(lost_message) != LIST ? {lost_message} | lost_message;
  else
    folder = toobj(folder);
    msg_nr = toint(msg_nr);
    message = folder.messages[msg_nr];
    if ($object_utils:isa(folder, $mail_agent))
      to = "*" + message[2][2];
    else
      to = message[2][2];
    endif
    subject = message[2][4];
    if (!match(subject, "Re: "))
      subject = "Re: " + subject;
      onload = "document.getElementById('message').focus()";
    endif
    if (quote == "yes")
      "Include original mail message";
      original = message[2][6..$];
      onload = "document.getElementById('message').focus()";
    endif
  endif
endif
editor = $list_utils:append($encore_web_utils:p($list_utils:append({strings[19]}, {": "}, $encore_web_utils:input("to", to, "20", "text"), {"(", strings[38], ")"})));
editor = $list_utils:append(editor, $encore_web_utils:p($list_utils:append({strings[17]}, {": "}, $encore_web_utils:input("subject", subject, "40", "text"))));
if (lost_to || lost_subject || lost_message)
  for line in (lost_message)
    msg_data = {@msg_data, line};
  endfor
else
  for line in (original)
    newline = "> " + line;
    msg_data = {@msg_data, newline};
  endfor
endif
editor = $list_utils:append(editor, $encore_web_utils:p($encore_web_utils:textarea(msg_data, "message", "20", "75")));
editor = $list_utils:append(editor, $encore_web_utils:p(), $encore_web_utils:input("signature", "yes", "", "checkbox", "", toint(user.signature_by_default) ? "checked" | ""), {strings[39]});
editor = $list_utils:append(editor, $encore_web_utils:input("MOOmail", strings[40], "", "submit"));
editor = $list_utils:append(editor, $encore_web_utils:input("wac", crypt(user.web_access_code), "", "hidden"));
if (($network.active && $Xpress_client.allow_internet_mail) && (!$anonymous_users))
  editor = $list_utils:append(editor, $encore_web_utils:input("email", strings[41], "", "submit"));
endif
editor = $list_utils:append(editor, $encore_web_utils:input("close_window", strings[5], "", "button", tostr("onclick=\"if(confirm('", $string_utils:escape(strings[43]), "')){parent.close();}\"")));
editor = $encore_web_utils:form(editor, "editor", "/Xpress_MOO_mailer/send_mail");
body = $list_utils:append(title, editor);
if (caller == this)
  return body;
endif
result = this:build(user, body, "MOO Mail Editor", onload);
return result;
.

@verb $encore_web_utils:"check_wac" this none this rxd
@program $encore_web_utils:check_wac
" ==========================================================";
" :chck_wac(user, wac)                                      ";
" encrypts the string wac and compares to user's web access ";
" code. => 1 if match, 0 if !match.                         ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
"Returning only true for now. Need to find out why send mail throws a wac error. Jan 01/01/04";
{user, wac} = args;
wac = tostr(wac);
return strcmp(crypt(user.web_access_code, wac), wac) ? 0 | 1;
.


@program $Xpress_MOO_Mailer:send_mail
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Send email and MOO mail from Xpress                       ";
" ==========================================================";
" Added copy to OutBox, took out strings. Added recover.    ";
" Security Patch: Made it spoof proof.                      ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
body = {};
alert = "";
if (data == {{}, {}})
  "No form data supplied";
  out = "400_Bad_Request";
else
  {wac, recipients, subject, message, MOOmail, email, signature} = $list_utils:map_formdata(data, {{"wac", 0}, {"to", 0}, {"subject", ""}, {"message", {}}, {"MOOmail", 0}, {"email", 0}, {"signature", 0}});
  strings = this.xpress_moo_mailer_strings;
  if (!$encore_web_utils:check_wac(user, wac))
    " --- we're being spoofed! --- ";
    alert = tostr("alert('", $string_utils:escape(strings[51]), "')");
  else
    lost_recipients = recipients;
    recipients = $string_utils:explode(tostr(recipients));
    from = user;
    out = to = names = invalids = {};
    alert = "";
    out = $encore_web_utils:get_page_properties(user, this);
    (typeof(message) != LIST) ? message = {message} | 0;
    if (signature && length(user.web_mail_signature))
      signature = user.web_mail_signature;
      (typeof(signature) != LIST) ? signature = {signature} | 0;
      message = {@message, "-- ", @signature};
    endif
    for recipient in (recipients)
      "Check if recipient is a valid mail recipient";
      object = $mail_agent:match_recipient_new(recipient);
      if (valid(object))
        to = {@to, object};
      else
        invalids = {@invalids, recipient};
      endif
    endfor
    "Compile list of recipient names";
    for n in [1..length(to)]
      names = {@names, to[n].name};
    endfor
    if (to)
      "Send mail to recipients and return status messages";
      if (((email && $network.active) && $xpress_client.allow_internet_mail) && (!$anonymous_users))
        origin = {"--", tostr("This email was sent with enCore Xpress ", $core_version, " from ", $network.MOO_name, " at http://", $network.site, ":", $network.webport, "/"), "--"};
        message = $list_utils:append(message, origin);
        success = 0;
        for n in (to)
          if ($object_utils:isa(n, $player))
            if (result = this:sendmail(user, n.email_address, subject, @message))
              alert = tostr("alert('", $string_utils:escape(strsub(strings[45], "%reason.why", result)), "');document.getElementById('to').focus();\"");
              body = this:compose(user, {{"lost_to", "lost_subject", "lost_message"},{lost_recipients, subject, message}});
              break;
            else
              success = 1;
            endif
          else
            alert = tostr("alert('", $string_utils:escape(strings[46]), "');document.getElementById('to').focus();\"");
            body = this:compose(user, {{"lost_to", "lost_subject", "lost_message"},{lost_recipients, subject, message}});
            break;
          endif
        endfor
        if (success)
          alert = tostr("alert('", $string_utils:escape(strings[47]), "');parent.focus();self.close();");
          body = {};
        endif
      else
        player = user;
        $mail_agent:send_message(from, to, subject, message);
        to_string = "";
        for d in (to)
          to_string = tostr(to_string, d.name, " (", d, "), ");
        endfor
        to_string = to_string[1..$ - 2];
        new_nr = length(from.messages_out) + 1;
        from.messages_out = {@from.messages_out, {new_nr, {time(), toliteral(from), to_string, subject, "", @message}}};
        alert = tostr("alert('", $string_utils:escape(strsub(strings[44], "%to", $string_utils:english_list(names))), "');parent.focus();self.close();");
        body = {};
      endif
    else
      "Notify user that one or more of the recipients are invalid";
      alert = tostr("alert('", $string_utils:escape(strsub(strings[48], "%$network.MOO_name", $network.MOO_name)), "');document.getElementById('to').focus()");
      body = this:compose(user, {{"lost_to", "lost_subject", "lost_message"},{lost_recipients, subject, message}});
    endif
  endif
endif
result = this:build(user, body, "MOO Mail Editor", alert);
return result;
.

@program $Xpress_MOO_Mailer:subscribe
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Form for subscribing and unsubscribing from MOO mail lists";
" ==========================================================";
" Took out strings. Security patch: Made it spoof proof.    ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
alert = "";
body = {};
strings = this.xpress_moo_mailer_strings;
if (data != {{}, {}})
  {subscriptions, wac} = $list_utils:map_formdata_all(data, {{"mlist", {}}, {"wac", 0}});
  if (typeof(subscriptions) != LIST)
    subscriptions = {subscriptions};
  endif
  if (!$encore_web_utils:check_wac(user, wac))
    " --- we're being spoofed! --- ";
    alert = tostr("alert('", $string_utils:escape(strings[51]), "')");
  else
    old_lists = new_lists = {};
    for n in (subscriptions)
      new_lists = {@new_lists, toobj(n)};
    endfor
    for n in (user.current_message[3..$])
      old_lists = {@old_lists, n[1]};
    endfor
    "Add new lists";
    for new in (new_lists)
      found = 0;
      for old in (old_lists)
        if (new == old)
          found = 1;
          break;
        endif
      endfor
      if (!found)
        user:make_current_message(new);
      endif
    endfor
    "Remove unsubscribed lists";
    for old in (old_lists)
      found = 0;
      for new in (new_lists)
        if (old == new)
          found = 1;
          break;
        endif
      endfor
      if (!found)
        old:delete_notify(user);
        user:kill_current_message(old);
      endif
    endfor
    alert = tostr("alert('", $string_utils:escape(strings[71]), "')");
  endif
  result = this:folders_html(user, alert);
  return result;
else
  form = form1 = form2 = mail_box = {};
  title = $encore_web_utils:get_title(user, this, "MOO Mailing Lists");
  {help_button, help_window_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Mailing_Lists");
  help_window_function = $encore_web_utils:insert_javascript(help_window_function);
  intro = $encore_web_utils:p($string_utils:subst(strings[67], {{"%$network.MOO_name", $network.MOO_name}, {"%Update_Subscriptions", strings[70]}}));
  cm = user.current_message;
  cm[1..2] = (verb == "@rn") ? {{this, @cm[1..2]}} | {};
  for item in (cm)
    mail_box = {@mail_box, item[1]};
  endfor
  for mlist in ($mail_agent.contents)
    "Cycle through available mailing lists";
    if (mlist:is_usable_by(user) && mlist:is_readable_by(user))
      form1 = {@form1, $encore_web_utils:input("mlist", mlist, "", "checkbox", "", (mlist in mail_box) ? "checked" | "")[1] + mlist.name};
      (typeof(mlist.description) != LIST) ? mlist.description = {mlist.description} | 0;
      for line in (mlist.description)
        form2 = {@form2, line};
      endfor
    endif
  endfor
  form1 = $list_utils:append({$encore_web_utils:div(strings[68], "header")}, form1);
  form2 = $list_utils:append({$encore_web_utils:div(strings[69], "header")}, form2);
  form = $encore_web_utils:generate_table(user, {form1, form2}, this, "1");
  form = $list_utils:append(form, $encore_web_utils:input("wac", crypt(user.web_access_code, user.web_access_code), "", "hidden"));
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("submit", strings[70], "", "submit"), $encore_web_utils:close());
  form = $encore_web_utils:form(form, "lists", "/Xpress_MOO_mailer/subscribe", tostr("setTimeout('self.close()',", $xpress_client.window_close_timeout, ");"), "folder");
  body = $list_utils:append(help_window_function, title, help_button, intro, form);
endif
result = this:build(user, body, "MOO Mailing Lists", alert);
return result;
.

@verb $Xpress_MOO_Mailer:"search" this none this rxd
@program $Xpress_MOO_Mailer:search
" ==========================================================";
" Copyright (C) 2003, Daniel Jung                           ";
" Make a search for a string in subscribed mailboxes.       ";
" Store query and result. Display found messages.           ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data, ?alert = ""} = args;
strings = this.xpress_moo_mailer_strings;
result = {};
{page, sstring, newsearch} = $list_utils:map_formdata(data, {{"page", 1}, {"sstring", ""}, {"newsearch", 0}});
page = toint(page);
if (newsearch)
  if (!length(sstring))
    table = {strings[29]};
  else
    "-----------------------";
    " --- update search --- ";
    "-----------------------";
    boxes = {user};
    for cm in (user.current_message)
      if ((typeof(cm) == LIST) && (!$object_utils:isa(cm[1], $big_mail_recipient)))
        boxes = {@boxes, cm[1]};
      endif
    endfor
    hits = {};
    for box in (boxes)
      suspend(0);
      for msg in (box.messages)
        suspend(0);
        for line in (msg[2])
          suspend(0);
          if (index(toliteral(line), sstring))
            hits = {@hits, {box, "", msg[1], msg[2][1]}};
            break;
          endif
        endfor
      endfor
    endfor
    for msg in (user.messages_out)
      suspend(0);
      for line in (msg[2])
        suspend(0);
        if (index(toliteral(line), sstring))
          hits = {@hits, {user, "OutBox", msg[1], msg[2][1]}};
          break;
        endif
      endfor
    endfor
    hits = $list_utils:reverse($list_utils:sort_alist(hits, 4));
    user.messages_search = {sstring, hits};
  endif
else
  sstring = user.messages_search[1];
endif
folder_name = this:get_mailfolder_name(user, "Search", sstring);
title = $encore_web_utils:get_subtitle(user, this, folder_name);
base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_MOO_mailer/");
mail_reader = $encore_web_utils:javascript_window_open($Xpress_MOO_mailer, "openMailReader", "");
open_mail_reader = $encore_web_utils:insert_javascript(mail_reader);
subject = from = where = date = quick_access = {};
chunks = 1;
if (user.messages_search)
  len = length(user.messages_search[2]);
  if ((!len) || (!length(sstring)))
    table = {strings[29]};
  else
    mtd = user.messages_to_display;
    chunks = (len / mtd) + (((len % mtd) > 0) ? 1 | 0);
    page = min(chunks, page);
    first = 1 + ((page - 1) * mtd);
    last = min((first + mtd) - 1, len);
    subject = {tostr($encore_web_utils:div(strings[17], "header"), $encore_web_utils:br())};
    from = {tostr($encore_web_utils:div(strings[18], "header"), $encore_web_utils:br())};
    where = {tostr($encore_web_utils:div(strings[20], "header"), $encore_web_utils:br())};
    date = {tostr($encore_web_utils:div(strings[21], "header"), $encore_web_utils:br())};
    ums2 = user.messages_search[2];
    for n in [first..last]
      suspend(0);
      message = (ums2[n][2] == "OutBox") ? ums2[n][1].messages_out[ums2[n][3]] | ums2[n][1].messages[ums2[n][3]];
      subj = tostr(n, " ", message[2][4]);
      sender = tostr(message[2][2]);
      loc = tostr(base_url, "view.html?obj=", toint(ums2[n][1]), ";index=", ums2[n][3], ";box=", ums2[n][2], ";sstring=", this:encode(user.messages_search[1]));
      if (user.messages_in_main_window)
        subject = {@subject, $encore_web_utils:a(tostr(loc, ";view=pre"), subj, "message")};
       else
        window_name = tostr(strsub($network.MOO_name, " ", "_"), "_openMailReader");
        subject = {@subject, $encore_web_utils:a(loc, subj, window_name, "onclick=\"openMailReader()\"")};
      endif
      from = {@from, sender};
      where = {@where, tostr(this:get_mailfolder_name(ums2[n][1], ums2[n][2]), ":", ums2[n][3])};
      date = {@date, this:get_date(message[2][1])};
    endfor
    table = $encore_web_utils:generate_table(user, {subject, from, where, date}, this, 1);
    table = {@table, $encore_web_utils:br()};
  endif
  if (chunks > 1)
    for chunk in [1..chunks]
      quick_access = (chunk == page) ? {@quick_access, $encore_web_utils:b(page)} | {@quick_access, $encore_web_utils:a(tostr(base_url, "search?page=", chunk), chunk)};
    endfor
    if (page > 1)
      quick_access = {$encore_web_utils:a(tostr(base_url, "search?page=", page - 1), tostr("[&lt;&lt; ", strings[14], "]")), @quick_access};
    endif
    if (page < chunks)
      quick_access = {@quick_access, $encore_web_utils:a(tostr(base_url, "search?page=", page + 1), tostr("[", strings[15], " &gt;&gt;]"))};
    endif
    quick_access = $encore_web_utils:align(quick_access, "center");
  endif
endif
body = $list_utils:append(open_mail_reader, title, quick_access, table, quick_access);
result = this:build(user, body, "MOO Mailer Contents", alert);
return result;
.

@verb $Xpress_MOO_Mailer:"encode decode" this none this rxd
@program $Xpress_MOO_Mailer:encode
" ==========================================================";
" :encode decode(STR input). Used to send search strings    ";
" in URLs. This isn't encoding encoded strings; this verb   ";
" should be replaced by a _real_ URLencode method.          ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
{input} = args;
rows = {{"$", "&", "+", ",", "/", ":", ";", "=", "?", "@", " ", "\"", "<", ">", "#", "%", "{", "}", "|", "\\", "^", "~", "[", "]"}, {"%24", "%26", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%20", "%22", "%3C", "%3E", "%23", "%25", "%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60"}};
output = "";
if (verb == "encode")
  for i in [1..length(input)]
    enc = $list_utils:passoc(input[i], rows[1], rows[2]);
    output = enc != {} ? tostr(output, enc[2]) | tostr(output, input[i]);
  endfor
else
  pos = 1;
  if (length(input) > 2)
    while (pos + 2 <= length(input))
      if (n = input[pos..pos + 2] in rows[2])
        output = tostr(output, rows[1][n]);
        pos = pos + 3;
      else
        output = tostr(output, input[pos]);
        pos = pos + 1;
      endif
    endwhile
    output = tostr(output, input[$ - 1..$]);
  else
    output = input;
  endif
endif
return output;
.


@verb $list_utils:"map_formdata*_all" this none this rxd
@program $list_utils:map_formdata*_all
" ==========================================================";
" Copyright (C) Daniel Jung, Nov. 2003                      ";
" ==========================================================";
" $list_utils:map_formdata*_all(formdata, elements)         ";
" where formdata = LIST(LIST keys, LIST values), and        ";
" elements = LIST(LIST(key, default)[,LIST(key, default)]..)";
" returns the value found in FORMDATA[2] corresponding to   ";
" the key in ELEMENTS found in FORMDATA[1]. If none is      ";
" found, the default value provided by ELEMENTS is returned.";
" :map_formdata returns the first occurence,                ";
" :map_formdata_all gathers all results in a list.          ";
" ==========================================================";
{formdata, elements} = args;
v = index(verb, "_all") ? "passoc_all" | "passoc";
if (length(elements) == 1)
  retrieve = this:(v)(elements[1][1], formdata[1], formdata[2]);
  retrieved = retrieve != {} ? retrieve[2] | elements[1][2];
  result = retrieved;
else
  result = {};
  for e in (elements)
    retrieve = this:(v)(e[1], formdata[1], formdata[2]);
    retrieved = retrieve != {} ? retrieve[2] | e[2];
    result = {@result, retrieved};
  endfor
endif
return result;
.

@verb $list_utils:"passoc_all" this none this rxd
@program $list_utils:passoc_all
" ==========================================================";
" :passoc_all(key,list1,list2)                              ";
" search through ALL of list1 for key and return its        ";
" corresponding element in list2.                           ";
" => {} when none is found, else => {key, LIST}             ";
" Daniel Jung, Nov. 2003                                    ";
" ==========================================================";
{key, list1, list2} = args;
hits = this:index_all(list1, key);
if (!hits)
  return {};
elseif (length(hits) == 1)
  return {key, list2[hits[1]]};
else
  result = {};
  for n in (hits)
    result = {@result, list2[n]};
  endfor
endif
result = {key, result};
return result;
.

@verb $list_utils:"index_all" this none this rxd
@program $list_utils:index_all
" ==========================================================";
" :index_all(list, key)                                     ";
" returns the positions of elements in LIST which match KEY.";
" ==========================================================";
{lst, key} = args;
result = {};
for n in [1..length(lst)]
  if (lst[n] == key)
    result = {@result, n};
  endif
endfor
return result;
.

@verb $string_utils:"escape" this none this rxd
@program $string_utils:escape
" ==========================================================";
" :escape(STR string, STR char)                             ";
" returns the string with escaped chars.                    ";
" char defaults to single quote. Used for javascript.       ";
" ==========================================================";
{string, ?what = "'"} = args;
return strsub(string, what, tostr("\\", what));
.


@program $mail_recipient_class:oldest_nonread
" ==========================================================";
" Returns the number of the first message after last logoff ";
" Daniel Jung, Nov. 2003                                     ";
" ==========================================================";
ldt = this.last_disconnect_time;
for msg in (this.messages)
  if (toint(msg[2][1]) > ldt)
    return msg[1];
  endif
endfor
return length(this.messages);
.

@program $xpress_client:check_moo_mail
" ==========================================================";
" Copyright (C) 1999-2004, Jan Rune Holmevik                ";
" Create sound tag if user has new mail                     ";
" and has sound turned on                                   ";
" ==========================================================";
" Added custom sound override. Daniel Jung, Nov. 2003       ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
sound = {};
try
  new_mail = user:length_all_msgs() - user:length_date_le(user:get_current_message()[2]);
  if (new_mail)
    ms = $object_utils:isa(user, $mail_recipient_class) && length(user.mail_notify_sound_custom) ? user.mail_notify_sound_custom | user.mail_notify_sound;
    sound = $encore_web_utils:make_sound(user, ms);
  endif
except error (ANY)
  "Ignore error in order to avoid breaking login.";
endtry
return sound;
.

"-------------------- end new MOO mailer code

@program $xpress_object_editor:main_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main Object Editor screen";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_Object_Editor/");
menu_frame = tostr(base_url, "menu.html");
class_frame = tostr(base_url, "blank.html");
editor_frame = tostr(base_url, "blank.html");
html = {             "<frameset cols=\"50%\">"};
html = {@html,       "   <noframes>"};
html = {@html,       "      <body><h3>Sorry you need a browser that supports frames to use this system</h3></body>"};
html = {@html,       "   </noframes>"};
html = {@html,       "   <frameset cols=\"50%\">"};
html = {@html,       "      <frameset rows=\"95,82%\">"};
html = {@html, tostr("         <frame src=\"", menu_frame, "\" id=\"menu\" name=\"menu\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "         <frameset cols=\"70%,30%\">"};
html = {@html, tostr("            <frame src=\"", editor_frame, "\" id=\"view\" name=\"view\" noresize=\"noresize\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html, tostr("            <frame src=\"", class_frame, "\" id=\"classes\" name=\"classes\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" frameborder=\"", this.frameborder, "\" />")};
html = {@html,       "         </frameset>"};
html = {@html,       "      </frameset>"};
html = {@html,       "   </frameset>"};
html = {@html,       "</frameset>"};
result = this:build(user, html, "Xpress Object Editor", "", "", "", "", this.doctype_frameset);
return result;
.

@program $xpress_object_editor:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
menu = buttons = {};
base_url = tostr($encore_web_utils:baseurl(), "Xpress_Object_Editor/");
{help_button, help_window_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Object_Editor");
help_window_function = $encore_web_utils:insert_javascript(help_window_function);
buttons = $list_utils:append(help_button, $encore_web_utils:input("search_string", "", "20", "text"));
buttons = $list_utils:append(buttons, $encore_web_utils:input("submit", "View", "", "submit"));
buttons = $list_utils:append(buttons, $encore_web_utils:input("view", "My Objects", "", "button", tostr("onclick=\"parent.classes.location.href = '", base_url, "list_objects_html", "'\"")));
buttons = $list_utils:append(buttons, $encore_web_utils:input("create", "Create New Object", "", "button", tostr("onclick=\"parent.classes.location.href = '", base_url, "classes_html", "'\"")));
buttons = $list_utils:append(buttons, $encore_web_utils:close("parent"));
title = $encore_web_utils:get_title(user, this, "Xpress Object Editor");
menu = $list_utils:append(title, buttons);
menu = $encore_web_utils:form(menu, "search", "/Xpress_Object_Editor/view_html", "", "view");
body = $list_utils:append(help_window_function, menu);
result = this:build(user, body, "Xpress Object Editor", $encore_web_utils:focus_field("search_string"), "properties");
return result;
.

@program $xpress_object_editor:view_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"User wants to edit an object. Check if object exists, is";
"reachable and editable by user.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, form_data, ?alert = ""} = args;
body = data = {};
if (form_data != {{}, {}})
  "User has asked for an object to view";
  requested = form_data[2][1];
  if (valid(object = $string_utils:match_object(requested, user.location, user)) || valid(object = $string_utils:match_object(tostr("#", requested), user.location, user)))
    if ($encore_web_utils:permission_to_edit(user, object))
      body = this:editor_html(user, object);
    else
      alert = tostr("alert('Sorry, you may only work with objects that you own. The object, ", object.name, " belongs to ", object.owner.name, ".')");
    endif
  else
    alert = "alert('Could not find an object by that name. You must either hold an object, or be in the same room as the object in order to refer to it by name.')";
  endif
else
  "If no arguments are passed return user's edit options by default";
  body = this:editor_html(user, user);
endif
result = this:build(user, body, "Xpress Edit", alert);
return result;
.

@program $xpress_object_editor:editor_html
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Build actions and editable properties for an object";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
edit_action = 0;
stats = buttons = menu = form = {};
if (typeof(data) == LIST)
  "------------------------------------------------------------";
  " User has selected an editing option";
  "------------------------------------------------------------";
  object = toobj(data[2][1]);
  edit_action = data[2][2];
else
  object = toobj(data);
endif
base_url = $encore_web_utils:baseurl();
confirmDelete = {"function confirmDelete() {", tostr("   if (confirm('", $xpress_program_editor:delete_warning(object), " Are you sure you want to permanently recycle this object? This action cannot be undone!')) {"), tostr("       location.href = '", base_url, "Xpress_object_editor/recycle_object?", toint(object), "';"), "       return true;", "   }", "   return false;", "}"};
functions = $encore_web_utils:insert_javascript(confirmDelete);
"----------------------------------------------------------------";
" Build display header";
"----------------------------------------------------------------";
if (edit_action)
  start = $string_utils:capitalize($string_utils:substitute(edit_action, {{"_", " "}}));
else
  start = "Editing";
endif
title = $encore_web_utils:get_subtitle(user, this, tostr(start, ": ", $string_utils:capitalize(object.name), " (", object, ")"));
"----------------------------------------------------------------";
" Build actions and editing options for this object";
"----------------------------------------------------------------";
buttons = {};
if (!is_player(object))
  buttons = $list_utils:append(buttons, $encore_web_utils:input("recycle", "Recycle This Object", "", "button", "onclick=\"return confirmDelete()\""));
endif
if ($object_utils:isa(object, $room))
  buttons = $list_utils:append(buttons, $encore_web_utils:input("GoTo", "Go to Room", "", "button", tostr("onclick=\"location.href = '", base_url, "Xpress_Object_Editor/move_to_room?", toint(object), "'\"")));
endif
buttons = $list_utils:append(buttons, $encore_web_utils:close("parent"));
buttons = $encore_web_utils:form(buttons);
"----------------------------------------------------------------";
" Add context sensitive help";
"----------------------------------------------------------------";
{help_button, help_window} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Quick_Editing");
help_window = $encore_web_utils:insert_javascript(help_window);
help = $list_utils:append(help_button, help_window);
"----------------------------------------------------------------";
" Generate list of most important editable properties";
"----------------------------------------------------------------";
hidden = $encore_web_utils:input("object", toint(object), "", "hidden");
properties = $list_utils:append($encore_web_utils:option("Select option to edit", ""), object:xpress_edit(user));
properties = $encore_web_utils:select(properties, "Edit_Options", "onchange=this.form.submit()");
prop_list = $list_utils:append(hidden, properties);
prop_list = $encore_web_utils:form(prop_list, "edit", "/Xpress_Object_Editor/Editor.html");
menu = $list_utils:append(prop_list, buttons);
"----------------------------------------------------------------";
" Add editing form if requested";
"----------------------------------------------------------------";
if (edit_action)
  form = $list_utils:append(form, this:(edit_action)(user, object));
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("submit", "Save Changes", "", "submit")); 
  form = $list_utils:append(hidden, form);
  if (edit_action == "edit_password")
    form = $encore_web_utils:form(form, "Change_Password", "/Xpress_Object_Editor/change_password");
  elseif (edit_action == "edit_sharing")
    form = $encore_web_utils:form(form, "Share_Object", "/Xpress_Object_Editor/share_object");
  else
    form = $encore_web_utils:form(form, "Xpress_Edit", "/Xpress_Object_Editor/save_property");
  endif
  form = $list_utils:append($encore_web_utils:hr(), form, $encore_web_utils:hr());
endif
body = $list_utils:append(functions, title, stats, help, menu, form);
return body;
.

@program $xpress_object_editor:list_objects_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Lists a user's objects";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
body = objects = {};
base_url = tostr($encore_web_utils:baseurl(), "Xpress_Object_Editor/view_html");
title = $encore_web_utils:get_subtitle(user, this, "My Objects");
for object in (user.owned_objects)
  "Compile list of objects the user owns";
  if ($object_utils:isa(object, $encore_web_class))
    if (object.icon != "")
      objects = {@objects, tostr($encore_web_utils:a(tostr(base_url, "?", toint(object)), object.name, "", "", $encore_web_utils:get_icon(user, object)))};
    else
      objects = {@objects, tostr($encore_web_utils:a(tostr(base_url, "?", toint(object)), object.name))};
    endif
    objects = {@objects, $encore_web_utils:br()};
  endif
endfor
body = $list_utils:append(title, objects);
result = this:build(user, body, "My Objects", "", "view");
return result;
.

@program $xpress_object_editor:classes_html
"===========================================================";
"Copyright (C) 1998-2004, Jan Rune Holmevik";
"Display a list of generics sorted in categories";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
result = body = {};
alert = "";
base_url = $encore_web_utils:baseurl();
external_baseurl = $xpress_client.external_baseurl + $xpress_client.icons_folder;
title = $encore_web_utils:get_subtitle(user, this, "Types of Objects");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $builder_help, "Xpress_Generics");
functions = $encore_web_utils:insert_javascript(help_function);
if ({{}, {}} == data)
  requested = 0;
else
  requested = data[2][1];
endif
try
  body = $encore_web_utils:p();
  generics = this.generics;
  for n in [1..length(generics)]
    body = $list_utils:append(body, $encore_web_utils:p());
    if (n == toint(requested))
      body = {@body, tostr($encore_web_utils:a(tostr(base_url, "Xpress_object_editor/classes.html?", n), generics[n][1], "", "", $encore_web_utils:img(tostr(external_baseurl, "list_view2.gif"))))};
      body = {@body, $encore_web_utils:br()};
      for object in (generics[n][2])
        body = {@body, tostr($encore_web_utils:a(tostr(base_url, "xpress_object_editor/create.html?", toint(object)), object.name, "view", "", $encore_web_utils:get_icon(user, object)))};
      body = {@body, $encore_web_utils:br()};
      endfor
    else
      body = {@body, tostr($encore_web_utils:a(tostr(base_url, "Xpress_object_editor/classes.html?", n), generics[n][1], "", "", $encore_web_utils:img(tostr(external_baseurl, "list_view1.gif"))))};
      body = {@body, $encore_web_utils:br()};
    endif
  endfor
except error (ANY)
  alert = "alert('There is a problem with the Xpress Class Browser. Please notify a MOO administrator!')";
endtry
body = $list_utils:append(functions, title, help_button, body);
result = this:build(user, body, "Xpress Class Browser", alert);
return result;
.

@program $xpress_object_editor:create_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Handle web creation of MOO objects";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, requested, ?alert = ""} = args;
body = form = title = {};
if ({{}, {}} != requested)
  if ($object_utils:isa(user, $builder))
    data = requested;
    object = toobj(data[2][1]);
    if (1 == length(data[2]))
      "User wants to create new object";
      title = $encore_web_utils:get_subtitle(user, this, tostr("Creating new ", $string_utils:substitute(object.name, {{"generic", ""}})));
      creation_form = object:creation_form_html(user, object);
      creation_form = $list_utils:append(creation_form, $encore_web_utils:p(), $encore_web_utils:input("submit", "Create", "", "submit"));
      creation_form = $encore_web_utils:form(creation_form, "create", "/Xpress_Object_Editor/create_new_object");
      alert = tostr(alert, $encore_web_utils:focus_field("name"));
      body = $list_utils:append(title, creation_form);
    endif
  else
    "User is not a builder but has requested this verb anyway.";
    return "403_Forbidden";
  endif
endif
result = this:build(user, body, "Create Object", alert);
return result;
.

@program $encore_web_class:creation_form_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generate a form for creation data";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, type} = args;
form = $encore_web_utils:input("parent", toint(type), "", "hidden");
form = $list_utils:append(form, $encore_web_utils:p("Please type a name for the new object"), $encore_web_utils:input("name", "", "20", "text"));
return form;
.


@program $room:creation_form_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generate a form for creating a new room";
"===========================================================";
if (caller != $Xpress_Object_Editor)
  return E_PERM;
endif
{user, object} = args;
start_form = pass(@args);
{help_button, help_window_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Creating_Rooms");
help_window_function = $encore_web_utils:insert_javascript(help_window_function);
form = owned_rooms = connections = {};
if (match($string_utils:print(user.location.shared_owners), tostr(user)) || user.wizard)
  owned_rooms = {@owned_rooms, user.location};
endif
for OBJ in (user.owned_objects)
  "Find all the users' non-fertile rooms";
  if ($object_utils:isa(OBJ, $room) && !OBJ.f)
    owned_rooms = {@owned_rooms, OBJ};
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), help_button, $encore_web_utils:p());
if (!owned_rooms)
  "User wants to create their first room, add valid connection points";
  owned_rooms = $list_utils:append(owned_rooms, $room_connection_points);
endif
if (owned_rooms)
  form = $list_utils:append(form, $encore_web_utils:input("connect", "0", "", "radio", ""), {" Do not connect my new room to another room "}, $encore_web_utils:p());
  form = $list_utils:append(form, $encore_web_utils:input("connect", "1", "", "radio", "", "checked"), {" Connect my new room to "});
  for room in (owned_rooms)
    if (room == user.location)
      connections = $list_utils:append(connections, $encore_web_utils:option(room.name, toint(room), "selected"));
    else
      connections = $list_utils:append(connections, $encore_web_utils:option(room.name, toint(room)));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(connections, "origin"));
else
  "This is the user's first room and no connection point has been defined.";
  form = $list_utils:append(form, $encore_web_utils:input("connect", "0", "", "hidden"));
  form = $list_utils:append(form, $encore_web_utils:input("origin", "", "", "hidden"));
  form = $list_utils:append(form, $encore_web_utils:input("entrance", "", "", "hidden"));
  form = $list_utils:append(form, $encore_web_utils:input("exit", "", "", "hidden"));
  form = $list_utils:append(form, $encore_web_utils:p(tostr("This will be your first room in ", $network.MOO_name, ". As such, it will not be connected to the rest of the MOO yet. You will therefore need to contact one of the MOO administrators and ask them to connect it for you.")));
endif
result = $list_utils:append(help_window_function, start_form, form);
return result;
.

@program $xpress_object_editor:create_new_object
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Perform permission checks and creates new objects and rooms";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
alert = sethome = "";
body = {};
base_url = $encore_web_utils:baseurl();
if (data == {{}, {}})
  return "400_Bad_Request";
elseif (!$object_utils:isa(user, $builder))
  return "403_Forbidden";
else
  "-------------------------------------";
  "Check that the user has provided necessary data";
  "-------------------------------------";
  parent = toobj(data[2][1]);
  name = $encore_web_utils:decode_url(data[2][2]);
  if (name == "")
    vrb = "create_html";
    object = parent;
    alert = "You must name the object you wish to create. Please try again.";
  else
    "-------------------------------------";
    "Attempt to create new object";
    "-------------------------------------";
    new_object = user:_create(parent, user);
    if (typeof(new_object) == ERR)
      "Modified by Traveller 7/15/01 to prevent a traceback when over quota...";
      vrb = "create_html";
      object = parent;
      alert = "Quota limit exceeded, cannot create a new object at this time. Please recycle some of your objects, or contact a wizard to get more quota.";
    else
      destination = user;
      for f in ($string_utils:char_list(user:build_option("create_flags") || ""))
        new_object.(f) = 1;
      endfor
      $building_utils:set_names(new_object, name);
      $byte_quota_utils:object_size(new_object);
      if ($object_utils:isa(parent, $room))
        "-------------------------------------";
        "User has created a room";
        "-------------------------------------";
        destination = $nowhere;
        connect_room = data[2][3];
        if (connect_room == "1")
          "-------------------------------------";
          "User wants to connect her new room";
          "-------------------------------------";
          origin = toobj(data[2][4]);
          entrance_name = tostr("To_", $string_utils:substitute(new_object.name, {{" ", "_"}}));
          exit_name = tostr("To_", $string_utils:substitute(origin.name, {{" ", "_"}}));
          do_recreate = !user:build_option("bi_create");
          {exit, alert} = this:make_exit(user, entrance_name, origin, new_object, do_recreate, $exit);
          if (alert == "" && exit != "")
            {exit, alert} = this:make_exit(user, exit_name, new_object, origin, do_recreate, $exit);
          endif
        endif
        "-------------------------------------";
        "Make room user's home if it's her first room";
        "-------------------------------------";
        if (user.home == $player.home && $object_utils:isa(new_object, $room) && new_object:accept_for_abode(user))
          user.home = new_object;
          sethome = tostr(" ", new_object.name, " is now your new MOO home. You will start here each time you connect. You can get to your home by typing the command HOME at anytime, anywhere in the MOO.");
        endif
      endif
      `move(new_object, destination) ! ANY';
      alert = tostr("New object named ", new_object.name, " created.");
      vrb = "view_html";
      object = new_object;
    endif
  endif
endif
result = this:(vrb)(user, {{}, {tostr(object)}}, $encore_web_utils:make_alert(alert + sethome));
return result;
.


@program $encore_web_class:xpress_edit
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Assemble the most important properties for quick ";
"and easy editing.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
options = {};
if (!$object_utils:isa(caller, $player) && user == this.owner)
  options = $list_utils:append(options, $encore_web_utils:option("Share This Object", "edit_sharing"));
endif
options = $list_utils:append(options, $encore_web_utils:option("Edit Name and Alias", "edit_name"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Multi-media Content", "edit_url"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Icon", "edit_icon"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Description", "edit_description"));
options = $list_utils:append(options, $encore_web_utils:option("Edit ASCII Art", "edit_ascii"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Appearance", "edit_appearance"));
return options;
.

@program $player:xpress_edit
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Assemble the most important properties for quick ";
"and easy editing.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
options = pass(@args);
options = $list_utils:append(options, $encore_web_utils:option("Change Password", "edit_password"));
options = $list_utils:append(options, $encore_web_utils:option("Change Gender", "edit_gender"));
options = $list_utils:append(options, $encore_web_utils:option("Edit User Information", "edit_player_info"));
"Not currently in use options = $list_utils:append(options, $encore_web_utils:option(Edit Player Messages, edit_player_messages))";
options = $list_utils:append(options, $encore_web_utils:option("Edit Theme and Appearance", "edit_theme"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Screen Size and Layout", "edit_screen_layout"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Chat Settings", "edit_java_settings"));
options = $list_utils:append(options, $encore_web_utils:option("Edit Sound Settings", "edit_sound_settings"));
return options;
.

@program $lecture:xpress_edit
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Assemble the most important properties for quick and easy editing.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
options = pass(@args);
options = $list_utils:append(options, $encore_web_utils:option("Edit Lecture Text", "edit_lecture_text"));
return options;
.

@program $webprojector:xpress_edit
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Assemble the most important properties for quick and easy editing.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
options = pass(@args);
options = $list_utils:append(options, $encore_web_utils:option("Edit Web Slides", "edit_web_slides"));
return options;
.

@verb $mail_recipient_class:"xpress_edit" this none this rxd
@program $mail_recipient_class:xpress_edit
" ==========================================================";
" Daniel Jung, Nov. 2003. Based on the passing verbs.       ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
strings = $Xpress_MOO_Mailer.xpress_moo_mailer_strings;
options = pass(@args);
options = $list_utils:append(options, $encore_web_utils:option(strings[53], "edit_mail_options"));
return options;
.


@program $xpress_object_editor:edit_sharing
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Form for editing sharing of objects.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
owners = object.shared_owners;
{help_button, help_window} = $encore_web_utils:insert_context_sensitive_help(user, $builder_help, "Xpress_Object_Sharing");
help_window = $encore_web_utils:insert_javascript(help_window);
form = $list_utils:append(help_button, help_window);
form = $list_utils:append(form, $encore_web_utils:p("Enter object numbers for users you wish to share this object with. Enter only one user per line."));
form = $list_utils:append(form, $encore_web_utils:textarea(owners, "shared_owners", "5", "10"));
return form;
.


@program $xpress_object_editor:edit_name
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
name = object.name;
for alias in (object.aliases)
  if (alias != object.name)
    name = name + ", " + alias;
  endif
endfor
form = $list_utils:append({"Name: "},$encore_web_utils:input("name", name, "40", "text"));
return form;
.

@program $xpress_object_editor:edit_url
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = options = select = {};
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Audio URL: "}, $encore_web_utils:input("audio_url", object.audio_url, "50", "text"))));
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Visual URL: "}, $encore_web_utils:input("url_address", object.url_address, "50", "text"))));
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Visual Height: "}, $encore_web_utils:input("web_height", object.web_height, "6", "text"))));
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Visual Width: "}, $encore_web_utils:input("web_width", object.web_width, "6", "text"))));
for pos in ($xpress_client.web_alignment_options)
  if (pos[2] == object.Media_Content_Alignment)
    options = $list_utils:append(options, $encore_web_utils:option(pos[1], pos[2], "1"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(pos[1], pos[2]));
  endif
endfor
form = $list_utils:append(form, {"Alignment: "}, $encore_web_utils:select(options, "Media_Content_Alignment"));
return form;
.

@program $xpress_object_editor:edit_icon
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = $list_utils:append({"Icon: "}, $encore_web_utils:input("icon", object.icon, "50", "text"));
return form;
.

@program $xpress_object_editor:edit_description
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
options = {};
descr = object.description;
form = $encore_web_utils:p("Description: ");
form = $list_utils:append(form, $encore_web_utils:textarea(descr, "description", "10", "70"));
for pos in ($xpress_client.web_alignment_options)
  if (pos[2] == object.Text_Alignment)
    options = $list_utils:append(options, $encore_web_utils:option(pos[1], pos[2], "1"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(pos[1], pos[2]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Alignment: "}, $encore_web_utils:select(options, "Text_Alignment"))));
return form;
.

@program $xpress_object_editor:edit_ascii
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
ascii = object.drawing;
form = $encore_web_utils:p("ASCII Drawing/Art: "); 
form = $list_utils:append(form, $encore_web_utils:textarea(ascii, "drawing", "10", "70"), $encore_web_utils:p());
form = $list_utils:append(form, {"Display ASCII graphics in Xpress? "});
if (object.display_ascii)
  form = $list_utils:append(form, $encore_web_utils:input("display_ascii", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("display_ascii", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("display_ascii", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("display_ascii", "0", "", "radio", "", "checked"), {"No"});
endif
return form;
.

@program $xpress_object_editor:edit_appearance
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = usr_font = usr_font_size = usr_font_color = usr_link_color = usr_vlink_color = usr_alink_color = usr_web_bgcolor = {};
if ($encore_web_object.use_external_stylesheet)
  form = $encore_web_utils:p("This MOO uses external style sheets for object layout. Appearance cannot be modified by users.");
else
  form = $list_utils:append(form, {"Font "});
  for font in ($xpress_client.web_fonts)
    if (font == object.web_font)
      usr_font = $list_utils:append(usr_font, $encore_web_utils:option(Font, font, "1"));
    else
      usr_font = $list_utils:append(usr_font, $encore_web_utils:option(Font, font));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(usr_font, "web_font")); 
  form = $list_utils:append(form, {" Size "});
  for size in ($xpress_client.web_font_sizes)
    if (size == object.web_font_size)
      usr_font_size = $list_utils:append(usr_font_size, $encore_web_utils:option(size, size, "1"));
    else
      usr_font_size = $list_utils:append(usr_font_size, $encore_web_utils:option(size, size));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(usr_font_size, "web_font_size")); 
  form = $list_utils:append(form, {" Color "});
  for color in ($xpress_client.web_colors)
    if (color == object.web_text_color)
      usr_font_color = $list_utils:append(usr_font_color, $encore_web_utils:option(color, color, "1"));
    else
      usr_font_color = $list_utils:append(usr_font_color, $encore_web_utils:option(color, color));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(usr_font_color, "web_text_color")); 
  form = $list_utils:append(form, $encore_web_utils:p(), {"Link "});
  for color in ($xpress_client.web_colors)
    if (color == object.web_link_color)
      usr_link_color = $list_utils:append(usr_link_color, $encore_web_utils:option(color, color, "1"));
    else
      usr_link_color = $list_utils:append(usr_link_color, $encore_web_utils:option(color, color));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(usr_link_color, "web_link_color")); 
  form = $list_utils:append(form, {" Visited "});
  for color in ($xpress_client.web_colors)
    if (color == object.web_vlink_color)
      usr_vlink_color = $list_utils:append(usr_vlink_color, $encore_web_utils:option(color, color, "1"));
    else
      usr_vlink_color = $list_utils:append(usr_vlink_color, $encore_web_utils:option(color, color));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(usr_vlink_color, "web_vlink_color")); 
  form = $list_utils:append(form, {" Active "});
  for color in ($xpress_client.web_colors)
    if (color == object.web_alink_color)
      usr_alink_color = $list_utils:append(usr_alink_color, $encore_web_utils:option(color, color, "1"));
    else
      usr_alink_color = $list_utils:append(usr_alink_color, $encore_web_utils:option(color, color));
    endif
  endfor
  form = $list_utils:append(form, $encore_web_utils:select(usr_alink_color, "web_alink_color")); 
  form = $list_utils:append(form, $encore_web_utils:p());
  for color in ($xpress_client.web_colors)
    if (color == object.web_bgcolor)
      usr_web_bgcolor = $list_utils:append(usr_web_bgcolor, $encore_web_utils:option(color, color, "1"));
    else
      usr_web_bgcolor = $list_utils:append(usr_web_bgcolor, $encore_web_utils:option(color, color));
    endif
  endfor
  form = $list_utils:append(form, {"Background "}, $encore_web_utils:select(usr_web_bgcolor, "web_bgcolor")); 
  form = $list_utils:append(form, $encore_web_utils:p("Background Image URL"));
  form = $list_utils:append(form, $encore_web_utils:input("web_background", object.web_background, "50"));
endif
return form;
.

@program $xpress_object_editor:Edit_Note_Text
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = options = {};
text = object.text;
form = $list_utils:append($encore_web_utils:p("Note text"), $encore_web_utils:textarea(text, "text", "10", "70"));
form = $list_utils:append(form, $encore_web_utils:p("Text alignment"));
for align in ($xpress_client.web_alignment_options)
  if (align[2] == object.Note_Text_Alignment)
    options = $list_utils:append(options, $encore_web_utils:option(align[1], align[2], "1"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(align[1], align[2]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:select(options, "Note_Text_Alignment"));
return form;
.

@program $xpress_object_editor:Edit_Lecture_Text
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
text = object.text;
form = $encore_web_utils:p("Lecture text");
form = $list_utils:append(form, $encore_web_utils:textarea(text, "text", "10", "70"));
return form;
.

@program $xpress_object_editor:edit_password
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
{password_help_button, help_window_function} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Password");
help_window_function = $encore_web_utils:insert_javascript(help_window_function);
password = $encore_web_utils:p("Please type in both your old (current) and new password.");
password = $list_utils:append(password, $encore_web_utils:input("object", toint(object), "", "hidden"));
password = $list_utils:append(password, {"Old password "}, $encore_web_utils:input("old_password", "", "10", "password"));
password = $list_utils:append(password, {"New password "}, $encore_web_utils:input("new_password", "", "10", "password"));
password = $list_utils:append(password_help_button, help_window_function, password);
return password;
.

@program $xpress_object_editor:Edit_Gender
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = options = {};
user_gender = user.gender;
available_genders = $gender_utils.genders;
for option in (available_genders)
  if (option == user_gender)
    options = $list_utils:append(options, $encore_web_utils:option(option, option, "1"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(option, option));
  endif
endfor
form = $list_utils:append({"Gender "}, $encore_web_utils:select(options, "gender"));
return form;
.

@program $xpress_object_editor:Edit_Player_Info
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = {};
form = $list_utils:append(form, {"Home page URL "}, $encore_web_utils:input("homepage", object.homepage, "40"), $encore_web_utils:p());
form = $list_utils:append(form, {"Activity message "}, $encore_web_utils:input("doing", object.doing, "40"));
form = $list_utils:append(form, $encore_web_utils:p("Personal and Professional Information"));
form = $list_utils:append(form, $encore_web_utils:textarea(object.interests_msg, "interests_msg", "7", "70"));
return form;
.

@program $xpress_object_editor:Edit_theme
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
viewThemes = $encore_web_utils:javascript_window_open($help_browser, "viewThemes", tostr("http://", $network.site, ":", $network.webport, "/Xpress_Client/view_themes"), 300, 500);
viewThemes = $encore_web_utils:insert_javascript(viewThemes);
form = themes = sizes = {};
for theme in ($xpress_client.themes)
  if (theme[2] == object.xpress_theme)
    themes = $list_utils:append(themes, $encore_web_utils:option(theme[1], theme[2], "selected"));
  else
    themes = $list_utils:append(themes, $encore_web_utils:option(theme[1], theme[2]));
  endif
endfor
form = $list_utils:append(form, {"Current Theme "}, $encore_web_utils:select(themes, "xpress_theme"));
form = {@form, $encore_web_utils:get_icon(user, $help_browser, "help.gif", "View Xpress Themes", "viewThemes()")};
form = $list_utils:append(form, $encore_web_utils:p("(Some changes take effect when you reconnect)"));
for size in ($xpress_client.icon_sizes)
  if (size[2] == object.icon_size)
    sizes = $list_utils:append(sizes, $encore_web_utils:option(size[1], size[2], "selected"));
  else
    sizes = $list_utils:append(sizes, $encore_web_utils:option(size[1], size[2]));
  endif
endfor
form = $list_utils:append(form, {"Icon Size "}, $encore_web_utils:select(sizes, "icon_size"));
form = $list_utils:append(form, $encore_web_utils:p(), {"Show Contextual Menu "});
if (user.show_contextual_menu)
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "0", "", "radio", "", "checked"), {"No"});
endif
if (!object.use_external_stylesheet)
  "------------------------------------------------";
  "Add option for overriding object specific styles";
  "------------------------------------------------";
  form = $list_utils:append(form, $encore_web_utils:p(), {"Override object specific styles "});
  if (user.override_object_styles)
    form = $list_utils:append(form, $encore_web_utils:input("override_object_styles", "1", "", "radio", "", "checked"), {"Yes"});
    form = $list_utils:append(form, $encore_web_utils:input("override_object_styles", "0", "", "radio"), {"No"});
  else
    form = $list_utils:append(form, $encore_web_utils:input("override_object_styles", "1", "", "radio"), {"Yes"});
    form = $list_utils:append(form, $encore_web_utils:input("override_object_styles", "0", "", "radio", "", "checked"), {"No"});
  endif
  form = $list_utils:append(form, $encore_web_utils:p("When the override styles option is on, you will use your own appearance settings to view MOO content. Select 'Edit Object Appearance' from the editing options above to modify these settings."));
endif
form = $list_utils:append(viewThemes, form);
return form;
.

@program $xpress_object_editor:Edit_Screen_Layout
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
object = $xpress_client;
{layout_help_button, layout_help_window} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Xpress_Screen_Layout");
layout_help_window = $encore_web_utils:insert_javascript(layout_help_window);
form = sizes = layouts = divisions = {};
form = $list_utils:append(layout_help_button, layout_help_window, form);
form = $list_utils:append(form, $encore_web_utils:p(), {"Screen Size "});
for size in (object.screen_sizes)
  if (size[1] == user.xpress_screen_size)
    sizes = $list_utils:append(sizes, $encore_web_utils:option(size[2], size[1], "selected"));
  else
    sizes = $list_utils:append(sizes, $encore_web_utils:option(size[2], size[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:select(sizes, "Xpress_Screen_Size"), $encore_web_utils:p(), {"Layout "});
for layout in (object.screen_layouts)
  if (layout[1] == user.xpress_layout)
    layouts = $list_utils:append(layouts, $encore_web_utils:option(layout[2], layout[1], "selected"));
  else
    layouts = $list_utils:append(layouts, $encore_web_utils:option(layout[2], layout[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:select(layouts, "Xpress_layout"), $encore_web_utils:p(), {"Screen Division "});
for division in (object.screen_divisions)
  if (division[1] == user.xpress_screen_division)
    divisions = $list_utils:append(divisions, $encore_web_utils:option(division[2], division[1], "selected"));
  else
    divisions = $list_utils:append(divisions, $encore_web_utils:option(division[2], division[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:select(divisions, "Xpress_Screen_Division"));
form = $list_utils:append(form, $encore_web_utils:p("Changes take effect when you reconnect"));
return form;
.

@program $xpress_object_editor:Edit_Java_Settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = fonts = sizes = {};
for font in ($xpress_client.java_fonts)
  if (font == user.java_font)
    fonts = $list_utils:append(fonts, $encore_web_utils:option(font, font, "selected"));
  else
    fonts = $list_utils:append(fonts, $encore_web_utils:option(font, font));
  endif
endfor
form = $list_utils:append({"Chat Area Font "}, $encore_web_utils:select(fonts, "java_font"));
for size in ($xpress_client.java_font_sizes)
  if (size == user.java_font_size)
    sizes = $list_utils:append(sizes, $encore_web_utils:option(size, size, "selected"));
  else
    sizes = $list_utils:append(sizes, $encore_web_utils:option(size, size));
  endif
endfor
form = $list_utils:append(form, {" Size "}, $encore_web_utils:select(sizes, "java_font_size"));
form = $list_utils:append(form, $encore_web_utils:p(), {"Local Echo "});
echo = user.java_client_localecho;
if (echo == "true")
    form = $list_utils:append(form, $encore_web_utils:input("java_client_localecho", "true", "", "radio", "", "checked"), {"On"});
    form = $list_utils:append(form, $encore_web_utils:input("java_client_localecho", "false", "", "radio"), {"Off"});
  else
    form = $list_utils:append(form, $encore_web_utils:input("java_client_localecho", "true", "", "radio"), {"On"});
    form = $list_utils:append(form, $encore_web_utils:input("java_client_localecho", "false", "", "radio", "", "checked"), {"Off"});
endif
form = $list_utils:append(form, $encore_web_utils:p("Changes take effect when you reconnect"));
return form;
.

@program $xpress_object_editor:Edit_Sound_Settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = vol = mail = {};
for option in ($xpress_client.sound_volumes)
  if (option[1] == user.sound_volume)
    vol = $list_utils:append(vol, $encore_web_utils:option(option[2], option[1], "selected"));
  else
    vol = $list_utils:append(vol, $encore_web_utils:option(option[2], option[1]));
  endif
endfor
form = $list_utils:append(form, {"Sound volume "}, $encore_web_utils:select(vol, "sound_volume"));
return form;
.

@program $xpress_object_editor:Edit_Player_Messages
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = {};
{help_button, help_window} = $encore_web_utils:insert_context_sensitive_help(user, $encore_help, "Player_Message_Editing");
help_window = $encore_web_utils:insert_javascript(help_window);
form = $list_utils:append(help_button, help_window);
form = $list_utils:append(form, $encore_web_utils:p("Message when your page has been successfully received "), $encore_web_utils:input("page_echo_msg", object.page_echo_msg, "50", "text")); 
form = $list_utils:append(form, $encore_web_utils:p("Message to people you page "), $encore_web_utils:input("page_origin_msg", object.page_origin_msg, "50", "text")); 
form = $list_utils:append(form, $encore_web_utils:p("Message to people who page you when you are not connected "), $encore_web_utils:input("page_absent_msg", object.page_absent_msg, "50", "text")); 
form = $list_utils:append(form, $encore_web_utils:p("Message to other people when you leave a room "), $encore_web_utils:input("odepart_msg", object.odepart_msg, "50", "text")); 
form = $list_utils:append(form, $encore_web_utils:p("Message to other people when you enter a room "), $encore_web_utils:input("oarrive_msg", object.oarrive_msg, "50", "text")); 
return form;
.

@program $xpress_object_editor:Edit_Web_Slides
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
form = {};
form = $list_utils:append(form, {"Target "});
if (object.display_in_xpress)
  form = $list_utils:append(form, $encore_web_utils:input("display_in_xpress", "1", "", "radio", "", "checked"), {"Xpress Web Area"});
  form = $list_utils:append(form, $encore_web_utils:input("display_in_xpress", "0", "", "radio"), {"New Browser Window"});
else
  form = $list_utils:append(form, $encore_web_utils:input("display_in_xpress", "1", "", "radio"), {"Xpress Web Area"});
  form = $list_utils:append(form, $encore_web_utils:input("display_in_xpress", "0", "", "radio", "", "checked"), {"New Browser Window"});
endif
form = $list_utils:append(form, $encore_web_utils:p("Type the URLs for the web pages you wish to display in the text area below. Type only one URL per. line. If you choose the Xpress Web Area as target for your web slides, please make sure your slides does not contain javascript code of any kind."));
form = $list_utils:append(form, $encore_web_utils:textarea(object.slides, "slides", "5", "70"));
return form;
.


@verb $xpress_object_editor:"edit_mail_options" this none this rxd
@program $xpress_object_editor:edit_mail_options
" ==========================================================";
" Copyright (C) 2003, Daniel Jung                           ";
" Gather options for web MOO mail handling                  ";
" ==========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
strings = $xpress_moo_mailer.xpress_moo_mailer_strings;
form = options = {};
" ---------------------------- ";
" --- preview frame or not --- ";
" ---------------------------- ";
if (user.messages_in_main_window)
  form = $list_utils:append(form, $encore_web_utils:input("messages_in_main_window", "1", "", "radio", "", "checked"), {strings[55]}, {$encore_web_utils:br()});
  form = $list_utils:append(form, $encore_web_utils:input("messages_in_main_window", "0", "", "radio"), {strings[56]});
else
  form = $list_utils:append(form, $encore_web_utils:input("messages_in_main_window", "1", "", "radio"), {strings[55]}, {$encore_web_utils:br()});
  form = $list_utils:append(form, $encore_web_utils:input("messages_in_main_window", "0", "", "radio", "", "checked"), {strings[56]});
endif
form = $list_utils:append(form, $encore_web_utils:p());
" ------------------------ ";
" --- quote by default --- ";
" ------------------------ ";
if (user.quote_by_default)
  form = $list_utils:append(form, $encore_web_utils:input("quote_by_default", "1", "", "radio", "", "checked"), {strings[57]}, {$encore_web_utils:br()});
  form = $list_utils:append(form, $encore_web_utils:input("quote_by_default", "0", "", "radio"), {strings[58]});
else
  form = $list_utils:append(form, $encore_web_utils:input("quote_by_default", "1", "", "radio"), {strings[57]}, {$encore_web_utils:br()});
  form = $list_utils:append(form, $encore_web_utils:input("quote_by_default", "0", "", "radio", "", "checked"), {strings[58]});
endif
form = $list_utils:append(form, $encore_web_utils:p());
" ---------------------------- ";
" --- signature by default --- ";
" ---------------------------- ";
if (user.signature_by_default)
  form = $list_utils:append(form, $encore_web_utils:input("signature_by_default", "1", "", "radio", "", "checked"), {strings[59]}, {$encore_web_utils:br()});
  form = $list_utils:append(form, $encore_web_utils:input("signature_by_default", "0", "", "radio"), {strings[60]});
else
  form = $list_utils:append(form, $encore_web_utils:input("signature_by_default", "1", "", "radio"), {strings[59]}, {$encore_web_utils:br()});
  form = $list_utils:append(form, $encore_web_utils:input("signature_by_default", "0", "", "radio", "", "checked"), {strings[60]});
endif
" --------------------------- ";
" --- number msg per page --- ";
" --------------------------- ";
for lpp in (object.links_per_page)
  if (object.messages_to_display == lpp)
    options = $list_utils:append(options, $encore_web_utils:option(lpp, lpp, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(lpp, lpp));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:select(options, "messages_to_display"), {strings[61]});
options = {};
" ------------------------- ";
" --- mail notification --- ";
" ------------------------- ";
for s in ($xpress_client.mail_notification_sounds)
  if (object.mail_notify_sound == s[1])
    options = $list_utils:append(options, $encore_web_utils:option(s[2], s[1], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(s[2], s[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:select(options, "mail_notify_sound"), {strings[62]});
options = {};
form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("mail_notify_sound_custom", object.mail_notify_sound_custom, "40", "text"), {strings[63]});
" ---------------------- ";
" --- mail signature --- ";
" ---------------------- ";
form = $list_utils:append(form, $encore_web_utils:p(strings[64]), $encore_web_utils:textarea(object.web_mail_signature, "web_mail_signature", "4", "70"));
return form;
.


@program $webprojector:display
"===========================================================";
"Copyright (C) 1997-2004, Ken Schweller and Jan Rune Holmevik";
"Modified to let output go to new browser window. Jan, 1/4/01";
"===========================================================";
if (dobjstr == "next")
  sn = this.index;
elseif ($string_utils:is_numeric(dobjstr))
  sn = tonum(dobjstr);
else
  player:tell("Usage:  display <number|next> on <projector name>");
  return;
endif
if (sn > length(this.slides))
  player:tell("Try again: projector only has ", length(this.slides), " slides.");
  return;
endif
s = this.slides[sn];
player.location:announce_all(player.name, " displays slide #", sn, " on ", this.name, ":");
if (this.display_in_xpress)
  player.location:announce_all("  <", s, ">.");
else
  player.location:announce_all("  <", s, " _blank>.");
endif
this.index = sn + 1;
.

@program $xpress_program_editor:main_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main program editor screen";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
base_url = tostr($encore_web_utils:baseurl(), "Xpress_Program_Editor/");
menu_frame = tostr(base_url, "menu.html");
editor_frame = tostr(base_url, "blank.html");
view1_frame = tostr(base_url, "blank.html");
view2_frame = tostr(base_url, "blank.html");
html = {tostr("<frameset cols=\"50%\">")};
html = {@html, tostr("<noframes><body>")};
html = {@html, "<h3>Sorry you need a browser that supports frames to use this system</h3>"};
html = {@html, "</body></noframes>"};
html = {@html, tostr("<frameset cols=\"50%\">")};
html = {@html, tostr("   <frameset rows=\"95,82%\">")};
html = {@html, tostr("      <frame src=\"", menu_frame, "\" id=\"menu\" name=\"menu\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html, tostr("      <frameset cols=\"70%,30%\">")};
html = {@html, tostr("         <frame src=\"", editor_frame, "\" id=\"editor\" name=\"editor\" noresize=\"noresize\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html, tostr("         <frameset rows=\"50%,50%\">")};
html = {@html, tostr("            <frame src=\"", view1_frame, "\" id=\"view1\" name=\"view1\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html, tostr("            <frame src=\"", view2_frame, "\" id=\"view2\" name=\"view2\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html, "         </frameset>"};
html = {@html, "      </frameset>"};
html = {@html, "   </frameset>"};
html = {@html, "</frameset>"};
html = {@html, "</frameset>"};
result = this:build(user, html, "Xpress Program Editor", "", "", "", "", this.doctype_frameset);
return result;
.

@program $xpress_program_editor:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
functions = buttons = body = {};
base_url = tostr($encore_web_utils:baseurl(), "Xpress_Program_Editor/");
title = $encore_web_utils:get_title(user, this, "Xpress Program Editor");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $prog_help, "Xpress_Program_Editor");
openManual = $encore_web_utils:javascript_window_open(this, "openManual", tostr($xpress_client.external_baseurl, $xpress_client.texts_folder, this.programmers_manual), "600", "500", "yes");
functions = $list_utils:append(help_function, openManual);
functions = $encore_web_utils:insert_javascript(functions);
buttons = $list_utils:append(help_button, $encore_web_utils:input("search_string", "", "20", "text"));
buttons = $list_utils:append(buttons, $encore_web_utils:input("submit", "View", "", "submit"));
buttons = $list_utils:append(buttons, $encore_web_utils:input("objects", "My Objects", "", "button", tostr("onclick=\"parent.view1.location.href = '", base_url, "list_objects", "'\"")));
buttons = $list_utils:append(buttons, $encore_web_utils:input("manual", "Programmer's Manual", "", "button", tostr("onclick=\"openManual()\"")));
buttons = $list_utils:append(buttons, $encore_web_utils:close("parent"));
body = $encore_web_utils:form($list_utils:append(title, buttons), "search", "/Xpress_Program_Editor/editor", "", "editor");
body = $list_utils:append(functions, body);
result = this:build(user, body, "Xpress Program Editor", $encore_web_utils:focus_field("search_string"));
return result;
.

@program $xpress_program_editor:view_verbs
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Compile list of editable verbs";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, form_data} = args;
body = vrbs = {};
alert = "";
if ({{}, {}} != form_data)
  if (user.programmer == 0)
    return "403_Forbidden";
  endif
  base_url = $encore_web_utils:baseurl();
  object = toobj(form_data[2][1]);
  if (valid(object))
    "Valid object found";
    title = $encore_web_utils:get_subtitle(user, this, tostr("Verbs on ", object.name));
    "----------------------------------------------";
    "Compile list of verbs on an object";
    "----------------------------------------------";
    if ($server_options.support_numeric_verbname_strings)
      index = 0;
    else
      index = 1;
    endif
    verb_list = verbs(object);
    for vrb_number in [1..length(verb_list)]
      vrb_name = verb_list[vrb_number];
      if (match(verb_info(object, vrb_number)[2], "r") || verb_info(object, vrb_number)[1] == user)
        vrbs = {@vrbs, $encore_web_utils:a(tostr(base_url, "Xpress_Program_Editor/editor?", toint(object), ":", index), vrb_name)};
      else
        vrbs = {@vrbs, tostr(vrb_name, " ** unreadable **")};
      endif
      vrbs = {@vrbs, $encore_web_utils:br()};
      index = index + 1;
    endfor
    if (!vrbs)
      alert = "There are no verbs defined directly on this object. Please select a super class to see verbs inherited by this object.";
    endif
    body = $list_utils:append(title, vrbs);
  else
    alert = tostr("Sorry, no object named ", object_name, " was found. Unless you refer to an object directly by it's object number, you can only work with objects that are in your possession, or in the same room as you are.");
  endif
endif
result = this:build(user, body, "Verb List", "", "editor");
return result;
.

@program $xpress_program_editor:edit_verb
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik and sindre.sorensen@rasmus.uib.no";
"Create the main program editor screen";
"===========================================================";
if (caller != this)
  return E_PERM;
endif
{user, object, requested_verb} = args;
"----------------------------------------------";
"Declare variables";
"----------------------------------------------";
body = submit = direct_object = preposition = indirect_object = arg_list = perm_list = verb_code = cancel_button = {};
base_url = $encore_web_utils:baseurl();
alert = continue_message = "";
if (slot = user in this.temporary_items[1])
  "------------------------------------------------";
  "User has unfinished business. Return verb in progress";
  "------------------------------------------------";
  continue_message = " (Last compile failed)";
  {object, verb_number, code} = this.temporary_items[2][slot];
else
  code = "";
  try
    "----------------------------------------------------------";
    "Find correct verb number";
    "----------------------------------------------------------";
    if ($server_options.support_numeric_verbname_strings && requested_verb == "0")
      "Added for compatibility with older, non-enCore based MOOs";
      verb_number = tostr(0);
    else
      if (!(verb_number = $code_utils:toint(requested_verb)))
        "If we are given a verb_name instead of a verb_number, we'll try to find it";
        verb_number = $code_utils:find_last_verb_named(object, requested_verb);
      endif
      error = verb_info(object, verb_number);
    endif
  except error (ANY)
    alert = "Sorry, the verb you requested either does not exist or is out of range";
  endtry
endif
"----------------------------------------------------------";
"String conversion added for compatibility with older";
"non-enCore based MOOs. Jan, 07/20/01";
"----------------------------------------------------------";
if ($server_options.support_numeric_verbname_strings)
  verb_number = tostr(verb_number);
endif
if (user.programmer && match(verb_info(object, verb_number)[2], "r") || user == verb_info(object, verb_number)[1])
  "User is programmer and verb is readable, or user is owner of verb";
  checkverbname = {"function checkVerbName() {", tostr("   if (document.getElementById('name').value == \"\" || document.getElementById('name').value == \"", this.default_new_verb_name, "\") {"), "   document.getElementById('name').select();", "   alert('You must give your verb a name before you can compile it !');", "   return false; ", "}", "return true;", "}"};
  confirmDelete = {"function confirmDelete() {", tostr("   if (confirm('", this:delete_warning(object, requested_verb), " Are you sure you want to delete this verb?')) {"), tostr("      location.href = '/Xpress_Program_Editor/delete_verb?", toint(object), ";", verb_number, "';"), "      return true;", "   }", "   return false;", "}"};
  functions = $list_utils:append(checkverbname, confirmDelete);
  functions = $encore_web_utils:insert_javascript(functions);
  arguments = verb_args(object, verb_number);
  permissions = verb_info(object, verb_number);
  if (!code)
    code = verb_code(object, verb_number);
  endif
  "----------------------------------------------";
  "Create editor web page based on verb values";
  "----------------------------------------------";
  obj = $encore_web_utils:input("obj", object, "", "hidden");
  obj = $list_utils:append(obj, $encore_web_utils:input("verb_number", verb_number, "", "hidden"));
  obj = $list_utils:append(obj, $encore_web_utils:input("long_old_verb_name", permissions[$], "", "hidden"));
  name = $list_utils:append({"Name "}, $encore_web_utils:input("name", permissions[$], "20", "text"));
  owner = {tostr("Owner: ", permissions[1].name, " (", permissions[1], ")")};
  title = $encore_web_utils:get_subtitle(user, this, tostr("Editing verb \"", permissions[$], "\" on ", object.name, "  ", continue_message));
  r = match(verb_info(object, verb_number)[2], "r") ? "r" | "";
  x = match(verb_info(object, verb_number)[2], "x") ? "x" | "";
  d = match(verb_info(object, verb_number)[2], "d") ? "d" | "";
  if (r)
    perm_list = $list_utils:append(perm_list, $encore_web_utils:input("read", r, "", "checkbox", "", "checked"), {" Read"});
  else
    perm_list = $list_utils:append(perm_list, $encore_web_utils:input("read", r, "", "checkbox"), {" Read"});
  endif
  if (x)
    perm_list = $list_utils:append(perm_list, $encore_web_utils:input("execute", x, "", "checkbox", "", "checked"), {" Execute"});
  else
    perm_list = $list_utils:append(perm_list, $encore_web_utils:input("execute", x, "", "checkbox"), {" Execute"});
  endif
  if (d)
    perm_list = $list_utils:append(perm_list, $encore_web_utils:input("debug", d, "", "checkbox", "", "checked"), {" Debug"});
  else
    perm_list = $list_utils:append(perm_list, $encore_web_utils:input("debug", d, "", "checkbox"), {" Debug"});
  endif
  for option in ({"this", "none", "any"})
    if (option == arguments[1])
      direct_object = $list_utils:append(direct_object, $encore_web_utils:option(option, option, "selected"));
    else
      direct_object = $list_utils:append(direct_object, $encore_web_utils:option(option, option));
    endif
  endfor
  direct_object = $list_utils:append($encore_web_utils:select(direct_object, "dobj"));
  preps = $list_utils:append({"this", "none", "any"}, $code_utils:prepositions());
  for option in (preps)
    if (option == arguments[2])
      preposition = $list_utils:append(preposition, $encore_web_utils:option($string_utils:explode(option, "/")[1], option, "selected"));
    else
      preposition = $list_utils:append(preposition, $encore_web_utils:option($string_utils:explode(option, "/")[1], option));
    endif
  endfor
  preposition = $list_utils:append($encore_web_utils:select(preposition, "preposition"));
  for option in ({"this", "none", "any"})
    if (option == arguments[3])
      indirect_object = $list_utils:append(indirect_object, $encore_web_utils:option(option, option, "selected"));
    else
      indirect_object = $list_utils:append(indirect_object, $encore_web_utils:option(option, option));
    endif
  endfor
  indirect_object = $list_utils:append($encore_web_utils:select(indirect_object, "iobj"));
  perm_list = $encore_web_utils:span($list_utils:append(name, $encore_web_utils:br("Permissions "), perm_list), "left");
  arg_list = $encore_web_utils:span($list_utils:append($encore_web_utils:br(owner), $encore_web_utils:br("Arguments "), $list_utils:append(direct_object, preposition, indirect_object)), "right");
  verb_properties = $list_utils:append(perm_list, arg_list, $encore_web_utils:p());
  "----------------------------------------------";
  "Insert line numbers in code";
  "----------------------------------------------";
  indent_width = length(tostr(length(code)));
  for line_number in [1..length(code)]
    line = $string_utils:right(tostr(line_number), indent_width) + ": " + code[line_number];
    "Added by Jan 05/16/99 to fix verb form layout";
    line = $encore_web_utils:substitute_suspended(line, {{"<", "&lt;"}, {">", "&gt;"}});
    verb_code = {@verb_code, line};
  endfor
  verb_code = $encore_web_utils:textarea(verb_code, "verb_code", "20", "72");
  "----------------------------------------------";
  "Add appropriate buttons";
  "----------------------------------------------";
  if (user == object.owner || user.wizard)
    submit = $encore_web_utils:input("submit", "Compile Verb", "", "submit");
    submit = $list_utils:append($encore_web_utils:p(), submit, $encore_web_utils:input("delete", "Delete This Verb", "", "button", "onclick=\"return confirmDelete()\""));
  endif
  if (continue_message)
    cancel_button = $encore_web_utils:input("cancel", "Revert to Original", "", "button", tostr("onclick=\"location.href = '", base_url, "Xpress_Program_Editor/cancel.html?", toint(user), "'\""));
  endif
  editor = $list_utils:append(OBJ, verb_properties, verb_code, submit, cancel_button);
  body = $list_utils:append(title, functions, $encore_web_utils:form(editor, "editor", "/Xpress_Program_Editor/compiler.html", "return checkVerbName()", "view2"));
else
  alert = "That verb is not readable by you.";
endif
return {body, alert};
.

@program $xpress_program_editor:compiler_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik and sindre.sorensen@rasmus.uib.no";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, form_data} = args;
function = sound = name_change = arg_result = perm_result = compile_result = {};
r = x = d = javascript = sound_file = "";
status = {};
title = $encore_web_utils:get_subtitle(user, this, "Verb Compiler");
if ({{}, {}} != form_data)
  "User wants to compile a verb";
  data = form_data;
  object = toobj(data[2][1]);
  verb_number = tostr(data[2][2]);
  long_old_verb_name = data[2][3];
  long_verb_name = data[2][4];
  short_verb_name = strsub($string_utils:explode(long_verb_name)[1], "*", "");
  "----------------------------------------------------------";
  "String conversion added for compatibility with older";
  "non-enCore based MOOs. Jan, 07/20/01";
  "----------------------------------------------------------";
  if ($server_options.support_numeric_verbname_strings == 0)
    verb_number = toint(verb_number);
  endif
  if (long_verb_name != verb_info(object, verb_number)[$])
    "User wants to change the verb name";
    try
      info = verb_info(object, verb_number);
      try
        result = set_verb_info(object, verb_number, listset(info, long_verb_name, 3));
        name_change = $encore_web_utils:p("Verb name changed");
      except e (ANY)
      endtry
      "Ignore exceptions here";
    except e (ANY)
    endtry
  endif
  if (user == object.owner || user.wizard)
    for n in [5..length(data[1]) - 1]
      if (data[1][n] == "Read")
        r = "r";
      elseif (data[1][n] == "Execute")
        x = "x";
      elseif (data[1][n] == "Debug")
        d = "d";
      elseif (data[1][n] == "dobj")
        dobj = data[2][n];
      elseif (data[1][n] == "preposition")
        "Modified the way prepositions are determined to fix problems with preps of more than one word. Jan Nov 22, 2000";
        "preposition = $string_utils:explode(data[2][n])[1]";
        preposition = data[2][n];
      elseif (data[1][n] == "iobj")
        iobj = data[2][n];
      elseif (data[1][n] == "verb_code")
        verb_code = data[2][n];
        if (typeof(verb_code) == STR)
          verb_code = {verb_code};
        endif
      endif
    endfor
    info = verb_info(object, short_verb_name);
    "Set verb permissions";
    perms = $string_utils:trim(r + x + d);
    if (info[2] != perms)
      try
        info[2] = perms = $perm_utils:apply(info[2], perms);
        result = set_verb_info(object, verb_number, info);
        perm_result = $encore_web_utils:p(tostr("Verb permissions set to ", perms));
      except error (ANY)
        perm_result = {error[2]};
      endtry
    endif
    "Set verb arguments";
    arguments = verb_args(object, strsub(short_verb_name, "*", ""));
    if (arguments != {dobj, preposition, iobj})
      try
        result = set_verb_args(object, verb_number, {dobj, preposition, iobj});
        arg_result = $encore_web_utils:p("Verb arguments changed");
      except error (ANY)
        arg_result = {error[2]};
      endtry
    endif
    "Compile code";
    insert_help = 0;
    try
      for line_number in [1..length(verb_code)]
        embedded_line_number = match(verb_code[line_number], "^[ 0-9]*:[ ]*");
        if (embedded_line_number)
          verb_code[line_number] = verb_code[line_number][embedded_line_number[2] + 1..$];
        endif
      endfor
      if (result = set_verb_code(object, verb_number, verb_code))
        for line in (result)
          compile_result = $list_utils:append(compile_result, $encore_web_utils:br(line));
        endfor
        compile_result = $list_utils:append(compile_result, $encore_web_utils:br(tostr(length(result), " error(s).")), $encore_web_utils:br("Verb not programmed."));
        if (slot = user in this.temporary_items[1])
          this.temporary_items[2][slot] = {object, verb_number, verb_code};
        else
          this.temporary_items[1] = {@this.temporary_items[1], user};
          this.temporary_items[2] = {@this.temporary_items[2], {object, verb_number, verb_code}};
        endif
        sound_file = "compile_failed.wav";
        insert_help = 1;
      else
        compile_result = $list_utils:append($encore_web_utils:br("0 errors."), $encore_web_utils:br("Verb programmed."));
        if (slot = user in this.temporary_items[1])
          this.temporary_items[1] = listdelete(this.temporary_items[1], slot);
          this.temporary_items[2] = listdelete(this.temporary_items[2], slot);
        endif
        sound_file = "compile_success.wav";
        this:update_last_modified(user, object, short_verb_name);
      endif
    except error (ANY)
      if (typeof(error[2]) == 4)
        for line in (error[2])
          compile_result = {@compile_result, line};
        endfor
      else
        compile_result = {@compile_result, error[2]};
      endif
      compile_result = {@compile_result, "Verb not programmed."};
      sound_file = "compile_failed.wav";
      insert_help = 1;
    endtry
    if (insert_help)
      {help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $prog_help, "Debugging");
      function = $encore_web_utils:insert_javascript(help_function);
      compile_result = $list_utils:append(function, help_button, $encore_web_utils:p(), compile_result);
    endif
    if (user.sound_volume)
      sound = $encore_web_utils:make_sound(user, sound_file);
    endif
  else
    javascript = "alert('Permission denied. You can only program verbs on objects that you own.')";
  endif
  status = $list_utils:append(name_change, arg_result, perm_result, compile_result);
endif
body = $list_utils:append(title, sound, status);
javascript = tostr(javascript, "parent.editor.location.reload()");
result = this:build(user, body, "Xpress Compiler", javascript);
return result;
.


@program $xpress_program_editor:cancel_html
"===========================================================";
"Copyright (C) 1999-2004, sindre.sorensen@rasmus.uib.no and Jan Rune Holmevik";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, form_data} = args;
body = {};
javascript = "";
user = toobj(user);
javascript = "alert('Permission denied: Only the owner of the verb may edit it.')";
slot = user in this.temporary_items[1];
if (slot)
  {object, verb_number, code} = this.temporary_items[2][slot];  
  this.temporary_items[1] = listdelete(this.temporary_items[1], slot);
  this.temporary_items[2] = listdelete(this.temporary_items[2], slot);
  javascript = tostr("alert('Verb reverted to original')");
endif
body = this:edit_verb(user, object, tostr(verb_number))[1];
result = this:build(user, body, "Cancel Editing", javascript, "");
return result;
.
    
@program $xpress_program_editor:delete_warning
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Checks of a verb or property is defined on a core object or if the object has sub classes prints delete warning to user.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
object = args[1];
alert = "";
"-------------------------------------------------";
"Check if object is system object";
"-------------------------------------------------";
if (object == #0)
  alert = "WARNING: You are working with the System Object. Unless you know exactly what you are doing, you are STRONGLY ADVICED NOT TO PROCEED, as this action may create severe problems with the MOO!";
  "-------------------------------------------------";
  "Check if object is a super class";
  "-------------------------------------------------";
elseif ($object_utils:descendants_suspended(object))
  alert = "WARNING: You are working with an object that has sub classes. If you proceed these sub classes will be affected!";
else
  "-------------------------------------------------";
  "Check if object is defined on core";
  "-------------------------------------------------";
  coreprops = properties(#0);
  for prop in (coreprops)
    if (#0.(prop) == object)
      alert = "WARNING: You are working with a core object. Unless you know exactly what you are doing, you are STRONGLY ADVICED NOT TO PROCEED, as this action may create severe problems with the MOO!";
    endif
  endfor
endif
return alert;
.

@program $xpress_program_editor:editor
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Display the Xpress Program Editor main screen";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data, ?alert = ""} = args;
error_msg = onload = "";
body = editor = {};
try;
  if (data != {{}, {}})
    "---------------------------------------------------------";
    "User has submitted a request. Find object and verb or";
    "property if submitted";
    "---------------------------------------------------------";
    {object, vrb, property, alert2} = this:parse_args(user, tostr(data[2][1]));
    if (valid(object))
      "------------------------------------------------------";
      "Valid object found.";
      "------------------------------------------------------";
      if (vrb != "")
        "---------------------------------------------------";
        "Verb specified. Diplay verb editor";
        "---------------------------------------------------";
        {editor, error_msg} = this:edit_verb(user, object, vrb);
      elseif (property != "")
        "---------------------------------------------------";
        "Property specified. Display property editor";
        "---------------------------------------------------";
        {editor, error_msg} = this:edit_property(user, object, property);
      else
        "---------------------------------------------------";
        "Object only specified. Display object editor";
        "---------------------------------------------------";
        {editor, error_msg, onload} = this:edit_object(user, object);
      endif
      if (error_msg)
        alert2 = alert2 + " " + error_msg;
      endif
      body = $list_utils:append(body, editor);
    endif
  endif
except error (ANY)
  alert = tostr("There is a problem with the Xpress Program Editor. Please try again later or notify a MOO administrator. Error: ", error[2]);
endtry
alert = alert + alert2;
alert = $encore_web_utils:make_alert(alert);
if (onload)
  alert = alert + onload;
endif
result = this:build(user, body, "Xpress Program Editor", alert);
return result;
.


@program $xpress_program_editor:edit_object
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Lists data and flags on an object";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object} = args;
body = classes = location = size = name = owner = flags = functions = form = {};
alert = onload = r = f = "";
if (object.r || user == object.owner || user.wizard)
  onload = "verbs_and_properties();";
  base_url = tostr($encore_web_utils:baseurl(), "Xpress_Program_Editor/");
  icon = {$encore_web_utils:get_icon(user, object)};
  title = $encore_web_utils:get_subtitle(user, this, tostr("Viewing ", object.name, " (", object, ")"));
  vrb_and_prop = {"function verbs_and_properties() {", tostr("  parent.view1.location.href = '", base_url, "view_verbs?", toint(object), "'"), tostr("  parent.view2.location.href = '", base_url, "view_properties?", toint(object), "'"), "}"};
  functions = $encore_web_utils:insert_javascript(vrb_and_prop);
  "----------------------------------------------";
  "Compile list of super classes";
  "----------------------------------------------";
  super = $list_utils:reverse($object_utils:ancestors(object));
  for class in (super)
    if (length(class.name) > 30)
      class_name = class.name[1..29] + "..";
    else
      class_name = class.name;
    endif
    classes = $list_utils:append(classes, $encore_web_utils:option(class_name, toint(class)));
  endfor
  if (length(object.name) > 30)
    object_name = object.name[1..29] + "..";
  else
    object_name = object.name;
  endif
  classes = $list_utils:append(classes, $encore_web_utils:option(object_name, toint(object), "selected"));
  classes = $list_utils:append({"Name "}, $encore_web_utils:select(classes, "classes", "onchange=this.form.submit()"));
  top_menu = $encore_web_utils:form($list_utils:append(classes), "Object_Menu", "/Xpress_Program_Editor/Editor");
  owner = $encore_web_utils:p(tostr("Owner: ", object.owner.name, " (", object.owner, ")"));
  if (object.location == $nowhere)
    location = $encore_web_utils:p("Location: Limbo");
  else
    location = $encore_web_utils:p(tostr("Location: ", object.location.name, " (", object.location, ")"));
  endif
  if ($quota_utils.byte_based && $object_utils:has_property(object, "object_size"))
    $quota_utils:object_size(object);
    obj_size = tostr($string_utils:group_number(object.object_size[1]), " bytes at ", user:ctime(object.object_size[2]));
  else
    obj_size = "Unknown";
  endif
  size = $encore_web_utils:p(tostr("Object size: ", obj_size));
  "----------------------------------------------";
  "Add editing options if user is owner or wiz";
  "----------------------------------------------";
  r = object.r ? "r" | "";
  f = object.f ? "f" | "";
  if (user == object.owner || user.wizard)
    form = $list_utils:append(form, $encore_web_utils:input("object", toint(object), "", "hidden"));
    "-------------------------------------------------";
    "Object flags";
    "-------------------------------------------------";
    flags = {@flags, "Flags: "};
    if (r)
      flags = $list_utils:append(flags, $encore_web_utils:input("read", r, "", "checkbox", "", "checked"), {" Read"});
    else
      flags = $list_utils:append(flags, $encore_web_utils:input("read", r, "", "checkbox"), {" Read"});
    endif
    if (f)
      flags = $list_utils:append(flags, $encore_web_utils:input("fertile", f, "", "checkbox", "", "checked"), {" Fertile"});
    else
      flags = $list_utils:append(flags, $encore_web_utils:input("fertile", f, "", "checkbox"), {" Fertile"});
    endif
    form = $list_utils:append(form, flags);
  else
    "----------------------------------------------";
    "Add non-editable object information";
    "----------------------------------------------";
    form = {@form, tostr("Flags: ", $string_utils:trim(r + f))};
  endif
  "----------------------------------------------";
  "Add save and create buttons if user is wiz or owner";
  "----------------------------------------------";
  if (user == object.owner || user.wizard)
    form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("save", "Save Object", "", "submit"));
    form = $list_utils:append(form, $encore_web_utils:input("verb", "New Verb", "", "button", tostr("onclick=\"location.href = '/Xpress_Program_Editor/create_new_verb?", toint(object), "'\"")));
    form = $list_utils:append(form, $encore_web_utils:input("property", "New Property", "", "button", tostr("onclick=\"location.href = '/Xpress_Program_Editor/create_new_property?", toint(object), "'\"")));
    form = $encore_web_utils:form(form, "editor", "/Xpress_Program_Editor/set_object");
  endif
  body = $list_utils:append(functions, title, icon, top_menu, owner, location, size, form);
else
  alert = "That object is not readable by you. ";
endif
return {body, alert, onload};
.

@program $xpress_program_editor:list_objects
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Lists a user's objects";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
user = args[1];
body = objects = {};
base_url = tostr($encore_web_utils:baseurl(), "/Xpress_Program_Editor/Editor");
title = $encore_web_utils:get_subtitle(user, this, "My Objects");
for object in (user.owned_objects)
  "Compile list of objects the user owns";
  if ($object_utils:isa(object, $encore_web_class))
    if (object.icon != "")
      objects = {@objects, tostr($encore_web_utils:a(tostr(base_url, "?", toint(object)), object.name, "", "", $encore_web_utils:get_icon(user, object)))};
    else
      objects = {@objects, tostr($encore_web_utils:a(tostr(base_url, "?", toint(object)), object.name))};
    endif
    objects = {@objects, $encore_web_utils:br()};
  endif
endfor
body = $list_utils:append(title, objects);
result = this:build(user, body, "Objects", "", "editor");
return result;
.

@program $xpress_program_editor:view_properties
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Lists web editable properties on an object";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
body = properties = {};
alert = "";
if ({{}, {}} != data)
  "User has asked for an object to edit";
  object = toobj(data[2][1]);
  if (valid(object))
    "----------------------------------------------------";
    "Compile a list properties on the requested object";
    "----------------------------------------------------";
    title = $encore_web_utils:get_subtitle(user, this, tostr("Properties on ", object.name));
    base_url = tostr($encore_web_utils:baseurl(), "Xpress_Program_Editor/editor");
    for property in ($object_utils:all_properties_suspended(object))
      prop_perms = property_info(object, property);
      if (match(prop_perms[2], "r") || user == prop_perms[1] || user.wizard)
        "Show only readable properties";
        properties = {@properties, $encore_web_utils:a(tostr(base_url, "?", toint(object), ".", property), property)};
      else
        properties = {@properties, tostr(property, " ** unreadable **")};
      endif
      properties = {@properties, $encore_web_utils:br()};
    endfor
    body = $list_utils:append(title, properties);
  else
    alert = "Could not find an object by that name. You must either hold an object, or be in the same room as the object in order to refer to it by name.";
  endif
endif
result = this:build(user, body, "Properties", $encore_web_utils:make_alert(alert), "editor");
return result;
.

@program $xpress_program_editor:edit_property
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress property editor screen";
"===========================================================";
if (caller != this)
  return E_PERM;
endif
{user, object, property} = args;
body = form = type = flags = name = owner = prop_value = {};
alert = datatype = coreCheck = "";
prop_info = property_info(object, property);
if (user.programmer && match(prop_info[2], "r") || user == prop_info[1] || user.wizard)
  "-------------------------------------------------";
  "Generate edit form for the requested property";
  "-------------------------------------------------";
  confirmDelete = {"function confirmDelete() {", tostr("   if (confirm('", this:delete_warning(object, property), " Are you sure you want to delete this property?')) {"), tostr("      location.href = '/Xpress_Program_Editor/delete_property?", toint(object), ";", property, "';"), "      return true;", "   }", "   return false;", "}"};
  checkPropName = {"function checkPropertyName() {", tostr("   if (document.getElementById('name').value == \"\" || document.getElementById('name').value == \"", this.default_new_property_name, "\") {"), "   document.getElementById('name').select();", "   alert('You must give your property a name before you can save it');", "   return false; ", "}", "return true;", "}"};
  functions = $list_utils:append(confirmDelete, checkPropName);
  confirmDelete = $encore_web_utils:insert_javascript(functions);
  base_url = tostr("http://", $network.site, ":", $network.webport, "/Xpress_Program_Editor/set_property");
  title = $encore_web_utils:get_subtitle(user, this, tostr("Editing property \"", property, "\" on ", object.name));
  form = $list_utils:append(form, $encore_web_utils:input("object", toint(object), "", "hidden"));
  form = $list_utils:append(form, $encore_web_utils:input("oldName", property, "", "hidden"));
  owner = $encore_web_utils:p(tostr("Owner: ", prop_info[1].name, " (", prop_info[1], ")"));
  data = object.(property);
  if (typeof(data) == OBJ)
    datatype = "Object";
  elseif (typeof(data) == INT)
    datatype = "Integer";
  elseif (typeof(data) == STR)
    datatype = "String";
  elseif (typeof(data) == LIST)
    datatype = "List";
  elseif (typeof(data) == FLOAT)
    datatype = "Floating-point number";
  elseif (typeof(data) == ERR)
    datatype = "Error code";
  else
    datatype = "Unknown";
  endif
  type = $encore_web_utils:p(tostr("Data Type: ", datatype));
  size = $encore_web_utils:p(tostr("Size: ", $quota_utils:value_bytes(object.(property)), " bytes"));
  if ($object_utils:defines_property(object, property) && user == prop_info[1] || user.wizard)
    "-------------------------------------------------";
    "Property is defined on the object, and user has permission to edit. add editing options";
    "-------------------------------------------------";
    name = $encore_web_utils:p($list_utils:append({"Name "}, $encore_web_utils:input("name", property, "20", "text")));
   "-------------------------------------------------";
    "Edit property permissions";
    "-------------------------------------------------";
    r = match(prop_info[2], "r") ? "r" | "";
    c = match(prop_info[2], "c") ? "c" | "";
    flags = {@flags, "Permissions: "};
    if (r)
     flags = $list_utils:append(flags, $encore_web_utils:input("read", r, "", "checkbox", "", "checked"), {" Read"});
    else
      flags = $list_utils:append(flags, $encore_web_utils:input("read", r, "", "checkbox"), {" Read"});
    endif
    if (c)
      flags = $list_utils:append(flags, $encore_web_utils:input("change", c, "", "checkbox", "", "checked"), {" Change"});
    else
      flags = $list_utils:append(flags, $encore_web_utils:input("change", c, "", "checkbox"), {" Change"});
    endif
  else
    "-------------------------------------------------";
    "Object does not define property. Add non-editable property information";
    "-------------------------------------------------";
    name = $encore_web_utils:p(tostr("Inherited property: ", property));
    flags = $list_utils:append(flags, $encore_web_utils:p(tostr("Permissions: ", prop_info[2])));
  endif
  form = $list_utils:append(form, name, owner, type, size, flags);
  try
    "-------------------------------------------------";
    "Format property value. Lists of lists must be treated as special cases";
    "-------------------------------------------------";
    if (typeof(data) == LIST)
      if (data != {} && typeof(data[$]) == LIST)
        prop_value = {@prop_value, $string_utils:print(data)};
      else
        if (data != {})
          for line in [1..length(data)]
            prop_value = {@prop_value, data[line]};
          endfor
        endif
      endif
    else
      prop_value = {@prop_value, data};
    endif
  except error (ANY)
    "-------------------------------------------------";
    "Default to formatted string if errors occur";
    "-------------------------------------------------";
    prop_value = {@prop_value, $string_utils:print(data)};
  endtry
  form = $list_utils:append(form, $encore_web_utils:p("Property Value: "), $encore_web_utils:textarea(prop_value, "value", "10", "72"));
  if (user == prop_info[1] || user.wizard)
    form = $list_utils:append(form, $encore_web_utils:input("save", "Save Property", "", "submit"));
    if ($object_utils:defines_property(object, property))
      form = $list_utils:append(form, $encore_web_utils:input("delete", "Delete This Property", "", "button", "onclick=\"return confirmDelete()\""));
    endif
  endif
  form = $encore_web_utils:form(form, "editor", "/Xpress_Program_Editor/set_property", "return checkPropertyName()");
  onload = tostr("document.edit_property.", property, ".focus()");
  body = $list_utils:append(confirmDelete, title, form);
else
  alert = "That property is not readable by you.";
endif
return {body, alert};
.

@program $administration_module:main_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Generates the main MOO administration module screen";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
if (!user.wizard)
  return "403_Forbidden";
endif
base_url = tostr($encore_web_utils:baseurl(), "administration_module/");
menu_frame = tostr(base_url, "menu.html");
work_frame = tostr(base_url, "blank.html");
html = {             "<frameset cols=\"50%\">"};
html = {@html, tostr("   <noframes><body>")};
html = {@html,       "      <h3>Sorry you need a browser that supports frames to use this system</h3>"};
html = {@html,       "   </body></noframes>"};
html = {@html, tostr("   <frameset rows=\"95,82%\">")};
html = {@html, tostr("      <frame src=\"", menu_frame, "\" name=\"menu\" noresize=\"noresize\" scrolling=\"no\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html, tostr("      <frame src=\"", work_frame, "\" name=\"work\" marginwidth=\"", this.frame_marginwidth, "\" marginheight=\"", this.frame_marginheight, "\" />")};
html = {@html,       "   </frameset>"};
html = {@html,       "</frameset>"};
result = this:build(user, html, "Xpress MOO Administration", "", "", "", "", this.doctype_frameset);
return result;
.

@program $administration_module:menu_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Create a menu for the Xpress administration module";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
user = args[1];
if (!user.wizard)
  return "403_Forbidden";
endif
base_url = tostr($encore_web_utils:baseurl(), "administration_module/");
"Assemble menu line";
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $wiz_help, "enCore_MOO_administration");
accounts_button = $encore_web_utils:input("accounts", "Accounts", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "view_html", "'\""));
xpress_button = $encore_web_utils:input("bookmarks", "Bookmarks", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "edit_xpress_bookmarks_html", "'\""));
generics_button = $encore_web_utils:input("generics", "Generics", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "edit_generics_html", "'\""));
motd_button = $encore_web_utils:input("motd", "MOTD", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "edit_motd_html", "'\""));
core_pref_button = $encore_web_utils:input("settings", "Settings", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "core_settings", "'\""));
functions = $encore_web_utils:insert_javascript(help_function);
title = $encore_web_utils:get_title(user, this, "Xpress MOO Administration");
menu = $list_utils:append(title, help_button, accounts_button, xpress_button, generics_button, motd_button, core_pref_button, $encore_web_utils:close("parent"));
body = $list_utils:append(functions, menu);
result = this:build(user, body, "MOO Administration Menu", "self.focus()");
return result;
.

@program $administration_module:view_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Account administration module";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
action = data[2];
msg = "Select a character class and enter name, email address and real name for the new account to be created below. If you are creating a new guest account, you only need to fill in the name field.";
if (action == {"update"})
  OBJ = data[1];
  player_class = parent(OBJ);
  plyr_name = OBJ.name;
  email = OBJ.email_address;
  real_name = OBJ.real_name;
  msg = "Change data for this account by editing the fields below.";
elseif (action == {"batch"})
  if (data[1] == {""})
    player_class = $player_class;
    account_data = {};
  else
    player_class = toobj(data[1][1]);
    msg = "The following name(s) is/are already in use: " + data[1][2] + $encore_web_utils:br() + "Please choose new name(s) and try again.";
    account_data = data[1][3];
  endif
elseif (action == {"report"})
  player_class = $player_class;
  msg = "Account Creation Report:";
  account_data = data[1][3];
else
  player_class = $player_class;
  plyr_name = email = real_name = "";
endif
body = search = part1 = part2 = {};
confirmDelete = {"function confirmAction() {", "   if (confirm('Are you sure you want to do this?')) {", "      return true;", "   }", "   return false;", "}"};
base_url = tostr("http://", $network.site, ":", $network.webport, "/administration_module/");
title = $encore_web_utils:get_subtitle(user, this, "Character Account Administration");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $wiz_help, "enCore_Account_Creation");
functions = $encore_web_utils:insert_javascript($list_utils:append(help_function, confirmDelete));
menu_buttons = $encore_web_utils:input("single", "Single Account", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "view_html'\""));
menu_buttons = $list_utils:append(menu_buttons, $encore_web_utils:input("multiple", "Multiple Accounts", "", "button", tostr("onclick=\"parent.work.location.href = '", base_url, "view_html?batch'\"")));
menu_buttons = $list_utils:append(menu_buttons, $encore_web_utils:input("edit", "Edit Account", "", "button", "onclick=\"this.form.submit()\""));
menu_buttons = $list_utils:append(menu_buttons, $encore_web_utils:input("name", "", "10", "text"));
menu = $list_utils:append(help_button, menu_buttons);
menu = $encore_web_utils:form(menu, "search", "/administration_module/find_player");
"=================================";
"== Set up player class section ==";
"=================================";
part1 = $encore_web_utils:input("name", obj, "", "hidden");
part1 = $list_utils:append(part1, $encore_web_utils:br("Character Type"));
player_classes = {$guest, $player_class, $builder, $prog, $wiz};
for class in (player_classes)
  class_name = $string_utils:trim($string_utils:substitute(class.name, {{"Generic", ""}}));
  class_name = $string_utils:capitalize(class_name);
  if (class == player_class)
    part1 = $list_utils:append(part1, $encore_web_utils:input("class", toint(class), "", "radio", "", "checked"), {class_name}, {$encore_web_utils:br()});
  else
    part1 = $list_utils:append(part1, $encore_web_utils:input("class", toint(class), "", "radio"), {class_name}, {$encore_web_utils:br()});
  endif
endfor
if (action == {"batch"} || action == {"report"})
  "==============================================";
  "== Form for creating a batch of characters  ==";
  "==============================================";
  msg = tostr("Select a character type and enter data for the new accounts below. Use one line for each new account. Separate user name, email address, and real name with open spaces. Example: ", $encore_web_utils:br(), $encore_web_utils:i("Anna Annab@someplace.com Anna Livingston"));
  part2 = $list_utils:append(part2, $encore_web_utils:p(msg), $encore_web_utils:textarea(account_data, "account_data", "10", "50"), {$encore_web_utils:br()});
  if (action == {"report"})
    if ($network.active)
      part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Email Report to Me", "", "submit"));
    else
      part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "MOOmail Report to Me", "", "submit"));
    endif
    vrb = "mail_report";
  else
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Create Multiple Accounts", "", "submit"));
    vrb = "batch_make_player";
  endif
else
  "============================================================";
  "== Form for making one character, or updating a character ==";
  "============================================================";
  part2 = $list_utils:append(part2, $encore_web_utils:p(msg), $encore_web_utils:input("name", plyr_name, "30", "text"), {" Name"}, {$encore_web_utils:br()});
  part2 = $list_utils:append(part2, $encore_web_utils:input("email_address", email, "30", "text"), {" Email"}, {$encore_web_utils:br()});
  part2 = $list_utils:append(part2, $encore_web_utils:input("real_name", real_name, "30", "text"), {" Real name"}, {$encore_web_utils:br()});
  if (action == {"update"})
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Update account", "", "submit"));
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Delete account", "", "submit"));
    vrb = "update";
  else
    part2 = $list_utils:append(part2, $encore_web_utils:input("submit", "Create New Account", "", "submit"));
    vrb = "create";
  endif
endif
form = $list_utils:append($encore_web_utils:p(), $encore_web_utils:span(part1, "classes"), $encore_web_utils:span(part2, "data"));
form = $encore_web_utils:form(form, "character", tostr("/administration_module/", vrb), "return confirmAction()");
body = $list_utils:append(functions, title, menu, $encore_web_utils:p(), form);
return body;
.

@program $administration_module:find_player
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Find a character and return character data";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
alert = "";
if (data)
  name = data[2][1];
  if (name != "")
    person = $string_utils:match_player(name);
    if (person == $failed_match)
      alert = tostr("alert('Sorry, no users by that name was found. Please try again');document.getElementById('name').focus();");
      body = this:view_html(user, {{}, {}});
    else
      body = this:view_html(user, {person, {"update"}});
    endif
  else
    alert = tostr("alert('Sorry, you must enter the name of a user in order to edit their account. Please try again');document.getElementById('name').focus();");
    body = this:view_html(user, {{}, {}});
  endif
endif
result = this:build(user, body, "Character Administration", alert);
return result;
.


@program $administration_module:batch_make_player
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Create several characters at once.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
body = names = email_addresses = real_names = {};
bad_names = "";
class = toobj(data[2][2]);
account_data = data[2][3];
if (typeof(account_data) == STR)
  account_data = {account_data};
endif
"=== Organize data ===";
for line in (account_data)
  $command_utils:suspend_if_needed(1);
  parts = $string_utils:explode(line);
  try
    names = {@names, parts[1]};
    if (class != $guest)
      email_addresses = {@email_addresses, parts[2]};
      real_names = {@real_names, $string_utils:from_list(parts[3..$], " ")};
    endif
  except error (ANY)
    body = this:view_html(user, {{class, "", account_data}, {"batch"}});
    msg = "alert('You need to fill both names and valid email addresses. Real names are optional. If you are creating new guest characters, you only need to fill in the names.')";
    result = this:pre_assemble(user, body, "Character Administration", msg);
    return result;
  endtry
endfor
"=== Check that names are available ===";
for name in (names)
  if (!$player_db:available(name))
    bad_names = bad_names + name + " ";
  endif
endfor
if (bad_names)
  return this:view_html(user, {{class, bad_names, account_data}, {"batch"}});
else
  result = {tostr("Account Creation Report: ", $network.MOO_name)};
  result = {@result, tostr("Date: ", $time_utils:time_sub("$2/$T/$Y", time()), $time_utils:time_sub(" $H:$M:$S, $Z", time()))};
  result = {@result, tostr("Created by: ", user.name)};
  result = {@result, ""};
  for n in [1..length(names)]
    $command_utils:suspend_if_needed(1);
    if (class == $guest)
      result = {@result, this:make_guest(user, class, names[n])};
    else
      result = {@result, this:make_player(user, class, names[n], email_addresses[n], real_names[n])};
    endif
    result = {@result, ""};
  endfor
endif
return this:view_html(user, {{$player_class, "", result}, {"report"}});
.


@program $administration_module:edit_motd_html
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Compose and edit message of the day to be displayed at login.";
"===========================================================";
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
base_url = "/administration_module/edit_motd_html";
alert = text = "";
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $wiz_help, "Xpress_MOTD_Editor");
functions = $encore_web_utils:insert_javascript(help_function);
title = $encore_web_utils:get_subtitle(user, this, "Xpress Message of the Day Editor");
if (data != {{}, {}})
  "-------------------------------------------------------------";
  "Arguments specified, update properties before generating form";
  "-------------------------------------------------------------";
  action = data[1][2];
  text = $string_utils:subst(data[2][1], {{"\"", ""}, {"'", ""}});
  if (action == "clear")
    $xpress_client.motd_msg = "";
    $xpress_client.MOTD_viewer_list = {};
    alert = "Message of the Day Cleared";
  else
    if ($xpress_client.motd_msg == text)
      alert = "No changes made";
    else
      $xpress_client.motd_msg = text;
      $xpress_client.MOTD_viewer_list = {};
      alert = "Message of the Day Updated";
    endif
  endif
endif
"-------------------------------------------------------------";
"Generate form";
"-------------------------------------------------------------";
body = $encore_web_utils:p(tostr($network.MOO_name, " Message of the Day "));
body = $list_utils:append(body, $encore_web_utils:input("MOTD_msg", $xpress_client.motd_msg, "60", "text", "", "", "maxlength=\"255\""), $encore_web_utils:p());
body = $list_utils:append(body, $encore_web_utils:input("submit", "Update", "", "submit"));
if ($xpress_client.motd_msg != "")
  body = $list_utils:append(body, $encore_web_utils:input("clear", "Reset", "", "submit"));
endif
body = $encore_web_utils:form(body, "motd_form", base_url);
body = $list_utils:append(functions, title, help_button, body);
result = this:pre_assemble(user, body, "MOTD Editor", $encore_web_utils:make_alert(alert));
return result;
.

@program $administration_module:edit_generics_html
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Form for editing and managing generics";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
if (typeof(data[1]) == LIST)
  msg = "";
else
  msg = data[1];
endif
generics_source = $xpress_object_editor.generics;
category = "";
generics = menu = {};
base_url = $encore_web_utils:baseurl() + "administration_module/";
index = 0;
if (data[2] != {})
  index = toint(data[2][1]);
  if (index > 0)
    category = generics_source[index][1];
    generics = generics_source[index][2];
  endif
endif
title = $encore_web_utils:get_subtitle(user, this, "Xpress Generics Editor");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $wiz_help, "Xpress_Generics_Editor");
functions = $encore_web_utils:insert_javascript(help_function);
menu = $list_utils:append(menu, $encore_web_utils:option("Edit Generics", "0"));
menu = $list_utils:append(menu, $encore_web_utils:option("Create New Generics Category", "0"));
for n in [1..length(generics_source)]
  menu = $list_utils:append(menu, $encore_web_utils:option(generics_source[n][1], n));
endfor
menu = $list_utils:append($encore_web_utils:select(menu, "form", "onchange=this.form.submit()"));
menu = $list_utils:append(help_button, menu);
menu = $encore_web_utils:form(menu, "menu", "/administration_module/edit_generics_html");
edit_form = $encore_web_utils:input("index", tostr(index), "", "hidden");
edit_form = $list_utils:append(edit_form, $encore_web_utils:p("Generics Category"), $encore_web_utils:input("category", category, "30", "text"));
edit_form = $list_utils:append(edit_form, $encore_web_utils:p("Generic Objects"), $encore_web_utils:textarea(generics, "Generics_Categories", "10", "30"));
if (index == 0)
  edit_form = $list_utils:append(edit_form, $encore_web_utils:p(), $encore_web_utils:input("save", "Save New Generics", "", "submit"));
  edit_form = $encore_web_utils:form(edit_form, "Genrics", "/administration_module/create_generics");
else
  edit_form = $list_utils:append(edit_form, $encore_web_utils:p(), $encore_web_utils:input("submit", "Update Generics", "", "submit"));
  edit_form = $list_utils:append(edit_form, $encore_web_utils:input("delete", "Delete This Generics Category", "", "button", tostr("onclick=\"location.href = '", base_url, "delete_generics?", tostr(index), "'\"")));
  edit_form = $encore_web_utils:form(edit_form, "Generics", "/administration_module/update_generics");
endif
body = $list_utils:append(functions, title, menu, edit_form);
result = this:pre_assemble(user, body, "Xpress Generics Editor", msg);
return result;
.

@program $administration_module:create_generics
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Verb to create, edit, and delete generics categories";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
try
  msg = err1 = "";
  if (verb == "delete_generics")
    index = toint(data[2][1]);
    msg = tostr("Generics Category: ", $xpress_object_editor.generics[index][1], " deleted");
    $xpress_object_editor.generics = listdelete($xpress_object_editor.generics, index);
  else
    generics = {};
    index = toint(data[2][1]);
    category = data[2][2];
    objects = data[2][3];
    if (typeof(data[2][3]) != LIST)
      objects = {objects};
    endif
    for n in (objects)
      object = toobj(n);
      if (!object.f)
        err1 = ";alert('One or more objects cannot be added to generics. Please make sure all objects are set to fertile')";
      else
        generics = {@generics, object};
      endif
    endfor
    if (verb == "create_generics")
      $xpress_object_editor.generics = listappend($xpress_object_editor.generics, {category, generics});
      msg = tostr("New category named: ", category, " added to Generics");
    else
      $xpress_object_editor.generics = listdelete($xpress_object_editor.generics, index);
      $xpress_object_editor.generics = listinsert($xpress_object_editor.generics, {category, generics}, index);
      msg = tostr("Generics Category: ", category, " Updated");
    endif
  endif
except error (ANY)
  msg = "An error occurred, please try again";
endtry
alert = tostr("alert('", msg, "!')") + err1;
body = this:edit_generics_html(user, {alert, {}});
return body;
.

@program $administration_module:edit_xpress_bookmarks_html
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Xpress bookmarks editor";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
if (typeof(data[1]) == LIST)
  msg = "";
else
  msg = data[1];
endif
bookmark_source = $xpress_navigator.bookmarks;
category = "";
bookmarks = menu = {};
base_url = $encore_web_utils:baseurl() + "administration_module/";
index = 0;
if (data[2] != {})
  index = toint(data[2][1]);
  if (index > 0)
    category = bookmark_source[index][1];
    bookmarks = bookmark_source[index][2];
  endif
endif
title = $encore_web_utils:get_subtitle(user, this, "Xpress Bookmark Editor");
{help_button, help_function} = $encore_web_utils:insert_context_sensitive_help(user, $wiz_help, "Xpress_Bookmark_Editor");
functions = $encore_web_utils:insert_javascript(help_function);
menu = $list_utils:append(menu, $encore_web_utils:option("Edit Bookmarks", "0"));
menu = $list_utils:append(menu, $encore_web_utils:option("Create New Bookmark Category", "0"));
for n in [1..length(bookmark_source)]
  menu = $list_utils:append(menu, $encore_web_utils:option(bookmark_source[n][1], n));
endfor
menu = $list_utils:append($encore_web_utils:select(menu, "form", "onchange=this.form.submit()"));
menu = $list_utils:append(help_button, menu);
menu = $encore_web_utils:form(menu, "menu", "/administration_module/edit_xpress_bookmarks_html");
edit_form = $encore_web_utils:input("index", tostr(index), "", "hidden");
edit_form = $list_utils:append(edit_form, $encore_web_utils:p("Bookmark Category"), $encore_web_utils:input("category", category, "30", "text"));
edit_form = $list_utils:append(edit_form, $encore_web_utils:p("Bookmarks"), $encore_web_utils:textarea(bookmarks, "bookmarks", "10", "30"));
if (index == 0)
  edit_form = $list_utils:append(edit_form, $encore_web_utils:p(), $encore_web_utils:input("save", "Save New Bookmarks", "", "submit"));
  edit_form = $encore_web_utils:form(edit_form, "Bookmarks", "/administration_module/create_bookmark");
else
  edit_form = $list_utils:append(edit_form, $encore_web_utils:p(), $encore_web_utils:input("submit", "Update Bookmarks", "", "submit"));
  edit_form = $list_utils:append(edit_form, $encore_web_utils:input("delete", "Delete this Bookmark Category", "", "button", tostr("onclick=\"location.href = '", base_url, "delete_bookmark?", tostr(index), "'\"")));
  edit_form = $encore_web_utils:form(edit_form, "Bookmarks", "/administration_module/update_bookmark");
endif
body = $list_utils:append(functions, title, menu, edit_form);
result = this:build(user, body, "Xpress Navigator Editor", msg);
return result;
.

@program $administration_module:create_bookmark
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Verb to create, modify, and delete bookmarks.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (!user.wizard)
  return "403_Forbidden";
endif
try
  msg = err1 = err2 = "";
  if (verb == "delete_bookmark")
    index = toint(data[2][1]);
    msg = tostr("Bookmark category: ", $xpress_navigator.bookmarks[index][1], " deleted");
    $xpress_navigator.bookmarks = listdelete($xpress_navigator.bookmarks, index);
  else
    bookmarks = {};
    index = toint(data[2][1]);
    category = data[2][2];
    objects = data[2][3];
    if (typeof(data[2][3]) != LIST)
      objects = {objects};
    endif
    for n in (objects)
      bookmark = toobj(n);
      if (bookmark == #0 || toint(bookmark) > toint(max_object()))
        err1 = ";alert('One or more bookmarks not added due to invalid object number(s). Do not use object names when entering bookmarks!')";
      elseif (!$object_utils:isa(bookmark, $encore_web_class))
        err2 = ";alert('One or more bookmarks not added because they cannot be viewed in Xpress!')";
      else
        bookmarks = {@bookmarks, bookmark};
      endif
    endfor
    if (verb == "create_bookmark")
      $xpress_navigator.bookmarks = listappend($xpress_navigator.bookmarks, {category, bookmarks});
      msg = tostr("New category named: ", category, " added to Xpress Navigator bookmarks");
    else
      $xpress_navigator.bookmarks = listdelete($xpress_navigator.bookmarks, index);
      $xpress_navigator.bookmarks = listinsert($xpress_navigator.bookmarks, {category, bookmarks}, index);
      msg = tostr("Bookmark category: ", category, " updated");
    endif
  endif
except error (ANY)
  msg = "An error occurred, please try again";
endtry
alert = tostr("alert('", msg, "!')") + err1 + err2;
body = this:edit_xpress_bookmarks_html(user, {alert, {}});
return body;
.

@program $xpress_program_editor:save_property_value
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik and Alexandre Borgia";
"Save property values via Xpress";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, property, value} = args;
alert = "";
value = this:coerce(value);
"Update 12/17/02: The verb now runs with user task perms in order to prevent unauthorized use";
"Check to see if the user has been designated as co-owner of the object.";
set_task_perms(user);
try
  if ($object_utils:has_property(object, "shared_owners") && (user in object.shared_owners))
    set_task_perms(toobj(object.owner));
  endif
except error (ANY)
"Ignore any errors since task_perms have already been set";
endtry
"Set new property value if the the object defines the property, otherwise return error message.";
try
  if (value != object.(property))
    object.(property) = value;
    alert = tostr(" Property ", property, " saved.");
  endif
except error (ANY)
  alert = " Could not save property: " + tostr(error[2]);
endtry
return alert;
.


@program $administration_module:save_settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Save system settings.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data} = args;
if (data == {{}, {}})
  return "400_Bad_Request";
else
  object = toobj(data[2][1]);
  result = $xpress_object_editor:set_property(user, object, data);
endif
return this:core_settings(user, {{}, {}}, result);
.

@program $xpress_object_editor:set_property
"===========================================================";
"Copyright (C) 1999-2004, Jan Rune Holmevik";
"Update properties";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, data} = args;
body = {};
if ($encore_web_utils:permission_to_edit(user, object))
  try
    "User has permission to edit this object";
    saved_properties = name_change = gender_change = alert = "";
    "Cycle through all data fields minus the first which is always the object number, and the last which is persumed to be the submit/save button data";
    for field in [2..length(data[$]) - 1]
      property = data[1][field];
      new_value = data[2][field];
      "----------------------------------------------------------------";
      "Update property value. Certain properties must be treated as special cases.";
      "----------------------------------------------------------------";
      if (property == "name")
        name_change = this:rename(user, object, new_value);
      elseif (is_player(object) && property == "gender")
        object:set_gender(new_value);
        gender_change = "Gender set to " + new_value;
      else
        saved_properties = saved_properties + $xpress_program_editor:save_property_value(user, object, property, new_value);
      endif
      if ($object_utils:isa(object, $news_item))
        "-------------------------------------------------------------";
        "Object is a $news_item. Notify users of update";
        "-------------------------------------------------------------";
        $news:notify_Xpress_change(object);
      endif
    endfor
    "-----------------------------------------------------";
    "      Generate alert to user";
    "-----------------------------------------------------";
    if (name_change != "")
      alert = alert + tostr("alert('", name_change, "');");
    endif
    if (gender_change != "")
      alert = alert + tostr("alert('", gender_change, "');");
    endif
    if (saved_properties != "")
      alert = alert + tostr("alert('", saved_properties, "');");
    endif
  except error (ANY)
    alert = "alert('There is a problem with the Xpress Object Editor. Please notify a MOO administrator!');";
  endtry
else
  return "403_Forbidden";
endif
return alert;
.

    

@program $administration_module:core_settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Assemble the most important system settings for easy editing.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, data, ?javascript = ""} = args;
title = menu = form = {};
edit_action = "";
if (data != {{}, {}})
  "------------------------------------------------------------";
  " User has selected an editing option. Add correct form";
  "------------------------------------------------------------";
  edit_action = data[2][1];
  form = this:(edit_action)(user);
  form = $list_utils:append(form, $encore_web_utils:p(), $encore_web_utils:input("submit", "Save Changes", "", "submit"));
  form = $encore_web_utils:form(form, "System_Settings", "/Administration_Module/save_settings");
endif
"----------------------------------------------------------------";
" Build display header";
"----------------------------------------------------------------";
title = $encore_web_utils:get_subtitle(user, this, tostr($network.MOO_name, " System Settings", edit_action == "" ? "" | tostr(": ", $string_utils:capitalize($string_utils:substitute(edit_action, {{"_", " "}})))));
"----------------------------------------------------------------";
"Build list of available core settings.";
"----------------------------------------------------------------";
menu = $list_utils:append(menu, $encore_web_utils:option("Select System Setting to Edit", "0"));
menu = $list_utils:append(menu, $encore_web_utils:option("Network", "edit_network"));
menu = $list_utils:append(menu, $encore_web_utils:option("Login", "edit_login"));
menu = $list_utils:append(menu, $encore_web_utils:option("Default User Settings", "edit_user_system_settings"));
menu = $list_utils:append(menu, $encore_web_utils:option("Default Xpress User Settings", "edit_xpress_user_settings"));
menu = $list_utils:append(menu, $encore_web_utils:option("Telnet Welcome Screen", "edit_telnet_welcome_screen"));
menu = $list_utils:append(menu, $encore_web_utils:option("Xpress Welcome Screen", "edit_xpress_login"));
menu = $list_utils:append(menu, $encore_web_utils:option("Xpress System Settings", "edit_xpress_settings"));
menu = $list_utils:append(menu, $encore_web_utils:option("Default Xpress Object Layout", "edit_xpress_object_layout"));
menu = $list_utils:append(menu, $encore_web_utils:option("Default Xpress Application Layout", "edit_xpress_application_layout"));
menu = $encore_web_utils:select(menu, "Edit_Options", "onchange=this.form.submit()");
menu = $encore_web_utils:form(menu, "edit", "/Administration_Module/Core_Settings");
body = $list_utils:append(title, $encore_web_utils:p(), menu, form);
result = this:build(user, body, "Xpress Edit", javascript);
return result;
.

@program $administration_module:Edit_Network
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = $network;
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, {"Network"});
if ($network.active)
  form = $list_utils:append(form, $encore_web_utils:input("active", "1", "", "radio", "", "checked"), {"On"});
  form = $list_utils:append(form, $encore_web_utils:input("active", "0", "", "radio"), {"Off"});
else
  form = $list_utils:append(form, $encore_web_utils:input("active", "1", "", "radio"), {"On"});
  form = $list_utils:append(form, $encore_web_utils:input("active", "0", "", "radio", "", "checked"), {"Off"});
endif
form = $list_utils:append(form, $encore_web_utils:p(), {"MOO name"}, $encore_web_utils:input("moo_name", $network.MOO_name, "30", "text"));
form = $list_utils:append(form, $encore_web_utils:p(), {"Domain name"}, $encore_web_utils:input("site", $network.site, "30", "text"));
form = $list_utils:append(form, $encore_web_utils:p(), {"Mail Server"}, $encore_web_utils:input("maildrop", $network.maildrop, "30", "text"));
form = $list_utils:append(form, $encore_web_utils:p(), {"Telnet port"}, $encore_web_utils:input("port", $network.port, "5", "text"));
form = $list_utils:append(form, $encore_web_utils:p(), {"Web port"}, $encore_web_utils:input("webport", $network.webport, "5", "text"));
return form;
.

@program $administration_module:edit_user_system_settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = #0;
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, {"Hide Real Names and Email Addresses"});
if ($anonymous_users)
  form = $list_utils:append(form, $encore_web_utils:input("anonymous_users", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("anonymous_users", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("anonymous_users", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("anonymous_users", "0", "", "radio", "", "checked"), {"No"});
endif
form = $list_utils:append(form, $encore_web_utils:p(), {"Enable guests to choose their own names"});
if ($real_guest_names)
  form = $list_utils:append(form, $encore_web_utils:input("real_guest_names", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("real_guest_names", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("real_guest_names", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("real_guest_names", "0", "", "radio", "", "checked"), {"No"});
endif
if ($real_guest_names)
  form = $list_utils:append(form, $encore_web_utils:p(), {"Guest name suffix"}, $encore_web_utils:input("guest_name_suffix", $guest_name_suffix, "15", "text", "", "", "maxlength=\"15\""));
endif
return form;
.

@program $administration_module:edit_login
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = $login;
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, {"Automatic character creation"});
if ($login.create_enabled)
  form = $list_utils:append(form, $encore_web_utils:input("create_enabled", "1", "", "radio", "", "checked"), {"On"});
  form = $list_utils:append(form, $encore_web_utils:input("create_enabled", "0", "", "radio"), {"Off"});
else
  form = $list_utils:append(form, $encore_web_utils:input("create_enabled", "1", "", "radio"), {"On"});
  form = $list_utils:append(form, $encore_web_utils:input("create_enabled", "0", "", "radio", "", "checked"), {"Off"});
endif
form = $list_utils:append(form, $encore_web_utils:p("When automatic character creation is enabled, users can make new accounts for themselves without involving the MOO administrators. When the feature is on, an option to create new accounts will be available directly from the login page."));
return form;
.

@program $administration_module:Edit_Xpress_User_Settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = $player;
options = {};
form = $encore_web_utils:input("object", toint(object), "", "hidden");
for theme in ($xpress_client.themes)
  if (theme[2] == object.xpress_theme)
    options = $list_utils:append(options, $encore_web_utils:option(theme[1], theme[2], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(theme[1], theme[2]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Default xpress theme"}, $encore_web_utils:select(options, "xpress_theme"))));
options = {};
for size in ($xpress_client.icon_sizes)
  if (size[2] == object.icon_size)
    options = $list_utils:append(options, $encore_web_utils:option(size[1], size[2], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(size[1], size[2]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Default icon size"}, $encore_web_utils:select(options, "icon_size"))));
form = $list_utils:append(form, {"Contextual menu"});
if (object.show_contextual_menu)
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "1", "", "radio", "", "checked"), {"On"});
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "0", "", "radio"), {"Off"});
else
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "1", "", "radio"), {"On"});
  form = $list_utils:append(form, $encore_web_utils:input("show_contextual_menu", "0", "", "radio", "", "checked"), {"Off"});
endif
options = {};
for size in ($xpress_client.screen_sizes)
  if (size[1] == object.xpress_screen_size)
    options = $list_utils:append(options, $encore_web_utils:option(size[2], size[1], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(size[2], size[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Default screen size"}, $encore_web_utils:select(options, "Xpress_Screen_Size"))));
options = {};
for option in ($xpress_client.screen_layouts)
  if (option[1] == object.xpress_layout)
    options = $list_utils:append(options, $encore_web_utils:option(option[2], option[1], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(option[2], option[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Default screen layout"}, $encore_web_utils:select(options, "Xpress_layout"))));
options = {};
for division in ($xpress_client.screen_divisions)
  if (division[1] == object.xpress_screen_division)
    options = $list_utils:append(options, $encore_web_utils:option(division[2], division[1], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(division[2], division[1]));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p($list_utils:append({"Default screen division"}, $encore_web_utils:select(options, "Xpress_Screen_Division"))));
options = {};
for font in ($xpress_client.java_fonts)
  if (font == object.java_font)
    options = $list_utils:append(options, $encore_web_utils:option(font, font, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(font, font));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), {"Default chat font"}, $encore_web_utils:select(options, "java_font"));
options = {};
for size in ($xpress_client.java_font_sizes)
  if (size == object.java_font_size)
    options = $list_utils:append(options, $encore_web_utils:option(size, size, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(size, size));
  endif
endfor
form = $list_utils:append(form, {" Size "}, $encore_web_utils:select(options, "java_font_size"));
options = {};
echo = object.java_client_localecho;
if (echo == "true")
  options = $list_utils:append(options, $encore_web_utils:option("On", "true", "selected"));
  options = $list_utils:append(options, $encore_web_utils:option("Off", "false"));
else
  options = $list_utils:append(options, $encore_web_utils:option("On", "true"));
  options = $list_utils:append(options, $encore_web_utils:option("Off", "false", "selected"));
endif
form = $list_utils:append(form, {" Local echo "}, $encore_web_utils:select(options, "java_client_localecho"), $encore_web_utils:p());
options = {};
for option in ($xpress_client.sound_volumes)
  if (option[1] == object.sound_volume)
    options = $list_utils:append(options, $encore_web_utils:option(option[2], option[1], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(option[2], option[1]));
  endif
endfor
form = $list_utils:append(form, {"Default sound volume"}, $encore_web_utils:select(options, "sound_volume"));
options = {};
for option in ($xpress_client.mail_notification_sounds)
  if (option[1] == object.mail_notify_sound)
    options = $list_utils:append(options, $encore_web_utils:option(option[2], option[1], "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(option[2], option[1]));
  endif
endfor
form = $list_utils:append(form, {" Mail notification sound "}, $encore_web_utils:select(options, "mail_notify_sound"));
form = $list_utils:append(form, $encore_web_utils:p("Please note, these default settings apply to new accounts only. Existing accounts will not be affected."));
return form;
.

@program $administration_module:Edit_Telnet_Welcome_Screen
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = $login;
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, $encore_web_utils:textarea($login.welcome_message, "welcome_message", "24", "79"));
return form;
.

@program $administration_module:Edit_Xpress_login
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = $xpress_login;
options = {};
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, $encore_web_utils:p("The first four settings apply to the login area (left area) of the welcome screen only."));
for color in ($xpress_client.web_colors)
  if (color == object.web_text_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Font"}, $encore_web_utils:select(options, "web_text_color"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_link_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Link"}, $encore_web_utils:select(options, "web_link_color"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_vlink_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Visited link"}, $encore_web_utils:select(options, "web_vlink_color"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_bgcolor)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Background"}, $encore_web_utils:select(options, "web_bgcolor"));
options = {};
form = $list_utils:append(form, $encore_web_utils:p("Enter the HTML code for your MOO's welcome screen below."));
form = $list_utils:append(form, $encore_web_utils:textarea(object.welcome_screen, "welcome_screen", "20", "79"));
return form;
.

@program $administration_module:Edit_Xpress_Settings
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user} = args;
object = $xpress_client;
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, {"Allow MOO mailer to send via Internet"});
if ($xpress_client.allow_internet_mail)
  form = $list_utils:append(form, $encore_web_utils:input("allow_internet_mail", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("allow_internet_mail", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("allow_internet_mail", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("allow_internet_mail", "0", "", "radio", "", "checked"), {"No"});
endif
form = $list_utils:append(form, $encore_web_utils:p(), {"External base URL"}, $encore_web_utils:input("external_baseurl", object.external_baseurl, "50", "text"));
return form;
.

@program $administration_module:Layout_Form
"===========================================================";
"Copyright (C) 2001-2004, Jan Rune Holmevik";
"Xpress Edit form for default web object and application layout.";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, ?heading = "Xpress Default Layout Form"} = args;
options = {};
form = $encore_web_utils:input("object", toint(object), "", "hidden");
form = $list_utils:append(form, {"Use external style sheet"});
if (object.use_external_stylesheet)
  form = $list_utils:append(form, $encore_web_utils:input("use_external_stylesheet", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("use_external_stylesheet", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("use_external_stylesheet", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("use_external_stylesheet", "0", "", "radio", "", "checked"), {"No"});
endif
form = $list_utils:append(form, $encore_web_utils:p(), {"External style sheet"}, $encore_web_utils:input("external_stylesheet", object.external_stylesheet, "40", "text"));
for color in ($xpress_client.web_colors)
  if (color == object.title_font_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form,  $encore_web_utils:p(), {"Title color"}, $encore_web_utils:select(options, "title_font_color"));
options = {};
for size in ($xpress_client.web_font_sizes)
  if (size == object.title_font_size)
    options = $list_utils:append(options, $encore_web_utils:option(size, size, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(size, size));
  endif
endfor
form = $list_utils:append(form, {"Title size"}, $encore_web_utils:select(options, "title_font_size"));
options = {};
for size in ($xpress_client.web_font_sizes)
  if (size == object.subtitle_font_size)
    options = $list_utils:append(options, $encore_web_utils:option(size, size, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(size, size));
  endif
endfor
form = $list_utils:append(form, {"Subtitle size"}, $encore_web_utils:select(options, "subtitle_font_size"));
options = {};
for font in ($xpress_client.web_fonts)
  if (font == object.web_font)
    options = $list_utils:append(options, $encore_web_utils:option(font, font, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(font, font));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), {"Font"}, $encore_web_utils:select(options, "web_font"));
options = {};
for size in ($xpress_client.web_font_sizes)
  if (size == object.web_font_size)
    options = $list_utils:append(options, $encore_web_utils:option(size, size, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(size, size));
  endif
endfor
form = $list_utils:append(form, {"Size"}, $encore_web_utils:select(options, "web_font_size"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_text_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Color"}, $encore_web_utils:select(options, "web_text_color"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_link_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), {"Link"}, $encore_web_utils:select(options, "web_link_color"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_vlink_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Visited link"}, $encore_web_utils:select(options, "web_vlink_color"));
options = {};
for color in ($xpress_client.web_colors)
  if (color == object.web_alink_color)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, {"Active link"}, $encore_web_utils:select(options, "web_alink_color"));
options = {};
form = $list_utils:append(form, $encore_web_utils:p(), {"Underline links"});
if (object.underline_links)
  form = $list_utils:append(form, $encore_web_utils:input("underline_links", "1", "", "radio", "", "checked"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("underline_links", "0", "", "radio"), {"No"});
else
  form = $list_utils:append(form, $encore_web_utils:input("underline_links", "1", "", "radio"), {"Yes"});
  form = $list_utils:append(form, $encore_web_utils:input("underline_links", "0", "", "radio", "", "checked"), {"No"});
endif
for color in ($xpress_client.web_colors)
  if (color == object.web_bgcolor)
    options = $list_utils:append(options, $encore_web_utils:option(color, color, "selected"));
  else
    options = $list_utils:append(options, $encore_web_utils:option(color, color));
  endif
endfor
form = $list_utils:append(form, $encore_web_utils:p(), {"Background color"}, $encore_web_utils:select(options, "web_bgcolor"));
options = {};
form = $list_utils:append(form, $encore_web_utils:p(), {"Background image URL"}, $encore_web_utils:input("web_background", object.web_background, "40"));
return form;
.

@verb $encore_web_utils:textarea this none this
@program $encore_web_utils:textarea
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a textarea element.";
"===========================================================";
{?data = "", ?name = "textarea", ?rows = "10", ?cols = "30"} = args;
content = {};
if (typeof(data) == STR)
  data = {data};
endif
for line in (data)
  suspend(0);
  line = $encore_web_utils:substitute_suspended(line, {{"<", "&lt;"}, {">", "&gt;"}});
  content = {@content, tostr(line)};
endfor
result = $list_utils:append({tostr("<textarea id=\"", name, "\" name=\"", name, "\" rows=\"", rows, "\" cols=\"", cols, "\">")}, content, {"</textarea>"});
return result;
.


@verb $encore_web_utils:span this none this
@program $encore_web_utils:span
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a span element";
"===========================================================";
{content, ?id = ""} = args;
if (typeof(content) == LIST)
  content = {tostr("<span", id == "" ? ">" | tostr(" id=\"", id, "\">")), @content, "</span>"};
else
  content = tostr("<span", id == "" ? ">" | tostr(" id=\"", id, "\">"), content, "</span>");
endif
return content;
.

       
@verb $encore_web_utils:input this none this
@program $encore_web_utils:input
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create an input field.";
"===========================================================";
{name, ?value = "", ?size = 10, ?type = "text", ?action = "", ?checked = "", ?custom = ""} = args;
return {tostr("<input class=\"", type, "\" type=\"", type, "\" id=\"", name, "\" name=\"", name, "\" value=\"", value, "\" size=\"", size, "\" ", custom, " ", action == "" ? "" |  action, checked == "" ? "" |  tostr(" checked=\"checked\""), " />")};
.

      
@verb $encore_web_utils:"focus_field select_field" this none this
@program $encore_web_utils:focus_field
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Javascript for targeting input elements by id. If no second argument is given, action defaults to focus.";
"===========================================================";
id = args[1];
if (verb == "focus_field")
  action = "focus()";
else
  action = "select()";
endif
return "self.focus();document.getElementById('" + id + "')." + action + ";"; 
.

@verb $encore_web_utils:hr this none this
@program $encore_web_utils:hr
"===========================================================";
"Copyright (C) 2004, Jan Rune Holmevik";
"Create an hr tag.";
"===========================================================";
return {"<hr />"};
.

@verb $encore_web_utils:select this none this
@program $encore_web_utils:select
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a select element.";
"===========================================================";
{data, ?name = "select", ?action = "", ?size = "1"} = args;
if (typeof(data) == STR)
  data = {data};
endif
result = {tostr("<select id=\"", name, "\" name=\"", name, "\" size=\"", size, "\"", action == "" ? "" | tostr(" onchange=\"", action, "\""), ">")};
for line in (data)
  result = $list_utils:append(result, {line});
endfor
result = $list_utils:append(result, {"</select>"});
return result;
.

@verb $encore_web_utils:div this none this
@program $encore_web_utils:div
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a div/class element";
"===========================================================";
{content, ?class = ""} = args;
if (typeof(content) == LIST)
  content = {tostr("<div", class == "" ? ">" | tostr(" class=\"", class, "\">")), @content, "</div>"};
else
  content = tostr("<div", class == "" ? ">" | tostr(" class=\"", class, "\">"), content, "</div>");
endif
return content;
.

@verb $encore_web_utils:"a link" this none this
@program $encore_web_utils:a
"===========================================================";
"Copyright (C) 2003-2004, Jan Rune Holmevik";
"Create a link.";
"===========================================================";
{?url = "", ?text = "", ?target = "", ?action = "", ?image = ""} = args;
return tostr("<a href=\"", url == "" ? "" | url, "\"", target == "" ? "" | " target=\"", target, "\"", action == "" ? "" | " " + action, ">", image, text, "</a>");
.

;#0.("core_history") = {{"enCore 4.0", "1.8.1", 1073061410}, {"enCore enCore 3.3.4", "1.8.1", 1069049189}, {"enCore enCore 3.3.3", "1.8.1", 1043507175}, {"enCore 3.3.2", "1.8.1", 1041824617}, {"enCore 3.3.1", "1.8.1", 1040185243}, {"enCore 3.3", "1.8.1", 1040053857}, {"enCore 3.2", "1.8.1", 1001876038}, {"enCore 3.1", "1.8.1", 1000852213}, {"enCore 3.0.2", "1.8.1", 998391691}, {"enCore 3.0.1", "1.8.1", 995638174}, {"enCore 3.0", "1.8.1", 987347897}, {"enCore 2.1.1", "1.8.1", 961336324}, {"enCore 2.1", "1.8.1", 960582191}, {"enCore 2.0.6", "1.8.1", 954635799}, {"enCore 2.0.5", "1.8.1", 953998452}, {"enCore 2.0.4", "1.8.1", 950453897}, {"enCore 2.0.3", "1.8.0r5", 943788625}, {"enCore 2.0.2", "1.8.0r5", 939547732}, {"enCore 2.0.1", "1.8.0r5", 939031601}, {"enCore 2.0", "1.8.0r5", 928255674}, {"enCore 1.1", "1.8.0p6", 908817314}, {"enCore 1.0", "1.8.0p6", 892671137}, "LambdaMOO", "1.8.0p5", 854992537}

@set #0.core_version to "4.0"


"Done. Your MOO has been updated to enCore version 4.0
