C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE ABORTX (HNAME)
C
C---->
C**** ABORTX - Terminates execution of program.
C
C     Purpose.
C     --------
C
C     Terminates execution of program.
C
C**   Interface.
C     ----------
C
C     CALL ABORTX (HNAME)
C
C
C     Input Parameters.
C     -----------------
C
C     HNAME      - Name of calling routine.
C
C     Output Parameters.
C     ------------------
C
C     None.
C
C     Method.
C     -------
C
C     Prints message and terminates.
C
C     Externals.
C     ----------
C
#ifdef VAX
C     EXIT
#endif
#if (defined IBM) && (!defined rs6000)
C     SYSABN
#endif
#ifdef CRAY
C     ABORT
#endif
#if defined(sun) || defined (sgi) || (defined rs6000)
C     ABORT
#endif
#ifdef CYBER
C     ABORT
#endif
#ifdef __uxp__
C     ABORT
#endif
#ifdef __hpux
C     JABORT
#endif
C
C     Reference.
C     ----------
C
C     None.
C
C     Comments.
C     ---------
C
#ifdef VAX
C     VAX version of routine.
#endif
#if (defined IBM) && (!defined rs6000)
C     IBM version of routine.
#endif
#ifdef CRAY
C     Cray version of routine.
#endif
#if defined(sun) || defined (sgi)
C     SUN/SGI version of routine.
#endif
#ifdef CYBER
C     Cyber version of routine.
#endif
#ifdef __uxp__
C     Fujitsu version of routine.
#endif
C
C     Author.
C     -------
C
C     J. Hennessy      ECMWF      13.11.91
C
C     Modifications.
C     --------------
C
C     None.
C
C----<
C
      IMPLICIT NONE
C
#include "grprs.h"
C
      CHARACTER*(*) HNAME
C
C     ------------------------------------------------------------------
C*    Section 1 . Print message and terminate.
C     ------------------------------------------------------------------
C
  100 CONTINUE
C
      WRITE(GRPRSM,9001) HNAME
C
#ifdef VAX
      CALL EXIT (-1)
#endif
#if (defined IBM) && (!defined rs6000)
      CALL SYSABN (1)
#endif
#ifdef CRAY
      CALL ABORT
#endif
#ifdef CYBER
      CALL ABORT ('US',0,' ')
#endif
#if defined(__uxp__)
      CALL ABORT
#endif
#if defined(sun) || defined (sgi) || (defined rs6000)
      CALL ABORT
#endif
#ifdef __hpux
      CALL JABORT
#endif
C
C     ------------------------------------------------------------------
C*    Section 9 . Format statements.
C     ------------------------------------------------------------------
C
  900 CONTINUE
C
 9001 FORMAT (1H ,'ABORTX : Routine ',A,' has requested program',
     C               ' termination.')
C
      RETURN
C
      END
