/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.datamodel.Alignment;
import jalview.datamodel.CigarBase;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.ShiftList;
import java.util.Hashtable;

public class SeqCigar
extends CigarSimple {
    private int start;
    private int end;
    private SequenceI refseq = null;
    private Hashtable seqProps;

    public SequenceI getRefSeq() {
        return this.refseq;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getSequenceString(char GapChar) {
        return this.length == 0 ? "" : (String)this.getSequenceAndDeletions(this.refseq.getSequenceAsString(this.start, this.end), GapChar)[0];
    }

    public SequenceI getSeq(char GapChar) {
        if (this.refseq == null || this.length == 0) {
            return null;
        }
        Object[] edit_result = this.getSequenceAndDeletions(this.refseq.getSequenceAsString(this.start, this.end), GapChar);
        if (edit_result == null) {
            throw new Error("Implementation Error - unexpected null from getSequenceAndDeletions");
        }
        int[] bounds = (int[])edit_result[1];
        Sequence seq = new Sequence(this.refseq.getName(), (String)edit_result[0], this.refseq.getStart() + this.start + bounds[0], this.refseq.getStart() + this.start + (bounds[2] == 0 ? -1 : bounds[2]));
        seq.setDescription(this.refseq.getDescription());
        int sstart = seq.getStart();
        int send = seq.getEnd();
        if (this.seqProps != null) {
            SeqsetUtils.SeqCharacterUnhash(seq, this.seqProps);
        }
        seq.setDatasetSequence(this.refseq);
        seq.setStart(sstart);
        seq.setEnd(send);
        return seq;
    }

    private boolean _setSeq(SequenceI seq, boolean initialDeletion, int _s, int _e) {
        boolean hasgaps = false;
        if (seq == null) {
            throw new Error("Implementation Error - _setSeq(null,...)");
        }
        if (_s < 0) {
            throw new Error("Implementation Error: _s=" + _s);
        }
        String seq_string = seq.getSequenceAsString();
        if (_e == 0 || _e < _s || _e > seq_string.length()) {
            _e = seq_string.length();
        }
        this.start = seq.findPosition(_s) - seq.getStart();
        this.end = seq.findPosition(_e) - seq.getStart();
        int l_ungapped = this.end - this.start;
        SequenceI ds = seq.getDatasetSequence();
        if (ds == null) {
            String ungapped = AlignSeq.extractGaps(" .-", new String(seq_string));
            l_ungapped = ungapped.length();
            ds = l_ungapped == seq.getLength() ? seq : new Sequence(seq.getName(), ungapped, seq.getStart(), seq.getStart() + ungapped.length() - 1);
        }
        if (ds.getStart() < seq.getStart()) {
            int offset = seq.getStart() - ds.getStart();
            if (initialDeletion) {
                this.addDeleted(_s + offset);
                this.start = 0;
                this.end += offset;
            } else {
                this.start += offset;
                this.end += offset;
            }
        }
        if (l_ungapped != _e - _s) {
            hasgaps = true;
        }
        this.refseq = ds;
        this.seqProps = SeqsetUtils.SeqCharacterHash(seq);
        if (this.end > ds.getLength()) {
            throw new Error("SeqCigar: Possible implementation error: sequence is longer than dataset sequence");
        }
        return hasgaps;
    }

    public SeqCigar(SequenceI seq, char[] operation, int[] range) {
        if (seq == null) {
            throw new Error("Implementation Bug. Null seq !");
        }
        if (operation.length != range.length) {
            throw new Error("Implementation Bug. Cigar Operation list!= range list");
        }
        if (operation != null) {
            this.operation = new char[operation.length + this._inc_length];
            this.range = new int[operation.length + this._inc_length];
            if (this._setSeq(seq, false, 0, 0)) {
                throw new Error("NOT YET Implemented: Constructing a Cigar object from a cigar string and a gapped sequence.");
            }
            int i = this.length;
            for (int j = 0; j < operation.length; ++j) {
                char op = operation[j];
                if (op != 'M' && op != 'I' && op != 'D') {
                    throw new Error("Implementation Bug. Cigar Operation '" + j + "' '" + op + "' not one of '" + 'M' + "', '" + 'I' + "', or '" + 'D' + "'.");
                }
                this.operation[i] = op;
                this.range[i] = range[j];
                ++i;
            }
            this.length += operation.length;
        } else {
            this.operation = null;
            this.range = null;
            this.length = 0;
            if (this._setSeq(seq, false, 0, 0)) {
                throw new Error("NOT YET Implemented: Constructing a Cigar object from a cigar string and a gapped sequence.");
            }
        }
    }

    public void addMatch(int range) {
        this.addOperation('M', range);
    }

    protected static void addSequenceOps(CigarBase cigar, SequenceI seq, int startpos, int endpos, boolean initialDeletions) {
        char op = '\u0000';
        int range = 0;
        int p = 0;
        int res = seq.getLength();
        if (!initialDeletions) {
            p = startpos;
        }
        while (p <= endpos) {
            boolean isGap;
            boolean bl = isGap = p < res ? Comparison.isGap(seq.getCharAt(p)) : true;
            if (startpos <= p && p <= endpos) {
                if (isGap) {
                    if (range > 0 && op != 'I') {
                        cigar.addOperation(op, range);
                        range = 0;
                    }
                    op = 'I';
                    ++range;
                } else {
                    if (range > 0 && op != 'M') {
                        cigar.addOperation(op, range);
                        range = 0;
                    }
                    op = 'M';
                    ++range;
                }
            } else if (!isGap) {
                if (range > 0 && op != 'D') {
                    cigar.addOperation(op, range);
                    range = 0;
                }
                op = 'D';
                ++range;
            }
            ++p;
        }
        if (range > 0) {
            cigar.addOperation(op, range);
        }
    }

    public SeqCigar(SequenceI seq) {
        if (seq == null) {
            throw new Error("Implementation error for new Cigar(SequenceI)");
        }
        this._setSeq(seq, false, 0, 0);
        SeqCigar.addSequenceOps(this, seq, 0, seq.getLength() - 1, false);
    }

    public SeqCigar(SequenceI seq, int start, int end) {
        if (seq == null) {
            throw new Error("Implementation error for new Cigar(SequenceI)");
        }
        this._setSeq(seq, false, start, end + 1);
        SeqCigar.addSequenceOps(this, seq, start, end, false);
    }

    public static SeqCigar parseCigar(SequenceI seq, String cigarString) throws Exception {
        Object[] opsandrange = CigarBase.parseCigarString(cigarString);
        return new SeqCigar(seq, (char[])opsandrange[0], (int[])opsandrange[1]);
    }

    public static SequenceI[] createAlignmentSequences(SeqCigar[] alseqs, char gapCharacter, ColumnSelection colsel, int[] segments) {
        int i;
        SequenceI[] seqs = new SequenceI[alseqs.length];
        StringBuffer[] g_seqs = new StringBuffer[alseqs.length];
        String[] alseqs_string = new String[alseqs.length];
        Object[] gs_regions = new Object[alseqs.length];
        for (int i2 = 0; i2 < alseqs.length; ++i2) {
            alseqs_string[i2] = alseqs[i2].getRefSeq().getSequenceAsString(alseqs[i2].start, alseqs[i2].end);
            gs_regions[i2] = alseqs[i2].getSequenceAndDeletions(alseqs_string[i2], gapCharacter);
            if (gs_regions[i2] == null) {
                throw new Error("Implementation error: " + i2 + "'th sequence Cigar has no operations.");
            }
            g_seqs[i2] = new StringBuffer((String)((Object[])gs_regions[i2])[0]);
        }
        ShiftList shifts = new ShiftList();
        for (i = 0; i < alseqs.length; ++i) {
            Object[] gs_region = (Object[])((Object[])gs_regions[i])[2];
            if (gs_region == null) continue;
            for (int hr = 0; hr < gs_region.length; ++hr) {
                int[] region = (int[])gs_region[hr];
                char[] insert = new char[region[1] - region[0] + 1];
                for (int s = 0; s < insert.length; ++s) {
                    insert[s] = gapCharacter;
                }
                int inspos = shifts.shift(region[2]);
                for (int s = 0; s < alseqs.length; ++s) {
                    if (s != i) {
                        if (g_seqs[s].length() <= inspos) {
                            for (int l = inspos - g_seqs[s].length(); l > 0; --l) {
                                g_seqs[s].append(gapCharacter);
                            }
                        }
                        g_seqs[s].insert(inspos, insert);
                        continue;
                    }
                    g_seqs[s].insert(inspos, alseqs_string[i].substring(region[0], region[1] + 1));
                }
                shifts.addShift(region[2], insert.length);
                if (segments != null) continue;
                colsel.hideColumns(inspos, inspos + insert.length - 1);
            }
        }
        for (i = 0; i < alseqs.length; ++i) {
            int[] bounds = (int[])((Object[])gs_regions[i])[1];
            SequenceI ref = alseqs[i].getRefSeq();
            seqs[i] = new Sequence(ref.getName(), g_seqs[i].toString(), ref.getStart() + alseqs[i].start + bounds[0], ref.getStart() + alseqs[i].start + (bounds[2] == 0 ? -1 : bounds[2]));
            seqs[i].setDatasetSequence(ref);
            seqs[i].setDescription(ref.getDescription());
        }
        if (segments != null) {
            for (i = 0; i < segments.length; i += 3) {
                colsel.hideColumns(segments[i + 1], segments[i + 1] + segments[i + 2] - 1);
            }
        }
        return seqs;
    }

    public static String testCigar_string(Sequence seq, String ex_cs_gapped) {
        SeqCigar c_sgapped = new SeqCigar(seq);
        String cs_gapped = c_sgapped.getCigarstring();
        if (!cs_gapped.equals(ex_cs_gapped)) {
            System.err.println("Failed getCigarstring: incorect string '" + cs_gapped + "' != " + ex_cs_gapped);
        }
        return cs_gapped;
    }

    public static boolean testSeqRecovery(SeqCigar gen_sgapped, SequenceI s_gapped) {
        SequenceI gen_sgapped_s = gen_sgapped.getSeq('-');
        if (!gen_sgapped_s.getSequence().equals(s_gapped.getSequence())) {
            System.err.println("Couldn't reconstruct sequence.\n" + gen_sgapped_s.getSequenceAsString() + "\n" + s_gapped.getSequenceAsString());
            return false;
        }
        return true;
    }

    public static void main(String[] argv) throws Exception {
        int i;
        SeqCigar sub_se_gp;
        String o_seq = "asdfktryasdtqwrtsaslldddptyipqqwaslchvhttt";
        Sequence s = new Sequence("MySeq", "asdfktryasdtqwrtsaslldddptyipqqwaslchvhttt", 39, 80);
        String orig_gapped = "----asdf------ktryas---dtqwrtsasll----dddptyipqqwa----slchvhttt";
        Sequence s_gapped = new Sequence("MySeq", "----asdf------ktryas---dtqwrtsasll----dddptyipqqwa----slchvhttt", 39, 80);
        String ex_cs_gapped = "4I4M6I6M3I11M4I12M4I9M";
        s_gapped.setDatasetSequence(s);
        String sub_gapped_s = "------ktryas---dtqwrtsasll----dddptyipqqwa----slchvh";
        Sequence s_subsequence_gapped = new Sequence("MySeq", "------ktryas---dtqwrtsasll----dddptyipqqwa----slchvh", 43, 77);
        s_subsequence_gapped.setDatasetSequence(s);
        SeqCigar c_null = new SeqCigar(s);
        String cs_null = c_null.getCigarstring();
        if (!cs_null.equals("42M")) {
            System.err.println("Failed to recover ungapped sequence cigar operations:" + (cs_null == "" ? "empty string" : cs_null));
        }
        SeqCigar.testCigar_string(s_gapped, ex_cs_gapped);
        SeqCigar gen_sgapped = SeqCigar.parseCigar(s, ex_cs_gapped);
        if (!gen_sgapped.getCigarstring().equals(ex_cs_gapped)) {
            System.err.println("Failed parseCigar(" + ex_cs_gapped + ")->getCigarString()->'" + gen_sgapped.getCigarstring() + "'");
        }
        SeqCigar.testSeqRecovery(gen_sgapped, s_gapped);
        SeqCigar sub_gapped = new SeqCigar(s_subsequence_gapped);
        if (!SeqCigar.testSeqRecovery(sub_gapped, s_subsequence_gapped)) {
            System.err.println("Failed recovery for subsequence of dataset sequence");
        }
        if (sub_gapped.getWidth() != sub_gapped_s.length()) {
            System.err.println("Failed getWidth()");
        }
        sub_gapped.getFullWidth();
        if (sub_gapped.hasDeletedRegions()) {
            System.err.println("hasDeletedRegions is incorrect.");
        }
        if ((sub_se_gp = new SeqCigar((SequenceI)s_subsequence_gapped, 8, 48)).getWidth() != 41) {
            System.err.println("SeqCigar(seq, start, end) not properly clipped alignsequence.");
        }
        System.out.println("Original sequence align:\n" + sub_gapped_s + "\nReconstructed window from 8 to 48\n" + "XXXXXXXX" + sub_se_gp.getSequenceString('-') + "..." + "\nCigar String:" + sub_se_gp.getCigarstring() + "\n");
        SequenceI ssgp = sub_se_gp.getSeq('-');
        System.out.println("\t " + ssgp.getSequenceAsString());
        for (int r = 0; r < 10; ++r) {
            sub_se_gp = new SeqCigar((SequenceI)s_subsequence_gapped, 8, 48);
            int sl = sub_se_gp.getWidth();
            int st = sl - 1 - r;
            for (int rs = 0; rs < 10; ++rs) {
                int e = st + rs;
                sub_se_gp.deleteRange(st, e);
                String ssgapedseq = sub_se_gp.getSeq('-').getSequenceAsString();
                System.out.println(st + "," + e + "\t:" + ssgapedseq);
                st -= 3;
            }
        }
        SeqCigar[] set = new SeqCigar[]{new SeqCigar(s), new SeqCigar((SequenceI)s_subsequence_gapped, 8, 48), new SeqCigar(s_gapped)};
        Alignment al = new Alignment(set);
        for (i = 0; i < al.getHeight(); ++i) {
            System.out.println("" + al.getSequenceAt(i).getName() + "\t" + al.getSequenceAt(i).getStart() + "\t" + al.getSequenceAt(i).getEnd() + "\t" + al.getSequenceAt(i).getSequenceAsString());
        }
        System.out.println("Gapped.");
        set = new SeqCigar[]{new SeqCigar(s), new SeqCigar((SequenceI)s_subsequence_gapped, 8, 48), new SeqCigar(s_gapped)};
        set[0].deleteRange(20, 25);
        al = new Alignment(set);
        for (i = 0; i < al.getHeight(); ++i) {
            System.out.println("" + al.getSequenceAt(i).getName() + "\t" + al.getSequenceAt(i).getStart() + "\t" + al.getSequenceAt(i).getEnd() + "\t" + al.getSequenceAt(i).getSequenceAsString());
        }
    }
}

