// Autogenerated AST node
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import java.util.Arrays;

public final class Subscript extends exprType implements expr_contextType {
    public exprType value;
    public sliceType slice;
    public int ctx;

    public Subscript(exprType value, sliceType slice, int ctx) {
        this.value = value;
        this.slice = slice;
        this.ctx = ctx;
    }

    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        result = prime * result + ((slice == null) ? 0 : slice.hashCode());
        result = prime * result + ctx;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Subscript other = (Subscript) obj;
        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        if (slice == null) {
            if (other.slice != null)
                return false;
        } else if (!slice.equals(other.slice))
            return false;
        if (this.ctx != other.ctx)
            return false;
        return true;
    }

    public Subscript createCopy() {
        return createCopy(true);
    }

    public Subscript createCopy(boolean copyComments) {
        Subscript temp = new Subscript(value != null ? (exprType) value.createCopy(copyComments) : null,
                slice != null ? (sliceType) slice.createCopy(copyComments) : null, ctx);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (o instanceof commentType) {
                    commentType commentType = (commentType) o;
                    temp.getSpecialsBefore().add(commentType.createCopy(copyComments));
                }
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (o instanceof commentType) {
                    commentType commentType = (commentType) o;
                    temp.getSpecialsAfter().add(commentType.createCopy(copyComments));
                }
            }
        }
        return temp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Subscript[");
        sb.append("value=");
        sb.append(dumpThis(this.value));
        sb.append(", ");
        sb.append("slice=");
        sb.append(dumpThis(this.slice));
        sb.append(", ");
        sb.append("ctx=");
        sb.append(dumpThis(this.ctx, expr_contextType.expr_contextTypeNames));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitSubscript(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (value != null) {
            value.accept(visitor);
        }
        if (slice != null) {
            slice.accept(visitor);
        }
    }

}
