/* $Id: proto_gnuchess4.cc,v 1.6 2002/02/13 03:53:56 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "eboard.h"
#include "protocol.h"
#include "global.h"

GnuChess4ProtocolParser::GnuChess4ProtocolParser() : XBoardProtocolParser() {
  strcpy(ComputerName,"GNU Chess");
  want_path_pane=0;
}

void GnuChess4ProtocolParser::initEngine() {
  char z[32];
  createGame();
  global.network->writeLine("nopost");

  global.network->writeLine("hard");
  if (!ThinkAlways)
    global.network->writeLine("easy");

  global.network->writeLine("new");

  if (SecsPerMove > 0) {
    if (SecsPerMove%60)
      sprintf(z,"level 1 %d:%02d",SecsPerMove/60,SecsPerMove%60);
    else
      sprintf(z,"level 1 %d",SecsPerMove/60);  
    global.network->writeLine(z);
  }

  if (MaxDepth > 0) {
    sprintf(z,"depth %d",MaxDepth);
    global.network->writeLine(z);
  }

  if (EngineWhite) {
    global.network->writeLine("white");
    global.network->writeLine("go");
  }
}

void GnuChess4ProtocolParser::readDialog() {
  XBoardProtocolParser::readDialog();
  strcpy(EngineCommandLine,"gnuchessx");
  EngineRunDir[0]=0;
}

char * GnuChess4ProtocolParser::getDialogName() {
  return("Play against GNU Chess 4");
}

