/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/
#ifndef QV4LWINDOW_H
#define QV4LWINDOW_H

#include <qthread.h>
#include <qframe.h>

class DVR;
class V4L;

class QV4LWindow : public QFrame, public QThread {
	Q_OBJECT
	
 	DVR *dvr;
  V4L *v4l;

  bool video_preview_enabled;
  bool has_xv_extension;
  bool record_mode;
 	
/*signals:
	void moved();
	void resized();
*/
protected:
	//void refreshV4L();
  void run();

  void xvVideoPreview();
  void x11VideoPreview();
	
public:	
	QV4LWindow(DVR *dvr, QWidget *parent=NULL, char *name=NULL);
	virtual ~QV4LWindow();

	void setAutoAdjustSize(bool);
  void setRecordMode(bool);

  void startVideoPreview();
  void stopVideoPreview();

	virtual void moveEvent(QMoveEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual void hideEvent(QHideEvent *);
	virtual void showEvent(QShowEvent *);
};

#endif //QV4LWINDOW_H
