/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/

// TV configuration dialog box implementation header

#ifndef QTVCONFIGIMPL_H
#define QTVCONFIGIMPL_H

#include <utility>

#include "QTVConfig.h"

using namespace std;

class V4L;

class QTVConfigImpl : public QTVConfig
{ 
    Q_OBJECT

public:
    QTVConfigImpl( QWidget* parent = 0, const char* name = 0);
    ~QTVConfigImpl();
	
//	void setChannel(int) const;		no need for this
//	void setNorm(int) const;
	void setChannelList(QList<pair<QString*, unsigned long> > *, const QString &current_channel);

	void setV4L(V4L*);
	int getChannel() const;
	int getNorm() const;

public slots:
	virtual void changeParameter();
	virtual void addCurrentChannel();
	virtual void removeCurrentChannel();
	virtual void changeChannel(const QString &);

signals:
	void parameterChanged();

protected:
	V4L	*v4l;
	QRadioButton **buttons;
	QList<pair<QString*, unsigned long> > *channels;
	QString current_channel;
};

#endif // QTVCONFIGIMPL_H
