/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "dsyslog.h"

static gboolean
cond_counter_handler(dsyslog_event_t *event, dsyslog_cond_t *cond)
{
	char *value;
	gboolean invert = FALSE;
	static gulong lastset = 0;

	_ENTER;

	value = cond->value;
	if (*value == '!') {
		value++;
		invert = TRUE;
	}

	_DEBUG("value<%s> invert(%d) eventprog<%s> cond<%s>", value, invert, event->program, cond->cond);

	if (!g_ascii_strcasecmp(cond->cond, "set")) {
		_DEBUG("Setting...");
		lastset = event->uid;
		_LEAVE TRUE;
	}

	if (!g_ascii_strcasecmp(cond->cond, "test")) {
		if (event->uid != lastset) {
			_DEBUG("No Match");
			_LEAVE invert;
		} else {
			_DEBUG("Match");
			_LEAVE (invert == TRUE) ? FALSE : TRUE;
		}

		/* matched | invert | return
 		 * --------+--------+-------
		 *   false |  false |  false
		 *   false |   true |   true
		 *    true |  false |   true
		 *    true |   true |  false
		 *
		 */
	}

	_LEAVE invert ? TRUE : FALSE;
}

void
_modinit(void)
{
	_ENTER;

	dsyslog_cond_type_register("counter", cond_counter_handler);

	_LEAVE;
}

void
_modfini(void)
{
	_ENTER;

	dsyslog_cond_type_unregister("counter");

	_LEAVE;
}

